<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Estadisticas_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
		$this->load->helper('util');
        $this->load->database();
    }
    
    function empleados()
    {
        $sql = "SELECT 
                    count(usr_id) as total, 
                    (SELECT count(usr_id) as total FROM sis20_usuarios WHERE perfil_id != 1 ";
        
        if(get_perfil_id() == 4)
        {
            $empresas = get_empresas_array();
            $sql .= " AND emp_id IN (".implode(',',$empresas).") ";
        }

        $sql .= " AND log_insrt_f >= date_sub(curdate(), interval DAYOFWEEK(curdate())-1 day)) as semana 
                FROM sis20_usuarios 
                WHERE perfil_id != 1 ";

        if(get_perfil_id() == 4)
        {
            $empresas = get_empresas_array();
            $sql .= " AND emp_id IN (".implode(',',$empresas).") ;";
        }

        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function empresas()
    {
        $sql = "SELECT 
                    count(emp_id) as total, 
                    (SELECT count(emp_id) as total FROM sis15_empresas WHERE emp_alta_f >= date_sub(curdate(), interval DAYOFWEEK(curdate())-1 day) ";
        if(get_perfil_id() == 4)
        {
            $empresas = get_empresas_array();
            //$sql .= " AND emp_id = ".get_emp_id();
            $sql .= " AND emp_id IN (".implode(',',$empresas).") ";
        }
        $sql .= ") as semana 
                FROM sis15_empresas 
                WHERE 1";
        if(get_perfil_id() == 4)
        {
            $empresas = get_empresas_array();
            //$sql .= " AND emp_id = ".get_emp_id()." ;";
            $sql .= " AND emp_id IN (".implode(',',$empresas).") ;";
        }
        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function personas($genero)
    {
        $sql = "SELECT 
                    count(clte_id) as total, 
                    (SELECT count(clte_id) as total FROM sis05_clientes  WHERE clte_genero_cve = '$genero' ";
        if(get_perfil_id() == 4)
        {
            $empresas = get_empresas_array();
            //$sql .= " AND emp_id = ".get_emp_id();
            $sql .= " AND emp_id IN (".implode(',',$empresas).") ";
        }
        $sql .= " AND log_insrt_f >= date_sub(curdate(), interval DAYOFWEEK(curdate())-1 day)) as semana 
                FROM sis05_clientes 
                WHERE clte_genero_cve = '$genero' ";
        if(get_perfil_id() == 4)
        {
            $empresas = get_empresas_array();
            //$sql .= " AND emp_id = ".get_emp_id()." ;";
            $sql .= " AND emp_id IN (".implode(',',$empresas).") ;";
        }
        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function edad()
    {
        $sql = "select ROUND(AVG(datediff(curdate(), clte_f_nac )/365)) as promedio 
                FROM sis05_clientes ";
        if(get_perfil_id() == 4)
        {
            $empresas = get_empresas_array();
            //$sql .= " WHERE emp_id = ".get_emp_id()." ;";
            $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ;";
        }
        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function top_clientes()
    {
        $sql = "SELECT a.emp_razon_social as empresa, count(clte_id) as sis05_clientes 
                FROM sis15_empresas as a LEFT JOIN sis05_clientes as b ON a.emp_id = b.emp_id 
                WHERE 1 
                GROUP BY a.emp_id 
                HAVING sis05_clientes > 0 
                ORDER BY sis05_clientes DESC
                LIMIT 5;";
        $result = $this->db->query($sql);
        return $result->result_array();
    }
    
    function estudios()
    {
        $empresas = get_empresas_array();

        $sql = "select sum(total) as total FROM (
                    select count(*) as total from fsm_poligrafico ";
                    if(get_perfil_id() == 4)
                    {
                        //$sql .= " WHERE emp_id = ".get_emp_id()." ";
                        $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ";
                    }
                    
                    $sql .="UNION 
                    select count(*) as total from fsm_medico_fisico ";
                    if(get_perfil_id() == 4)
                    {
                        //$sql .= " WHERE emp_id = ".get_emp_id()." ";
                        $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ";
                    }
                    $sql .="UNION 
                    select count(*) as total from fsm_psicologico ";
                    if(get_perfil_id() == 4)
                    {
                        //$sql .= " WHERE emp_id = ".get_emp_id()." ";
                        $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ";
                    }
                    $sql .="UNION 
                    select count(*) as total from fsm_toxicologico ";
                    if(get_perfil_id() == 4)
                    {
                        //$sql .= " WHERE emp_id = ".get_emp_id()." ";
                        $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ";
                    }
                    $sql .="UNION 
                    select count(*) as total from fsm_acreditacion ";
                    if(get_perfil_id() == 4)
                    {
                        //$sql .= " WHERE emp_id = ".get_emp_id()." ";
                        $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ";
                    }
                    $sql .="UNION 
                    select count(*) as total from fsm_historia_clinica ";
                    if(get_perfil_id() == 4)
                    {
                        //$sql .= " WHERE emp_id = ".get_emp_id()." ";
                        $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ";
                    }
                    $sql .="UNION 
                    select count(*) as total from socio_eco ";
                    if(get_perfil_id() == 4)
                    {
                        //$sql .= " WHERE emp_id = ".get_emp_id()." ";
                        $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ";
                    }
                    $sql .="UNION 
                    select count(*) as total from entorno_soc ";
                    if(get_perfil_id() == 4)
                    {
                        //$sql .= " WHERE emp_id = ".get_emp_id()." ";
                        $sql .= " WHERE emp_id IN (".implode(',',$empresas).") ";
                    }
                    $sql .= ") as x;";
        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function estudios_realizados($serv_id)
    {
        $sql = "select sum(IFNULL(total,0)) as total 
            FROM (
                select 1,IFNULL(count(fsm_id),0) as total from fsm_poligrafico where serv_id = $serv_id 
                UNION 
                select 2,IFNULL(count(fsm_id),0) as total from fsm_medico_fisico where serv_id = $serv_id 
                UNION 
                select 3,IFNULL(count(fsm_id),0) as total from fsm_psicologico where serv_id = $serv_id 
                UNION 
                select 4,IFNULL(count(fsm_id),0) as total from fsm_toxicologico where serv_id = $serv_id 
                UNION 
                select 5,IFNULL(count(fsm_id),0) as total from fsm_acreditacion where serv_id = $serv_id 
                UNION 
                select 6,IFNULL(count(fsm_id),0) as total from fsm_historia_clinica where serv_id = $serv_id 
                UNION 
                select 7,IFNULL(count(fsm_id),0) as total from socio_eco where serv_id = $serv_id 
                UNION 
                select 8,IFNULL(count(fsm_id),0) as total from entorno_soc where serv_id = $serv_id 
                ) as x ";
        $result = $this->db->query($sql);
        return $result->row_array();
    }
}