<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Seguro_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get all seguro
     */
    function get_all_seguros()
    {
        return $this->db->get('socio_eco_seguro')->result_array();
    }
    
    /*
     * Get all seguros by fsm_id
     */
    function get_seguros($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_seguro');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * function to add new seguro
     */
    function inserta($params)
    {
        $this->db->insert('socio_eco_seguro',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to add new seguros
     */
    function inserta_seguros($seguros, $fsm_id)
    {
        foreach($seguros as $seguro){
            if(trim($seguro['tipo']) != "")
            {
                $seguro['fsm_id'] = $fsm_id;
                $this->db->insert('socio_eco_seguro', array_to_upper($seguro));
            }
        }
        return $this->db->insert_id();
    }

    function actualiza_seguros($seguros, $fsm_id)
    {
        $insert_id = null;
        if(!empty($seguros))
        {
            foreach($seguros as $seguro)
            {
                    if(isset($seguro['seguro_id']))
                    {
                        $seguro_id = $seguro['seguro_id'];
                        unset($seguro['seguro_id']);
                        $this->db->where('seguro_id', $seguro_id);
                        $this->db->update('socio_eco_seguro',  array_to_upper($seguro));
                    }
                    else
                    {
                        $credito['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('socio_eco_seguro',  array_to_upper($seguro));
                    }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }


    
    function delete($fsm_id, $id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('seguro_id', $id);
        return $this->db->delete('socio_eco_seguro');
    }
}
