<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */ 
 
class Empresas_c_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    

    function consultorios_gsi()
    {
		$sql='SELECT DISTINCT(fsm_emp_atte) emp_id,emp_razon_social FROM fsm_recetario  
              join sis15_empresas_c on fsm_emp_atte=sis15_empresas_c.emp_id order by emp_razon_social;';
		$result = $this->db->query($sql);
		
        return $result->result_array();
    }




    function get_empresa($emp_id)
    {
        return $this->db->get_where('sis15_empresas_c',array('emp_id'=>$emp_id))->row_array();
    }
  
  
     function get_consultorio($cons_id)
    {
        return $this->db->get_where('sis15_consultorios',array('cons_id'=>$cons_id))->row_array();
    } 
  
  
  
    function get_cei($cei_id)
    {
        return $this->db->get_where('sis80_ceis',array('cei_id'=>$cei_id))->row_array();
    }

	
	function get_una_sucursal($suc_id)
    {
        return $this->db->get_where('sis65_sucursales',array('suc_id'=>$suc_id))->row_array();
    }
	
	function get_cotizaciones($emp_id)
    {	           
            $this->db->select('*');            
            $this->db->from('sis_cotizaciones');
			$this->db->where('emp_id',$emp_id);
            $this->db->order_by('cost_id','DESC');
            $result = $this->db->get();
            return $result->result_array();	
    }
	
	function get_ciudad_mpio_estado($codigo_postal)
    {	    
			$this->db->select('cp_ciudad,mpio_nombre,estado');
			$this->db->from('cat_dir_cp');
			$this->db->like('cp_codigo',$codigo_postal);
			$this->db->limit(1); 
			$zona=$this->db->get()->row_array();
            return $zona;	
    }	
	
	
	function get_paquetes_costo($emp_id)
    {	           
            $this->db->select('*');            
            $this->db->from('sis16_empresas_costos');
			$this->db->where('emp_id',$emp_id);
            $this->db->order_by('cost_nombre_pkt','ASC');
            $result = $this->db->get();
            return $result->result_array();	
    }	

	function get_nombre_examen_by_emp($cost_nombre_pkt,$emp_id)
    {	           
            $this->db->select('*');            
            $this->db->from('sis16_empresas_costos');
			$this->db->where('emp_id',$emp_id);
			$this->db->where('cost_id',$cost_nombre_pkt);
            $this->db->order_by('cost_nombre_pkt','ASC');
            $result = $this->db->get()->row_array();
            return $result['cost_nombre_pkt'];
    }	


	function corporacion_chk($emp_id , $corporacion)
    {	           
            $this->db->select('emp_corp');            
            $this->db->from('sis15_empresas_c');
			$this->db->where('emp_id',$emp_id);
			$this->db->like('emp_corp',$corporacion);
			$result = $this->db->get()->row_array();
            return $result['emp_corp'];	
    }
	
	function get_costos_paquetes($emp_id)
    {	       
            $this->db->select('*');            
            $this->db->from('sis16_empresas_costos');
			$this->db->where('emp_id',$emp_id);
            $this->db->order_by('cost_id','DESC');
            $result = $this->db->get();
            return $result->result_array();	
    }

	function get_una_cotizacion($emp_id)
    {
        return $this->db->get_where('sis_cotizaciones',array('emp_id'=>$emp_id))->row_array();
    }
	
	
    function find_empresa($emp)
    {
        $this->db->like('emp_razon_social', $emp);
        $this->db->where('emp_estatus_cve', 'ACTIVO');
        return $this->db->get('sis15_empresas_c')->result_array();
    }
   

/**************************************************************************************/        
        function busca($nombre = '', $rfc = '', $estatus = '')
        {            
           
            $this->db->select('*');            
            $this->db->from('sis15_empresas_c');
            if($nombre != ''){ $this->db->like('emp_razon_social',$nombre); }            
            if($rfc != ''){ $this->db->like('emp_rfc ',$rfc); }   
			if($estatus != ''){ $this->db->like('emp_estatus_cve',$estatus); }			
            $this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
        function busca_consultorio($nombre = '', $estatus = '')
        {            
           
            $this->db->select('*');            
            $this->db->from('sis15_consultorios');
            if($nombre != ''){ $this->db->like('cons_razon_social',$nombre); }            
			if($estatus != ''){ $this->db->like('emp_estatus_cve',$estatus); }			
            $this->db->order_by('cons_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
			
        } 
  
    function borra_consultorio($fsm_id)
    {
        $this->db->where('cons_id', $fsm_id);
        return $this->db->delete('sis15_consultorios');
    }
  
    /*
     * ir eliminado esta función alenta los procesos
     */
    function get_all_empresas()
    {
        $this->db->select('a.*, ifnull(count(clte_id),0) as empleados');
        $this->db->from('sis15_empresas_c as a');
        $this->db->join('sis05_clientes as b','a.emp_id = b.emp_id','LEFT');
        if(get_perfil_id() == 4)
        {
            $this->db->where('a.emp_id', get_emp_id());
        }
        //$this->db->where('emp_estatus_cve', 'ACTIVO');
        $this->db->group_by('a.emp_id');
        $this->db->order_by('a.emp_razon_social ASC');
        return $this->db->get()->result_array();
    }

    function get_all_empresas_clean()
    {
        $this->db->select('*');
        $this->db->from('sis15_empresas_c');
        if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
        $this->db->group_by('emp_id');
        $this->db->order_by('emp_razon_social ASC');
        return $this->db->get()->result_array();
    }	

    function get_all_despachos()
    {
        $this->db->select('a.*, ifnull(count(clte_id),0) as empleados');
        $this->db->from('sis15_empresas_c as a');
        $this->db->join('sis05_clientes as b','a.emp_id = b.emp_id','LEFT');
        if(get_perfil_id() == 4)
        {
            $this->db->where('a.emp_id', get_emp_id());
        }
        $this->db->where('emp_desp','1');
        $this->db->group_by('a.emp_id');
        $this->db->order_by('a.emp_razon_social ASC');
        return $this->db->get()->result_array();
    }
	
    function get_all_empresas_no_31()
    {
		$n=31;
        $this->db->select('a.*, ifnull(count(clte_id),0) as empleados');
        $this->db->from('sis15_empresas_c as a');
        $this->db->join('sis05_clientes as b','a.emp_id = b.emp_id','LEFT');
        //$this->db->where('emp_estatus_cve', 'ACTIVO');
		$this->db->where('a.emp_id !=', $n);
        $this->db->group_by('a.emp_id');
        $this->db->order_by('a.emp_razon_social ASC');
        return $this->db->get()->result_array();
    }	
	

    function get_all_empresas_subcorp($corporativo, $subcorporativo)
    { 
	    $this->db->select('*');
        $this->db->from('sis15_empresas_c');
        $this->db->where('emp_estatus_cve', 'ACTIVO');
		$this->db->where('emp_corp', $corporativo);
		$this->db->where('emp_subcorp', $subcorporativo);
        $this->db->group_by('emp_id');
        $this->db->order_by('emp_razon_social ASC');
        return $this->db->get()->result_array();
    }


    function get_sis15_empresas_c_gsi()
    { 
	    $this->db->select('*');
        $this->db->from('sis15_empresas_c_gsi');
        //$this->db->where('emp_estatus_cve', 'ACTIVO');
        //$this->db->group_by('emp_id');
        $this->db->order_by('emp_gsi_nombre ASC');
        return $this->db->get()->result_array();
    }


    function get_sis15_sucursales_gsi()
    { 
	    $this->db->select('*');
        $this->db->from('sis15_sucursales_gsi');
        //$this->db->where('emp_estatus_cve', 'ACTIVO');
        //$this->db->group_by('emp_id');
        $this->db->order_by('emp_gsi_nombre ASC');
        return $this->db->get()->result_array();
    }
	
    function get_sis15_sucursales_gsi_by_emp($emp_id)
    { 
	    $this->db->select('*');
        $this->db->from('sis15_sucursales_gsi');
		$this->db->where('emp_gsi_id', $emp_id);
        //$this->db->where('emp_estatus_cve', 'ACTIVO');
        //$this->db->group_by('emp_id');
        $this->db->order_by('emp_gsi_nombre ASC');
        return $this->db->get()->result_array();
    }	
	


	function get_sucursal_gsi($suc_id)
    {
        return $this->db->get_where('sis15_sucursales_gsi',array('suc_gsi_id'=>$suc_id))->row_array();
    }

	function get_empresa_gsi($emp_id)
    {
        return $this->db->get_where('sis15_empresas_c_gsi',array('emp_gsi_id'=>$emp_id))->row_array();
    }

    function get_all_empresas_gsi_id()
    { 
	    $this->db->select('*');
        $this->db->from('sis15_empresas_c');
        $this->db->where('emp_estatus_cve', 'ACTIVO');
		$this->db->where('emp_corp', 'GSI');
        $this->db->group_by('emp_id');
        $this->db->order_by('emp_razon_social ASC');
        return $this->db->get()->result_array();
    }

    function get_all_empresas_gsi()
    { 
	    $this->db->select('*');
        $this->db->from('sis15_empresas_c');
        $this->db->where('emp_estatus_cve', 'ACTIVO');
		$this->db->where('emp_corp', 'GSI');
        $this->db->group_by('emp_id');
        $this->db->order_by('emp_razon_social ASC');
        return $this->db->get()->result_array();
    }	

    function get_all_emp_id_gsi()
    { 
	    $this->db->select('emp_id');
        $this->db->from('sis15_empresas_c');
        $this->db->where('emp_estatus_cve', 'ACTIVO');
		$this->db->where('emp_corp', 'GSI');
        $this->db->group_by('emp_id');
        $this->db->order_by('emp_razon_social ASC');
        return $this->db->get()->result_array();
    }

    function get_all_empresas_gss($arreglo)
    { 
	    $this->db->select('*');
        $this->db->from('sis15_empresas_c');
        $this->db->where('emp_estatus_cve', 'ACTIVO');
		$this->db->where_in('emp_id',$arreglo); 
        $this->db->group_by('emp_id');
        $this->db->order_by('emp_razon_social ASC');
        return $this->db->get()->result_array();
    }


    function get_empresa_razon_social($emp_id)
    { 
	    $this->db->select('emp_razon_social');
        $this->db->from('sis15_empresas_c');
        $this->db->where('emp_id', $emp_id);
		
		$empresa=$this->db->get()->row_array();	
        return $empresa[emp_razon_social];
    }
	
	function get_allo_empresas($rows)
    {
		
		$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
		
		//$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
		
        $this->db->select('a.*, ifnull(count(clte_id),0) as empleados');
        $this->db->from('sis15_empresas_c as a');
        $this->db->join('sis05_clientes as b','a.emp_id = b.emp_id','LEFT');
        if(get_perfil_id() == 4)
        {
            $this->db->where('a.emp_id', get_emp_id());
        }
        //$this->db->where('emp_estatus_cve', 'ACTIVO');
        $this->db->group_by('a.emp_id');
        $this->db->order_by('a.emp_razon_social ASC');
		$this->db->limit($rows, $page);
        return $this->db->get()->result_array();
    }
 

	function get_all_ac_empresas($rows)
    {
		
		$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
		
        $this->db->select('*');
        $this->db->from('sis15_empresas_c');
        $this->db->order_by('emp_razon_social ASC');
		$this->db->limit($rows, $page);
        return $this->db->get()->result_array();
    }



	function get_all_consultorios($rows)
    {
		
		$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
		
        $this->db->select('*');
        $this->db->from('sis15_consultorios');
        //$this->db->where('emp_estatus_cve', 'ACTIVO');
       // $this->db->group_by('emp_id');
        $this->db->order_by('cons_razon_social ASC');
		$this->db->limit($rows, $page);
        return $this->db->get()->result_array();
    }


	function get_lista_consultorios()
    {	
        $this->db->select('*');
        $this->db->from('sis15_consultorios');
        $this->db->order_by('cons_razon_social ASC');
        return $this->db->get()->result_array();
    }



	function get_all_evaluados_empresas($emp_id)
    {
		
		$this->db->select('ifnull(count(clte_id),0) as empleados');
		$this->db->from('sis05_clientes');

        if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
		else
		{
			$this->db->where('emp_id', $emp_id);	
		}	
        $empresa=$this->db->get()->row_array();		
        return $empresa['empleados'];
    }



	function get_corporativo_consultorio($cons_id)
    {
		
		$this->db->select('corp_id');
		$this->db->from('sis15_consultorios');
		$this->db->where('cons_id', $cons_id);	
        $consultorio=$this->db->get()->row_array();		
        return $consultorio['corp_id'];
    }
	
	
	function get_empresa_consultorio($cons_id)
    {
		
		$this->db->select('emp_id');
		$this->db->from('sis15_consultorios');
		$this->db->where('cons_id', $cons_id);	
        $consultorio=$this->db->get()->row_array();		
        return $consultorio['emp_id'];
    }	



	function get_corporacion($emp_id)
    {
		$this->db->select('emp_corp');
		$this->db->from('sis15_empresas_c');
		$this->db->where('emp_id', $emp_id);	
        $c=$this->db->get()->row_array();		
        return $c['emp_corp'];
    }


	function get_razon_social_consultorio($cons_id)
    {		
		$this->db->select('cons_razon_social');
		$this->db->from('sis15_consultorios');
		$this->db->where('cons_id', $cons_id);	
        $consultorio=$this->db->get()->row_array();		
        return $consultorio['cons_razon_social'];
    }

	function get_all_pacientes_consultorios($emp_id)
    {
		
		$this->db->select('ifnull(count(clte_id),0) as empleados');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id', $emp_id);	
		$this->db->where('paciente', 1);
        $pacientes=$this->db->get()->row_array();		
        return $pacientes['empleados'];
    }



	function get_all_sucursales($emp_id=0)
    {

		$sql= "SELECT * FROM sis65_sucursales ";
		if (($emp_id >0) && ($emp_id != 31))
		{
			$sql.="where emp_id =".$emp_id;
			$sql.="  and  emp_id !=  31";
			$sql.= " order by emp_razon_social ASC, suc_alias ASC";
		}
		elseif ($emp_id == 31)
		{
			$sql.="  where  emp_id =  31";
			$sql.= " order by suc_alias ASC";
		}
		elseif ($emp_id == -1)
		{
			$sql.= " order by emp_razon_social ASC, suc_alias ASC";
		}		
		else
		{
			$sql.="  where  emp_id !=  31";
			$sql.= " order by emp_razon_social ASC, suc_alias ASC";
		}	
		
		
		$result = $this->db->query($sql);
        return $result->result_array();
    }
	

	function trae_empresas($notodas='')
    {
	/*	$sql= 'SELECT * FROM sis15_empresas_c ';
		if(get_perfil_id() == 4)
        {
            $sql.=' WHERE emp_id = '.get_emp_id();
        }
		else
		$sql.=' WHERE emp_id like ';
		$sql.=' order by emp_razon_social ASC';*/
		
            $this->db->select("*");
            $this->db->from('sis15_empresas_c');

            if(get_perfil_id() == 4)
			{
                $this->db->where('emp_id', get_emp_id());
            }
			else
			{
				if ($notodas =='')
				{	
				$estatus='INACTIVO';
				 $this->db->not_like('emp_estatus_cve',$estatus);
				}
			}
			$this->db->order_by('emp_razon_social ASC');
            $result = $this->db->get();
			return $result->result_array();
    }




		function trae_emp_asig($empresas)
		{
				$this->db->select("*");
				$this->db->from('sis15_empresas_c');
				$this->db->where('emp_id', $empresas);
				$this->db->order_by('emp_razon_social ASC');
				$result = $this->db->get();
				return $result->result_array();
		}	
	
	    function count_all_consultorios()
        {
            $this->db->select("count(cons_id) as regs");
            $this->db->from('sis15_consultorios');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

	
        function count_all()
        {
            $this->db->select("count(emp_id) as regs");
            $this->db->from('sis15_empresas_c');

            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
            }

            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

        function examen_de_empresa_por_categoria($emp_id , $categoria)
        {
			 
			//$res='`'.$categoria.'`'.' as RES';
            //$this->db->select($res);
			$this->db->select($categoria." as regs");
            $this->db->from('sis15_empresas_c');
            $this->db->where('emp_id', $emp_id);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }




    /*
     * function to add new empresa
     */
    function inserta($params)
    {
        $this->db->insert('sis15_empresas_c',$params);
        return $this->db->insert_id();
    }
 
    /*
     * function to add new consultorio
     */
    function inserta_consultorio($params)
    {
        $this->db->insert('sis15_consultorios',$params);
        return $this->db->insert_id();
    }
 
    /*
     * function to update empresa
     */
    function actualiza($emp_id,$params)
    {
        $this->db->where('emp_id',$emp_id);
        return $this->db->update('sis15_empresas_c',$params);
    }
 
    /*
     * function to update consultorio
     */
    function actualiza_consultorio($cons_id,$params)
    {
        $this->db->where('cons_id',$cons_id);
        return $this->db->update('sis15_consultorios',$params);
    }

 
    /*
     * function to delete empresa
     */
    function delete_empresa($emp_id)
    {
        return $this->db->delete('sis15_empresas_c',array('emp_id'=>$emp_id));
    }
  
    /*
     * function to delete paquete de una empresa
     */
    function delete_paquete($cost_id)
    {
        return $this->db->delete('sis16_empresas_costos',array('cost_id'=>$cost_id));
    }

  
    function get_empresa_busca( $busca ){
                
        return $result;
    }
    function inserta_sucursal($params)
    {
        $this->db->insert('sis65_sucursales',$params);
        return $this->db->insert_id();
    }
   
    function get_sucursales($emp_id)
    {
        return $this->db->get_where('sis65_sucursales',array('emp_id'=>$emp_id))->result_array();
    }



    function get_sucursal($suc_id)
    {
        return $this->db->get_where('sis65_sucursales',array('suc_id'=>$suc_id))->row_array();
    }



    function get_empresa_by_id($emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis15_empresas_c');
        $this->db->where('emp_id', $emp_id);
        $result = $this->db->get();
        return $result->row_array();
    }
	


    function actualiza_sucursal($suc_id,$params)
    {
        $this->db->where('suc_id',$suc_id);
        return $this->db->update('sis65_sucursales',$params);
    }
    
    function delete_sucursal($suc_id)
    {
        $this->db->where('suc_id',$suc_id);
        return $this->db->delete('sis65_sucursales');
    }

    function get_examenes($emp_id)
    {
        return $this->db->get_where('sis16_empresas_costos',array('emp_id'=>$emp_id))->result_array();
    }

    function inserta_examen($params)
    {
        $this->db->insert('sis16_empresas_costos',$params);
        return $this->db->insert_id();
    }

    function get_realizados($examen, $emp_id, $ini = '', $fin = '')
    {
        $mapeo = array(
            'TOXI'  => array('tabla' => 'fsm_toxicologico', 'fecha' => 'fsm_f'),
            'TOXIS' => array('tabla' => 'fsm_toxicologico7', 'fecha' => 'fsm_f'),
            'PSIC'  => array('tabla' => 'fsm_psicologico', 'fecha' => 'fsm_f'),
            'ACRED' => array('tabla' => 'fsm_acreditacion', 'fecha' => 'fsm_f'),
            'MEDFIS' => array('tabla' => 'fsm_medico_fisico', 'fecha' => 'fsm_f'),
            'SOCIE' => array('tabla' => 'socio_eco', 'fecha' => 'fecha_eval'),
            'ENTSOC' => array('tabla' => 'entorno_soc', 'fecha' => 'fecha_eval'),
            'CED' => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval','where' => array('campo' => 'polig_tipo_cve','valor' => 'CEDULA')),
            'POL' => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval','where' => array('campo' => 'polig_tipo_cve','valor' => 'POLI')),
            'HIST' => array('tabla' => 'fsm_historia_clinica', 'fecha' => 'fsm_f'),
            'TOXIN' => array('tabla' => 'fsm_toxi', 'fecha' => 'fsm_f'),
            'ESTSOC' => array('tabla' => 'esc', 'fecha' => 'esc_f'),
            'QUISAN' => array('tabla' => 'fsm_quimica_sanguinea', 'fecha' => 'qui_f_recibido'),
            'ORINA' => array('tabla' => 'fsm_orina', 'fecha' => 'ori_f_recibido'),
            'BIOHEM' => array('tabla' => 'fsm_biometria_hematica', 'fecha' => 'bio_f_recibido'),
            'GPOSAN' => array('tabla' => 'fsm_grupo_sanguineo', 'fecha' => 'gs_f_recibido'),
            'REPSIC' => array('tabla' => 'fsm_psicologico_2', 'fecha' => 'fsm_f'),
            'EYED' => array('tabla' => 'fsm_eye_detect', 'fecha' => 'fsm_f'),
            'SOCLAB' => array('tabla' => 'fsm_sociolab', 'fecha' => 'fsm_f'),
			'PIE'       => array('tabla' => 'fsm_pie', 'fecha' => 'pie_f_recibido'),
			'ODO'       => array('tabla' => 'fsm_odon', 'fecha' => 'fodon_fechaeva'),
			'FSM0105'   => array('tabla' => 'fpfh_01_05', 'fecha' => 'fpfh_fechaeva'),
			'PYB'   => array('tabla' => 'fsm_pyb', 'fecha' => 'pyb_f_recibido ')
			
        );

        $this->db->select('count(*) as realizados');
        $this->db->from($mapeo[$examen]['tabla']);
        $this->db->where('emp_id', $emp_id);
        if($ini != '')
        {
            $this->db->where($mapeo[$examen]['fecha'].'>= ',$ini);
        }
        if($fin != '')
        {
            $this->db->where($mapeo[$examen]['fecha'].'<= ',$fin);
        }
        if(isset($mapeo[$examen]['where']))
        {
            $this->db->where($mapeo[$examen]['where']['campo'],$mapeo[$examen]['where']['valor']);
        }
        $result = $this->db->get();
        return $result->row_array();
    }

    function delete_costos($emp_id)
    {
        $this->db->where('emp_id',$emp_id);
        return $this->db->delete('sis16_empresas_costos');
    }

    function insert_costos($params)
    {
        return $this->db->insert_batch('sis16_empresas_costos',$params);
    }
	
	function insert_costos_paquete($params)
    {
        return $this->db->insert('sis16_empresas_costos',$params);
    }
}