<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Generico_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    function insert($data_insert)
    {
        $this->db->insert('fsm_generico', $data_insert);
        return $this->db->insert_id();
    }
	

    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_generico');
        $this->db->where('fsm_id', $fsm_id);

        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }
		
        $result = $this->db->get();
        return $result->row_array();
    }


    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
		$this->db->select('*');
        $this->db->from('fsm_generico');
        $this->db->where('clte_id', $cliente_id);

        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }
		
        $this->db->order_by('generico_f_recibido','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	

    function delete_generico($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_generico');
    }
	
}