<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Agendaos_model extends CI_Model
{
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 
    function horario($semana,$table)
    {
       $this->db->select('*');
        $this->db->from($table);

		if ($semana == 52)
		{	
			$week=array(52,1);
			$this->db->where_in('she_semana', $week);
		}
		else
		{	
			$this->db->where('she_semana >=', $semana);
			$this->db->where('she_semana <=', $semana+2);	
			
		}
		
		$this->db->where('she_fecha >=',date('Y-m-d'));
		$this->db->where('she_capacidad >', 0);
        return $this->db->get()->result_array();
	
    }


	function get_horario($id_horario)
	{
		$this->db->select('*');
        $this->db->from('doc11_sheduler');
		$this->db->where('she_id',$id_horario);
        return $this->db->get()->row_array();		
	}
	
	function valida_horario($id_horario,$cuantos_evaluados,$table)
	{
		$this->db->select('*');
        $this->db->from($table);
		$this->db->where('she_id',$id_horario);
		$this->db->where('she_capacidad >=',$cuantos_evaluados);
        return $this->db->get()->row_array();		
	}

	function aparta_horario($id_horario,$params,$table)	
    {
		$this->db->where('she_id',$id_horario);
        $data_update = array_merge($params, log_insert('Se descuenta capacidad'));
        $folio=$this->db->update($table,$data_update);		
		return $folio;
    }	
    
    function get_all_eventos_json($year, $month)
    {   $user = $this->session->user; 
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
	
       $query   = "select * "
                . "from doc11_calendario "
                . "where year(cal_fecha_ini) = '".$year."' "
                . "and month(cal_fecha_ini) = '".$month."' "
				. "and cal_estatus like 'ACTIVO' ";
		
		if (chk_autoridad_total($user['usr_id'],'COORDINADOR_HC') > 0 )
		{} else { $query   .= " and cal_asignacion like '".$user['usr_id']."' ";}	
		
        $query .= "order by cal_fecha_ini ASC;";
        
        $result  = $this->db->query($query);
        $eventos = $result->result_array();
        if($eventos)
        {
            $data_events = array();
            $i = 0;
            foreach ($eventos as $evento)
            {
                $data_events[$i]['id'] = $evento['cal_id'];
                $data_events[$i]['title'] = substr($evento['cal_titulo'],0,120);//cambiar longitud
                $data_events[$i]['fecha_ini'] = $evento['cal_fecha_ini'];
                $data_events[$i]['fecha_fin'] = $evento['cal_fecha_fin'];
                $i++;
            }
            return $data_events;
        }
        else
        {
            return FALSE;
        }
    }
    
    function get_evento($cal_id)
    {
        $this->db->select('*');
        $this->db->from('doc11_calendario as a');
        $this->db->where('cal_id', $cal_id);
        return $this->db->get()->row_array();
    }
      

/*********************************************************************/	
	function get_allo_eventos($rows)
    {
		
		$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
		
		$this->db->select('*');
        $this->db->from('doc11_calendario');
        $this->db->order_by('cal_fecha_ini DESC');
		$this->db->limit($rows, $page);
        return $this->db->get()->result_array();
    }
 /*********************************************************************/ 
         function count_all()
        {
            $this->db->select("count(cal_id) as regs");
            $this->db->from('doc11_calendario');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
/*********************************************************************/	
		function eventos_dia($empresa,$cei,$f_ini,$f_fin)
		{
			$this->db->select('*');
			$this->db->from('doc11_calendario');
			if ($empresa > 0)
			{	
				$this->db->where('emp_id', $empresa);
			}
			$this->db->where('cal_fecha_ini >=', $f_ini. ' 00:00:00');
			$this->db->where('cal_fecha_ini <=', $f_ini. ' 23:59:59');
			//$this->db->where('cal_fecha_fin', $f_fin);
			$this->db->order_by('cal_fecha_ini ASC');
			return $this->db->get()->result_array();		
		}
 /*********************************************************************/  
	  
    /*
     * Get all doc11_calendario
     */
    function get_all_eventos($year, $month)
    {
        $query   = "select * "
                . "from doc11_calendario "
                . "where year(cal_fecha) = '".$year."' "
                . "and month(cal_fecha) = '".$month."' "
                . "and abn_id = '".get_abn_id()."' "
                . "order by cal_fecha ASC, cal_hora_ini ASC;";
        
        $result  = $this->db->query($query);
        $eventos = $result->result_array();
        if($eventos)
        {
            $data_events = array();
            foreach ($eventos as $evento)
            {
                $array_h = explode(':', $evento['cal_hora_ini']);
                $hora =$array_h[0].':'.$array_h[1];
                $data_events[intval(date('j', strtotime($evento['cal_fecha'])))][] = array('title' => substr($evento['cal_titulo'],0,50), 'url' => base_url('medico/agenda/evento/'.$evento['cal_id']), 'time' => $hora);
            }
            return $data_events;
        }
        else
        {
            return FALSE;
        }
    }
    
    /*
     * function to add new doc11_calendario
     */
    function add_evento($params)
    {
        $data_insert = array_merge($params, log_insert('Inserta evento'));
        $this->db->insert('doc11_calendario',$data_insert);
        return $this->db->insert_id();
    }
	

	function add_evento_folio_en_servicio($params)
    {
        $data_insert = array_merge($params, log_insert('Inserta evento'));
        $this->db->insert('doc11_calendario',$data_insert);
        $folio= $this->db->insert_id();
		
		$params['cal_titulo']='FOLIO DE AGENDA: '.$folio.' | '.$params['cal_titulo']; 
		$this->db->where('cal_id',$folio);
        $data_update = array_merge($params, log_insert('Inserta evento y CAL_ID'));
        $this->db->update('doc11_calendario',$data_update);		
		return $folio;
    }
	
	function add_evento_folio($params)
    {
        $data_insert = array_merge($params, log_insert('Inserta evento'));
        $this->db->insert('doc11_calendario',$data_insert);
        $folio= $this->db->insert_id();
		return $folio;
    }
    
    /*
     * function to update doc11_calendario
     */
    function update_evento($cal_id,$params)
    {
        $this->db->where('cal_id',$cal_id);
        $data_update = array_merge($params, log_insert('Actualiza evento'));
        return $this->db->update('doc11_calendario',$data_update);
    }
    
    
    /*
     * function to delete doc11_calendario
     */
    function delete_evento($cal_id)
    {
        return $this->db->delete('doc11_calendario',array('cal_id'=>$cal_id));
    }
    
    
    /*
     * Get doc11_calendario by cal_id
     */
    function get_cons_post_hoy($cons_id)
    {
        $this->db->select('cal_id');
        $this->db->from('doc11_calendario as a');
        $this->db->where('cons_id' , $cons_id);
        $this->db->where('cal_fecha_ini >=', date('Y-m-d'));
        return $this->db->get()->result_array();
    }
}