<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Nom35f_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }

         function get_pensante_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_pensante_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
		
		
         function get_cleaver_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_cleaver_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		


         function get_entrevista_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_entrevista_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

         function get_proyectivas_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_proyectivas_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

		function add_pensante_doc($data_insert)
        {
            $this->db->insert('sis13_pensante_doc', $data_insert);
            return $this->db->insert_id();
        }



         function get_vendedor_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_vendedor_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

		function add_vendedor_doc($data_insert)
        {
            $this->db->insert('sis13_vendedor_doc', $data_insert);
            return $this->db->insert_id();
        }

		function delete_doc_PPSM16PF($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_ppsm16mf_doc');
		}
		
		function get_doc_PPSM16PF($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_ppsm16mf_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
		
		function add_PPSM16PF_doc($data_insert)
        {
            $this->db->insert('sis12_ppsm16mf_doc', $data_insert);
            return $this->db->insert_id();
        } 
		
		function get_PPSM16PF_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_ppsm16mf_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }	

        function get_doc_detail_insignia($clte_id,$emp_id,$serv_id,$doc_nombre )
        {
            $this->db->select('*');
            $this->db->from('sis12_sgmty_doc');
            $this->db->where('clte_id', $clte_id);
			$this->db->where('emp_id', $emp_id);
			$this->db->where('serv_id', $serv_id);
			$this->db->like('doc_nombre', $doc_nombre);
            $result = $this->db->get();
            return $result->row_array();
        }

		function borrar_comentario($fsm_id)
		{
			$this->db->where('com_id', $fsm_id);
			return $this->db->delete('sis06_clientes_com');
		}


		function get_quincena($fecha)
        {
            $this->db->select("*");
            $this->db->from('doc10_quincenas');
			$this->db->where('qui_fecha_ini <=',$fecha);
			$this->db->where('qui_fecha_fin >=',$fecha);
            $result = $this->db->get();			
            $row = $result->row_array();
		return $row['qui_descripcion'];
        }

		function count_allo_corporacion($suc,$campo_corpo,$corpo)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis05_clientes.paciente', 0);
			$this->db->where($campo_corpo, $corpo);
            $result = $this->db->get();			
            $row = $result->row_array();
            return $row['regs'];
        }


		function count_allo_gsi($suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$gsi)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
			/*$this->db->where_in('emp_id',$gsi);*/
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
            $result = $this->db->get();			
            $row = $result->row_array();
            return $row['regs'];
        }		 
	



		function get_all_only($rows)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "*";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis04_conduce');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();

            return $result->result_array();

        } 
	
		function get_allo_gsi($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife,clte_webflow, hc, num_empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            
			$this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
			$this->db->where('sis05_clientes.paciente', 0);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();

            return $result->result_array();

        } 	 


		function get_allo_gsi_reclutadora($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife,clte_nife, hc, num_empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($suc)
			{
				
				$this->db->where('desp_id', $suc);
			}	
            $this->db->where('status', 'activo');
            
			$this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();

            return $result->result_array();

        }

		function get_allo_emp_asig($rows,$empresas)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife,clte_nife, hc, num_empleado,f_ingreso,log_insrt_usr_cve ,clte_webflow, clte_ida,f_baja,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo'); 
			$this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis05_clientes.emp_id', $empresas);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

		function get_allo_emp_asig_psw($rows,$empresas)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife,clte_nife, hc, num_empleado,f_ingreso, f_baja,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo'); 
			$this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis05_clientes.emp_id', $empresas);
			$this->db->where('sis05_clientes.empleado !=', 1);
			$this->db->where('sis05_clientes.paciente !=',1);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

		function get_allo_p_gsi($rows,$usr_emp_asig,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife,clte_nife, hc, num_empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($paciente==1)
			{
				$this->db->where('sis05_clientes.paciente',1);
				
				//$this->db->where('sis05_clientes.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS
			}	
            if ($usr_emp_asig)
			{
				
				$this->db->where('med_emp_asig', $usr_emp_asig);
			}			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
			$this->db->like('root', 'GSI');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }		 



		function get_allo_dx($rows)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.paciente',1);
			$this->db->not_like('root', 'GSI');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }
	
		function get_allo_p($rows,$usr_emp_asig,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($paciente==1)
			{
				$this->db->where('sis05_clientes.paciente',1);
				
				//$this->db->where('sis05_clientes.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS
			}	
            if ($usr_emp_asig)
			{
				
				$this->db->where('med_emp_asig', $usr_emp_asig);
			}			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
			$this->db->not_like('root', 'GSI');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        } 

		function get_allo_empleados_rol($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado, f_ingreso, f_baja,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->where('sis05_clientes.empleado_rol >',0);
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }



		function get_unique_e($clte_id,$rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado, f_ingreso, f_baja,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.clte_id',$clte_id);
			
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->not_like('sis05_clientes.num_empleado ','8000');
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();

        }


		function get_unique_ee($clte_id,$rows,$emp_id)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado, f_ingreso, f_baja,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.clte_id',$clte_id);
			
		/*	if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->not_like('sis05_clientes.num_empleado ','8000');
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	*/
            $this->db->where('status', 'activo');
        /*    $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');*/
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();

        }



		function get_allo_e($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado, f_ingreso, f_baja,clte_status_proc,clte_ida,clte_cat_puesto,clte_ida";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->not_like('sis05_clientes.num_empleado ','8000');
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }


		function get_allo_externos($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado, f_ingreso, f_baja,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.empleado_rol',0);
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }


		function get_allo_ee($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado, f_ingreso, f_baja,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->like('sis05_clientes.num_empleado ','8000');
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }

		function get_allo_hc($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.hc',1);
            $this->db->where('status', 'activo');
			$this->db->order_by('log_insrt_f','DESC');	  
			//$this->db->order_by('clte_paterno_crypt, clte_materno_crypt','asc');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }



		function get_allo_empleados($emp_id,$empleado=0)
        {

            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id,emp_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			
			$this->db->where('sis05_clientes.emp_id',$emp_id);
			
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
            $this->db->where('status', 'activo');
            $this->db->order_by('log_insrt_f','DESC');

            $result = $this->db->get();

            return $result->result_array();

        }






		function get_allo_empleados_reportes($emp_id,$modo=0)
        {

            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id,emp_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado,f_ingreso, f_baja, empleado,area_depto,clte_status_proc,clte_ida,clte_cat_puesto";
          	$this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');			
			$this->db->where('emp_id',$emp_id);

			if ($modo == 0)
			{
				$this->db->where('empleado',0);	
			}			
			elseif ($modo == 1)
			{
					$this->db->where('empleado',1);	
					$this->db->not_like('status','NOACTIVO');
					$this->db->where('empleado_rol',0);
			}			
			elseif ($modo == 2)
			{
					$this->db->where('empleado',1);	
					$this->db->not_like('status','NOACTIVO');
					$this->db->where('empleado_rol >',0);
			}
			elseif ($modo == 3)
			{
					$this->db->where('empleado',1);	
					$this->db->like('status','NOACTIVO');
			}
            $this->db->order_by('clte_paterno','ASC');
			$this->db->order_by('clte_materno','ASC');
			$this->db->order_by('clte_nombre','ASC');			
            //$this->db->order_by('log_insrt_f','DESC');

            $result = $this->db->get();

            return $result->result_array();

        }




		function get_allo_emp_sw_nombres($emp_id,$modo=0)
        {

            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id,emp_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado,f_ingreso, f_baja, empleado,area_depto,clte_status_proc,clte_ida,clte_cat_puesto";
          	$this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			
			$this->db->where('emp_id',$emp_id);

			if ($modo == 0)
			{
				$this->db->where('empleado',0);	
			}			
			elseif ($modo == 1)
			{
					$this->db->where('empleado',1);	
					$this->db->not_like('status','NOACTIVO');
					$this->db->like('num_empleado','8000');
			}			
			elseif ($modo == 2)
			{
					$this->db->where('empleado',1);	
					$this->db->not_like('status','NOACTIVO');
					$this->db->not_like('num_empleado','8000');
			}
			elseif ($modo == 3)
			{
					$this->db->where('empleado',1);	
					$this->db->like('status','NOACTIVO');
			}
            $this->db->order_by('clte_paterno','ASC');
			$this->db->order_by('clte_materno','ASC');
			$this->db->order_by('clte_nombre','ASC');			
            //$this->db->order_by('log_insrt_f','DESC');

            $result = $this->db->get();

            return $result->result_array();

        }





		function get_allo_empleados_nombres($emp_id,$empleado=0)
        {

            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id,emp_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado,clte_status_proc,clte_ida,clte_cat_puesto,area_depto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			
			$this->db->where('sis05_clientes.emp_id',$emp_id);
			
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
            $this->db->where('status', 'activo');
            $this->db->order_by('clte_paterno','ASC');
			$this->db->order_by('clte_materno','ASC');
			$this->db->order_by('clte_nombre','ASC');			
            //$this->db->order_by('log_insrt_f','DESC');

            $result = $this->db->get();

            return $result->result_array();

        }



		function get_allo_m($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
			$names = array(28163,
19581,
27842,
21598,
28198,
26062,
22647,
26904,
29070,
14174,
27887,
28166,
25410,
19297,
7367,
4728,
28230,
21787,
25406,
28638,
22813,
16887,
17862,
25980,19472,30746,30743,30744,30745,27765,
27802,27187
) ;
			$this->db->where_in('sis05_clientes.clte_id', $names);
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }
	
		function get_allo_a($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');

				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc != ',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);

			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }	

		function get_allo_b($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado, status,f_baja,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');

				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}
			
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->like('sis05_clientes.status','NOACTIVO');

			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
           
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }		



		function get_allo_gsi_agenda_sborja($rows,$emp_id)
        {                        
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt,suc_id,log_insrt_usr_cve,clte_webflow,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('paciente !=',1); 
			$this->db->where('empleado !=',1);
			$this->db->where('cei_id !=',8);
			$this->db->where('clte_ida =',0); //para que ya no aparezca si feu asignada
            $this->db->where('status', 'activo');           
			$this->db->where_in('emp_id', $emp_id);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows);
            $result = $this->db->get();
            return $result->result_array();
        }
		
		function get_allo_gsi_agenda($rows,$emp_id)
        {                        
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt,suc_id,log_insrt_usr_cve,clte_webflow,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('paciente !=',1); 
			$this->db->where('empleado !=',1);
			$this->db->where('clte_ida =',0); //para que ya no aparezca si feu asignada
            $this->db->where('status', 'activo');           
			$this->db->where_in('emp_id', $emp_id);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows);
            $result = $this->db->get();
            return $result->result_array();
        }


		function get_allo_alpura_agenda($rows,$emp_id)
        {                        
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt,suc_id,log_insrt_usr_cve,clte_webflow,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('paciente !=',1); 
			$this->db->where('empleado',1);	   //solo empleados
			$this->db->where('clte_ida =',0); //para que ya no aparezca si feu asignada
            $this->db->where('status', 'activo');           
			$this->db->where_in('emp_id', $emp_id);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows);
            $result = $this->db->get();
            return $result->result_array();
        }
		

		function get_allo_gsi_agenda_reclutadoras($rows,$emp_id)
        {                        
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, emp_id,suc_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			$this->db->where('paciente !=',1); 
			$this->db->where('empleado !=',1);
            $this->db->where('status', 'activo');           
			$this->db->where('desp_id', $emp_id);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows);
            $result = $this->db->get();
            return $result->result_array();

        }


		function get_all_wrk($rows, $empresas)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;			
           
			if (get_perfil_id() != 4)
			{			
				$select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife,clte_webflow, hc,clte_status_proc,clte_ida,clte_cat_puesto";
				$this->db->select(parsea_select($select, 'humancenter'));
				$this->db->from('sis05_clientes');
				$this->db->where('sis05_clientes.paciente !=',1);
				$this->db->where('sis05_clientes.empleado',1);
				$this->db->where('status', 'activo');
				$this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
				$this->db->where_in('sis05_clientes.emp_id', $empresas);
				$this->db->order_by('log_insrt_f','DESC');
				$this->db->limit($rows, $page);
				$result = $this->db->get();
				
				return $result->result_array();
			}
        } 
	
		function get_allo($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
			
            $user = $this->session->user;
			
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife,clte_webflow, hc,clte_status_proc,clte_ida,serv_id,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			
			
			if ($paciente==1)
			{
				$this->db->where('sis05_clientes.paciente =',1);
			}
			else
			{
				$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS
				$this->db->where('sis05_clientes.empleado !=',1);
			}			
			
			if ($suc)
			{
				$sucursales=$suc;//.';';
				$a_sucursales=explode(';',$sucursales);
				$this->db->where_in('suc_id', $a_sucursales);
			}
			/*(if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
			*/
			
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');

			if (get_perfil_id() == 4)
			{
				if ( $es_usr_de_un_despacho == 0)
				{	
					//$empresas = get_empresas_array();
					//$this->db->where_in('sis05_clientes.emp_id', $empresas);
					
					$emp_id_user=get_emp_id();
					$this->db->where('sis05_clientes.emp_id', $emp_id_user);
				}
				else
				{	
					$this->db->where('sis05_clientes.desp_id', $es_usr_de_un_despacho);

				}	
				
				$emp_id_user=get_emp_id();
				
				if ($emp_id_user == 31)
				{
				 $this->db->where('sis05_clientes.hc =',1); //SOLO DEJAR a la gente HC	
				}	
				
			}
			else
			{
				if ($root1 > 2)
				{
					$this->db->where('sis05_clientes.cei_id', $cei);
				}
				
				if ( ( $user['usr_id'] != 261) && ($user['usr_id'] != 302) )
				{
					$this->db->where('sis05_clientes.hc !=',1); //quitar al personal HC	
				}				
			}	

            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			
            return $result->result_array();

        } 
 
 
		function get_empleados_nom035($emp_id)
        {            

			$CIs =& get_instance();
			$CIs->load->model('empleado/Empleado_model','empleado');
			$user = $this->session->user;
			$usuario = $CIs->empleado->get($user['usr_id']);

            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_puesto, clte_rfc_crypt,log_insrt_f,suc_id, cei_id,hc, desp_id, nomserv,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            $this->db->where('a.emp_id',$emp_id);
			if ($emp_id == 31)
			{
				$this->db->where('a.hc',1);
			}	
			elseif ( strstr($usuario['portal'],'CORPO') )
			{
				
			}			
			else
			{
				$this->db->where('a.empleado',1);
			}				
            $this->db->order_by('clte_paterno','ASC');
			$this->db->order_by('clte_materno','ASC');
			$this->db->order_by('clte_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
 
 
 
        function get_all($rows) /*ok clte_nss_crypt*/
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id,cei_id,clte_nss_crypt,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');

            if(get_perfil_id() == 4){
				/*$surcursal_id=get_sucursal_id();
				echo "$surcursal_id->".$surcursal_id."<--";
				if ($surcursal_id > 0)
				{	
				$this->db->where('suc_id', $surcursal_id); 	
				}
				echo " Punto A ";*/
                $empresas = get_empresas_array();
				//echo " Punto B ";
                $this->db->where_in('sis05_clientes.emp_id', $empresas);
				//echo " Punto C ";
            }
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }
        
        function count_all()
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
            

            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
            }

            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


		function count_all_wrk($empresas)
        {
			if (get_perfil_id() != 4)
			{
				$this->db->select("count(clte_id) as regs");
				$this->db->from('sis05_clientes');			
				$this->db->where_in('emp_id', $empresas);
     			$this->db->where('sis05_clientes.paciente !=',1);
				$this->db->where('sis05_clientes.empleado',1);
				$this->db->where('status', 'activo');
				$result = $this->db->get();
				$row = $result->row_array();
				return $row['regs'];
			}	
        }

  


  
		
		function count_allo($suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			
			if ($paciente==1)
			{
				$this->db->where('sis05_clientes.paciente',1);
			}
			else
			{
				$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS
				if ($user['usr_id'] != 261)
				{
					$this->db->where('sis05_clientes.empleado !=',1);
				}
			}
						
            if ($suc)
			{
				$sucursales=$suc; //.';';
				$a_sucursales=explode(';',$sucursales);
				$this->db->where_in('suc_id', $a_sucursales);
			}
			
            
			
			if (get_perfil_id() == 4)
			{
				if ( $es_usr_de_un_despacho == 0)
				{	
			        
					/*$empresas = get_empresas_array();
					$this->db->where_in('emp_id', $empresas);
					$i=33;
					$this->db->where('desp_id !=',$i);*/
					$emp_id_user=get_emp_id();
					$this->db->where('sis05_clientes.emp_id', $emp_id_user);
					
					
				}
				else
				{	
					$this->db->where('desp_id', $es_usr_de_un_despacho);
					
				}				
				$emp_id_user=get_emp_id();
				
				if ($emp_id_user == 31)
				{
				 $this->db->where('sis05_clientes.hc =',1); //SOLO DEJAR a la gente HC	
				}					
			}	
			else
			{
				if ($root1 > 2)
				{
					$this->db->where('sis05_clientes.cei_id', $cei);
				}
				
				if (($user['usr_id'] != 261) && ($user['usr_id'] != 302) )
				{
					$this->db->where('hc !=',1); //quitar al personal HC	
				}				

			}	
			
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }





		function get_allo_cometra($rows)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
			$this->db->where('paciente', 0);
			$this->db->where('empleado', 0);
			$arreglo=array(93,174,175,150,129,30);
			$this->db->where_in('sis05_clientes.emp_id',$arreglo);             
			$this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
			//$this->db->where('sis15_empresas.emp_corp', $corporativo);
			//$this->db->where('sis15_empresas.emp_subcorp', $subcorporativo);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

		function get_allo_gss($rows, $arreglo,$accion='',$state='')
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
			$this->db->where('paciente', 0);
			$this->db->where('empleado', 0);
			//$arreglo=array(93,174,175,150,129,30);
			if (strstr($accion, 'SUCK+'))
			{
				$this->db->where('suc_id', $state);
			}
			$this->db->where_in('sis05_clientes.emp_id',$arreglo);             
			$this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

		function get_allo_empleados_empresas($rows, $arreglo)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
			$this->db->where('paciente', 0);
			$this->db->where('empleado', 1);
			$this->db->like('sis05_clientes.nomserv','EXMEPER');
			$this->db->where_in('sis05_clientes.emp_id',$arreglo);             
			$this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }


		function count_allo_emp_unidad_reclutadora($empresas)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS
			$this->db->where('sis05_clientes.empleado !=',1);
			$this->db->where_in('desp_id', $empresas);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

		function count_allo_emp_asig($empresas,$accion='',$state='')
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS
			$this->db->where('sis05_clientes.empleado !=',1);
			$this->db->where_in('emp_id', $empresas);
			if (strstr($accion, 'SUCK+'))
			{
				$this->db->where('suc_id', $state);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

		function count_allo_empleados_empresas($empresas,$accion='',$state='')
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS
			$this->db->where('sis05_clientes.empleado',1);
			$this->db->like('sis05_clientes.nomserv','EXMEPER');
			$this->db->where_in('emp_id', $empresas);
			if (strstr($accion, 'SUCK+'))
			{
				$this->db->where('suc_id', $state);
			}	
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

		function count_allo_dx()
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.paciente',1);
			$this->db->not_like('root', 'GSI');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


		function count_allo_p($suc,$usr_emp_asig,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			
			if ($paciente==1)
			{
				$this->db->where('sis05_clientes.paciente',1);
			}
			else
			{
				$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS				
			}

            if ($usr_emp_asig)
			{
				
				$this->db->where('med_emp_asig', $usr_emp_asig);
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
			$this->db->like('root', '');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }		
		
		
		function count_allo_p_gsi($suc,$usr_emp_asig,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			
			if ($paciente==1)
			{
				$this->db->where('sis05_clientes.paciente',1);
			}
			else
			{
				$this->db->where('sis05_clientes.paciente !=',1); //SOLO DEJAR EVALUADOS				
			}

            if ($usr_emp_asig)
			{
				
				$this->db->where('med_emp_asig', $usr_emp_asig);
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
			$this->db->like('root', 'GSI');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }		

		function count_all_empleados_hc_gsi_medicos($emp_id,$where)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('emp_id',$emp_id);
			$this->db->where($where);
			$this->db->where('hc',1);
			$this->db->where('status', 'activo');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


		function get_all_empleados_hc_gsi_medicos($rows,$emp_id,$where)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt,clte_nife, hc, num_empleado, empleado,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
			$this->db->from('sis05_clientes');			
			$this->db->where('emp_id',$emp_id);
			$this->db->where($where);			
			$this->db->where('hc',1);
			$this->db->where('status', 'activo');
			$this->db->order_by('clte_paterno, clte_materno, clte_nombre','ASC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();
		}



		function busca_empleados_hc_gsi_medicos($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='')
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_puesto, clte_rfc_crypt,log_insrt_f,suc_id, cei_id, desp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('emp_id',$empresa);
			$where = "cei_id = 4 and  (clte_puesto = 'MÉDICO EVALUADOR' or clte_puesto = 'ENFERMERA'  )";
			$this->db->where($where);			
			$this->db->where('hc',1);
			$this->db->where('status', 'activo');
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }



		function count_allo_empleados($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.emp_id',$emp_id);
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->where('sis05_clientes.empleado_rol >',0);
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }



		
		function count_allo_e($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.emp_id',$emp_id);
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->not_like('sis05_clientes.num_empleado ','8000');
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }	



		function count_allo_externos($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.emp_id',$emp_id);
			$this->db->where('sis05_clientes.empleado_rol',0);
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}
			
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->like('sis05_clientes.num_empleado','8000');
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}
						
            if ($suc)
			{
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }



		
		function count_allo_ee($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.emp_id',$emp_id);
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}
			
				$this->db->where('sis05_clientes.emp_id',$emp_id);
				$this->db->like('sis05_clientes.num_empleado','8000');
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }	




		

		function count_allo_m($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.emp_id',$emp_id);
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis05_clientes.empleado !=',1); //SOLO DEJAR EVALUADOS
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
			
			$names = array(28163,
19581,
27842,
21598,
28198,
26062,
22647,
26904,
29070,
14174,
27887,
28166,
25410,
19297,
7367,
4728,
28230,
21787,
25406,
28638,
22813,
16887,
17862,
25980,19472,30746,30743,30744,30745,27765,
27802,27187
) ;
			$this->db->where_in('sis05_clientes.clte_id', $names);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
		
		
		function count_allo_a($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.emp_id',$emp_id);
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc !=',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
			$this->db->like('sis05_clientes.status','activo');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


		function count_allo_b($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
			$this->db->where('sis05_clientes.emp_id',$emp_id);
				if ($emp_id==31)
				{$this->db->where('sis05_clientes.hc',1);}
				else
				{$this->db->where('sis05_clientes.empleado',1);	}							
				$this->db->where('sis05_clientes.emp_id',$emp_id);	
				$this->db->like('sis05_clientes.status','NOACTIVO');
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }



        function get_special($id,$gss)
        {   			
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto,emp_id, log_insrt_f,clte_edo_civ_cve, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,clte_nss_crypt,clte_nife,clte_arraigo,clte_nacionalidad,clte_regimen,clte_tel_recados_crypt,clte_redes_sociales,clte_env_entre_calles_crypt,desp_id,nomserv,root,desp_id,suc_id,cei_id, serv_id,serv_orden,clte_reclutador, paciente, num_empleado, empleado,hc,status,f_ingreso,f_baja, clte_observaciones,sueldo,usr_id,prestamo,supervisor,domserv,area_depto,clte_tipo_sangre,f_ingreso, f_baja,clte_region,clte_webflow,empleado_rol,clte_cat_puesto,clte_ida";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('clte_id', $id); 
			$this->db->where_in('emp_id', $gss); 
            $result = $this->db->get();			
            return $result->row_array();           
        }

		
        function get($id,$es_usr_de_un_despacho=0)
        {   
			$user = $this->session->user;
			
			
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto,emp_id, log_insrt_f,clte_edo_civ_cve, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,clte_nss_crypt,clte_nife,clte_arraigo,clte_nacionalidad,clte_regimen,clte_tel_recados_crypt,clte_redes_sociales,clte_env_entre_calles_crypt,desp_id,nomserv,root,desp_id,suc_id,cei_id, serv_id,serv_orden,clte_reclutador, paciente, num_empleado, empleado,hc,status,f_ingreso,f_baja, clte_observaciones,sueldo,usr_id,prestamo,supervisor,domserv,area_depto,clte_tipo_sangre,f_ingreso, f_baja,clte_region,clte_webflow,empleado_rol, clte_centro_costo,clte_accidente_av,clte_parentesco_av,clte_telefono_av,clte_clinica_imss,clte_no_consultorio,clte_f_consulta,clte_turno,clte_status_proc,clte_ida,clte_zona,clte_objeto,clte_cat_puesto,clte_gral_med";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');

			if (get_perfil_id() == 4) 
			{
				if (
					($user['usr_id'] != 589) && 
					($user['usr_id'] != 590) && 
					($user['usr_id'] != 591) &&
					 ($user['usr_id'] != 1254) 
					)
				{	
					if ( $es_usr_de_un_despacho == 0)
					{	
						
						$empresas = get_empresas_array();
						$this->db->where_in('emp_id', $empresas);
					}
					else
					{	
						$this->db->where('desp_id', $es_usr_de_un_despacho);
					}
				}
			}

            $this->db->where('clte_id', $id);         
            $result = $this->db->get();
			
            return $result->row_array();
           
        }


        function geton($id)
        {   
			$user = $this->session->user;
			
			
           // $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto,emp_id, log_insrt_f,clte_edo_civ_cve, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,clte_nss_crypt,clte_nife,clte_arraigo,clte_nacionalidad,clte_regimen,clte_tel_recados_crypt,clte_redes_sociales,clte_env_entre_calles_crypt,desp_id,nomserv,root,desp_id,suc_id,cei_id, serv_id,serv_orden,clte_reclutador, paciente, num_empleado, empleado,hc,status,f_ingreso,f_baja, clte_observaciones,sueldo,usr_id,prestamo,supervisor,domserv,area_depto,clte_tipo_sangre,f_ingreso, f_baja,clte_region,clte_webflow,empleado_rol, clte_centro_costo,clte_accidente_av,clte_parentesco_av,clte_telefono_av,clte_clinica_imss,clte_no_consultorio,clte_f_consulta,clte_turno,clte_status_proc,clte_ida,clte_zona,clte_objeto,clte_cat_puesto,clte_gral_med";
             $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt";
			$this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');

            $this->db->where('clte_id', $id);         
            $result = $this->db->get();
			
            return $result->row_array();
           
        }



        function get_by_cei($id,$emp_id=0,$cei=0)
        {   
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto,emp_id, log_insrt_f,clte_edo_civ_cve, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,clte_nss_crypt,clte_nife,clte_arraigo,clte_nacionalidad,clte_regimen,clte_tel_recados_crypt,clte_redes_sociales,clte_env_entre_calles_crypt,desp_id,ordenes_series,root,desp_id,suc_id,cei_id, serv_id,serv_orden,clte_reclutador, paciente, num_empleado, empleado,hc,status,f_ingreso, f_baja,sueldo,usr_id,prestamo,supervisor,domserv,clte_cat_puesto ";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
			if ($cei>0)
			{	
				$this->db->where('cei_id', $cei);
			}
			if ($emp_id>0)
			{	
				$this->db->where('emp_id', $emp_id);
			}			
            $this->db->where('clte_id', $id);         
            $result = $this->db->get();			
            return $result->row_array();           
        }






        function get_card($id)
        {   
            $select = "*";
            $this->db->select($select);
            $this->db->from('sis06_clientes_card');
            $this->db->where('clte_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }

        function get_especial($id,$genero='')/*ok clte_nss_crypt*/
        {   
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_path_foto,emp_id, log_insrt_f,clte_edo_civ_cve, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,clte_nss_crypt,clte_nife,clte_arraigo,clte_nacionalidad,clte_regimen,clte_tel_recados_crypt,clte_redes_sociales,clte_env_entre_calles_crypt,desp_id,ordenes_series,nomserv,root,desp_id,suc_id,cei_id, serv_id,serv_orden,clte_reclutador, paciente, num_empleado, empleado,hc,status,f_ingreso, f_baja,sueldo,sueldo,sueldo,usr_id,prestamo,supervisor,domserv,clte_cat_puesto";
            //$select = "*";
			$this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->where('clte_id', $id); 
			if ($genero != '')
			{	
				$this->db->where('clte_genero_cve', $genero); 
			}	
            $result = $this->db->get();
			
            return $result->row_array();
           
        }


        function get_roots($id)
        {
            $select = "root1,root2";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }


        function get_a_usuario($id)
        {
            $select = "*";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();           
        }


        function get_my_servicios($id)
        {
            $select = "servicios";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }

        function get_my_modulos($id)
        {
            $select = "modulo";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }
        
        function get_empresa_by_clte($clte_id)
        {
            $select = "sis15_empresas.*";
            $this->db->select($select);
            $this->db->from('sis05_clientes');
            $this->db->join('sis15_empresas', 'sis15_empresas.emp_id = sis05_clientes.emp_id');
            $this->db->where('clte_id', $clte_id);
            $result = $this->db->get();
            return $result->row_array();
        }
   


       function insrt_update_worker($clte_id,$emp_id,$params)
        {
			$user = $this->session->user; 
			$this->db->select('work_id');
            $this->db->from('sis07_workers');
			$this->db->where('clte_id', $clte_id);
			$this->db->where('emp_id', $emp_id);
			$result = $this->db->get();
			$r=$result->row_array();
			
						
			if ($r['work_id'] > 0)
			{
				$params['log_updt_f']=date('Y-m-d H:i:s'); 
				$params['log_updt_usr_cve']=$user['usr_id'];
				$this->db->where('work_id',$r['work_id']);
				return $this->db->update('sis07_workers',$params);
			}
			else
			{
				$params['log_insrt_f']=date('Y-m-d H:i:s'); 
				$params['log_insrt_usr_cve']=$user['usr_id'];				
				$this->db->insert('sis07_workers',$params);
				return $this->db->insert_id();				
			}
        }




       function get_worker($clte_id,$emp_id)
        {
			$this->db->select('*');
            $this->db->from('sis07_workers');
			$this->db->where('clte_id', $clte_id);
			$this->db->where('emp_id',$emp_id);
			$result = $this->db->get();
			return  $result->row_array();
        }



   
        function inserta($params)
        {
            $data = array_merge($params, log_insert('Nuevo cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('sis05_clientes');
            return $this->db->insert_id();
        }
		
        function inserta_card($data_insert)
        {
            //$data = array_merge($params, log_insert('Nuevo cliente'));
            //parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('sis06_clientes_card',$data_insert);
            return $this->db->insert_id();
        }		


        function inserta_empleados_card($data_insert)
        {
            //$data = array_merge($params, log_insert('Nuevo cliente'));
            //parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('sis06_empleados_card',$data_insert);
            return $this->db->insert_id();
        }

		
        function actualiza($clte_id, $params)
        {
            $data = array_merge($params, log_update('Edita cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis05_clientes');
        }
		
        function actualiza_status($clte_id,$estatus)
        {
			$params['status']=$estatus;
            $data = array_merge($params, log_update('Cambio de ESTATUS'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis05_clientes');
        }		


        function actualiza_nombre_doc($fsm_id, $params)
        {
            $this->db->where('doc_id',$fsm_id);
            return $this->db->update('sis10_clientes_doc',$params);
        }
		
  
        function actualiza_registro($clte_id, $params)
        {
            $data = array_merge($params, log_update_reg('Edita y registra nuevamente cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis05_clientes');
        }
 
        function actualiza_registro_sin_log($clte_id, $data)
        {
            //$data = array_merge($params, log_update_reg('Edita y registra nuevamente cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis05_clientes');
        }
 
 
        function actualiza_registro_card($clte_id, $params)
        {
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis06_clientes_card',$params);
        } 
  
        function actualiza_registro_individual($clte_id, $params)
        {
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis05_clientes',$params);
        }
  
        function get_coms($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis06_clientes_com');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('com_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_obs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis06_clientes_obs');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('obs_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

         function get_medico_by_examen($cliente_id,$serv_id,$tabla)
        {
           $this->db->select('*');
            $this->db->from($tabla);
            $this->db->where('clte_id', $cliente_id);
			$this->db->where('serv_id', $serv_id);
            $result = $this->db->get();
            $r=$result->row_array();
		 	return $r['med_id']; 
			/*return 351;*/
        }
 
        function get_doc_gen($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis10_clientes_gen_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }

 
        function get_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis10_clientes_doc');
            $this->db->where('clte_id', $cliente_id);
           // $this->db->order_by('doc_f','DESC');
		   $this->db->order_by('doc_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis10_clientes_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
		
		function inserta_borrado($data_insert)
		{
			$this->db->insert('sis_borrado_docs', $data_insert);
			return $this->db->insert_id();
		}		
        
		function delete_doc($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis10_clientes_doc');
		}			

		function delete_doc_TORAX($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_torax_doc');
		}
		
		function delete_doc_ANTICUA($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_anticua_doc');
		}		

		function delete_doc_ALCOSA($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_alcosa_doc');
		}	

		
		function delete_doc_RADIOL($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_radiol_doc');
		}	

		function delete_doc_RADIOT($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_radiot_doc');
		}	

		function delete_doc_PCR($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_pcr_doc');
		}		

        function actualiza_nombre_doc_gen($fsm_id, $params)
        {
            $this->db->where('doc_id',$fsm_id);
            return $this->db->update('sis10_clientes_gen_doc',$params);
        }

		function delete_doc_gen($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis10_clientes_gen_doc');
		}
		
        function add_doc($data_insert)
        {
            $this->db->insert('sis10_clientes_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_doc_gen($data_insert)
        {
            $this->db->insert('sis10_clientes_gen_doc', $data_insert);
            return $this->db->insert_id();
        }		
/***************************COMPORTAMIENTO*******************************************/
        function get_compo_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_comportamiento_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 

 
 
        function get_sgmty_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_sgmty_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_doc_sgmty($cliente_id,$doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_sgmty_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->where('doc_id',$doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }

        function get_covid_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_covid_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_AUDIO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_audio_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function get_VDRL_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_vdrl_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function get_SPIRO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_spiro_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		

        function get_KOH_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_koh_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function get_CULTIVOU_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_cultivou_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		

        function get_VALPROF_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_valprof_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		
 
         function get_VISTA_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_vista_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
        function get_ELECTRO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_electro_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


		function get_CERTIFICADO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_certificado_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

		function get_FINANCIERO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_financiero_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
	
		function get_PLOMO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_plomo_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

	
		function get_ELECTROE_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_electroe_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		function get_hhcc_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_hhcc_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		

		function get_ELECTROR_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_electror_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		
 
         function get_LEGAL_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_legal_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 

 
        function get_BURO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_buro_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


       function get_gen_docs($cliente_id,$clave, $table)
        {
            $this->db->select('*');
            $this->db->from('sis10_clientes_gen_doc');
            $this->db->where('clte_id', $cliente_id);
		    $this->db->like('doc_nombre', $clave);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

       function get_LABORATORIODS_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_laboratorio_ds_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
         function get_EXAMMDS_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_examm_ds_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
         function get_EXAMM_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_examm_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

         function get_LABORATORIO_DS_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_laboratorio_ds_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
         function get_EXAMM_DS_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_examm_ds_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		
 
           function get_PAPAN_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_papan_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
          function get_RADIOT_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_radiot_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
           function get_RADIOL_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_radiol_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_OPTOM_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_optom_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_RADIOM_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_radiom_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function get_TORAX_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_torax_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

           function get_ALCOSA_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_alcosa_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

           function get_ANTICUA_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_anticua_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
           function get_PCR_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_pcr_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
        function get_compo_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_comportamiento_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
  
        function add_covid_doc($data_insert)
        {
            $this->db->insert('sis12_covid_doc', $data_insert);
            return $this->db->insert_id();
        }
		
        function add_AUDIO_doc($data_insert)
        {
            $this->db->insert('sis12_audio_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_BURO_doc($data_insert)
        {
            $this->db->insert('sis12_buro_doc', $data_insert);
            return $this->db->insert_id();
        }			


        function add_LEGAL_doc($data_insert)
        {
            $this->db->insert('sis12_legal_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_EXAMM_DS_doc($data_insert)
        {
            $this->db->insert('sis12_examm_ds_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_LABORATORIODS_doc($data_insert)
        {
            $this->db->insert('sis12_laboratorio_ds_doc', $data_insert);
            return $this->db->insert_id();
        }		
		
        function add_EXAMM_doc($data_insert)
        {
            $this->db->insert('sis12_examm_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_VDRL_doc($data_insert)
        {
            $this->db->insert('sis12_vdrl_doc', $data_insert);
            return $this->db->insert_id();
        }

       function add_SPIRO_doc($data_insert)
        {
            $this->db->insert('sis12_spiro_doc', $data_insert);
            return $this->db->insert_id();
        }

       function add_evacom_doc($data_insert)
        {
            $this->db->insert('sis12_evacom_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_KOH_doc($data_insert)
        {
            $this->db->insert('sis12_koh_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_CULTIVOU_doc($data_insert)
        {
            $this->db->insert('sis12_cultivou_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_VALPROF_doc($data_insert)
        {
            $this->db->insert('sis12_valprof_doc', $data_insert);
            return $this->db->insert_id();
        }		

        function add_VISTA_doc($data_insert)
        {
            $this->db->insert('sis12_vista_doc', $data_insert);
            return $this->db->insert_id();
        }	

        function add_INTE_doc($data_insert)
        {
            $this->db->insert('sis12_inte_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_PUESIC_doc($data_insert)
        {
            $this->db->insert('sis12_pruebas_psico_doc', $data_insert);
            return $this->db->insert_id();
        }		

        function add_PENSA_doc($data_insert)
        {
            $this->db->insert('sis12_pensa_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_CLEAVER_doc($data_insert)
        {
            $this->db->insert('sis12_cleaver_doc', $data_insert);
            return $this->db->insert_id();
        }


        function add_ENTREVISTA_doc($data_insert)
        {
            $this->db->insert('sis12_entrevista_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_PROYECTIVAS_doc($data_insert)
        {
            $this->db->insert('sis12_proyectivas_doc', $data_insert);
            return $this->db->insert_id();
        }



        function add_EGEREN_doc($data_insert)
        {
            $this->db->insert('sis12_egeren_doc', $data_insert);
            return $this->db->insert_id();
        }


        function add_TERMAN_doc($data_insert)
        {
            $this->db->insert('sis12_terman_doc', $data_insert);
            return $this->db->insert_id();
        }


        function add_ELECTRO_doc($data_insert)
        {
            $this->db->insert('sis12_electro_doc', $data_insert);
            return $this->db->insert_id();
        } 

        function add_PLOMO_doc($data_insert)
        {
            $this->db->insert('sis12_plomo_doc', $data_insert);
            return $this->db->insert_id();
        } 

        function add_CERTIFICADO_doc($data_insert)
        {
            $this->db->insert('sis12_certificado_doc', $data_insert);
            return $this->db->insert_id();
        } 

        function add_FINANCIERO_doc($data_insert)
        {
            $this->db->insert('sis12_financiero_doc', $data_insert);
            return $this->db->insert_id();
        } 

        function add_ELECTROE_doc($data_insert)
        {
            $this->db->insert('sis12_electroe_doc', $data_insert);
            return $this->db->insert_id();
        } 

        function add_ELECTROR_doc($data_insert)
        {
            $this->db->insert('sis12_electror_doc', $data_insert);
            return $this->db->insert_id();
        } 

        function add_HHCC_doc($data_insert)
        {
            $this->db->insert('sis12_hhcc_doc', $data_insert);
            return $this->db->insert_id();
        } 	

        function get_doc_hc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_hhcc_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }		

		function delete_doc_hc($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_hhcc_doc');
		}

        function get_doc_CERTIFICADO($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_certificado_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }


        function get_doc_FINANCIERO($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_financiero_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }

        function get_doc_SPIRO($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_spiro_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }

		function delete_doc_FINANCIERO($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_financiero_doc');
		}

		function delete_doc_CERTIFICADO($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_certificado_doc');
		}

		function delete_doc_SPIRO($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_spiro_doc');
		}

        function get_doc_AUDIO($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_audio_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }

		function delete_doc_AUDIO($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis12_audio_doc');
		}

        function add_PAPAN_doc($data_insert)
        {
            $this->db->insert('sis12_papan_doc', $data_insert);
            return $this->db->insert_id();
        }
        function add_RADIOT_doc($data_insert)
        {
            $this->db->insert('sis12_radiot_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_OPTOM_doc($data_insert)
        {
            $this->db->insert('sis12_optom_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_RADIOL_doc($data_insert)
        {
            $this->db->insert('sis12_radiol_doc', $data_insert);
            return $this->db->insert_id();
        }		

        function add_TORAX_doc($data_insert)
        {
            $this->db->insert('sis12_torax_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_RADIOM_doc($data_insert)
        {
            $this->db->insert('sis12_radiom_doc', $data_insert);
            return $this->db->insert_id();
        }

         function add_ALCOSA_doc($data_insert)
        {
            $this->db->insert('sis12_alcosa_doc', $data_insert);
            return $this->db->insert_id();
        }

         function add_ANTICUA_doc($data_insert)
        {
            $this->db->insert('sis12_anticua_doc', $data_insert);
            return $this->db->insert_id();
        }
		
         function add_PCR_doc($data_insert)
        {
            $this->db->insert('sis12_pcr_doc', $data_insert);
            return $this->db->insert_id();
        }		
 
        function add_compo_doc($data_insert)
        {
            $this->db->insert('sis13_comportamiento_doc', $data_insert);
            return $this->db->insert_id();
        }

		function chk_sgmty_doc($cliente_id,$emp_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_sgmty_doc');
            $this->db->where('clte_id', $cliente_id);
			$this->db->where('emp_id', $emp_id);
            $result = $this->db->get();
            return $result->row_array();
        }

	

	
		 function add_sgmty_doc($data_insert)
        {
            $this->db->insert('sis12_sgmty_doc', $data_insert);
            return $this->db->insert_id();
        }

        function update_sgmty_doc($doc_id, $params)
        {
            $this->db->where('doc_id',$doc_id);
            return $this->db->update('sis12_sgmty_doc',$params);
        }


        function get_EGEREN_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_egeren_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_TERMAN_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_terman_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_PENSA_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_pensa_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function get_INTE_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_inte_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		
		


        function get_PUESIC_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_pruebas_psico_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }	


        function get_hon_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_honestidad_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_hon_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_honestidad_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function add_hon_doc($data_insert)
        {
            $this->db->insert('sis12_honestidad_doc', $data_insert);
            return $this->db->insert_id();
        }
		
		
        function borra_sgmty_doc($id)
        {
            $this->db->where('clte_id', $id);
            return $this->db->delete('sis12_sgmty_doc`');
        }
		
        function borra_sgmty_venta($id,$tipo)
        {
            $this->db->where('clte_id', $id);
			$this->db->like('doc_nombre', $tipo);
            return $this->db->delete('sis12_sgmty_doc`');
        }	

    function borra_evaluado($fsm_id)
    {
        $this->db->where('clte_id', $fsm_id);
        return $this->db->delete('sis05_clientes');
    }	

/**********************************************************************/


        
        function add_heredofamiliar($params)
        {
            $data = array_merge($params, log_insert('inserta heredo'));
            $this->db->insert('exp15_ant_heredo', $data);
            return $this->db->insert_id();
        }
        
        function get_heredofamiliar($clte_id)
        {
            $this->db->select('*');
            $this->db->from('exp15_ant_heredo');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('her_fecha','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_nopatologico($params)
        {
            $data = array_merge($params, log_insert('inserta nopat'));
            $this->db->insert('exp45_ant_nopat', $data);
            return $this->db->insert_id();
        }
        
        function get_nopatologico($clte_id)
        {
            $this->db->select('*');
            $this->db->from('exp45_ant_nopat');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('nopat_fecha','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_patologico($params)
        {
            $data = array_merge($params, log_insert('inserta pat'));
            $this->db->insert('exp20_pat', $data);
            return $this->db->insert_id();
        }
        
        function get_patologico($clte_id)
        {
            $this->db->select('*');
            $this->db->from('exp20_pat');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function delete_heredofamiliar($id)
        {
            $this->db->where('her_id', $id);
            return $this->db->delete('exp15_ant_heredo');
        }
        
        function delete_nopatologico($id)
        {
            $this->db->where('nopat_id', $id);
            return $this->db->delete('exp45_ant_nopat');
        }
        
        function delete_patologico($id)
        {
            $this->db->where('pat_id', $id);
            return $this->db->delete('exp20_pat');
        }
        
        function add_signosvitales($params)
        {
            $data = array_merge($params, log_insert('inserta signos'));
            $this->db->insert('exp85_sigvit', $data);
            return $this->db->insert_id();
        }
        
        function delete_signosvitales($id)
        {
            $this->db->where('sig_id', $id);
            return $this->db->delete('exp85_sigvit');
        }
        
        function get_signosvitales($clte_id)
        {
            $this->db->select('*');
            $this->db->from('exp85_sigvit');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_empresas()
        {
            $this->db->select('b.*');
            $this->db->from('sis05_clientes as a');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id','left');
            
            /*if(get_perfil_id() == 4)
            {
                $this->db->where('a.emp_id', get_emp_id());
            }*/

            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            $this->db->group_by('b.emp_id');
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }


	function get_una_empresa($emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis15_empresas');
		
		$estatus='INACTIVO';
		$this->db->not_like('emp_estatus_cve',$estatus);
		$this->db->where('emp_id', $emp_id);	
		$this->db->order_by('emp_razon_social','ASC');
		$result = $this->db->get();
		return $result->result_array();
    }
	

	function trae_empresas()
    {
        $this->db->select('*');
        $this->db->from('sis15_empresas');
		
		if(get_perfil_id() == 4)
        {
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
        }
		else
		{
			$estatus='INACTIVO';
			 $this->db->not_like('emp_estatus_cve',$estatus);
		}	

			$ex_sucursales=array(246,176,177,175,249,174,53,247,248);
			$this->db->where_not_in('emp_id', $ex_sucursales);	
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
    }

	
        function get_despachos()
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
			$n='1';
			$this->db->where('emp_desp', $n);
            $this->db->group_by('emp_id');
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }		
/**************************************************************************************/
        function buscate($nombre1 = '',$nombre2 = '',$paterno = '',$materno = '')
        {            
            //$select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,log_insrt_f,suc_id, cei_id";
            $select = "log_insrt_f";
			$this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
            $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre1);
			$this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2);
			$this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno);
			$this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno);

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


		
        function buscate_rfc($rfc = '',$emp_id = '')
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,log_insrt_f,suc_id, cei_id,clte_status_proc,clte_ida,clte_cat_puesto";
            //$select = "log_insrt_f";
			$this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
            $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc);
			$this->db->like('emp_id',$emp_id);
            $result = $this->db->get();
            return $result->result_array();
        }		


/**************************************************************************************/        
        function busca_evaluados($empresa = '',$nombre = '',$paterno='',$materno='', $rfc = '', $ubicacion = '',$despacho='',$emp_id_user='',$id_persona='',$cei_id='',$suc_id='')
        {            
            
			$user = $this->session->user; 
			$select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id, suc_id,emp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			$this->db->where('a.paciente !=',1);			
			$this->db->where('a.empleado !=',1);
            
			$this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
			$this->db->where('a.emp_id',$empresa);					

			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
  			
			if($id_persona != ''){ $this->db->where('clte_id',$id_persona);}
			
			if($cei_id != ''){ $this->db->where('cei_id',$cei_id);}
			
			if($suc_id != '')
			{ 
				$this->db->where('a.suc_id',$suc_id);
				if($empresa == '')				
				{
					$empresa =get_emp_by_suc($suc_id);
					$this->db->where('a.emp_id',$empresa);
				}
			}

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

		
/**************************************************************************************/        


/**************************************************************************************/        
        function busca_evalua2($empresa = '',$nombre = '',$paterno='',$materno='', $rfc = '', $ubicacion = '',$despacho='',$emp_id_user='',$id_persona='',$cei_id='',$suc_id='')
        {            
            
			$user = $this->session->user; 
			$select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, log_insrt_f,suc_id, cei_id, desp_id, suc_id,emp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
			$this->db->where('paciente !=',1);			
			$this->db->where('empleado !=',1);
			$this->db->where('emp_id',$empresa);					

			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
  			
			if($id_persona != ''){ $this->db->where('clte_id',$id_persona);}
			
			if($cei_id != ''){ $this->db->where('cei_id',$cei_id);}
			
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

		
/**************************************************************************************/ 



        function busca_empleado_gsi($empresa = '',$nombre = '',$paterno='',$materno='', $rfc = '', $ubicacion = '',$despacho='',$emp_id_user='',$id_persona='',$cei_id='',$suc_id='')
        {              
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,log_insrt_f,suc_id, cei_id, desp_id, suc_id,emp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');

			if($empresa != '') {$this->db->where('a.emp_id',$empresa);}
			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
			if($id_persona != ''){ $this->db->where('clte_id',$id_persona);}
		    if($cei_id != ''){ $this->db->where('cei_id',$cei_id);}
			$this->db->where('paciente', 0);
			$this->db->where('empleado', 1);
			$this->db->like('nomserv','EXMEPER');

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }



        function busca_wrk($empresa = '',$nombre = '',$paterno='',$materno='', $rfc = '', $ubicacion = '',$despacho='',$emp_id_user='',$id_persona='',$cei_id='',$suc_id='',$odt='')
        {            
            
			$user = $this->session->user; 
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, log_insrt_f,suc_id, cei_id, desp_id,suc_id,emp_id,clte_webflow,log_insrt_usr_cve,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			$this->db->where('a.paciente !=',1);			
			$this->db->where('a.empleado',1);
		
			if($empresa != '')
			{
					$this->db->where('a.emp_id',$empresa);					
			}
			
			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
  			if($odt != ''){ $this->db->like('clte_webflow',$odt); }
			if($id_persona != ''){ $this->db->where('clte_id',$id_persona);}
			
			if($cei_id != ''){ $this->db->where('cei_id',$cei_id);}
			

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function busca($empresa = '',$nombre = '',$paterno='',$materno='', $rfc = '', $ubicacion = '',$despacho='',$emp_id_user='',$id_persona='',$cei_id='',$suc_id='',$odt='',$estatus_proc='',$gerente=0,$f_ini='',$f_fin='')
        {            
            
			/*$empresa=92;*/
			/*$cei_id=6;*/
			
			
			$user = $this->session->user; 
			//$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, log_insrt_f,suc_id, cei_id, desp_id,suc_id,emp_id,clte_webflow,log_insrt_usr_cve,clte_status_proc,clte_ida,serv_id,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			$this->db->where('a.paciente !=',1);			
			$this->db->where('a.empleado !=',1);
            
		
			if($empresa != '')
			{
					$this->db->where('a.emp_id',$empresa);					
			}
			else
			{
				if (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
				{
					$gss=array(242,95,92);
					$this->db->where_in('a.emp_id',$gss);
				}
				elseif (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
				{
					$gss=array(242,95,92,124);
					$this->db->where_in('a.emp_id',$gss);
				}				
			}
		
		
				
			
			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
  			if($odt != ''){ $this->db->like('clte_webflow',$odt); }
			if($estatus_proc != ''){ $this->db->like('clte_status_proc',$estatus_proc); }
			
			if($f_ini != ''){$this->db->where('log_insrt_f >=', $f_ini.' 00:00:00');}
			if($f_fin != ''){$this->db->where('log_insrt_f <=', $f_fin.' 23:59:59');}

			
			if($id_persona != ''){ $this->db->where('clte_id',$id_persona);}

			
			
			
			
			if($cei_id != ''){ $this->db->where('cei_id',$cei_id);}
			
			if ($gerente == 0)
			{	
				if($suc_id != '0')
				{ 			
					if (intval($suc_id))
					{
						$sucursales=$suc_id;//.';';
						$a_sucursales=explode(';',$sucursales);
						$this->db->where_in('suc_id', $a_sucursales);
						//$this->db->where('a.suc_id',$suc_id);
					}
					
				/*	if($empresa == '')				
					{
						$empresa =get_emp_by_suc($suc_id);
						$this->db->where('a.emp_id',$empresa);
					}*/
				}
			}

			
			if ((get_perfil_id() == 4) 
				&& ( ($user['usr_id'] != 737) && ($user['usr_id'] != 736) && ($user['usr_id'] != 589) && ($user['usr_id'] != 590) && ($user['usr_id'] != 591)))
			{
	
				if ($despacho != 0)
				{					
					$this->db->where('desp_id',$despacho);					
				}	
				else
				{

				$this->db->where('a.emp_id',$emp_id_user);
						
				}
				$emp_id_user=get_emp_id();
				if ($emp_id_user == 31)
				{
				 $this->db->where('a.hc =',1); 
				}	
            } 
			else
			{
				
				if (($user['usr_id'] != 261) && ($user['usr_id'] != 302) )
				{
					$this->db->where('a.hc !=',1); 
				}
			}

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		








        function busca_asegurado($nombre1 = '',$nombre2='',$paterno='',$materno='', $emp_id = '')
        {            
            
			$user = $this->session->user; 
		    $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, log_insrt_f,suc_id, cei_id, desp_id,suc_id,emp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes');
         //   $this->db->where('status', 'activo');
		//	$this->db->where('emp_id',$emp_id);					

			if($nombre1 != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre1); }            
            if($nombre1 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); }
			if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
            $this->db->order_by('log_insrt_f','DESC');
			$this->db->limit(1); 
			$cliente=$this->db->get()->row_array();			
            return $cliente;
        }




        function busca_corp($empresa = '',$nombre = '',$paterno='',$materno='', $rfc = '', $ubicacion = '',$despacho='',$emp_id_user='',$id_persona='',$cei_id='',$gss)
        {            
            
			$user = $this->session->user; 
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, log_insrt_f,suc_id, cei_id, desp_id, suc_id,emp_id,clte_webflow,log_insrt_usr_cve,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
			$this->db->where('paciente !=',1);			
			$this->db->where('empleado !=',1);
		
			
			if($empresa != '')
			{
					$this->db->where('emp_id',$empresa);					
			}
			else
			{	
			 $this->db->where_in('emp_id',$gss);
			}

			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }

            if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
			if($id_persona != ''){ $this->db->where('clte_id',$id_persona);}			
			if($cei_id != ''){ $this->db->where('cei_id',$cei_id);}
			

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }





        function busca_gsi($empresa = '',$nombre = '',$paterno='',$materno='', $rfc = '', $ubicacion = '',$despacho='',$emp_id_user='',$id_persona='',$cei_id='',$gss)
        {            
            
			$user = $this->session->user; 
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, log_insrt_f,suc_id, cei_id, desp_id, suc_id,emp_id,clte_webflow,log_insrt_usr_cve,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes');
            $this->db->where('status', 'activo');
			$this->db->where('paciente !=',1);			
			$this->db->where('empleado !=',1);
		
			
			if($empresa != '')
			{
					$this->db->where('emp_id',$empresa);					
			}
			
			$this->db->where_in('emp_id',$gss);
			
			
		/*	
			else
			{
				if (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
				{
					$gss=array(242,95,92);
					$this->db->where_in('emp_id',$gss);
				}
				elseif (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
				{
					$gss=array(242,95,92,124);
					$this->db->where_in('emp_id',$gss);
				}				
			}
		*/	
		
			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }

            if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
			if($id_persona != ''){ $this->db->where('clte_id',$id_persona);}			
			if($cei_id != ''){ $this->db->where('cei_id',$cei_id);}
			

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

		
		
        function busca_px($nombre='',
		$nombre2='',
		$paterno='', 
		$materno='',
		$id_persona='',
		$tpaciente='',
		$unidad='',
		$no_empleado='')
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_id,log_insrt_f,suc_id, cei_id, desp_id,med_emp_asig,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			$this->db->where('a.paciente',1);
			
            //if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($id_persona != ''){ $this->db->where('a.clte_id',intval($id_persona)); }
            if($no_empleado != ''){ $this->db->like('a.num_empleado',$no_empleado); }
			
			if($tpaciente != ''){ $this->db->like('a.root',$tpaciente); }
			if($unidad != ''){ $this->db->where('a.suc_id',$unidad); }

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		



/**************************************************************************************/
        function busca_swb($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_id_user='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,log_insrt_f,suc_id, cei_id, desp_id, f_ingreso, f_baja,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'NOACTIVO');
			
			if($empresa != 31)
			{
			$this->db->where('a.empleado',1);
			}
			else
			{
			  $this->db->where('a.hc',1);
			}
			
                      
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',$receta); } 
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        } 
/**************************************/
 function busca_empleado($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '')
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, log_insrt_f,suc_id, cei_id, desp_id, f_ingreso, f_baja,clte_puesto,clte_status_proc,clte_ida";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			
			if($empresa != 31)
			{
				$this->db->where('a.empleado',1);
			}
			else
			{
				$this->db->where('a.hc',1);
			}
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',$receta); } 

			if($empresa != 31)
			{	
				if($empleado != '')
				{ 
					$this->db->like('a.num_empleado',$empleado); 
					
				}
			}
  		
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }  

		
/**************************************************************************************/
        function busca_sw($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, log_insrt_f,suc_id, cei_id, desp_id, f_ingreso, f_baja,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			
			if($empresa != 31)
			{
				$this->db->where('a.empleado',1);
			}
			else
			{
				$this->db->where('a.hc',1);
			}
			
            //$this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',$receta); } 
			$this->db->not_like('a.num_empleado','8000');
			if($empresa != 31)
			{	
				if($empleado != '')
				{ 
					$this->db->like('a.num_empleado',$empleado); 
					
				}
			}
  		
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }   

/**************************************************************************************/
        function busca_empleados_ext($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_id_user='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id, f_ingreso, f_baja,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			
			if($empresa != 31)
			{
			$this->db->where('a.empleado',1);
			}
			else
			{
			  $this->db->where('a.hc',1);
			}
			
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',$receta); } 
			$this->db->where('a.empleado_rol',0);
			if($empresa != 31)
			{
				if($empleado != '')
				{ 
					$this->db->like('a.num_empleado',$empleado); 
					
				}
			}
  		
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }  


/**************************************************************************************/
        function busca_swe($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_id_user='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id, f_ingreso, f_baja,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			
			if($empresa != 31)
			{
			$this->db->where('a.empleado',1);
			}
			else
			{
			  $this->db->where('a.hc',1);
			}
			
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',$receta); } 
			$this->db->like('a.num_empleado','8000');
			if($empresa != 31)
			{
				if($empleado != '')
				{ 
					$this->db->like('a.num_empleado',$empleado); 
					
				}
			}
  		
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }   




   function busca_enom($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_id_user='')
        {            

            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_id, log_insrt_f,suc_id, cei_id, desp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			
			if($empresa != 31)
			{
			$this->db->where('empleado',1);
			}
			else
			{
			  $this->db->where('hc',1);
			}
			
			if($empresa != ''){$this->db->where('emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			
			if($empresa != 31)
			{			
				if($empleado != ''){ $this->db->like('a.num_empleado',$empleado); }
			}
  		
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }




   function busca_e($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_id_user='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			
			if($empresa != 31)
			{
			$this->db->where('a.empleado',1);
			}
			else
			{
			  $this->db->where('a.hc',1);
			}
			
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			
			if($empresa != 31)
			{			
			//if($receta != '')  { $this->db->where('a.clte_id',intval($receta)); }
            if($empleado != ''){ $this->db->like('a.num_empleado',$empleado); }
			}
  		
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function busca_m($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_id_user='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			
			if($empresa != 31)
			{
			$this->db->where('a.empleado',1);
			}
			else
			{
			  $this->db->where('a.hc',1);
			}
			
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			
			if($empresa != 31)
			{			
			//if($receta != '')  { $this->db->where('a.clte_id',intval($receta)); }
            if($empleado != ''){ $this->db->like('a.num_empleado',$empleado); }
			}
  					$names = array(28163,
19581,
27842,
21598,
28198,
26062,
22647,
26904,
29070,
14174,
27887,
28166,
25410,
19297,
7367,
4728,
28230,
21787,
25406,
28638,
22813,
16887,
17862,
25980,19472,30746,30743,30744,30745,27765,
27802,27187
) ;
			$this->db->where_in('a.clte_id', $names);
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		

/**************************************************************************************/
        function busca_a($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			$this->db->where('a.hc !=',1);
			//$this->db->or_where('a.hc', NULL);
           
  			
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

/**************************************************************************************/        
        function busca_p($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_asig_user='')
        {            
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_id,log_insrt_f,suc_id, cei_id, desp_id,med_emp_asig,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			$this->db->where('a.paciente',1);
            //$this->db->where('a.med_emp_asig',intval($emp_asig_user)); 
			//$this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
			
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',intval($receta)); }
            if($empleado != ''){ $this->db->like('a.num_empleado',$empleado); }
			$this->db->like('a.root','GSI');
  			
         
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function busca_pp($sucursal = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_asig_user='')
        {            
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_id,log_insrt_f,suc_id, cei_id, desp_id,med_emp_asig,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
			$this->db->where('a.paciente',1);
            //$this->db->where('a.med_emp_asig',intval($emp_asig_user)); 
			//$this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
     
			
            if($sucursal != ''){$this->db->where('a.suc_id',$sucursal);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',intval($receta)); }
            if($empleado != ''){ $this->db->like('a.num_empleado',$empleado); }
			
  			
         
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


/**************************************************************************************/        
        function buscandote($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			//echo $fecha->format('Y-m-d') . "\n";
			
			//$f_fino=date_add($f_fin, date_interval_create_from_date_string('1 days'));
			//$this->db->where('log_insrt_f <=',date_format($f_fino,'Y-m-d' ));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            			
			//if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/             

        function buscandote_evaluados($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            //$this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			$this->db->where('paciente',0);
			$this->db->where('empleado',0);
			
			//$this->db->where('clte_id',323297);
			
			
			$this->db->where('log_insrt_f >=', '2022-07-16 19:12:16');
			
			$this->db->where('log_insrt_f <=', '2022-07-20 19:12:16');
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			
			//$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
           // $this->db->where('log_insrt_f <=', '2022-07-19 08:12:21');
			
			
			//if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            //if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }

         
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

			$this->db->order_by('clte_id','ASC');

           /* if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}	*/	
			
			
            $result = $this->db->get();
            return $result->result_array();
        }



        function buscandote_evaluados_new_servicios($empresa = '',$cei='',$nombre = '', $rfc = '',$f_ini,$f_fin,$orden=0,$servicios=0)
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,serv_id,nomserv,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			$this->db->where('paciente',0);
			$this->db->where('empleado',0);
			
			$this->db->where('log_insrt_f >=', $f_ini.' 00:00:00');
			$this->db->where('log_insrt_f <=', $f_fin.' 23:59:59');
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
         
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->like('nomserv',';');
			}

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			elseif ($orden == 1)
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}
			elseif ($orden == 2)
			{
				$this->db->order_by('clte_paterno', 'clte_materno','clte_nombre', 'clte_2_nombre', 'ASC');				
			}			
			elseif ($orden == 3)
			{
				$this->db->order_by('clte_paterno', 'clte_materno','clte_nombre', 'clte_2_nombre', 'DESC');				
			}			
			
			
            $result = $this->db->get();
            return $result->result_array();
        }

        function buscandote_evaluados_empresas_servicios($empresas,$cei='',$nombre = '', $rfc = '',$f_ini,$f_fin,$orden=0,$servicios=0)
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,serv_id,nomserv,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            
            //if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			//$empresas = array('94', '37', '136');
			$this->db->where_in('emp_id',$empresas); 
			$this->db->like('nomserv','MEDFIS'); 
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			$this->db->where('paciente',0);
			$this->db->where('empleado',0);
			
			$this->db->where('log_insrt_f >=', $f_ini.' 00:00:00');
			$this->db->where('log_insrt_f <=', $f_fin.' 23:59:59');
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
         
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->like('nomserv',';');
			}

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			elseif ($orden == 1)
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}
			elseif ($orden == 2)
			{
				$this->db->order_by('clte_paterno', 'clte_materno','clte_nombre', 'clte_2_nombre', 'ASC');				
			}			
			elseif ($orden == 3)
			{
				$this->db->order_by('clte_paterno', 'clte_materno','clte_nombre', 'clte_2_nombre', 'DESC');				
			}			
			
			
            $result = $this->db->get();
            return $result->result_array();
        }


        function buscandote_evaluados_new($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve,clte_env_calle_crypt, clte_env_num_ext_crypt,clte_env_num_int_crypt,clte_env_colonia_crypt, clte_env_cp ,	clte_env_localidad ,clte_env_municipio,clte_env_edo_cve,, clte_rfc_crypt,clte_path_foto,emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,serv_id,clte_reclutador,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			//if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			$this->db->where('paciente',0);
			$this->db->where('empleado',0);
			
			$this->db->where('log_insrt_f >=', $f_ini.' 00:00:00');
			$this->db->where('log_insrt_f <=', $f_fin.' 23:59:59');
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			
			//$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
           // $this->db->where('log_insrt_f <=', '2022-07-19 08:12:21');
			
			
			//if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            //if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }

         
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

			//$this->db->order_by('clte_id','ASC');

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/        
        function buscando_evaluados_gsi($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            $this->db->where('b.emp_corp', 'GSI');
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));

			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
    			
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }

/**************************************************************************************/        
        function buscandote_by_despacho($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$es_usr_de_un_despacho=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt,clte_env_calle_crypt, clte_env_num_ext_crypt,clte_env_num_int_crypt,clte_env_colonia_crypt, 	clte_env_localidad ,clte_env_municipio,clte_env_edo_cve,  clte_f_nac, clte_rfc_crypt,,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto,clte_status_proc,clte_ida,clte_cat_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            			
            /*
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
			}
			*/
			
			
			if(get_perfil_id() == 4)
			{
				if ($es_usr_de_un_despacho==0)
				{	
					$empresas = get_empresas_array();
					$this->db->where_in('a.emp_id', $empresas);
					$i=33;
					$this->db->where('desp_id !=',$i);
					
					
				}
				else
				{
					
					$this->db->where('a.desp_id', $es_usr_de_un_despacho);					
				}	
			}
			
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/ 

        
        function get_dificultad($clte_id)
        {
            $select = "usr_id, clte_id, dis_id, dis_cif_nota_crypt, dis_dif_tipo_cve, b.cat_nombre as tipo, dis_dif_grado_cve,c.cat_nombre as grado, dis_dif_orig_cve,d.cat_nombre as origen";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('exp10_discap as a');
            $this->db->join('cat_catalogos as b','a.dis_dif_tipo_cve = b.cat_cve');
            $this->db->join('cat_catalogos as c','a.dis_dif_grado_cve = c.cat_cve');
            $this->db->join('cat_catalogos as d','a.dis_dif_orig_cve = d.cat_cve');
            $this->db->where('clte_id', $clte_id);
            $this->db->where(array('discap_cve' => NULL));
            $this->db->where('b.cat_grupo', 'DIF_TIPO');
            $this->db->where('c.cat_grupo', 'DIF_GRADO');
            $this->db->where('d.cat_grupo', 'DIF_ORIG');
            $this->db->order_by('dis_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_alergia($params)
        {
            $data = array_merge($params, log_insert('inserta alergia'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('exp35_alerg');
            return $this->db->insert_id();
        }
        
        function delete_alergia($id)
        {
            $this->db->where('alerg_id', $id);
            return $this->db->delete('exp35_alerg');
        }
        
        function get_alergia($clte_id)
        {
            $select = "usr_id, clte_id, nmed_id, alerg_id, alerg_fecha_detecto, alerg_alergeno, alerg_reaccion, alerg_estado_actual, alerg_nota_crypt, alerg_medico_detecto_crypt";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('exp35_alerg');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('alerg_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_gineco($params)
        {
            $data = array_merge($params, log_insert('inserta gineco'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('exp25_ant_gineco');
            return $this->db->insert_id();
        }
        
        function update_gineco($id, $params)
        {
            $data = array_merge($params, log_insert('actualiza gineco'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('gin_id', $id);
            return $this->db->update('exp25_ant_gineco');
        }
        
        function get_gineco($clte_id)
        {
            $select = "usr_id, clte_id, gin_id, gin_ritmo_cve, gin_menst_cada, gin_menst_dura, gin_f_ult_menst, gin_ivsa, gin_mpf_cve, gin_docma_f, gin_docma_nota_crypt, gin_papanic_f, gin_papanic_nota_crypt, gin_colposc_f, gin_colposc_nota_crypt, gin_num_gestas, gin_num_abortos, gin_num_partos, gin_num_cesareas, gin_f_ult_aborto, gin_f_ult_parto, gin_notas_crypt";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('exp25_ant_gineco');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('gin_id','DESC');
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function get_empresa_by_id($emp_id)
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
            $this->db->where('emp_id', $emp_id);
            $result = $this->db->get();
            return $result->row_array();
        }

        /*function get_examenes($clte_id){
            $mapeo = unserialize(MAPEO_EXAMENES);

            $select = "SELECT a.clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt,clte_materno_crypt,clte_genero_cve, clte_rfc_crypt, emp_razon_social, b.emp_id";
            $select = parsea_select($select, 'humancenter');
            $inicio = FALSE;
            $sql = $select.',FROM (';
            
            foreach($mapeo as $tb) {
                if($inicio) $sql .= ' UNION ';
                $sql .= 'SELECT clte_id,"'.$tb['alias'].'" as alias, '.$tb['fecha'].' as fecha,emp_id FROM '.$tb['tabla'].' WHERE clte_id='.$clte_id;
                if(isset($tb['where'])) $sql .= ' AND '.$tb['where']['campo'].' = "'.$tb['where']['valor'].'"';
                $inicio = TRUE;
            }

            $sql .= ') as a ';
            $sql .= ' LEFT JOIN sis05_clientes as a ON y.clte_id = a.clte_id ';
            $sql .= ' LEFT JOIN sis15_empresas as b ON a.emp_id = b.emp_id ';
            if($emp_id != ''){
                $sql .= ' WHERE b.emp_id = "'.$emp_id.'"';
            }
            $sql .= ' GROUP BY y.clte_id ';
            $sql .= ' ORDER BY b.emp_id ASC;';
            echo $sql;
            //$result = $this->db->query($sql);
            //return $result->result_array();
        }*/
}