<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Vista_reporte_costos_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 /*modificación de Vista_model*/

    function count_allo()
        {
            $this->db->select("count(clte_id ) as regs");
            $this->db->from('sis05_clientes');
			
            if(get_perfil_id() == 4)
            {
                $this->db->where('emp_id', get_emp_id());
            }
			
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }



    function exarea()
    {
                      $sql="select b.clte_id clavec, AES_DECRYPT(b.clte_nombre_crypt,'humancenter') nombre, c.fsm_id toxi, d.fsm_id psico,g.serv_id, e.fsm_id toxs,
                            GROUP_CONCAT(h.exam_cve) exaser  
                             from  sis05_clientes as b
                    LEFT JOIN fsm_toxicologico as c on b.clte_id = c.clte_id
                     left join fsm_psicologico as d on b.clte_id = d.clte_id
                     LEFT JOIN fsm_toxicologico7 as e on b.clte_id = e.clte_id
                       LEFT join sis30_servicios as g on c.serv_id = g.serv_id or d.serv_id = g.serv_id or e.serv_id = g.serv_id
                        left join sis35_servicios_examenes as h on g.serv_id = h.serv_id
                        where date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        GROUP BY b.clte_id";
                        $result = $this->db->query($sql);
                        return $result->result_array();
    }                     


    


    function get_realizados($examen, $emp_id, $ini = '', $fin = '')
    {
        $mapeo = array(
            'TOXI'  => array('tabla' => 'fsm_toxicologico', 'fecha' => 'fsm_f'),
            'TOXIS' => array('tabla' => 'fsm_toxicologico7', 'fecha' => 'fsm_f'),
            'PSIC'  => array('tabla' => 'fsm_psicologico', 'fecha' => 'fsm_f'),
            'ACRED' => array('tabla' => 'fsm_acreditacion', 'fecha' => 'fsm_f'),
            'MEDFIS' => array('tabla' => 'fsm_medico_fisico', 'fecha' => 'fsm_f'),
            'SOCIE' => array('tabla' => 'socio_eco', 'fecha' => 'fecha_eval'),
            'ENTSOC' => array('tabla' => 'entorno_soc', 'fecha' => 'fecha_eval'),
            'CED' => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval','where' => array('campo' => 'polig_tipo_cve','valor' => 'CEDULA')),
            'POL' => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval','where' => array('campo' => 'polig_tipo_cve','valor' => 'POLI')),
            'HIST' => array('tabla' => 'fsm_historia_clinica', 'fecha' => 'fsm_f'),
            'TOXIN' => array('tabla' => 'fsm_toxi', 'fecha' => 'fsm_f'),
            'ESTSOC' => array('tabla' => 'esc', 'fecha' => 'esc_f'),
            'QUISAN' => array('tabla' => 'fsm_quimica_sanguinea', 'fecha' => 'qui_f_recibido'),
            'ORINA' => array('tabla' => 'fsm_orina', 'fecha' => 'ori_f_recibido'),
            'BIOHEM' => array('tabla' => 'fsm_biometria_hematica', 'fecha' => 'bio_f_recibido'),
            'GPOSAN' => array('tabla' => 'fsm_grupo_sanguineo', 'fecha' => 'gs_f_recibido'),
            'REPSIC' => array('tabla' => 'fsm_psicologico_2', 'fecha' => 'fsm_f'),
            'EYED' => array('tabla' => 'fsm_eye_detect', 'fecha' => 'fsm_f'),
            'SOCLAB' => array('tabla' => 'fsm_sociolab', 'fecha' => 'fsm_f')
        );

        $this->db->select('*');
        $this->db->from($mapeo[$examen]['tabla']);
        $this->db->where('emp_id', $emp_id);
        if($ini != '')
        {
            $this->db->where($mapeo[$examen]['fecha'].'>= ',$ini);
        }
        if($fin != '')
        {
            $this->db->where($mapeo[$examen]['fecha'].'<= ',$fin);
        }
        if(isset($mapeo[$examen]['where']))
        {
            $this->db->where($mapeo[$examen]['where']['campo'],$mapeo[$examen]['where']['valor']);
        }
        $result = $this->db->get();
        return $result->result_array();
    }


    function get_realizados_count($examen, $cliente_id, $ini = '', $fin = '')
    {
        $mapeo = array(
            'TOXI'  => array('tabla' => 'fsm_toxicologico', 'fecha' => 'fsm_f'),
            'TOXIS' => array('tabla' => 'fsm_toxicologico7', 'fecha' => 'fsm_f'),
            'PSIC'  => array('tabla' => 'fsm_psicologico', 'fecha' => 'fsm_f'),
            'ACRED' => array('tabla' => 'fsm_acreditacion', 'fecha' => 'fsm_f'),
            'MEDFIS' => array('tabla' => 'fsm_medico_fisico', 'fecha' => 'fsm_f'),
            'SOCIE' => array('tabla' => 'socio_eco', 'fecha' => 'fecha_eval'),
            'ENTSOC' => array('tabla' => 'entorno_soc', 'fecha' => 'fecha_eval'),
            'CED' => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval','where' => array('campo' => 'polig_tipo_cve','valor' => 'CEDULA')),
            'POL' => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval','where' => array('campo' => 'polig_tipo_cve','valor' => 'POLI')),
            'HIST' => array('tabla' => 'fsm_historia_clinica', 'fecha' => 'fsm_f'),
            'TOXIN' => array('tabla' => 'fsm_toxi', 'fecha' => 'fsm_f'),
            'ESTSOC' => array('tabla' => 'esc', 'fecha' => 'esc_f'),
            'QUISAN' => array('tabla' => 'fsm_quimica_sanguinea', 'fecha' => 'qui_f_recibido'),
            'ORINA' => array('tabla' => 'fsm_orina', 'fecha' => 'ori_f_recibido'),
            'BIOHEM' => array('tabla' => 'fsm_biometria_hematica', 'fecha' => 'bio_f_recibido'),
            'GPOSAN' => array('tabla' => 'fsm_grupo_sanguineo', 'fecha' => 'gs_f_recibido'),
            'REPSIC' => array('tabla' => 'fsm_psicologico_2', 'fecha' => 'fsm_f'),
            'EYED' => array('tabla' => 'fsm_eye_detect', 'fecha' => 'fsm_f'),
            'SOCLAB' => array('tabla' => 'fsm_sociolab', 'fecha' => 'fsm_f')
        );


		if ($examen == 'TOXI')
		{
			$sql = "select count(*) as total 
				FROM fsm_toxicologico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIS')
		{
			$sql = "select count(*) as total 
				FROM fsm_toxicologico7
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PSIC')
		{
			$sql = "select count(*) as total 
				FROM fsm_psicologico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ACRED')
		{
			$sql = "select count(*) as total 
				FROM fsm_acreditacion
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'MEDFIS')
		{
			$sql = "select count(*) as total 
				FROM fsm_medico_fisico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'SOCIE')
		{
			$sql = "select count(*) as total 
				FROM socio_eco
				where 
				clte_id = ".$cliente_id." and fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ENTSOC')
		{
			$sql = "select count(*) as total 
				FROM socio_eco
				where 
				clte_id = ".$cliente_id." and fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'CED')
		{
			$sql = "select count(*) as total 
				FROM fsm_poligrafico
				where 
				polig_tipo_cve = 'CEDULA' and
				clte_id = ".$cliente_id." and polig_fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'POL')
		{
			$sql = "select count(*) as total 
				FROM fsm_poligrafico
				where 
				polig_tipo_cve = 'POLI' and
				clte_id = ".$cliente_id." and polig_fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'HIST')
		{
			$sql = "select count(*) as total 
				FROM fsm_historia_clinica
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIN')
		{
			$sql = "select count(*) as total 
				FROM fsm_toxi
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ESTSOC')
		{
			$sql = "select count(*) as total 
				FROM esc
				where 
				clte_id = ".$cliente_id." and esc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QUISAN')
		{
			$sql = "select count(*) as total 
				FROM fsm_quimica_sanguinea
				where 
				clte_id = ".$cliente_id." and qui_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ORINA')
		{
			$sql = "select count(*) as total 
				FROM fsm_orina
				where 
				clte_id = ".$cliente_id." and ori_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'BIOHEM')
		{
			$sql = "select count(*) as total 
				FROM fsm_biometria_hematica
				where 
				clte_id = ".$cliente_id." and bio_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'GPOSAN')
		{
			$sql = "select count(*) as total 
				FROM fsm_grupo_sanguineo
				where 
				clte_id = ".$cliente_id." and gs_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'REPSIC')
		{
			$sql = "select count(*) as total 
				FROM fsm_psicologico_2
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'EYED')
		{
			$sql = "select count(*) as total 
				FROM fsm_eye_detect
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PIE')
		{
			$sql = "select count(*) as total 
				FROM fsm_pie
				where 
				clte_id = ".$cliente_id." and pie_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ODO')
		{
			$sql = "select count(*) as total 
				FROM fsm_odon
				where 
				clte_id = ".$cliente_id." and fodon_fechaeva between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'fpfh0105')
		{
			$sql = "select count(*) as total 
				FROM fpfh_01_05
				where 
				clte_id = ".$cliente_id." and fpfh_fechaeva between '".$ini."' and '".$fin."'";

		}elseif ($examen == 'nom0351')
		{
			$sql = "select count(*) as total 
				FROM fsm_nom035
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
				
        }elseif ($examen == 'nom0352')
		{
			$sql = "select count(*) as total 
				FROM fsm_nom035ii
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'nom0353')
		{
			$sql = "select count(*) as total 
				FROM fsm_nom035iii
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }
		
	
		$result = $this->db->query($sql);
        return $result->row_array();
    } 




    function get_examenes_realizados_detail($examen, $cliente_id,$emp_id ,$ini = '', $fin = '')
    {
		$sql = "select * "; 
		if ($examen == 'COVID')
		{
			$sql = $sql." FROM sis12_covid_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXI')
		{
			$sql = $sql." FROM fsm_toxicologico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIS')
		{
			$sql = $sql. " FROM fsm_toxicologico7
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        
		}elseif ($examen == 'PSIC')
		{
			$sql = $sql. "	FROM fsm_psicologico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ACRED')
		{
			$sql = $sql. "	FROM fsm_acreditacion
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'MEDFIS')
		{
			$sql = $sql. "	FROM fsm_medico_fisico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'SOCIE')
		{
			$sql = $sql. "	FROM socio_eco
				where 
				clte_id = ".$cliente_id." and fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ENTSOC')
		{
			$sql = $sql. "
				FROM entorno_soc
				where 
				clte_id = ".$cliente_id." and fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'CED')
		{
			$sql = $sql. "	FROM fsm_poligrafico
				where 
				polig_tipo_cve = 'CEDULA' and
				clte_id = ".$cliente_id." and polig_fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'POL')
		{
			$sql = $sql. "	FROM fsm_poligrafico
				where 
				polig_tipo_cve = 'POLI' and
				clte_id = ".$cliente_id." and polig_fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'HIST')
		{
			$sql = $sql. "
				FROM fsm_historia_clinica
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIN')
		{
			$sql = $sql. "
				FROM fsm_toxi
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ESTSOC')
		{
			$sql = $sql. "
				FROM esc
				where 
				clte_id = ".$cliente_id." and esc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QUISAN')
		{
			$sql = $sql. "
				FROM fsm_quimica_sanguinea
				where 
				clte_id = ".$cliente_id." and qui_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ORINA')
		{
			$sql = $sql. "
				FROM fsm_orina
				where 
				clte_id = ".$cliente_id." and ori_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'BIOHEM')
		{
			$sql = $sql. "
				FROM fsm_biometria_hematica
				where 
				clte_id = ".$cliente_id." and bio_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'GPOSAN')
		{
			$sql = $sql. "
				FROM fsm_grupo_sanguineo
				where 
				clte_id = ".$cliente_id." and gs_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'REPSIC')
		{
			$sql = $sql. "
				FROM fsm_psicologico_2
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'EYED')
		{
			$sql = $sql. "
				FROM fsm_eye_detect
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PIE')
		{
			$sql = $sql. "
				FROM fsm_pie
				where 
				clte_id = ".$cliente_id." and pie_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ODO')
		{
			$sql = $sql. "
				FROM fsm_odon
				where 
				clte_id = ".$cliente_id." and fodon_fechaeva between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'fpfh0105')
		{
			$sql = $sql. "
				FROM fpfh_01_05
				where 
				clte_id = ".$cliente_id." and fpfh_fechaeva between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'SOCIOL')
		{
			$sql = $sql. "
				FROM fsm_sociolab
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }else	
		
		$sql=$sql."and emp_id = ".$emp_id." limit 1";
		
		if ($examen == 'ALCOHOL')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE 'ALCOHO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'FEBRILES')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%FEBRIL%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'EXUF')
		{//EXUF 	EXUDADO FARINGEO
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%FARIN%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'CPROPA')
		{//CPROPA	COPROPARASITOSCOPICO 			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%PROPARASIT%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'CPROCU')
		{//CPROCU 	COPROCULTIVO							
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%OPROCUL%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'QS6')
		{//QS6 	QUIMICA SANGUINEA DE 6
				$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%NEA DE 6%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'AAFQ')
		{//AAFQ 	ANALISIS DE AGUA FISICO-QUIMICO					
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%AGUA FISICO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'AHFQ')
		{//AHFQ 	ANALISIS DE HIELO FISICO-QUIMICO		
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%HIELO FISICO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'KOHU')
		{//	KOHU 	KOH DE UÑAS			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%KOH DE U%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'CSVIVA')
		{//CSVIVA 	CULTIVO DE SUPERFICIE VIVA			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%VIVA%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'CSINERTE')
		{//CSINERTE 	CULTIVO DE SUPERFICIE INERTE			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%INERTE%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'CACRUDO')
		{//CACRUDO 	CULTIVO DE ALIMENTO CRUDO		
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%CRUDO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'CACOCIDO')
		{//CACOCIDO 	CULTIVO DE ALIMENTO COCIDO				
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%COCIDO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'ABA')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%LOGICO DE AGUA%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'ABH')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%LOGICO DE HIELO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			$sql=$sql." limit 1";
		}elseif ($examen == 'PSSIM')
		{			
			$sql = "select * FROM fsm_psicologico_4
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
		}elseif ($examen == 'HONE')
		{			
			$sql = "select * FROM sis12_honestidad_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
		}elseif ($examen == 'COMPO')
		{			
			$sql = "select * FROM sis13_comportamiento_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
		}			
		
		
		//echo $sql;
		$result = $this->db->query($sql);
        return $result->row_array();
    }


/***************************************************/
    function get_examenes_servicio_detail($examen,$cliente_id,$emp_id ,$ini = '', $fin = '')
    {
		$sql = "select * "; 
		if ($examen == 'COVID')
		{
			$sql = $sql." FROM sis12_covid_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ACRED')
		{
			$sql = $sql. "	FROM fsm_acreditacion
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }
		elseif ($examen == 'TOXI')
		{
			$sql = $sql." FROM fsm_toxicologico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIS')
		{
			$sql = $sql. " FROM fsm_toxicologico7
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PSIC')
		{
			$sql = $sql. "	FROM fsm_psicologico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'MEDFIS')
		{
			$sql = $sql. "	FROM fsm_medico_fisico
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'SOCIE')
		{	
			if ( $emp_id == 136)
			{
			$sql = $sql. "	FROM fsm_ss_estsoc
				where 
			clte_id = ".$cliente_id." and fss_fechaeva between '".$ini."' and '".$fin."'";				
			}
			else
			{		
			$sql = $sql. "	FROM socio_eco
				where 
			clte_id = ".$cliente_id." and fecha_eval between '".$ini."' and '".$fin."'";
			}
        }elseif ($examen == 'ENTSOC')
		{
			$sql = $sql. "
				FROM entorno_soc
				where 
				clte_id = ".$cliente_id." and fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'CED')
		{
			$sql = $sql. "	FROM fsm_poligrafico
				where 
				polig_tipo_cve = 'CEDULA' and
				clte_id = ".$cliente_id." and polig_fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'POL')
		{
			$sql = $sql. "	FROM fsm_poligrafico
				where 
				polig_tipo_cve = 'POLI' and
				clte_id = ".$cliente_id." and polig_fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'HIST')
		{
			$sql = $sql. "
				FROM fsm_historia_clinica
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIN')
		{
			$sql = $sql. "
				FROM fsm_toxi
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ESTSOC')
		{
			$sql = $sql. "
				FROM esc
				where 
				clte_id = ".$cliente_id." and esc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QUISAN')
		{
			$sql = $sql. "
				FROM fsm_quimica_sanguinea
				where 
				clte_id = ".$cliente_id." and qui_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ORINA')
		{
			$sql = $sql. "
				FROM fsm_orina
				where 
				clte_id = ".$cliente_id." and  ori_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'BIOHEM')
		{
			$sql = $sql. "
				FROM fsm_biometria_hematica
				where 
				clte_id = ".$cliente_id." and bio_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'GPOSAN')
		{
			$sql = $sql. "
				FROM fsm_grupo_sanguineo
				where 
				clte_id = ".$cliente_id." and gs_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'REPSIC')
		{
			$sql = $sql. "
				FROM fsm_psicologico_2
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'EYED')
		{
			$sql = $sql. "
				FROM fsm_eye_detect
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PIE')
		{
			$sql = $sql. "
				FROM fsm_pie
				where 
				clte_id = ".$cliente_id." and pie_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ODO')
		{
			$sql = $sql. "
				FROM fsm_odon
				where 
				clte_id = ".$cliente_id." and fodon_fechaeva between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'fpfh0105')
		{
			$sql = $sql. "
				FROM fpfh_01_05
				where 
				clte_id = ".$cliente_id." and fpfh_fechaeva between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'SOCLAB')
		{
			$sql = $sql. "
				FROM fsm_sociolab
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ALCOHOL')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE 'ALCOHO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'FEBRILES')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%FEBRIL%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'EXUF')
		{//EXUF 	EXUDADO FARINGEO
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%FARIN%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CPROPA')
		{//CPROPA	COPROPARASITOSCOPICO 			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%PROPARASIT%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CPROCU')
		{//CPROCU 	COPROCULTIVO							
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%OPROCUL%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'QS6')
		{//QS6 	QUIMICA SANGUINEA DE 6
				$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%NEA DE 6%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'AAFQ')
		{//AAFQ 	ANALISIS DE AGUA FISICO-QUIMICO					
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%AGUA FISICO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'AHFQ')
		{//AHFQ 	ANALISIS DE HIELO FISICO-QUIMICO		
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%HIELO FISICO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'KOHU')
		{$sql = "SELECT * FROM sis10_clientes_doc where clte_id = ".$cliente_id." and doc_nombre LIKE '%KOH DE U%'";
		}elseif ($examen == 'CSVIVA')
		{//CSVIVA 	CULTIVO DE SUPERFICIE VIVA			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%VIVA%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CSINERTE')
		{//CSINERTE 	CULTIVO DE SUPERFICIE INERTE			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%INERTE%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CACRUDO')
		{//CACRUDO 	CULTIVO DE ALIMENTO CRUDO		
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%CRUDO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CACOCIDO')
		{//CACOCIDO 	CULTIVO DE ALIMENTO COCIDO				
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%COCIDO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'ABA')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%LOGICO DE AGUA%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'COVID19')
		{			
			$sql = "select * FROM sis12_covid_doc where	clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
		}
		elseif ($examen == 'ABH')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%LOGICO DE HIELO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'PROST')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%ANTÍGENO PROSTÁTICO ESPECÍFICO PSA%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'PSSIM')
		{			
			$sql = "select * FROM fsm_psicologico_4
				where 
				clte_id = ".$cliente_id." and fsm_f between '".$ini."' and '".$fin."'";
		}elseif ($examen == 'HONE')
		{			
			$sql = "select * FROM sis12_honestidad_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
		}elseif ($examen == 'COMPO')
		{			
			$sql = "select * FROM sis13_comportamiento_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
		
		}elseif ($examen == 'TOXIV')
		{			
			$sql = "select * FROM sis13_comportamiento_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
		
		}else
		{
			 return NULL;
		}
		//$sql=$sql." and emp_id = ".$emp_id; ." limit 1";
		//echo $sql;
		$result = $this->db->query($sql);
        return $result->row_array();
    }


/**************************************************/

/***************************************************/
    function get_examenes_servicio_detail_2($examen,$cliente_id,$emp_id ,$ini = '', $fin = '',$serv_id=0)
    {   $i=0;
	    //echo 'aqui --->'.$examen.'<---'; 
		$sql = "select * "; 

		if ($examen == 'QS38')
		{
			$sql = $sql." FROM fsm_quimica_sanguinea38
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and qui_f_recibido  between '".$ini."' and '".$fin."'";
        }else		
		if ($examen == 'QS24')
		{
			$sql = $sql." FROM fsm_quimica_sanguinea24
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and qui_f_recibido  between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QS15')
		{
			$sql = $sql." FROM fsm_quimica_sanguinea15
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and qui_f_recibido  between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QS12')
		{
			$sql = $sql." FROM fsm_quimica_sanguinea12
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and qui_f_recibido  between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QS6')
		{
			$sql = $sql." FROM fsm_quimica_sanguinea6
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and qui_f_recibido  between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QS3')
		{
			$sql = $sql." FROM fsm_quimica_sanguinea3
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and qui_f_recibido  between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QS27')
		{
			$sql = $sql." FROM fsm_quimica_sanguinea27
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and qui_f_recibido  between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'COV19R')
		{
			$sql = $sql." FROM fsm_covid
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and covid_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'COVID')
		{
			$sql = $sql." FROM sis12_covid_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'RADIOT')
		{
			$sql = $sql." FROM sis12_radiot_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'RADIOL')
		{
			$sql = $sql." FROM sis12_radiol_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PAPAN')
		{
			$sql = $sql." FROM sis12_papan_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'AUDIO')
		{
			$sql = $sql." FROM sis12_audio_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }
elseif ($examen == 'BURO')
		{
			$sql = $sql." FROM sis12_buro_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }		
elseif ($examen == 'EXAMM')
		{
			$sql = $sql." FROM sis12_examm_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }		
elseif ($examen == 'VDRL')
		{
			$sql = $sql." FROM sis12_vdrl_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }


elseif ($examen == 'VALPROF')
		{
			$sql = $sql." FROM sis12_valprof_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }		

elseif ($examen == 'KOHU')
		{
			$sql = $sql." FROM sis12_koh_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }		
elseif ($examen == 'SPIRO')
		{
			$sql = $sql." FROM sis12_spiro_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }		
		
		elseif ($examen == 'PUESIC')
		{
			$sql = $sql." FROM sis12_pruebas_psico_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'INTE')
		{
			$sql = $sql." FROM sis12_inte_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PENSA')
		{
			$sql = $sql." FROM sis12_pensa_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'VISTA')
		{
			$sql = $sql." FROM sis12_vista_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ELECTRO')
		{
			$sql = $sql." FROM sis12_electro_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ACRED')
		{
			$sql = $sql. "	FROM fsm_acreditacion
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }
		elseif (strstr($examen, 'ALCOHOL'))
		{
			$sql = $sql. "	FROM fsm_alcohol
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and alcohol_f_recibido between '".$ini."' and '".$fin."'";
				$i=1;
        }		
		elseif ($examen == 'TOXI')
		{
			$sql = $sql." FROM fsm_toxicologico
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIS')
		{
			$sql = $sql. " FROM fsm_toxicologico7
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIT')
		{
			$sql = $sql. " FROM fsm_toxicologico3
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PSIC')
		{
			$sql = $sql. "	FROM fsm_psicologico
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'MEDFIS')
		{
			$sql = $sql. "	FROM fsm_medico_fisico
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'SOCIE')
		{	
			if ( $emp_id == 136)
			{
			$sql = $sql. "	FROM fsm_ss_estsoc
				where 
			clte_id = ".$cliente_id." and fss_fechaeva between '".$ini."' and '".$fin."'";				
			}
			else
			{		
			$sql = $sql. "	FROM socio_eco
				where 
			clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fecha_eval between '".$ini."' and '".$fin."'";
			}
        }elseif ($examen == 'ENTSOC')
		{
			$sql = $sql. "
				FROM entorno_soc
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'CED')
		{
			$sql = $sql. "	FROM fsm_poligrafico
				where 
				polig_tipo_cve = 'CEDULA' and
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and polig_fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'POL')
		{
			$sql = $sql. "	FROM fsm_poligrafico
				where 
				polig_tipo_cve = 'POLI' and
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and polig_fecha_eval between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'HIST')
		{
			$sql = $sql. "
				FROM fsm_historia_clinica
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'TOXIN')
		{
			$sql = $sql. "
				FROM fsm_toxi
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ESTSOC')
		{
			$sql = $sql. "
				FROM esc
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and esc_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'QUISAN')
		{
			$sql = $sql. "
				FROM fsm_quimica_sanguinea
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and qui_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ORINA')
		{
			$sql = $sql. "
				FROM fsm_orina
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and serv_id  =".$serv_id." and "." ori_f_recibido between '".$ini."' and '".$fin."'";
				//echo $sql;
        }elseif ($examen == 'BIOHEM')
		{
			$sql = $sql. "
				FROM fsm_biometria_hematica
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and bio_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'GPOSAN')
		{
			$sql = $sql. "
				FROM fsm_grupo_sanguineo
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and gs_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'REPSIC')
		{
			$sql = $sql. "
				FROM fsm_psicologico_2
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'EYED')
		{
			$sql = $sql. "
				FROM fsm_eye_detect
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'PIE')
		{
			$sql = $sql. "
				FROM fsm_pie
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and pie_f_recibido between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'ODO')
		{
			$sql = $sql. "
				FROM fsm_odon
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fodon_fechaeva between '".$ini."' and '".$fin."'";
        }elseif (($examen == 'fpfh0105') ||  ($examen == 'FSM0105'))  
		{
			$sql = $sql. "
				FROM fpfh_01_05
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fpfh_fechaeva between '".$ini."' and '".$fin."'";
        }elseif ($examen == 'SOCLAB')
		{
			$sql = $sql. "
				FROM fsm_sociolab
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
        }elseif (($examen == 'ALCOHOL') && ($i=0))
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE 'ALCOHO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'FEBRILES')
		{			
			$sql =  "select * 
				FROM fsm_reacciones
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  reacciones_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'EXUF')
		{//EXUF 	EXUDADO FARINGEO
			$sql =  "select * 
				FROM fsm_exudado
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  exudado_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}
		elseif ($examen == 'PROST')
		{
			$sql =  "select * 
				FROM fsm_prost
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  prost_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}
		elseif ($examen == 'HBSAG')
		{
			$sql =  "select * 
				FROM fsm_hbsag
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  hbsag_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}
		elseif ($examen == 'HCAP')
		{
			$sql =  "select * 
				FROM fsm_hcap
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  hcap_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}		
		elseif ($examen == 'IMUNO')
		{//IMUNO    IMUNO
			$sql =  "select * 
				FROM  fsm_imuno
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  imuno_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}		
		elseif ($examen == 'HBA1C')
		{
			$sql =  "select * 
				FROM  fsm_hba1c
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  hba1c_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}		
		elseif ($examen == 'VIH')
		{
			$sql =  "select * 
				FROM  fsm_vih
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  vih_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}		
		elseif ($examen == 'CONTIN')
		{
			$sql =  "select * 
				FROM  fsm_cotinina
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and  cotinina_f_recibido  between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}		
		elseif ($examen == 'CPROPA')
		{//CPROPA	COPROPARASITOSCOPICO 			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%PROPARASIT%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CPROCU')
		{//CPROCU 	COPROCULTIVO							
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%OPROCUL%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'QS6')
		{//QS6 	QUIMICA SANGUINEA DE 6
				$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%NEA DE 6%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'AAFQ')
		{//AAFQ 	ANALISIS DE AGUA FISICO-QUIMICO					
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%AGUA FISICO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'AHFQ')
		{//AHFQ 	ANALISIS DE HIELO FISICO-QUIMICO		
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%HIELO FISICO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'KOHU')
		{$sql = "SELECT * FROM sis10_clientes_doc where clte_id = ".$cliente_id." and doc_nombre LIKE '%KOH DE U%'";
		}elseif ($examen == 'CSVIVA')
		{//CSVIVA 	CULTIVO DE SUPERFICIE VIVA			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%VIVA%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CSINERTE')
		{//CSINERTE 	CULTIVO DE SUPERFICIE INERTE			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%INERTE%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CACRUDO')
		{//CACRUDO 	CULTIVO DE ALIMENTO CRUDO		
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%CRUDO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'CACOCIDO')
		{//CACOCIDO 	CULTIVO DE ALIMENTO COCIDO				
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%COCIDO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'ABA')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%LOGICO DE AGUA%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'COVID19')
		{			
			$sql = "select * FROM sis12_covid_doc where	clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
		}
		elseif ($examen == 'ABH')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%LOGICO DE HIELO%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'PROST')
		{			
			$sql =  "select * 
				FROM sis10_clientes_doc
				where 
				clte_id = ".$cliente_id." and doc_nombre LIKE '%ANTÍGENO PROSTÁTICO ESPECÍFICO PSA%'"; //fsm_f between '".$ini."' and '".$fin."'";
			//$sql=$sql." limit 1";
		}elseif ($examen == 'PSSIM')
		{			
			$sql = "select * FROM fsm_psicologico_4
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and fsm_f between '".$ini."' and '".$fin."'";
		}elseif ($examen == 'HONE')
		{			
			$sql = "select * FROM sis12_honestidad_doc
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and doc_f between '".$ini."' and '".$fin."'";
		}elseif ($examen == 'COMPO')
		{			
			$sql = "select * FROM sis13_comportamiento_doc
				where 
				clte_id = ".$cliente_id." and serv_id  =".$serv_id." and doc_f between '".$ini."' and '".$fin."'";
		
		}elseif ($examen == 'TOXIV')
		{			
			$sql = "select * FROM sis13_comportamiento_doc
				where 
				clte_id = ".$cliente_id." and doc_f between '".$ini."' and '".$fin."'";
		
		}else
		{
			 return NULL;
		}
		//$sql=$sql." and emp_id = ".$emp_id; ." limit 1";
		//echo $sql;
		$result = $this->db->query($sql);
        return $result->row_array();
    }


/**************************************************/


	function get_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis10_clientes_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

	function get_orden_de_servicio($serv_id)
        {
            $sql="select serv_orden,serv_f_inicio,serv_f_fin from sis30_servicios where serv_id = ".$serv_id;
            //echo $sql;
			$result = $this->db->query($sql);
            return $result->row_array();
        }
		
		
	

	function get_orden_de_servicio_examenes($serv_id)
        {
            $sql="select exam_cve from sis35_servicios_examenes where serv_id = ".$serv_id;
            $sql=$sql." order by exam_cve ASC"; 
		   // echo $sql;
			$result = $this->db->query($sql);
            return $result->result_array();
        }


    function get_examenes($emp_id = '', $ini = '', $fin = '')
    {
        $mapeo = unserialize(MAPEO_EXAMENES);

        $select = "SELECT a.clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt,clte_materno_crypt,clte_genero_cve, clte_rfc_crypt, emp_razon_social, b.emp_id, cei_id";
        $select = parsea_select($select, 'humancenter');
        $inicio = FALSE;
        $sql = $select.',y.clte_id, group_concat(alias,":", regs) as examenes FROM (SELECT clte_id, alias, sum(registros) as regs FROM (';
        foreach($mapeo as $tb) {
            if($inicio) $sql .= ' UNION ';
            $sql .= 'SELECT clte_id,"'.$tb['alias'].'" as alias, count(clte_id) as registros FROM '.$tb['tabla'].' WHERE '.$tb['fecha'].' between "'.$ini.'" AND "'.$fin.'"';
            if(isset($tb['where'])) $sql .= ' AND '.$tb['where']['campo'].' = "'.$tb['where']['valor'].'"';
            $sql .=  ' group by 1,2';
            $inicio = TRUE;
			
        }
		//echo "-----> ".$sql;
        $sql .= ') as x group by 1,2) as y ';
        $sql .= ' LEFT JOIN sis05_clientes as a ON y.clte_id = a.clte_id ';
        $sql .= ' LEFT JOIN sis15_empresas as b ON a.emp_id = b.emp_id ';
        if($emp_id != ''){
            $sql .= ' WHERE b.emp_id = "'.$emp_id.'"';
        }
        $sql .= ' GROUP BY y.clte_id ';
        $sql .= ' ORDER BY b.emp_id ASC;';
		
		/*echo "-----> ".$sql;*/
        $result = $this->db->query($sql);
        return $result->result_array(); 
    }

    function get_costos($emp_id){
        $this->db->select('*');
        $this->db->from('sis16_empresas_costos');
        $this->db->where('emp_id',$emp_id);
        $result = $this->db->get();
        return $result->result_array();
    }


    function get_el_costos_l($emp_id,$clave,$desp_id=0)
	{
		
        $this->db->select('cost_monto');
        $this->db->from('sis16_empresas_costos');
		
		if (
			($desp_id==0) 
		   ) 
		{	
			$this->db->where('emp_id',$emp_id);
		}
		elseif (
			  ($desp_id==33)
			||  ($desp_id==77)
			||  ($desp_id==106)
			||  ($desp_id==148)
			||  ($desp_id==183)
			)
		{
			$this->db->where('emp_id',$desp_id);
		}
		else
		{	
			$this->db->where('emp_id',$emp_id);
		}	
		
		//$this->db->where('cost_examen_cve',$clave);
		$this->db->like('cost_examen_cve',$clave);
        $result = $this->db->get();
        return $result->row_array();
    }	
	
    function get_el_costos($emp_id,$clave,$desp_id=0)
	{
		
		
        $this->db->select('cost_monto');
        $this->db->from('sis16_empresas_costos');
		
		if (
			($desp_id==0) 
		   ) 
		{	
			$this->db->where('emp_id',$emp_id);
		}
		elseif (
			  ($desp_id==33)
			||  ($desp_id==77)
			||  ($desp_id==106)
			||  ($desp_id==148)
			||  ($desp_id==183)
			)
		{
			$this->db->where('emp_id',$desp_id);
		}
		else
		{	
			$this->db->where('emp_id',$emp_id);
		}

		if ($emp_id == 	52)
		{
			$this->db->where('cost_nombre_pkt','EVALUACION POLIGRAFICA HECHO ESPECIFICO');
		}	
		else 
		{	
			$this->db->where('cost_examen_cve',$clave);
		}
		
		
		
        $result = $this->db->get();
        return $result->row_array();
    }


    function get_la_aptitud($emp_id,$clave){
        $this->db->select('cost_monto');
        $this->db->from('sis16_empresas_costos');
        $this->db->where('emp_id',$emp_id);
		$this->db->where('cost_examen_cve',$clave);
        $result = $this->db->get();
        return $result->row_array();
    }		
	
	
	/**************************************************************************************/        
        function buscandote($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			//if($cei != ''){ $this->db->where('cei_id',$cei); }
			
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            
			
			//if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/        
/**************************************************************************************/        
 function busca($empresa = '',$nombre = '', $rfc = '', $ubicacion = '', $cei='')
        {            
            //$this->db->select('*');
            //$select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id";
            //$this->db->select(parsea_select($select, 'humancenter'));
            
           // $this->db->from('sis05_clientes as a');
            //$this->db->where('status', 'activo');
            //$this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            //$this->db->where('cei_id',$cei);
            //if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
            //if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
           // if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
           // if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
            
         
            /*if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $where = "(a.emp_id=70 or a.emp_id=72 or a.emp_id=74 or a.emp_id=78 or a.emp_id=79 or a.emp_id=68 or a.emp_id=66)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $where = "(a.emp_id=80 or a.emp_id=82 or a.emp_id=83)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('a.emp_id', get_emp_id());
            }*/

            //if(get_perfil_id() == 4){
            //    $empresas = get_empresas_array();
            //    $this->db->where_in('a.emp_id', $empresas);
            //}

           
            //$this->db->order_by('log_insrt_f','DESC');
            //$result = $this->db->get();
			
		   $sql="SELECT clte_id, AES_DECRYPT(clte_nombre_crypt, 'humancenter') as clte_nombre, AES_DECRYPT(clte_2_nombre_crypt, 'humancenter') as clte_2_nombre, AES_DECRYPT(clte_paterno_crypt, 'humancenter') as clte_paterno,AES_DECRYPT( clte_materno_crypt, 'humancenter') as clte_materno, clte_f_nac, AES_DECRYPT(clte_rfc_crypt, 'humancenter') as clte_rfc, emp_razon_social,log_insrt_f,suc_id, cei_id
from sis05_clientes as a JOIN sis15_empresas as b ON a.emp_id = b.emp_id
WHERE 
status = 'activo' ";
/*if($cei != ''){*/ $sql=$sql." AND cei_id = '".$cei."' "; /* }*/
if($rfc != ''){ $sql=$sql." AND AES_DECRYPT(clte_rfc_crypt, 'humancenter') = '".$rfc."' ";} 
if($empresa != ''){ $sql=$sql."and a.emp_id = ".$empresa." ";} 
$sql=$sql."order_by log_insrt_f DESC"; 
echo $sql;
                        $result = $this->db->query($sql);
                        return $result->result_array();			
        }
/**************************************************************************************/        
    
	
}