<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Nx_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }


    function get_nx_examenes($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('nx_examenes');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }

    function delete_familiar($fsm_id,$id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('fam_id', $id);
        return $this->db->delete('nx_examenes');
    }

	function get_coms($cliente_id)
	{
		$this->db->select('*');
		$this->db->from('sis06_nx_com');
		$this->db->where('clte_id', $cliente_id);
		$this->db->order_by('com_id','DESC');
		$result = $this->db->get();
		return $result->result_array();
	}

    function insert_arreglo($array, $columna_val, $fsm_id, $tabla)
    {
        $insert_id = null;

        if(!empty($array))
        {
            foreach($array as $row)
            {
                if(trim($row[$columna_val]) != "")
                {
                    $row['fsm_id'] = $fsm_id;
                    $this->db->insert($tabla,  array_to_upper($row));
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }



		function count_allo($suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_nx');
			$result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


		function get_allo($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

			$this->db->select('*');
            $this->db->from('sis90_nx');
            $this->db->where('status', 'activo');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }


        function get($id,$es_usr_de_un_despacho=0)
        {
			$this->db->select('*');
            $this->db->from('sis90_nx');
            $this->db->where('clte_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }

        function get_docs_nx($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis10_nx_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		

        
        function add_doc_nx($data_insert)
        {
            $this->db->insert('sis10_nx_doc', $data_insert);
            return $this->db->insert_id();
        }

        
        function get_doc_nx($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis10_nx_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }

		function inserta_borrado($data_insert)
		{
			$this->db->insert('sis_borrado_docs', $data_insert);
			return $this->db->insert_id();
		}
		
		function delete_doc_nx($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis10_nx_doc');
		}		
		

        function busca_nx($empresa = '')
        {            
            $this->db->select('*');
            $this->db->from('sis90_nx');
            //if($empresa != ''){$this->db->where('nx_empresa',$empresa);}
			
			/*
			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }*/
  			//$this->db->order_by('log_insrt_f','DESC');
			
            $result = $this->db->get();
            return $result->result_array();
        }

/**************************************************************************************/        
        function busca($empresa,$concepto='',$orden_de_venta='',$orden_de_compra='',$f_ini='',$f_fin='',$numero_de_factura='',$folio_5000='',$estatus='')
        {            
            $this->db->select('*');
           // $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id";
           // $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx as a');
			//$this->db->from('sis05_clientes as a');
           // $this->db->where('status', 'activo');
			
           $this->db->join('sis15_empresas as b', 'a.nx_empresa = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.nx_empresa',$empresa);}
			if($concepto != ''){$this->db->like('a.nx_concepto',$concepto);}
			if($orden_de_venta != ''){$this->db->like('a.nx_orden_de_venta',$orden_de_venta);}
			if($orden_de_compra != ''){$this->db->like('a.nx_folio_orden_de_compra',$orden_de_compra);}
			if($numero_de_factura != ''){$this->db->like('a.nx_numero_de_factura',$numero_de_factura);}
			if($folio_5000 != ''){$this->db->like('a.nx_folio_5000',$folio_5000);}
			if($estatus != ''){$this->db->like('a.nx_status',$estatus);}
			
			if($f_ini!= ''){$this->db->where('a.nx_periodo_inicial',$f_ini);}
			if($f_fin != ''){$this->db->where('a.nx_periodo_final',$f_fin);}
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
/*===============================================================================*/
		function count_allo_gsi($suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$gsi)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_nx');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
			/*$this->db->where_in('emp_id',$gsi);*/
            $this->db->join('sis15_empresas', 'sis90_nx.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
            $result = $this->db->get();			
            $row = $result->row_array();
            return $row['regs'];
        }		 
		 
		function get_allo_gsi($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_nx.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_nx');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            
			$this->db->join('sis15_empresas', 'sis90_nx.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
			/*$this->db->where_in('emp_id',$gsi);*/
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        } 	 
		 
	
		function get_allo_p($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_nx.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_nx');
			if ($paciente==1)
			{
				$this->db->where('sis90_nx.paciente',1);
				
				//$this->db->where('sis90_nx.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis90_nx.paciente !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_nx.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        } 

		function get_allo_e($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_nx.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado, empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_nx');
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis90_nx.hc',1);}
				else
				{$this->db->where('sis90_nx.empleado',1);	}							
				$this->db->where('sis90_nx.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis90_nx.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_nx.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }

	
		function get_allo_a($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_nx.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado, empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_nx');

				if ($emp_id==31)
				{$this->db->where('sis90_nx.hc != ',1);}
				else
				{$this->db->where('sis90_nx.empleado',1);	}							
				$this->db->where('sis90_nx.emp_id',$emp_id);

			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_nx.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }	

		function get_allo_b($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_nx.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado, empleado, status";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_nx');

				if ($emp_id==31)
				{$this->db->where('sis90_nx.hc',1);}
				else
				{$this->db->where('sis90_nx.empleado',1);	}							
				$this->db->where('sis90_nx.emp_id',$emp_id);
				$this->db->like('sis90_nx.status','noactivo');

			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
           
            $this->db->join('sis15_empresas', 'sis90_nx.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }		
	
 
 
 

 

 

 
		function get_empleados_nom035($emp_id)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id,hc, desp_id, nomserv";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            $this->db->where('a.emp_id',$emp_id);
			if ($emp_id == 31)
			{
				$this->db->where('a.hc',1);
			}	
			else
			{
				$this->db->where('a.empleado',1);
			}				
			//$this->db->like('nomserv',$nom035); 
            $this->db->order_by('clte_paterno','ASC');
			$this->db->order_by('clte_materno','ASC');
			$this->db->order_by('clte_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
 
 
 
        function get_all($rows) /*ok clte_nss_crypt*/
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_nx.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id,cei_id,clte_nss_crypt";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_nx');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_nx.emp_id=sis15_empresas.emp_id','left');

            if(get_perfil_id() == 4){
				/*$surcursal_id=get_sucursal_id();
				echo "$surcursal_id->".$surcursal_id."<--";
				if ($surcursal_id > 0)
				{	
				$this->db->where('suc_id', $surcursal_id); 	
				}
				echo " Punto A ";*/
                $empresas = get_empresas_array();
				//echo " Punto B ";
                $this->db->where_in('sis90_nx.emp_id', $empresas);
				//echo " Punto C ";
            }
            
            // if(get_perfil_id() == 1 && get_user_id() == 138 )
            // {
            //     $this->db->where('sis15_empresas.emp_id', '70');
            //     $this->db->or_where('sis15_empresas.emp_id', '72');
            //     $this->db->or_where('sis15_empresas.emp_id', '74');
            //     $this->db->or_where('sis15_empresas.emp_id', '78');
            //     $this->db->or_where('sis15_empresas.emp_id', '79');
            //     $this->db->or_where('sis15_empresas.emp_id', '68');
            //     $this->db->or_where('sis15_empresas.emp_id', '66');
            // }

            // if(get_perfil_id() == 5)
            // {
            //     $this->db->where('sis15_empresas.emp_id', '65');
            //     $this->db->or_where('sis15_empresas.emp_id', '72');
            //     $this->db->or_where('sis15_empresas.emp_id', '71');
            // }


            // if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            // {
            //     $this->db->where('sis15_empresas.emp_id', '70');
            //     $this->db->or_where('sis15_empresas.emp_id', '72');
            //     $this->db->or_where('sis15_empresas.emp_id', '74');
            //     $this->db->or_where('sis15_empresas.emp_id', '78');
            //     $this->db->or_where('sis15_empresas.emp_id', '79');
            //     $this->db->or_where('sis15_empresas.emp_id', '68');
            //     $this->db->or_where('sis15_empresas.emp_id', '66');
            // } 
            // elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            // {
            //     $this->db->where('sis15_empresas.emp_id', '80');
            //     $this->db->or_where('sis15_empresas.emp_id', '82');
            //     $this->db->or_where('sis15_empresas.emp_id', '83');
               
            // }
            // elseif(get_perfil_id() == 4 && get_user_id() == 215 )
            // {
            //  $this->db->where('sis90_nx.sub_emp', 4);
            // }
            // elseif(get_perfil_id() == 4 && get_user_id() == 216 )
            // {
            //  $this->db->where('sis90_nx.sub_emp', 3);
            // }
            // elseif(get_perfil_id() == 4 && get_user_id() == 217 )
            // {
            //  $this->db->where('sis90_nx.sub_emp', 2);
            // }
            // elseif(get_perfil_id() == 4 && get_user_id() == 218 )
            // {
            //  $this->db->where('sis90_nx.sub_emp', 1);
            // }
            // elseif(get_perfil_id() == 4){
            //     $this->db->where('sis90_nx.emp_id', get_emp_id());
            // }

            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }
        
        function count_all()
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_nx');
            
            /*if(get_perfil_id() == 1 && get_user_id() == 138 )
            {
                $this->db->where('emp_id', '70');
                $this->db->or_where('emp_id', '72');
                $this->db->or_where('emp_id', '74');
                $this->db->or_where('emp_id', '78');
                $this->db->or_where('emp_id', '79');
                $this->db->or_where('emp_id', '68');
                $this->db->or_where('emp_id', '66');

            }
         
            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $this->db->where('emp_id', '70');
                $this->db->or_where('emp_id', '72');
                $this->db->or_where('emp_id', '74');
                $this->db->or_where('emp_id', '78');
                $this->db->or_where('emp_id', '79');
                $this->db->or_where('emp_id', '68');
                $this->db->or_where('emp_id', '66');
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('emp_id', get_emp_id());
            }*/
			

            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
            }

            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
        
		function count_allo_p($suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_nx');
			
			if ($paciente==1)
			{
				$this->db->where('sis90_nx.paciente',1);
			}
			else
			{
				$this->db->where('sis90_nx.paciente !=',1); //SOLO DEJAR EVALUADOS				
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }		
		
		function count_allo_e($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_nx');
			$this->db->where('sis90_nx.emp_id',$emp_id);
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis90_nx.hc',1);}
				else
				{$this->db->where('sis90_nx.empleado',1);	}							
				$this->db->where('sis90_nx.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis90_nx.empleado !=',1); //SOLO DEJAR EVALUADOS
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }			
		
		function count_allo_a($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_nx');
			$this->db->where('sis90_nx.emp_id',$emp_id);
				if ($emp_id==31)
				{$this->db->where('sis90_nx.hc !=',1);}
				else
				{$this->db->where('sis90_nx.empleado',1);	}							
				$this->db->where('sis90_nx.emp_id',$emp_id);						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
			$this->db->like('sis90_nx.status','activo');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


		function count_allo_b($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_nx');
			$this->db->where('sis90_nx.emp_id',$emp_id);
				if ($emp_id==31)
				{$this->db->where('sis90_nx.hc',1);}
				else
				{$this->db->where('sis90_nx.empleado',1);	}							
				$this->db->where('sis90_nx.emp_id',$emp_id);	
				$this->db->like('sis90_nx.status','noactivo');
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
		


        function get_roots($id)
        {
            $select = "root1,root2";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }


        function get_my_servicios($id)
        {
            $select = "servicios";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }

        
        function get_empresa_by_clte($clte_id)
        {
            $select = "sis15_empresas.*";
            $this->db->select($select);
            $this->db->from('sis90_nx');
            $this->db->join('sis15_empresas', 'sis15_empresas.emp_id = sis90_nx.emp_id');
            $this->db->where('clte_id', $clte_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function inserta($params)
        {
            $data = array_merge($params, log_insert('Nuevo cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('sis90_nx');
            return $this->db->insert_id();
        }
        function actualiza($clte_id, $params)
        {
            $data = array_merge($params, log_update('Edita cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis90_nx');
        }
  
        function actualiza_registro($clte_id, $params)
        {
            $data = array_merge($params, log_update_reg('Edita y registra nuevamente cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis90_nx');
        }
 
  


		
		
/***************************COMPORTAMIENTO*******************************************/
        function get_compo_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_comportamiento_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
        function get_sgmty_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_sgmty_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }



        function get_covid_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_covid_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

 
        function get_compo_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_comportamiento_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
  
        function add_covid_doc($data_insert)
        {
            $this->db->insert('sis12_covid_doc', $data_insert);
            return $this->db->insert_id();
        }
		
  
        function add_compo_doc($data_insert)
        {
            $this->db->insert('sis13_comportamiento_doc', $data_insert);
            return $this->db->insert_id();
        }
		
		 function add_sgmty_doc($data_insert)
        {
            $this->db->insert('sis12_sgmty_doc', $data_insert);
            return $this->db->insert_id();
        }
/***************************HONESTIDAD*******************************************/
        function get_hon_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_honestidad_doc');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_hon_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_honestidad_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function add_hon_doc($data_insert)
        {
            $this->db->insert('sis12_honestidad_doc', $data_insert);
            return $this->db->insert_id();
        }
		
		
        function borra_sgmty_doc($id)
        {
            $this->db->where('clte_id', $id);
            return $this->db->delete('sis12_sgmty_doc`');
        }
		
        function borra_sgmty_venta($id,$tipo)
        {
            $this->db->where('clte_id', $id);
			$this->db->like('doc_nombre', $tipo);
            return $this->db->delete('sis12_sgmty_doc`');
        }	

    function borra_evaluado($fsm_id)
    {
        $this->db->where('clte_id', $fsm_id);
        return $this->db->delete('sis90_nx');
    }	

        
        function get_empresas()
        {
            $this->db->select('b.*');
            $this->db->from('sis90_nx as a');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id','left');
            
            /*if(get_perfil_id() == 4)
            {
                $this->db->where('a.emp_id', get_emp_id());
            }*/

            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            $this->db->group_by('b.emp_id');
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
	

	function trae_empresas()
    {
        $this->db->select('*');
        $this->db->from('sis15_empresas');
		
		if(get_perfil_id() == 4)
        {
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
        }
		else
		{
			$estatus='INACTIVO';
			 $this->db->not_like('emp_estatus_cve',$estatus);
		}		
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
    }

	
        function get_despachos()
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
			$n='1';
			$this->db->where('emp_desp', $n);
            $this->db->group_by('emp_id');
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }		
/**************************************************************************************/
        function buscate($nombre1 = '',$nombre2 = '',$paterno = '',$materno = '')
        {            
            //$select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,log_insrt_f,suc_id, cei_id";
            $select = "log_insrt_f";
			$this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx');
            $this->db->where('status', 'activo');
            $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre1);
			$this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2);
			$this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno);
			$this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno);

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function buscate_rfc($rfc = '',$emp_id = '')
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,log_insrt_f,suc_id, cei_id";
            //$select = "log_insrt_f";
			$this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx');
            $this->db->where('status', 'activo');
            $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc);
			$this->db->like('emp_id',$emp_id);
            $result = $this->db->get();
            return $result->result_array();
        }		
		
/**************************************************************************************/        

/**************************************************************************************/
        function busca_e($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_id_user='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx as a');
            $this->db->where('status', 'activo');
			
			if($empresa != 31)
			{
			$this->db->where('a.empleado',1);
			}
			else
			{
			  $this->db->where('a.hc',1);
			}
			
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			
			if($empresa != 31)
			{			
			//if($receta != '')  { $this->db->where('a.clte_id',intval($receta)); }
            if($empleado != ''){ $this->db->like('a.num_empleado',$empleado); }
			}
  		
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

/**************************************************************************************/
        function busca_a($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			$this->db->where('a.hc !=',1);
			//$this->db->or_where('a.hc', NULL);
           
  			
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

/**************************************************************************************/        
        function busca_p($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_id_user='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx as a');
            $this->db->where('status', 'activo');
			$this->db->where('a.paciente',1);
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',intval($receta)); }
            if($empleado != ''){ $this->db->like('a.num_empleado',$empleado); }
  			
			if(get_perfil_id() == 4)
			{
				//$despacho=get_desp_id_usr();
				//echo  '--DESPACHO>'.$user_despacho.'<--';
				//echo  '--EMPRESA>'.get_emp_id().'<--';				
				if ($despacho != 0)
				{					
					$this->db->where('desp_id',$despacho);					
				}	
				else
				{
                //$empresas = get_empresas_array();
                //$this->db->where_in('a.emp_id', $empresas);
				$this->db->where('a.emp_id',$emp_id_user);
						
				}
				$emp_id_user=get_emp_id();
				
				if ($emp_id_user == 31)
				{
				 $this->db->where('a.hc =',1); //SOLO DEJAR a la gente HC	
				}	
            } 
			else
			{
				//$this->db->where('a.hc',NULL); //quitar a la gente HC	
				
			}	         
         
            /*if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $where = "(a.emp_id=70 or a.emp_id=72 or a.emp_id=74 or a.emp_id=78 or a.emp_id=79 or a.emp_id=68 or a.emp_id=66)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $where = "(a.emp_id=80 or a.emp_id=82 or a.emp_id=83)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('a.emp_id', get_emp_id());
            }*/


			/*else
			{
				if ( $root2 == '1')
				{

				}
				else
				{
					$this->db->where('a.emp_id !=', '31');					
				}
			} */
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }




/**************************************************************************************/        
        function buscandote($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			//echo $fecha->format('Y-m-d') . "\n";
			
			//$f_fino=date_add($f_fin, date_interval_create_from_date_string('1 days'));
			//$this->db->where('log_insrt_f <=',date_format($f_fino,'Y-m-d' ));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            			
			//if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/             
/**************************************************************************************/        
        function buscando_evaluados_gsi($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            $this->db->where('b.emp_corp', 'GSI');
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));

			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
    			
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/             
        
/**************************************************************************************/        
        function buscandote_by_despacho($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$es_usr_de_un_despacho=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_nx as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            			
            /*
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
			}
			*/
			
			
			if(get_perfil_id() == 4)
			{
				if ($es_usr_de_un_despacho==0)
				{	
					$empresas = get_empresas_array();
					$this->db->where_in('a.emp_id', $empresas);
					$i=33;
					$this->db->where('desp_id !=',$i);
					
					
				}
				else
				{
					
					$this->db->where('a.desp_id', $es_usr_de_un_despacho);					
				}	
			}
			
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        
        function get_empresa_by_id($emp_id)
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
            $this->db->where('emp_id', $emp_id);
            $result = $this->db->get();
            return $result->row_array();
        }

 
}