<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Carwash_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }

	function inserta($params)
	{
		$data = array_merge($params, log_insert('Nuevo cliente'));
		parsea_insert($data, $this->db, 'humancenter');
		$this->db->insert('sis04_carwash');
		return $this->db->insert_id();
	}

    function get_doc_entrega($fsm_id)
    {
		$this->db->select('*');
        $this->db->from('fsm_documento_entrega');
        $this->db->where('fsm_id',$fsm_id);
        $result = $this->db->get();
        return  $row = $result->row_array();
    }

    function get_doc_entrega_by_cliente($cliente_id)
    {
		$this->db->select('*');
        $this->db->from('fsm_documento_entrega');
        $this->db->where('cond_id',$cliente_id);
        $result = $this->db->get();
        return  $row = $result->row_array();
    }

    function get_doc_recibe($fsm_id)
    {
		$this->db->select('*');
        $this->db->from('fsm_documento_recibo');
        $this->db->where('fsm_id',$fsm_id);
        $result = $this->db->get();
        return  $row = $result->row_array();
    }


    function get_doc_resumen($fsm_id)
    {
		$this->db->select('*');
        $this->db->from('fsm_documento_resumen');
        $this->db->where('fsm_id',$fsm_id);
        $result = $this->db->get();
        return  $row = $result->row_array();
    }

    function get_by_documento_entrega($cliente_id)
    {
		$this->db->select('*');
        $this->db->from('fsm_documento_entrega');
        $this->db->where('cond_id', $cliente_id);
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_by_documento_resumen($cliente_id)
    {
		$this->db->select('*');
        $this->db->from('fsm_documento_resumen');
        $this->db->where('cond_id', $cliente_id);
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_by_documento_recibo($cliente_id)
    {
		$this->db->select('*');
        $this->db->from('fsm_documento_recibo');
        $this->db->where('cond_id', $cliente_id);
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }


    function get_by_ultimo_documento_recibo($cliente_id)
    {
		$this->db->select('*');
        $this->db->from('fsm_documento_recibo');
        $this->db->where('cond_id', $cliente_id);
        $this->db->order_by('log_insrt_f','DESC');
        $this->db->limit(1);
        $result = $this->db->get();
        $row = $result->row_array();
        return $row;		
		
    }



		function inserta_documento_resumen($data_insert)
		{
			$this->db->insert('fsm_documento_resumen', $data_insert);
			return $this->db->insert_id();
		}


		function inserta_documento_entrega($data_insert)
		{
			$this->db->insert('fsm_documento_entrega', $data_insert);
			return $this->db->insert_id();
		}

		function inserta_documento_recibo($data_insert)
		{
			$this->db->insert('fsm_documento_recibo', $data_insert);
			return $this->db->insert_id();
		}


		function delete_doc($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis04_carwash_doc');
		}

        function add_doc($data_insert)
        {
            $this->db->insert('sis04_carwash_doc', $data_insert);
            return $this->db->insert_id();
        }

        function actualiza_nombre_doc($fsm_id, $params)
        {
            $this->db->where('doc_id',$fsm_id);
            return $this->db->update('sis04_carwash_doc',$params);
        }

        function get_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis04_carwash_doc');
            $this->db->where('cond_id', $cliente_id);
		    $this->db->order_by('doc_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_coms($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis04_carwash_com');
            $this->db->where('cond_id', $cliente_id);
            $this->db->order_by('com_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function busca(
			$id='', 
			$nombre='',
			$paterno='', 
			$materno='', 
			$poliza='', 
			$estatus='',
			$f_ini='',
			$f_fin=''
			)
        {            
			
			$this->db->select('*');
            $this->db->from('sis04_carwash');

			if($id != ''){ $this->db->where('cond_id',$id);}
			if($nombre != ''){ $this->db->like('cond_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('cond_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('cond_materno',$materno); } 
			if($poliza != ''){ $this->db->like('cond_poliza',$poliza); }
			if($estatus != ''){ $this->db->like('cond_estatus',$estatus); }
			
			if($f_ini != ''){$this->db->where('log_insrt_f >=', $f_ini.' 00:00:00');}
			if($f_fin != ''){$this->db->where('log_insrt_f <=', $f_fin.' 23:59:59');}
		
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


		function get_allo_conductor($rows,$conductor_id)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
			
            $this->db->select('*');
            $this->db->from('sis04_carwash');			 
			 $this->db->where('cond_conductor',$conductor_id);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			
            return $result->result_array();

        } 	
		
		function count_allo_conductor($conductor_id)
        {
            $this->db->select("count(cond_id) as regs");
            $this->db->from('sis04_carwash');
			 $this->db->where('cond_conductor',$conductor_id);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


		function get_allo($rows)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
			
            $this->db->select('*');
            $this->db->from('sis04_carwash');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			
            return $result->result_array();

        } 	
		
		function count_allo()
        {
            $this->db->select("count(cond_id) as regs");
            $this->db->from('sis04_carwash');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


        function get($id)
        {   
            $this->db->select("*");
            $this->db->from('sis04_carwash');
            $this->db->where('cond_id', $id);         
            $result = $this->db->get();			
            return $result->row_array();           
        }

        function actualiza($cond_id, $params)
        {
            $this->db->where('cond_id',$cond_id);
            return $this->db->update('sis04_carwash',$params);
        }
		
		
	
/*****************************************************************************************/
      

}