<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Historia_clinica_jr_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

     function insert_historia_clinica_jr($data_insert)
    {
        $this->db->insert('fsm_historia_clinica_jr', $data_insert);
        return $this->db->insert_id();
    }


    function borra_historia_clinica_jr($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_historia_clinica_jr');
    }	
    
    function get_nom030($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_historia_clinica_jr');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }
	

    function get_by_clte($cliente_id) 
    {
        $this->db->select('*');
        $this->db->from('fsm_historia_clinica_jr');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }


    function get_cuantos_ISOEXMESAOC($clte_id)
    {
        $this->db->select("count(clte_id) as regs");
        $this->db->from('fsm_historia_clinica_jr');
        $this->db->where('clte_id', $clte_id);
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
    }



    

    function get_ISOEXMEDINEX($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_historia_clinica_jr');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }
	
	
	function actualiza_nom30($fsm_id, $params)
	{
		$this->db->where('fsm_id',$fsm_id);
		return $this->db->update('fsm_historia_clinica_jr',$params);
	}	
	





}