<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Ingreso_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get all ingreso
     */
    function get_all_ingresos()
    {
        return $this->db->get('socio_eco_ingreso')->result_array();
    }
    
    /*
     * Get all ingresos by fsm_id
     */
    function get_ingresos($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_ingreso');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * function to add new ingreso
     */
    function inserta($params)
    {
        $this->db->insert('socio_eco_ingreso',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to add new ingresos
     */
    function inserta_ingresos($ingresos, $fsm_id)
    {
        if(!empty($ingresos))
        {
            foreach($ingresos as $ingreso)
            {
                if($ingreso['tipo_cve'] != '' && $ingreso['mensual'] != '')
                {
                    if(isset($ingreso['ingreso_id']))
                    {
                        $ingreso_id = $ingreso['ingreso_id'];
                        unset($ingreso['ingreso_id']);
                        $this->db->where('ingreso_id', $ingreso_id);
                        $this->db->update('socio_eco_ingreso',  array_to_upper($ingreso));
                    }
                    else
                    {
                        $ingreso['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('socio_eco_ingreso',array_to_upper($ingreso));
                    }
                }
            }
        }
        return $this->db->insert_id();
    }
}