<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Persona_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }

        /*
         * Get usuario by mail
         */
        function get_all($rows)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            if(get_perfil_id() == 1 && get_user_id() == 138 )
            {
                $this->db->where('sis15_empresas.emp_id', '70');
                $this->db->or_where('sis15_empresas.emp_id', '72');
                $this->db->or_where('sis15_empresas.emp_id', '74');
                $this->db->or_where('sis15_empresas.emp_id', '78');
                $this->db->or_where('sis15_empresas.emp_id', '79');
                $this->db->or_where('sis15_empresas.emp_id', '68');
                $this->db->or_where('sis15_empresas.emp_id', '66');

            }
            if(get_perfil_id() == 5)
            {
                $this->db->where('sis15_empresas.emp_id', '65');
                $this->db->or_where('sis15_empresas.emp_id', '72');
                $this->db->or_where('sis15_empresas.emp_id', '71');


            }


            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $this->db->where('sis15_empresas.emp_id', '70');
                $this->db->or_where('sis15_empresas.emp_id', '72');
                $this->db->or_where('sis15_empresas.emp_id', '74');
                $this->db->or_where('sis15_empresas.emp_id', '78');
                $this->db->or_where('sis15_empresas.emp_id', '79');
                $this->db->or_where('sis15_empresas.emp_id', '68');
                $this->db->or_where('sis15_empresas.emp_id', '66');
            } 
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $this->db->where('sis15_empresas.emp_id', '80');
                $this->db->or_where('sis15_empresas.emp_id', '82');
                $this->db->or_where('sis15_empresas.emp_id', '83');
               
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('sis05_clientes.emp_id', get_emp_id());
            }
            //es para cesareo pero creo que se puede hacer como arriba con el perfil cuatro 
  	        
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function count_all()
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
            if(get_perfil_id() == 1 && get_user_id() == 138 )
            {
                $this->db->where('emp_id', '70');
                $this->db->or_where('emp_id', '72');
                $this->db->or_where('emp_id', '74');
                $this->db->or_where('emp_id', '78');
                $this->db->or_where('emp_id', '79');
                $this->db->or_where('emp_id', '68');
                $this->db->or_where('emp_id', '66');

            }
         
            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $this->db->where('emp_id', '70');
                $this->db->or_where('emp_id', '72');
                $this->db->or_where('emp_id', '74');
                $this->db->or_where('emp_id', '78');
                $this->db->or_where('emp_id', '79');
                $this->db->or_where('emp_id', '68');
                $this->db->or_where('emp_id', '66');
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('emp_id', get_emp_id());
            }
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
        
        function get($id)
        {
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto,emp_id, log_insrt_f,clte_edo_civ_cve, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $where = "(emp_id=70 or emp_id=72 or emp_id=74 or emp_id=78 or emp_id=79 or emp_id=68 or emp_id=66)";
                $this->db->where($where);
                
            }
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $where = "(emp_id=80 or emp_id=82 or emp_id=83)";
                $this->db->where($where);
                
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('emp_id', get_emp_id());
            }
            $this->db->where('clte_id', $id);

                             
            $result = $this->db->get();
            return $result->row_array();     
        
           
        }
        
        function get_empresa_by_clte($clte_id)
        {
            $select = "sis15_empresas.*";
            $this->db->select($select);
            $this->db->from('sis05_clientes');
            $this->db->join('sis15_empresas', 'sis15_empresas.emp_id = sis05_clientes.emp_id');
            $this->db->where('clte_id', $clte_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function inserta($params)
        {
            $data = array_merge($params, log_insert('Nuevo cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('sis05_clientes');
            return $this->db->insert_id();
        }
        function actualiza($clte_id, $params)
        {
            $data = array_merge($params, log_update('Edita cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis05_clientes');
        }
        
        function get_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis_juridico');
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis_juridico');
            $this->db->where('jur_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function add_doc($data_insert)
        {
            $this->db->insert('sis_juridico', $data_insert);
            return $this->db->insert_id();
        }
        
        function add_heredofamiliar($params)
        {
            $data = array_merge($params, log_insert('inserta heredo'));
            $this->db->insert('exp15_ant_heredo', $data);
            return $this->db->insert_id();
        }
        
        function get_heredofamiliar($clte_id)
        {
            $this->db->select('*');
            $this->db->from('exp15_ant_heredo');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('her_fecha','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_nopatologico($params)
        {
            $data = array_merge($params, log_insert('inserta nopat'));
            $this->db->insert('exp45_ant_nopat', $data);
            return $this->db->insert_id();
        }
        
        function get_nopatologico($clte_id)
        {
            $this->db->select('*');
            $this->db->from('exp45_ant_nopat');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('nopat_fecha','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_patologico($params)
        {
            $data = array_merge($params, log_insert('inserta pat'));
            $this->db->insert('exp20_pat', $data);
            return $this->db->insert_id();
        }
        
        function get_patologico($clte_id)
        {
            $this->db->select('*');
            $this->db->from('exp20_pat');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function delete_heredofamiliar($id)
        {
            $this->db->where('her_id', $id);
            return $this->db->delete('exp15_ant_heredo');
        }
        
        function delete_nopatologico($id)
        {
            $this->db->where('nopat_id', $id);
            return $this->db->delete('exp45_ant_nopat');
        }
        
        function delete_patologico($id)
        {
            $this->db->where('pat_id', $id);
            return $this->db->delete('exp20_pat');
        }
        
        function add_signosvitales($params)
        {
            $data = array_merge($params, log_insert('inserta signos'));
            $this->db->insert('exp85_sigvit', $data);
            return $this->db->insert_id();
        }
        
        function delete_signosvitales($id)
        {
            $this->db->where('sig_id', $id);
            return $this->db->delete('exp85_sigvit');
        }
        
        function get_signosvitales($clte_id)
        {
            $this->db->select('*');
            $this->db->from('exp85_sigvit');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_empresas()
        {
            $this->db->select('b.*');
            $this->db->from('sis05_clientes as a');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id','left');
            if(get_perfil_id() == 4)
            {
                $this->db->where('a.emp_id', get_emp_id());
            }
            $this->db->group_by('b.emp_id');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function busca($empresa = '',$nombre = '', $rfc = '')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            
         
            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $where = "(a.emp_id=70 or a.emp_id=72 or a.emp_id=74 or a.emp_id=78 or a.emp_id=79 or a.emp_id=68 or a.emp_id=66)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $where = "(a.emp_id=80 or a.emp_id=82 or a.emp_id=83)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('a.emp_id', get_emp_id());
            }

           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_cirugia($params)
        {
            $data = array_merge($params, log_insert('inserta cirugia'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('exp50_cirug');
            return $this->db->insert_id();
        }
        
        function get_cirugia($clte_id)
        {
            $select = "usr_id, clte_id, cir_id, cir_fecha, a.proc_cve_proc, cir_notas_crypt, proc_descrip";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('exp50_cirug as a');
            $this->db->join('cat_procedimiento as b','a.proc_cve_proc = b.proc_cve_proc');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('cir_fecha','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function delete_cirugia($id)
        {
            $this->db->where('cir_id', $id);
            return $this->db->delete('exp50_cirug');
        }
        
        function add_discapacidad($params)
        {
            $data = array_merge($params, log_insert('inserta discap'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('exp10_discap');
            return $this->db->insert_id();
        }
        
        function get_discapacidad($clte_id)
        {
            $select = "usr_id, clte_id, dis_id, a.discap_cve, dis_cif_nota_crypt, discap_descrip";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('exp10_discap as a');
            $this->db->join('cat_discapacidad as b','a.discap_cve = b.discap_cve');
            $this->db->where('clte_id', $clte_id);
            $this->db->where(array('dis_dif_tipo_cve' => NULL));
            $this->db->order_by('dis_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function delete_discapacidad($id)
        {
            $this->db->where('dis_id', $id);
            return $this->db->delete('exp10_discap');
        }
        
        function get_dificultad($clte_id)
        {
            $select = "usr_id, clte_id, dis_id, dis_cif_nota_crypt, dis_dif_tipo_cve, b.cat_nombre as tipo, dis_dif_grado_cve,c.cat_nombre as grado, dis_dif_orig_cve,d.cat_nombre as origen";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('exp10_discap as a');
            $this->db->join('cat_catalogos as b','a.dis_dif_tipo_cve = b.cat_cve');
            $this->db->join('cat_catalogos as c','a.dis_dif_grado_cve = c.cat_cve');
            $this->db->join('cat_catalogos as d','a.dis_dif_orig_cve = d.cat_cve');
            $this->db->where('clte_id', $clte_id);
            $this->db->where(array('discap_cve' => NULL));
            $this->db->where('b.cat_grupo', 'DIF_TIPO');
            $this->db->where('c.cat_grupo', 'DIF_GRADO');
            $this->db->where('d.cat_grupo', 'DIF_ORIG');
            $this->db->order_by('dis_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_alergia($params)
        {
            $data = array_merge($params, log_insert('inserta alergia'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('exp35_alerg');
            return $this->db->insert_id();
        }
        
        function delete_alergia($id)
        {
            $this->db->where('alerg_id', $id);
            return $this->db->delete('exp35_alerg');
        }
        
        function get_alergia($clte_id)
        {
            $select = "usr_id, clte_id, nmed_id, alerg_id, alerg_fecha_detecto, alerg_alergeno, alerg_reaccion, alerg_estado_actual, alerg_nota_crypt, alerg_medico_detecto_crypt";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('exp35_alerg');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('alerg_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function add_gineco($params)
        {
            $data = array_merge($params, log_insert('inserta gineco'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('exp25_ant_gineco');
            return $this->db->insert_id();
        }
        
        function update_gineco($id, $params)
        {
            $data = array_merge($params, log_insert('actualiza gineco'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('gin_id', $id);
            return $this->db->update('exp25_ant_gineco');
        }
        
        function get_gineco($clte_id)
        {
            $select = "usr_id, clte_id, gin_id, gin_ritmo_cve, gin_menst_cada, gin_menst_dura, gin_f_ult_menst, gin_ivsa, gin_mpf_cve, gin_docma_f, gin_docma_nota_crypt, gin_papanic_f, gin_papanic_nota_crypt, gin_colposc_f, gin_colposc_nota_crypt, gin_num_gestas, gin_num_abortos, gin_num_partos, gin_num_cesareas, gin_f_ult_aborto, gin_f_ult_parto, gin_notas_crypt";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('exp25_ant_gineco');
            $this->db->where('clte_id', $clte_id);
            $this->db->order_by('gin_id','DESC');
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function get_empresa_by_id($emp_id)
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
            $this->db->where('emp_id', $emp_id);
            $result = $this->db->get();
            return $result->row_array();
        }
}