<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Nom0_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

/**************************************************************/    
    function borra_compaq($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_hcsyngenta');
    }   

     function insert_hcsyngenta($data_insert)
    {
        $this->db->insert('fsm_hcsyngenta', $data_insert);
        return $this->db->insert_id();
    }

	function actualiza_hcsyngenta($fsm_id, $params)
	{
		$this->db->where('fsm_id',$fsm_id);
		return $this->db->update('fsm_hcsyngenta',$params);
	}

    function get_hcsyngenta($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_hcsyngenta');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }


     function insert_nom030($data_insert)
    {
        $this->db->insert('fsm_isoexmesaoc', $data_insert);
        return $this->db->insert_id();
    }

    
    function get_nom030($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_isoexmesaoc');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }


    function get_by_clte_hcsyngenta($cliente_id) 
    {
        $this->db->select('*');
        $this->db->from('fsm_hcsyngenta');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }	

    function get_by_clte_ISOEXMESAOC($cliente_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fsm_isoexmesaoc');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }


    function get_cuantos_ISOEXMESAOC($clte_id)
    {
        $this->db->select("count(clte_id) as regs");
        $this->db->from('fsm_isoexmesaoc');
        $this->db->where('clte_id', $clte_id);
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
    }

    function borra_ISOEXMESAOC($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_isoexmesaoc');
    }	

    

    function get_ISOEXMEDINEX($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_isoexmesaoc');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }
	
	
	function actualiza_nom30($fsm_id, $params)
	{
		$this->db->where('fsm_id',$fsm_id);
		return $this->db->update('fsm_isoexmesaoc',$params);
	}	
	
/**************************************************************/  

// function insert_ISOEXMEDINEX($data_insert)
// {
//     $this->db->insert('fsm_isoexmedinex', $data_insert);
//     return $this->db->insert_id();
// }

// function get_by_clte_ISOEXMEDINEX($cliente_id,$es_usr_de_un_despacho=0) 
// {
//     $this->db->select('*');
//     $this->db->from('fsm_isoexmedinex');
//     $this->db->where('clte_id', $cliente_id);
//     $this->db->order_by('fsm_f','DESC');
//     $result = $this->db->get();
//     return $result->result_array();
// }


// function get_cuantos_ISOEXMEDINEX($clte_id)
// {
//     $this->db->select("count(clte_id) as regs");
//     $this->db->from('fsm_isoexmedinex');
//     $this->db->where('clte_id', $clte_id);
//     $result = $this->db->get();
//     $row = $result->row_array();
//     return $row['regs'];
// }

// function borra_ISOEXMEDINEX($fsm_id)
// {
//     $this->db->where('fsm_id', $fsm_id);
//     return $this->db->delete('fsm_isoexmedinex');
// }	


// function get_ISOEXMEDINEX($fsm_id)
// {
//     $this->db->select('*');
//     $this->db->from('fsm_isoexmedinex');
//     $this->db->where('fsm_id', $fsm_id);
//     $result = $this->db->get();
//     return $result->row_array();
// }

// function update_ISOEXMEDINEX($fsm_id, $params)
// {
//     $this->db->where('fsm_id',$fsm_id);
//     return $this->db->update('fsm_isoexmedinex',$params);
// }	













}