<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Familiar_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get all familiares
     */
    function get_all_familiar()
    {
        return $this->db->get('socio_eco_familiar')->result_array();
    }
    
    /*
     * Get all familiares by fsm_id
     */
    function get_familiares($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_familiar');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * function to add new familiar
     */
    function inserta($params)
    {
        $this->db->insert('socio_eco_familiar',$params);
        return $this->db->insert_id();
    }
 






    /*
     * function to add new familiares
     */
    function inserta_familiares_e($familiares, $fsm_id)
    {
        $insert_id = null;
        
        if(!empty($familiares))
		{
            foreach($familiares as $familiar){
                if(
					trim($familiar['nombre']) != "" /*&& 
					trim($familiar['edad']) != "" && 
					trim($familiar['edo_civil']) != "" && 
					trim($familiar['escolaridad']) != "" && 
					trim($familiar['ocupacion']) != "" && 
					trim($familiar['vive_eval']) != "" && 
					trim($familiar['tiempo']) != "" && 
					trim($familiar['dependiente']) != ""*/
				)
				{
                    $familiar['fsm_id'] = $fsm_id;
                    $this->db->insert('entorno_soc_familiar',  array_to_upper($familiar));
                }
            }
            
            $insert_id = $this->db->insert_id();
        }
        
        return $insert_id;
    }
 
    function actualiza_familiares_e($familias, $fsm_id)
    {
        $insert_id = null;
        if(!empty($familias))
        {
            foreach($familias as $familia)
            {
                 if($familia['fam_id'] > 0)
                {
                    if(isset($familia['fam_id']))
                    {
                        $fam_id = $familia['fam_id'];
                        unset($familia['fam_id']);
                        $this->db->where('fam_id', $fam_id);
                        $this->db->update('entorno_soc_familiar',  array_to_upper($familia));
                    }
                    else
                    {
                        $familia['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('entorno_soc_familiar',  array_to_upper($familia));
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id; 
    }

    function delete_1($fsm_id, $id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('fam_id', $id);
        return $this->db->delete('entorno_soc_familiar');
    }








 
    /*
     * function to add new familiares
     */
    function inserta_familiares($familiares, $fsm_id)
    {
        $insert_id = null;
        
        if(!empty($familiares))
		{
            foreach($familiares as $familiar){
                if(
					trim($familiar['nombre']) != "" /*&& 
					trim($familiar['edad']) != "" && 
					trim($familiar['edo_civil']) != "" && 
					trim($familiar['escolaridad']) != "" && 
					trim($familiar['ocupacion']) != "" && 
					trim($familiar['vive_eval']) != "" && 
					trim($familiar['tiempo']) != "" && 
					trim($familiar['dependiente']) != ""*/
				)
				{
                    $familiar['fsm_id'] = $fsm_id;
                    $this->db->insert('socio_eco_familiar',  array_to_upper($familiar));
                }
            }
            
            $insert_id = $this->db->insert_id();
        }
        
        return $insert_id;
    }
 
    function actualiza_familiares($familias, $fsm_id)
    {
        $insert_id = null;
        if(!empty($familias))
        {
            foreach($familias as $familia)
            {
                 if($familia['fam_id'] > 0)
                {
                    if(isset($familia['fam_id']))
                    {
                        $fam_id = $familia['fam_id'];
                        unset($familia['fam_id']);
                        $this->db->where('fam_id', $fam_id);
                        $this->db->update('socio_eco_familiar',  array_to_upper($familia));
                    }
                    else
                    {
                        $familia['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('socio_eco_familiar',  array_to_upper($familia));
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id; 
    }



 
    function delete($fsm_id, $id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('fam_id', $id);
        return $this->db->delete('socio_eco_familiar');
    }
}
