<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Corporativos_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }


        function busca($empresa,$corp_nombre,$estatus)
        {            
			$this->db->select('*');            
            $this->db->from('sis15_corporativos');
            if($empresa != ''){ $this->db->where('emp_id',$empresa ); }
            if($corp_nombre != ''){ $this->db->like('corp_nombre',$corp_nombre); }
			if($estatus != ''){ $this->db->like('cat_estatus_cve',$estatus); }            
            
			
            $this->db->order_by('emp_razon_social ASC' );
            $result = $this->db->get();
            return $result->result_array();
        }




        function actualiza($fsm_id, $params)
        {
            //$data = array_merge($params, log_insert('Edita empleado'));
            $this->db->where('corp_id',$fsm_id);
            return $this->db->update('sis15_corporativos',$params);
        }

		function borra($fsm_id)
		{
			$this->db->where('corp_id', $fsm_id);
			return $this->db->delete('sis15_corporativos');
		}
			
        function get($id)
        {
            $this->db->select('*');
            $this->db->from('sis15_corporativos');
            $this->db->where('corp_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }


        function inserta($params)
        {
            $data = $params; //array_merge($params, log_insert('Nuevo empleado'));
            $this->db->insert('sis15_corporativos', $data);
            return $this->db->insert_id();
        }
		
		function count_all()
        {
            $this->db->select("count(corp_id) as regs");
            $this->db->from('sis15_corporativos');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


	    function get_allo($rows)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis15_corporativos');
			$this->db->order_by('emp_razon_social ASC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }	


		
}