<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Qrconfianza_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
	
    function get_by_clte($cliente_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_qrconfianza');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }  
	
	
		
    function insert($params)
    {
        $this->db->insert('fsm_qrconfianza', $params);
        return $this->db->insert_id();
    }
	
        function update($fsm_id, $params)
        {
            $data = array_merge($params, log_update('Genera QR'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('fsm_id',$fsm_id);
            return $this->db->update('fsm_qrconfianza');
        }	
	
	
 
    function get_qr($fsm_id,$emp_id,$clte_id,$serv_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_qrconfianza');
        $this->db->where('emp_id', $emp_id);
		$this->db->where('clte_id', $clte_id);
		$this->db->where('serv_id', $serv_id);
		$this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }
 
    function get($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_qrconfianza');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }
 
    function get_by_clte_servicio($cliente_id,$serv_id,$es_usr_de_un_despacho=0)
    {

		$this->db->select('*');
        $this->db->from('fsm_qrconfianza');
        $this->db->where('clte_id', $cliente_id);
		$this->db->where('serv_id', $serv_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
 
    function get_in($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_qrconfianza');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }


 

}