<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Rexipe_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
  

   function get_direccion_empresa($emp_id)
    {
        $this->db->select('cat_nombre');
        $this->db->from('cat_catalogos');
		$this->db->like('cat_grupo', 'DATA_RECIPE');
		$this->db->like('cat_grupo_nombre', 'DIRECCION_EMPRESA');
        $this->db->like('cat_cve', $emp_id);
		$result = $this->db->get();
		$row = $result->row_array();
		if ($row['cat_nombre'])
		{
			return $row['cat_nombre'];
		}	
	else
		{
			$emp_id=31;
			$this->db->select('cat_nombre');
			$this->db->from('cat_catalogos');
			$this->db->like('cat_grupo', 'DATA_RECIPE');
			$this->db->like('cat_grupo_nombre', 'DIRECCION_EMPRESA');
			$this->db->like('cat_cve', $emp_id);
			$result = $this->db->get();
			$row = $result->row_array();
			return $row['cat_nombre'];
		}	
    }

  function get_email_empresa($emp_id)
    {
        $this->db->select("cat_nombre");
        $this->db->from('cat_catalogos');
		$this->db->like('cat_grupo', 'DATA_RECIPE');
		$this->db->like('cat_grupo_nombre', 'EMAIL_EMPRESA');
        $this->db->like('cat_cve', $emp_id);
		$result = $this->db->get();
		$row = $result->row_array();
		
		if ($row['cat_nombre'])
		{
			return $row['cat_nombre'];
		}	
		else
		{
			$emp_id=31;
			$this->db->select("cat_nombre");
			$this->db->from('cat_catalogos');
			$this->db->like('cat_grupo', 'DATA_RECIPE');
			$this->db->like('cat_grupo_nombre', 'EMAIL_EMPRESA');
			$this->db->like('cat_cve', $emp_id);
			$result = $this->db->get();
			$row = $result->row_array();
			return $row['cat_nombre'];
		}	
    }
 
    function get_rfc_empresa($emp_id)
    {
        $this->db->select('cat_nombre');
        $this->db->from('cat_catalogos');
		$this->db->like('cat_grupo', 'DATA_RECIPE');
		$this->db->like('cat_grupo_nombre', 'RFC_EMPRESA');
        $this->db->like('cat_cve', $emp_id);
		$result = $this->db->get();
		$row = $result->row_array();
		
		if ($row['cat_nombre'])
		{
			return $row['cat_nombre'];
		}	
		else
		{
			$emp_id=31;
			$this->db->select('cat_nombre');
			$this->db->from('cat_catalogos');
			$this->db->like('cat_grupo', 'DATA_RECIPE');
			$this->db->like('cat_grupo_nombre', 'RFC_EMPRESA');
			$this->db->like('cat_cve', $emp_id);
			$result = $this->db->get();
			$row = $result->row_array();
			return $row['cat_nombre'];
		}	
    } 
	
	function get_logo_empresa($emp_id)
    {
        $this->db->select("cat_nombre");
        $this->db->from('cat_catalogos');
		$this->db->like('cat_grupo', 'DATA_RECIPE');
		$this->db->like('cat_grupo_nombre', 'LOGO_EMPRESA');
        $this->db->like('cat_cve', $emp_id);
		$result = $this->db->get();
		$row = $result->row_array();
		
		if ($row['cat_nombre'])
		{
			return $row['cat_nombre'];
		}	
		else
		{
			$emp_id=31;
			$this->db->select("cat_nombre");
			$this->db->from('cat_catalogos');
			$this->db->like('cat_grupo', 'DATA_RECIPE');
			$this->db->like('cat_grupo_nombre', 'LOGO_EMPRESA');
			$this->db->like('cat_cve', $emp_id);
			$result = $this->db->get();
			$row = $result->row_array();
			return $row['cat_nombre'];
		}	
    } 

    function insert_r($data_insert)
    {
        $this->db->insert('fsm_rexipe', $data_insert);
        return $this->db->insert_id();
    }
	
    function delete($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_rexipe');
    }

    function get_recetas_paciente($clte_id)
    {
        $this->db->select("count(clte_id) as regs");
        $this->db->from('fsm_rexipe');
        $this->db->where('clte_id', $clte_id);
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
    }


    function get_r($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_rexipe');
        $this->db->where('fsm_id', $fsm_id);

        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }		
        $result = $this->db->get();
        return $result->row_array();
    }

  function get_max_numerador($fsm_emp_atte)
    {
        $this->db->select_max('fsm_numerador','maximo');
        $this->db->from('fsm_rexipe');
        $this->db->where('fsm_emp_atte', $fsm_emp_atte);
        $result = $this->db->get();
        return $result->row_array();
    }

	
	
    function get_by_clte_r($cliente_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fsm_rexipe');
        $this->db->where('clte_id', $cliente_id);

        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

 
	
}