<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Socio_resultado_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    function insert($data_insert)
    {
        $this->db->insert('socio_resultado', $data_insert);
        return $this->db->insert_id();
    }
    
    function update($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('socio_resultado', $params);
    }
    
    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('socio_resultado');
        $this->db->where('clte_id', $cliente_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());   
        }
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }	*/		
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('socio_resultado');
        $this->db->where('fsm_id', $fsm_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }*/			
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_by_os($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('socio_resultado');
        $this->db->where('serv_id', $fsm_id);
        $this->db->order_by('log_insrt_f','DESC');

        $result = $this->db->get();
        return $result->row_array();
    }


    function insert_image($data_insert)
    {
        $this->db->insert('socio_eco_imagenes', $data_insert);
        return $this->db->insert_id();
    }

    function get_images($id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_imagenes');
        $this->db->where('fsm_id', $id);
        $result = $this->db->get();
        return $result->result_array();
    }

    function delete_image($fsm_id,$id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('img_id', $id);
        return $this->db->delete('socio_eco_imagenes');
    }
	
	
	function delete($id,$fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('clte_id', $id);
        return $this->db->delete('socio_resultado');
    }
	
}