<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Toxicologico_model7 extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
		
    }
 
    function get_by_clte_referencia($cliente_id,$referencia_id)
    {
		$referencia_id.=$cliente_id.'_';
		$evaluados_array = explode("_", $referencia_id);
        $this->db->select('*');
        $this->db->from('fsm_toxicologico7');
        $this->db->where_in('clte_id', $evaluados_array);
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
    function update($id, $params)
    {
		$this->db->where('fsm_id', $id);
        return $this->db->update('fsm_toxicologico7', $params);
    }
  
    function insert($data_insert)
    {
        $this->db->insert('fsm_toxicologico7', $data_insert);
        return $this->db->insert_id();
    }

    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_toxicologico7');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_toxicologico7');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
    function get_by_clte_servicio($cliente_id,$serv_id,$es_usr_de_un_despacho=0)
    {

		$this->db->select('*');
        $this->db->from('fsm_toxicologico7');
        $this->db->where('clte_id', $cliente_id);
		$this->db->where('serv_id', $serv_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }	
	
	
    function delete_toxicologico7($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_toxicologico7');
    }	
	
	
}