<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Credito_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get all credito
     */
    function get_all_creditos()
    {
        return $this->db->get('socio_eco_credito')->result_array();
    }
    
    /*
     * Get all credito by fsm_id
     */
    function get_creditos($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_credito');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * function to add new credito
     */
    function inserta($params)
    {
        $this->db->insert('socio_eco_credito',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to add new credito
     */
    function inserta_creditos($creditos, $fsm_id)
    {
        $insert_id = null;
        
        if(!empty($creditos)){
            foreach($creditos as $credito){
                if (
					 (trim($credito['quien']) != "") ||
					 (trim($credito['tipo']) != "")
				   )
				{
                    $credito['fsm_id'] = $fsm_id;
                    $this->db->insert('socio_eco_credito', array_to_upper($credito));
                }
            }
            
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
 


    function actualiza_creditos($creditos, $fsm_id)
    {
        $insert_id = null;
        if(!empty($creditos))
        {
            foreach($creditos as $credito)
            {
                    if(isset($credito['credito_id']))
                    {
                        $credito_id = $credito['credito_id'];
                        unset($credito['credito_id']);
                        $this->db->where('credito_id', $credito_id);
                        $this->db->update('socio_eco_credito',  array_to_upper($credito));
                    }
                    else
                    {
                        $credito['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('socio_eco_credito',  array_to_upper($credito));
                    }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }


 
    function delete($fsm_id, $id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('credito_id', $id);
        return $this->db->delete('socio_eco_credito');
    }
}
