<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Receta_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }

        /*
         * Get usuario by mail ok pcte_nss_crypt
         */

		function count_allo_gsi($suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$gsi)
        {
            $this->db->select("count(pcte_id) as regs");
            $this->db->from('sis77_pacientes');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
			/*$this->db->where_in('emp_id',$gsi);*/
            $this->db->join('sis15_empresas', 'sis77_pacientes.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
            $result = $this->db->get();			
            $row = $result->row_array();
            return $row['regs'];
        }		 
		 
		function get_allo_gsi($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_ocupa_cve, pcte_nac_cve, pcte_mex_resid_cve, pcte_f_nac, pcte_genero_cve, pcte_rfc_crypt, pcte_curp_crypt, pcte_email_crypt, pcte_tel_casa_crypt, pcte_tel_of_crypt, pcte_cel_crypt, pcte_env_calle_crypt, pcte_env_num_ext_crypt, pcte_env_num_int_crypt, pcte_env_colonia_crypt, pcte_env_localidad, pcte_env_municipio, pcte_env_edo_cve, pcte_env_pais_cve, pcte_env_cp, pcte_fis_calle_crypt, pcte_fis_num_ext_crypt, pcte_fis_num_int_crypt, pcte_fis_colonia_crypt, pcte_fis_localidad, pcte_fis_municipio, pcte_fis_edo_cve, pcte_fis_pais_cve, pcte_fis_cp,pcte_path_foto, sis77_pacientes.emp_id, pcte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,pcte_grado_acad_cve,pcte_puesto,emp_razon_social,pcte_lab_ubicacion,desp_id,suc_id, cei_id,pcte_nss_crypt, hc";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis77_pacientes');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            
			$this->db->join('sis15_empresas', 'sis77_pacientes.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
			/*$this->db->where_in('emp_id',$gsi);*/
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        } 	 
		 
		 
		function get_allo($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_f_nac, pcte_genero_cve,emp_id, log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,pcte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis77_pacientes');
            $this->db->where('status', 'activo');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        } 
 

 
 
 
        function get_all($rows) /*ok pcte_nss_crypt*/
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_ocupa_cve, pcte_nac_cve, pcte_mex_resid_cve, pcte_f_nac, pcte_genero_cve, pcte_rfc_crypt, pcte_curp_crypt, pcte_email_crypt, pcte_tel_casa_crypt, pcte_tel_of_crypt, pcte_cel_crypt, pcte_env_calle_crypt, pcte_env_num_ext_crypt, pcte_env_num_int_crypt, pcte_env_colonia_crypt, pcte_env_localidad, pcte_env_municipio, pcte_env_edo_cve, pcte_env_pais_cve, pcte_env_cp, pcte_fis_calle_crypt, pcte_fis_num_ext_crypt, pcte_fis_num_int_crypt, pcte_fis_colonia_crypt, pcte_fis_localidad, pcte_fis_municipio, pcte_fis_edo_cve, pcte_fis_pais_cve, pcte_fis_cp,pcte_path_foto, sis77_pacientes.emp_id, pcte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,pcte_grado_acad_cve,pcte_puesto,emp_razon_social,pcte_lab_ubicacion,desp_id,suc_id,cei_id,pcte_nss_crypt";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis77_pacientes');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis77_pacientes.emp_id=sis15_empresas.emp_id','left');

            if(get_perfil_id() == 4){
				/*$surcursal_id=get_sucursal_id();
				echo "$surcursal_id->".$surcursal_id."<--";
				if ($surcursal_id > 0)
				{	
				$this->db->where('suc_id', $surcursal_id); 	
				}
				echo " Punto A ";*/
                $empresas = get_empresas_array();
				//echo " Punto B ";
                $this->db->where_in('sis77_pacientes.emp_id', $empresas);
				//echo " Punto C ";
            }
 
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }
        
        function count_all()
        {
            $this->db->select("count(pcte_id) as regs");
            $this->db->from('sis77_pacientes');
            
            /*if(get_perfil_id() == 1 && get_user_id() == 138 )
            {
                $this->db->where('emp_id', '70');
                $this->db->or_where('emp_id', '72');
                $this->db->or_where('emp_id', '74');
                $this->db->or_where('emp_id', '78');
                $this->db->or_where('emp_id', '79');
                $this->db->or_where('emp_id', '68');
                $this->db->or_where('emp_id', '66');

            }
         
            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $this->db->where('emp_id', '70');
                $this->db->or_where('emp_id', '72');
                $this->db->or_where('emp_id', '74');
                $this->db->or_where('emp_id', '78');
                $this->db->or_where('emp_id', '79');
                $this->db->or_where('emp_id', '68');
                $this->db->or_where('emp_id', '66');
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('emp_id', get_emp_id());
            }*/
			

            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
            }

            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
        
		
		function count_allo($suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0)
        {
            $this->db->select("count(pcte_id) as regs");
            $this->db->from('sis77_pacientes');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
		
		
        function get($id,$es_usr_de_un_despacho=0)
        {
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_f_nac, pcte_genero_cve,emp_id, log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,pcte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis77_pacientes');
            $this->db->where('status', 'activo');
            $this->db->where('pcte_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }


        function get_roots($id)
        {
            $select = "root1,root2";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }


        function get_my_servicios($id)
        {
            $select = "servicios";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }

        
        function get_empresa_by_clte($pcte_id)
        {
            $select = "sis15_empresas.*";
            $this->db->select($select);
            $this->db->from('sis77_pacientes');
            $this->db->join('sis15_empresas', 'sis15_empresas.emp_id = sis77_pacientes.emp_id');
            $this->db->where('pcte_id', $pcte_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function inserta($params)
        {
            $data = array_merge($params, log_insert('Nuevo paciente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('sis77_pacientes');
            return $this->db->insert_id();
        }
		
        function actualiza($pcte_id, $params)
        {
            $data = array_merge($params, log_update('Edita paciente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('pcte_id',$pcte_id);
            return $this->db->update('sis77_pacientes');
        }
  
        function actualiza_registro($pcte_id, $params)
        {
            $data = array_merge($params, log_update_reg('Edita y registra nuevamente paciente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('pcte_id',$pcte_id);
            return $this->db->update('sis77_pacientes');
        }
  
  
  
        function get_coms($paciente_id)
        {
            $this->db->select('*');
            $this->db->from('sis06_pacientes_com');
            $this->db->where('pcte_id', $paciente_id);
            $this->db->order_by('com_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

  
        function get_docs($paciente_id)
        {
            $this->db->select('*');
            $this->db->from('sis10_pacientes_doc');
            $this->db->where('pcte_id', $paciente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis10_pacientes_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
		
        
        function add_doc($data_insert)
        {
            $this->db->insert('sis10_pacientes_doc', $data_insert);
            return $this->db->insert_id();
        }		
/***************************COMPORTAMIENTO*******************************************/
        function get_compo_docs($paciente_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_comportamiento_doc');
            $this->db->where('pcte_id', $paciente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
        function get_sgmty_docs($paciente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_sgmty_doc');
            $this->db->where('pcte_id', $paciente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }



        function get_covid_docs($paciente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_covid_doc');
            $this->db->where('pcte_id', $paciente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

 
        function get_compo_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_comportamiento_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
  
        function add_covid_doc($data_insert)
        {
            $this->db->insert('sis12_covid_doc', $data_insert);
            return $this->db->insert_id();
        }
		
  
        function add_compo_doc($data_insert)
        {
            $this->db->insert('sis13_comportamiento_doc', $data_insert);
            return $this->db->insert_id();
        }
		
		 function add_sgmty_doc($data_insert)
        {
            $this->db->insert('sis12_sgmty_doc', $data_insert);
            return $this->db->insert_id();
        }
/***************************HONESTIDAD*******************************************/
        function get_hon_docs($paciente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_honestidad_doc');
            $this->db->where('pcte_id', $paciente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_hon_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_honestidad_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function add_hon_doc($data_insert)
        {
            $this->db->insert('sis12_honestidad_doc', $data_insert);
            return $this->db->insert_id();
        }
		
		
        function borra_sgmty_doc($id)
        {
            $this->db->where('pcte_id', $id);
            return $this->db->delete('sis12_sgmty_doc`');
        }
		
        function borra_sgmty_venta($id,$tipo)
        {
            $this->db->where('pcte_id', $id);
			$this->db->like('doc_nombre', $tipo);
            return $this->db->delete('sis12_sgmty_doc`');
        }	

    function borra_evaluado($fsm_id)
    {
        $this->db->where('pcte_id', $fsm_id);
        return $this->db->delete('sis77_pacientes');
    }		


        
        function get_empresas()
        {
            $this->db->select('b.*');
            $this->db->from('sis77_pacientes as a');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id','left');
            
            /*if(get_perfil_id() == 4)
            {
                $this->db->where('a.emp_id', get_emp_id());
            }*/

            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            $this->db->group_by('b.emp_id');
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
	

	function trae_empresas()
    {
        $this->db->select('*');
        $this->db->from('sis15_empresas');
		
		if(get_perfil_id() == 4)
        {
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
        }
		else
		{
			$estatus='INACTIVO';
			 $this->db->not_like('emp_estatus_cve',$estatus);
		}		
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
    }

	
        function get_despachos()
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
			$n='1';
			$this->db->where('emp_desp', $n);
            $this->db->group_by('emp_id');
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }		
/**************************************************************************************/
        function buscate($nombre1 = '',$nombre2 = '',$paterno = '',$materno = '')
        {            
            //$select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_f_nac, pcte_rfc_crypt,log_insrt_f,suc_id, cei_id";
            $select = "log_insrt_f";
			$this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis77_pacientes');
            $this->db->where('status', 'activo');
            $this->db->like('AES_DECRYPT(pcte_nombre_crypt, "humancenter")',$nombre1);
			$this->db->like('AES_DECRYPT(pcte_2_nombre_crypt, "humancenter")',$nombre2);
			$this->db->like('AES_DECRYPT(pcte_paterno_crypt, "humancenter")',$paterno);
			$this->db->like('AES_DECRYPT(pcte_materno_crypt, "humancenter")',$materno);

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function buscate_rfc($rfc = '',$emp_id = '')
        {            
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_f_nac, pcte_rfc_crypt,log_insrt_f,suc_id, cei_id";
            //$select = "log_insrt_f";
			$this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis77_pacientes');
            $this->db->where('status', 'activo');
            $this->db->like('AES_DECRYPT(pcte_rfc_crypt, "humancenter")',$rfc);
			$this->db->like('emp_id',$emp_id);
            $result = $this->db->get();
            return $result->result_array();
        }		
		
/**************************************************************************************/        
        function busca($empresa = '',$nombre = '',$paterno='',$materno='', $rfc = '', $ubicacion = '',$despacho='',$emp_id_user='')
        {            
            //$this->db->select('*');
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_f_nac, pcte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis77_pacientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(pcte_nombre_crypt, "humancenter")," ",AES_DECRYPT(pcte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($paterno != ''){ $this->db->like('AES_DECRYPT(pcte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(pcte_materno_crypt, "humancenter")',$materno); } 
			if($rfc != ''){ $this->db->like('AES_DECRYPT(pcte_rfc_crypt, "humancenter")',$rfc); }
            if($ubicacion != ''){ $this->db->where('pcte_lab_ubicacion',$ubicacion); }
  			
			if(get_perfil_id() == 4)
			{
				//$despacho=get_desp_id_usr();
				//echo  '--DESPACHO>'.$user_despacho.'<--';
				//echo  '--EMPRESA>'.get_emp_id().'<--';				
				if ($despacho != 0)
				{					
					$this->db->where('desp_id',$despacho);					
				}	
				else
				{
                //$empresas = get_empresas_array();
                //$this->db->where_in('a.emp_id', $empresas);
				$this->db->where('a.emp_id',$emp_id_user);
						
				}
				$emp_id_user=get_emp_id();
				if ($emp_id_user == 31)
				{
				 $this->db->where('a.hc =',1); //SOLO DEJAR a la gente HC	
				}	
            } 
			else
			{
				//$this->db->where('a.hc',NULL); //quitar a la gente HC	
				
			}	         
         
            /*if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $where = "(a.emp_id=70 or a.emp_id=72 or a.emp_id=74 or a.emp_id=78 or a.emp_id=79 or a.emp_id=68 or a.emp_id=66)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $where = "(a.emp_id=80 or a.emp_id=82 or a.emp_id=83)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('a.emp_id', get_emp_id());
            }*/


			/*else
			{
				if ( $root2 == '1')
				{

				}
				else
				{
					$this->db->where('a.emp_id !=', '31');					
				}
			} */
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/        
/**************************************************************************************/        
        function buscandote($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_f_nac,pcte_genero_cve, pcte_rfc_crypt,pcte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,pcte_reclutador,pcte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis77_pacientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			//echo $fecha->format('Y-m-d') . "\n";
			
			//$f_fino=date_add($f_fin, date_interval_create_from_date_string('1 days'));
			//$this->db->where('log_insrt_f <=',date_format($f_fino,'Y-m-d' ));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(pcte_nombre_crypt, "humancenter")," ",AES_DECRYPT(pcte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(pcte_rfc_crypt, "humancenter")',$rfc); }
            			
			//if($ubicacion != ''){ $this->db->where('pcte_lab_ubicacion',$ubicacion); }
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/             
/**************************************************************************************/        
        function buscando_evaluados_gsi($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_f_nac,pcte_genero_cve, pcte_rfc_crypt,pcte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,pcte_reclutador,pcte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis77_pacientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            $this->db->where('b.emp_corp', 'GSI');
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));

			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(pcte_nombre_crypt, "humancenter")," ",AES_DECRYPT(pcte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(pcte_rfc_crypt, "humancenter")',$rfc); }
    			
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/             
        
/**************************************************************************************/        
        function buscandote_by_despacho($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$es_usr_de_un_despacho=0)
        {            
            //$this->db->select('*');
            $select = "pcte_id, pcte_nombre_crypt, pcte_2_nombre_crypt, pcte_paterno_crypt, pcte_materno_crypt, pcte_f_nac, pcte_rfc_crypt,pcte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,pcte_reclutador,pcte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis77_pacientes as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(pcte_nombre_crypt, "humancenter")," ",AES_DECRYPT(pcte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(pcte_rfc_crypt, "humancenter")',$rfc); }
            			
            /*
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
			}
			*/
			
			
			if(get_perfil_id() == 4)
			{
				if ($es_usr_de_un_despacho==0)
				{	
					$empresas = get_empresas_array();
					$this->db->where_in('a.emp_id', $empresas);
					$i=33;
					$this->db->where('desp_id !=',$i);
					
					
				}
				else
				{
					
					$this->db->where('a.desp_id', $es_usr_de_un_despacho);					
				}	
			}
			
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/ 

}