<?php 
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Catalogo_model extends CI_Model
{
        protected $database;
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
        }
 

        function get_pass_data($cat_grupo, $cat_grupo_nombre)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
			$this->db->where('cat_grupo_nombre',$cat_grupo_nombre);
            $this->db->where('cat_estatus_cve','ACTIVO');
			$res=$this->db->get()->row_array();
            return $res['cat_nombre']; 
        }


 
		function quincena_nomina($fsm_f)
		{
			$sql ="SELECT * FROM cat_quincenas where quin_f_fin > '".$fsm_f."'  and quin_f_ini <= '".$fsm_f."'"; 
			//echo $sql;
			$result = $this->db->query($sql,$fsm_f);
            return $result->row_array();;
		}  





        function get_pass_word()
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo','SHELDON');
            $this->db->where('cat_estatus_cve','ACTIVO');
            $res=$this->db->get()->row_array();
			return $res['cat_nombre'];
        }



        function get_x()
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->like('cat_grupo','EMPLEADOX');
            $this->db->where('cat_estatus_cve','ACTIVO');
            $res=$this->db->get()->row_array();
			return $res['cat_nombre'];
        }


        function get_version()
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
			$this->db->where('cat_id',1);
            $this->db->where('cat_grupo','VERSION');
            $this->db->where('cat_estatus_cve','ACTIVO');
            $res=$this->db->get()->row_array();
			return $res['cat_nombre'];
        }


        function get_catalogo($cat_grupo)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
            $this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->order_by('cat_nombre','ASC');
            return $this->db->get()->result_array();
        }

        function get_catalogo_secuencia($cat_grupo)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
            $this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->order_by('cat_seq','ASC');
            return $this->db->get()->result_array();
        }

        function get_catalogo_by_name($cat_grupo,$name)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
			$this->db->where('cat_nombre',$name);
            $this->db->where('cat_estatus_cve','ACTIVO');
			$res=$this->db->get()->row_array();
            return $res['cat_cve']; 
        }
		

        function get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
			$this->db->like('cat_grupo_nombre',$cat_grupo_nombre);
			$this->db->where('cat_cve',$cat_cve);
           $this->db->like('cat_estatus_cve','ACTIVO');
			$res=$this->db->get()->row_array();
            return $res['cat_nombre']; 
        }
		

        function get_cat_nombre_nom($cat_grupo,$cat_grupo_nombre,$cat_cve)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
			$this->db->like('cat_grupo_nombre',$cat_grupo_nombre);
			$this->db->like('cat_cve',$cat_cve);
            $this->db->like('cat_estatus_cve','ACTIVO');
			$res=$this->db->get()->row_array();
            return $res['cat_nombre']; 
        }


		
        function get_catalogo_by_clave($cat_grupo,$cve)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
			$this->db->where('cat_cve',$cve);
            $this->db->where('cat_estatus_cve','ACTIVO');
			$res=$this->db->get()->row_array();
            return $res['cat_nombre']; 
        }		

        function get_serv_monto_by_cve($servicio, $optSelected)
        {
            $this->db->select('*');
            $this->db->from('sis35_servicios_examenes');
            $this->db->where('serv_id',$servicio);
			$this->db->like('exam_cve',$optSelected);
			$res=$this->db->get()->row_array();
            return $res['exam_monto']; 
        }
		
	
		
        function get_serv_clte_doc_path($clte_id, $servicio)	
        {
            $this->db->select('*');
            $this->db->from('sis12_sgmty_doc');
            $this->db->where('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$res=$this->db->get()->row_array();
            return $res['doc_path']; 
        }		

        function get_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle)	
        {
            $this->db->select('*');
			$this->db->from($table);
			if ($table == 'sis10_clientes_gen_doc')
			{
				$this->db->like('doc_nombre',$detalle);
			}            
            $this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$res=$this->db->get()->row_array();
            return $res['doc_path']; 
        }


        function count_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle)	
        {
            $this->db->select("count(*) as regs");
            $this->db->from($table);
			if ($table == 'sis10_clientes_gen_doc')
			{
				$this->db->like('doc_nombre',$detalle);
			} 
			elseif ($table == 'sis12_generico_doc')
			{
				$this->db->like('doc_clave',$detalle);	
			}
            $this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$res=$this->db->get()->row_array();
            return $res['regs']; 
        }
		
		
        function count_examen_form($clte_id, $servicio,$table)
        {
			$this->db->select("count(fsm_id) as regs");
			$this->db->from($table);
			$this->db->where('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$row =$this->db->get()->row_array();
			return $row['regs'];			
        }		

        function get_fsm_id_examen_form($clte_id,$servicio,$table)
        {
			if ($table != '')
			{	
			$this->db->select("fsm_id");
			$this->db->from($table);
			$this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$row =$this->db->get()->row_array();
			return $row['fsm_id'];
			}
			else
			{ return 0;}	
        }


        function all_fsm_id_examen_form($clte_id,$servicio,$table)
        {
			if ($table != '')
			{	
			$this->db->select("*");
			$this->db->from($table);
			$this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$rows=$this->db->get()->result_array();
			return $rows;
			}
			else
			{ return 0;}	
        }
		
        function count_fsm_id_examen_form($clte_id,$servicio,$table)
        {
			if ($table != '')
			{	
			$this->db->select("count(*) as regs");
			$this->db->from($table);
			$this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$row =$this->db->get()->row_array();
			return $row['regs'];
			}
			else
			{ return 0;}	
        }		
		


        function count_fsm_id_examen_form_poli($clte_id,$servicio,$table,$det)
        {
			$this->db->select("count(*) as regs");
			$this->db->from($table);
			$this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$this->db->where('polig_tipo_cve',$det);			 	 
			$row =$this->db->get()->row_array();
			return $row['regs'];			
        }		
		
        function all_fsm_id_examen_form_poli($clte_id,$servicio,$table,$det)
        {
			$this->db->select("fsm_id");
			$this->db->from($table);
			$this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$this->db->where('polig_tipo_cve',$det);			 	 
			$rows=$this->db->get()->result_array();
			return $rows;			
        }

        function all_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle)	
        {
            $this->db->select('*');
            $this->db->from($table);
			if  ($table == 'sis10_clientes_gen_doc') 
			{
				$this->db->like('doc_nombre',$detalle);
			}
			if ($table == 'sis12_generico_doc')
			{
				$this->db->like('doc_clave',$detalle);	
			}
            $this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$rows=$this->db->get()->result_array();
            return $rows; 
        }


        function get_fsm_id_examen_form_poli($clte_id,$servicio,$table,$det)
        {
			$this->db->select("fsm_id");
			$this->db->from($table);
			$this->db->where_in('serv_id',$servicio);
			$this->db->where('clte_id',$clte_id);
			$this->db->where('polig_tipo_cve',$det);			 	 
			$row =$this->db->get()->row_array();
			return $row['fsm_id'];			
        }


		function get_tipo_foto_socio($fsm_id, $tipo_foto)
        {
			$this->db->select('*');
            $this->db->from('socio_eco_imagenes');
            $this->db->where('fsm_id',$fsm_id);			
			$this->db->like('nombre',$tipo_foto);
            $this->db->limit(1);
			$nombre=$this->db->get()->row_array();
            return $nombre['nombre'];        
        }

		
		
        function get_catalogo_orden_cve($cat_grupo)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
            $this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->order_by('cat_cve','ASC');
            return $this->db->get()->result_array();
        }	



        function get_catalogo_grupo_by_name_grupo($cat_grupo,$cat_grupo_nombre)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
			$this->db->where('cat_grupo_nombre',$cat_grupo_nombre);
            $this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->order_by('cat_cve','ASC');
            return $this->db->get()->result_array();
        }


        function chk_autoridad_total($id,$cat_grupo)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
			$this->db->where('cat_cve',$id);
            $this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->order_by('cat_cve','ASC');
            return $this->db->get()->result_array();
        }
		
		
        function get_catalogo_cat($cat_grupo)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
            $this->db->where('cat_estatus_cve','ACTIVO');
			$this->db->order_by('cat_grupo_nombre','ASC');
            $this->db->order_by('cat_nombre','ASC');
            return $this->db->get()->result_array();
        }		
		
		function get_grupo_nombre($cat_grupo)
        {
			
            $sql = "SELECT DISTINCT (`cat_grupo_nombre`) FROM `cat_catalogos` WHERE `cat_grupo` like '".$cat_grupo."' order by cat_grupo_nombre DESC" ; 

            return $this->db->query($sql)->result_array();        
        }

		function get_grupo_clave($cat_grupo, $cat_grupo_nombre)
        {
			
            $sql = "SELECT * FROM `cat_catalogos` WHERE `cat_grupo` like '".$cat_grupo."' and `cat_grupo_nombre` like '".$cat_grupo_nombre."' ORDER BY `cat_nombre` ASC " ; 
            return $this->db->query($sql)->result_array();        
        }		
		

		function get_cat_grupo_nombre_clave($cat_clave,$cat_grupo)
        {
			$this->db->select('cat_grupo_nombre');
            $this->db->from('cat_catalogos');
            $this->db->like('cat_grupo',$cat_grupo);
			$this->db->like('cat_cve',$cat_clave);
			$this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->limit(1);
			$nombre=$this->db->get()->row_array();
            return $nombre['cat_grupo_nombre'];        
        }


		function get_cat_nombre_id($cat_clave,$cat_grupo)
        {
/*			$this->db->select('cat_nombre');
            $this->db->from('cat_catalogos');
            $this->db->like('cat_grupo',$cat_grupo);
			$this->db->like('cat_cve',$cat_clave);
			$this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->limit(1);
			$nombre=$this->db->get()->row_array();
            return $nombre['cat_nombre'];   */
			
            $sql = "SELECT * FROM cat_catalogos "
                    . "WHERE cat_grupo LIKE '". $cat_grupo ."' "
                    . "AND cat_cve LIKE '".$cat_clave ."';"; 

             $nombre=$this->db->query($sql)->row_array();
			return $nombre['cat_nombre'];
			
        }


		function get_grupo_grupo_nombre($cat_grupo, $cat_grupo_nombre)
        {
			$this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->like('cat_grupo',$cat_grupo);
			$this->db->like('cat_grupo_nombre',$cat_grupo_nombre);
			$this->db->where('cat_estatus_cve','ACTIVO');
 		    $this->db->order_by('cat_seq','DESC');
            return $this->db->get()->result_array();       
        }


		function get_grupo_grupo_nombre_seq($cat_seq,$cat_grupo, $cat_grupo_nombre)
        {
			$this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->like('cat_grupo',$cat_grupo);
			$this->db->like('cat_grupo_nombre',$cat_grupo_nombre);
			$this->db->like('cat_seq',$cat_seq);
			$this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->limit(1);
			$nombre=$this->db->get()->row_array();
            return $nombre;        
        }




		function get_grupo_nombre_clave($cat_clave,$cat_grupo, $cat_grupo_nombre)
        {
			$this->db->select('cat_nombre');
            $this->db->from('cat_catalogos');
            $this->db->like('cat_grupo',$cat_grupo);
			$this->db->like('cat_grupo_nombre',$cat_grupo_nombre);
			$this->db->like('cat_cve',$cat_clave);
			$this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->limit(1);
			$nombre=$this->db->get()->row_array();
            return $nombre['cat_nombre'];        
        }

		function get_grupo_nombre_clave_sin_grupo_nombre($cat_clave,$cat_grupo)
        {
			$this->db->select('cat_nombre');
            $this->db->from('cat_catalogos');
            $this->db->like('cat_grupo',$cat_grupo);
			$this->db->like('cat_cve',$cat_clave);
			$this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->limit(1);
			$nombre=$this->db->get()->row_array();
            return $nombre['cat_nombre'];   
        }


		function get_nombre_de_examen_por_empresa($paquete,$emp_id)
        {
			$this->db->select('*');
            $this->db->from('sis16_empresas_costos');
            $this->db->like('emp_id',$emp_id);
			$this->db->like('cost_nombre_pkt',$paquete);
            $this->db->limit(1);
			$nombre=$this->db->get()->row_array();
            return $nombre['cost_examen_cve'];   
        }

		

		function get_catalogo_inverso($cat_grupo)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
            $this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->order_by('cat_seq','DESC');
            return $this->db->get()->result_array();
        }		
		
		function get_catalogo_secuencial($cat_grupo)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_grupo',$cat_grupo);
            $this->db->where('cat_estatus_cve','ACTIVO');
            $this->db->order_by('cat_seq','ASC');
            return $this->db->get()->result_array();
        }
		
		function get_cat_ceis()
        {
            $this->db->select('*');
            $this->db->from('sis80_ceis');
            $this->db->order_by('cei_alias','ASC');
            return $this->db->get()->result_array();
        }		

		function get_cat_seguros()
        {
            $this->db->select('*');
            $this->db->from('sis80_seguros');
            $this->db->order_by('seguros_alias','ASC');
            return $this->db->get()->result_array();
        }
		

		function get_cat_los_despachos()
        {	$esp_id='1';
            $this->db->select('*');
            $this->db->from('sis15_empresas');
			$this->db->where('emp_desp',$esp_id);
            $this->db->order_by('emp_razon_social','ASC');
            return $this->db->get()->result_array();
        }
		
		
        
        function get_cat_esp_med()
        {
            return $this->db->get('cat_med_esp')->result_array();
        }
        
        function get_cat_esp_med_by_id($esp_id)
        {
            $this->db->select('esp_especialidad');
            $this->db->from('cat_med_esp');
            $this->db->where('esp_id',$esp_id);
            return $this->db->get()->row_array();
        }
        
        function get_cies()
        {
            $this->db->select('*');
            $this->db->from('cat_cie');
            $this->db->where('nivel', 1);
            $this->db->order_by('cie_clave ASC , cie_nombre ASC');
            return $this->db->get()->result_array();
        }
        
        function get_cies_by_caitulo($cap_id)
        {
            $this->db->select('*');
            $this->db->from('cat_cie');
            $this->db->where('nivel', 1);
            $this->db->like('cie_capitulo', $cap_id,'after');
            $this->db->order_by('cie_clave ASC , cie_nombre ASC');
            return $this->db->get()->result_array();
        }
        
        function busca_cie_L1($cie_nombre)
        {
            $sql = "SELECT * FROM cat_cie "
                    . "WHERE cie_clave LIKE '%$cie_nombre%' "
                    . "OR cie_nombre LIKE '%$cie_nombre%' ORDER BY cie_clave ASC, cie_nombre ASC;"; 
            /*$this->db->select('*');
            $this->db->from('cat_cie');
            $this->db->like('concat(cie_clave,cie_nombre)', $cie_nombre);
            $this->db->where('length(cie_clave)', 3);
            $this->db->order_by('cie_nombre','ASC');*
            */
            return $this->db->query($sql)->result_array();
        }
        
        function busca_cie_L2($cie_clave)
        {
            $this->db->select('*');
            $this->db->from('cat_cie');
            $this->db->like('cie_clave', $cie_clave);
            $this->db->where('cie_clave !=', $cie_clave);
            $this->db->where('nivel', 2);
            $this->db->order_by('cie_nombre','ASC');
            return $this->db->get()->result_array();
        }
        
        function get_cie($cie_id = '')
        {
            if($cie_id != '')
            {
				
                return $this->db->get_where('cat_cie',array('cie_id' => $cie_id))->row_array();
            }
            else
            {
                return FALSE;
            }
        }
        
        function get_cie_by_clave($clave = '')
        {
            if($clave != '')
            {
                return $this->db->get_where('cat_cie',array('cie_clave' => $clave))->row_array();
            }
            else
            {
                return FALSE;
            }
        }
        
        function busca_proc($term)
        {
            $this->db->select('*');
            $this->db->from('cat_procedimiento');
            $this->db->where('proc_nivel', '1');
            $this->db->like('proc_descrip', $term);
            $this->db->or_like('proc_cve_proc', $term);
            $this->db->order_by('proc_descrip','ASC');
            return $this->db->get()->result_array();
        }
        
        function busca_discap($discap_nombre)
        {
            $sql = "SELECT * FROM cat_discapacidad "
                    . "WHERE discap_cve LIKE '%$discap_nombre%' "
                    . "OR discap_descrip LIKE '%$discap_nombre%' ORDER BY discap_cve ASC, discap_descrip ASC;"; 
            return $this->db->query($sql)->result_array();
        }
        
        function get_religion()
        {
            $this->db->select('*');
            $this->db->from('cat_religion');
            $this->db->order_by('relig_descrip','ASC');
            return $this->db->get()->result_array();
        }
  

        function get_religiones()
        {
            $this->db->select('*');
            $this->db->from('cat_religiones');
            $this->db->order_by('relig_descrip','ASC');
            return $this->db->get()->result_array();
        }

  
        function get_estado($edo_cve)
        {
            $this->db->select('*');
            $this->db->from('cat_dir_cp');
            $this->db->where('edo_cve',$edo_cve);
            $this->db->limit(1);
            return $this->db->get()->row_array();
        }
}