<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Guia_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }

        /*
         * Get usuario by mail
         */
        function get_all($rows)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis05_clientes.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            $this->db->join('sis15_empresas', 'sis05_clientes.emp_id=sis15_empresas.emp_id','left');
            if(get_perfil_id() == 1 && get_user_id() == 138 )
            {
                $this->db->where('sis15_empresas.emp_id', '70');
                $this->db->or_where('sis15_empresas.emp_id', '72');
                $this->db->or_where('sis15_empresas.emp_id', '74');
                $this->db->or_where('sis15_empresas.emp_id', '78');
                $this->db->or_where('sis15_empresas.emp_id', '79');
                $this->db->or_where('sis15_empresas.emp_id', '68');
                $this->db->or_where('sis15_empresas.emp_id', '66');

            }
            if(get_perfil_id() == 5)
            {
                $this->db->where('sis15_empresas.emp_id', '65');
                $this->db->or_where('sis15_empresas.emp_id', '72');
                $this->db->or_where('sis15_empresas.emp_id', '71');


            }


            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $this->db->where('sis15_empresas.emp_id', '70');
                $this->db->or_where('sis15_empresas.emp_id', '72');
                $this->db->or_where('sis15_empresas.emp_id', '74');
                $this->db->or_where('sis15_empresas.emp_id', '78');
                $this->db->or_where('sis15_empresas.emp_id', '79');
                $this->db->or_where('sis15_empresas.emp_id', '68');
                $this->db->or_where('sis15_empresas.emp_id', '66');
            } 
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $this->db->where('sis15_empresas.emp_id', '80');
                $this->db->or_where('sis15_empresas.emp_id', '82');
                $this->db->or_where('sis15_empresas.emp_id', '83');
               
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('sis05_clientes.emp_id', get_emp_id());
            }
            //es para cesareo pero creo que se puede hacer como arriba con el perfil cuatro 
  	        
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function count_all()
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis05_clientes');
            if(get_perfil_id() == 1 && get_user_id() == 138 )
            {
                $this->db->where('emp_id', '70');
                $this->db->or_where('emp_id', '72');
                $this->db->or_where('emp_id', '74');
                $this->db->or_where('emp_id', '78');
                $this->db->or_where('emp_id', '79');
                $this->db->or_where('emp_id', '68');
                $this->db->or_where('emp_id', '66');

            }
         
            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $this->db->where('emp_id', '70');
                $this->db->or_where('emp_id', '72');
                $this->db->or_where('emp_id', '74');
                $this->db->or_where('emp_id', '78');
                $this->db->or_where('emp_id', '79');
                $this->db->or_where('emp_id', '68');
                $this->db->or_where('emp_id', '66');
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('emp_id', get_emp_id());
            }
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
        
        function get($id)
        {
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto,emp_id, log_insrt_f,clte_edo_civ_cve, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis05_clientes');
            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $where = "(emp_id=70 or emp_id=72 or emp_id=74 or emp_id=78 or emp_id=79 or emp_id=68 or emp_id=66)";
                $this->db->where($where);
                
            }
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $where = "(emp_id=80 or emp_id=82 or emp_id=83)";
                $this->db->where($where);
                
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('emp_id', get_emp_id());
            }
            $this->db->where('clte_id', $id);

                             
            $result = $this->db->get();
            return $result->row_array();     
        
           
        }
        
        function get_empresa_by_clte($clte_id)
        {
            $select = "sis15_empresas.*";
            $this->db->select($select);
            $this->db->from('sis05_clientes');
            $this->db->join('sis15_empresas', 'sis15_empresas.emp_id = sis05_clientes.emp_id');
            $this->db->where('clte_id', $clte_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function inserta($params)
        {
            $data = array_merge($params, log_insert('Nuevo cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('sis05_clientes');
            return $this->db->insert_id();
        }
        function actualiza($clte_id, $params)
        {
            $data = array_merge($params, log_update('Edita cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('clte_id',$clte_id);
            return $this->db->update('sis05_clientes');
        }
        
        function get_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis_iso');
            $this->db->where('clte_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_docs_section($cliente_id,$section)
        {
            $this->db->select('*');
            $this->db->from('sis_iso');
            $this->db->where('clte_id', $cliente_id);
			$this->db->where('empresa', $section);
			$this->db->order_by('doc_nombre','ASC');
            $this->db->order_by('doc_f','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }		
        
        function get_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis_iso');
            $this->db->where('iso_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }

		function borra_doc($doc_name,$empresa)
		{
            return $this->db->delete('sis_iso');
		}
		
		function delete_iso($fsm_id)
		{
			$this->db->where('iso_id', $fsm_id);
			return $this->db->delete('sis_iso');
		}

		function inserta_borrado($data_insert)
		{
			$this->db->insert('sis_borrado_docs', $data_insert);
			return $this->db->insert_id();
		}
		
        function add_doc($data_insert)
        {
			$this->db->insert('sis_iso', $data_insert);
            return $this->db->insert_id();
        }
        
        
        function get_empresas()
        {
            $this->db->select('b.*');
            $this->db->from('sis05_clientes as a');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id','left');
            if(get_perfil_id() == 4)
            {
                $this->db->where('a.emp_id', get_emp_id());
            }
            $this->db->group_by('b.emp_id');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function busca($empresa = '',$nombre = '', $rfc = '')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis05_clientes as a');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            
         
            if(get_perfil_id() == 4 && (get_user_id() == 139 || get_user_id()==140 ))
            {
                $where = "(a.emp_id=70 or a.emp_id=72 or a.emp_id=74 or a.emp_id=78 or a.emp_id=79 or a.emp_id=68 or a.emp_id=66)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4 && (get_user_id() == 142 || get_user_id()==143 ))
            {
                $where = "(a.emp_id=80 or a.emp_id=82 or a.emp_id=83)";
                $this->db->where($where);
            }
            elseif(get_perfil_id() == 4){
                $this->db->where('a.emp_id', get_emp_id());
            }

           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
       
        function get_empresa_by_id($emp_id)
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
            $this->db->where('emp_id', $emp_id);
            $result = $this->db->get();
            return $result->row_array();
        }
}