<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Programmer_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }

        function busca($temas='',$actividades='',$empresa=0,$frecuencia='')
        {           
            $this->db->select('*');
            $this->db->from('sis90_programmer');			
			
			if($temas != ''){ $this->db->like('prog_tema',$temas);}
			if($actividades != ''){$this->db->like('prog_actividad',$actividades);}
			if($empresa > 0){$this->db->where('emp_id',$empresa);}
            if($frecuencia != ''){$this->db->like('prog_frecuencia',$frecuencia);}

            $this->db->order_by('prog_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function actualiza($clte_id, $params)
        {
           // $data = array_merge($params, log_update('Edita cliente'));
           // parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('prog_id',$clte_id);
            return $this->db->update('sis90_programmer', $params);
        }

		function count_allo()
        {
            $this->db->select("count(prog_id) as regs");
            $this->db->from('sis90_programmer');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

		function get_allo($rows)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "*";
            $this->db->select($select);
            $this->db->from('sis90_programmer');
			$this->db->order_by('prog_id','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        } 

 		function get_allo_servicios_by_emp_area($emp_id,$area)
        {
            $select = "*";
            $this->db->select($select);
            $this->db->from('sis90_programmer');
			if (!($area == ''))
			{	
				$this->db->where('cats_grupo_nombre',$area);
			}
			$this->db->order_by('cats_grupo_nombre','ASC');
            $this->db->order_by('cats_nombre_servicio','ASC');			
			$this->db->order_by('cats_categoria','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }





    function borra_evaluado($fsm_id)
    {
        $this->db->where('prog_id', $fsm_id);
        return $this->db->delete('sis90_programmer');
    }	

	function get($id)
	{   
		$select = "*";
		$this->db->select($select);
		$this->db->from('sis90_programmer');
		$this->db->where('prog_id', $id); 
		$result = $this->db->get();
		
		return $result->row_array();
	   
	}
	
	function get_docs($cliente_id)
	{
		$this->db->select('*');
		$this->db->from('sis90_programmer_doc');
		$this->db->where('prog_id', $cliente_id);
		$this->db->order_by('doc_f','DESC');
		$result = $this->db->get();
		return $result->result_array();
	}	
	
	function get_coms($cliente_id)
	{
		$this->db->select('*');
		$this->db->from('sis90_programmer_com');
		$this->db->where('prog_id', $cliente_id);
		$this->db->order_by('com_id','DESC');
		$result = $this->db->get();
		return $result->result_array();
	}	
/**********************************************************************************/

		function get_caliza_clientes($emp_id)
        {
			if ($emp_id != '')
			{	
				$this->db->select('*');
				$this->db->from('sis15_empresas_c');
				$this->db->where('emp_id',$emp_id);
				$result = $this->db->get();
				$row = $result->row_array();
				return $row['emp_razon_social'];
			}
			else
			{ return ''; }	
            
        } 


		function get_all_caliza_clientes()
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas_c');
            $this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        } 

/************************************************************/
		function borrar_comentario($fsm_id)
		{
			$this->db->where('com_id', $fsm_id);
			return $this->db->delete('sis90_programmer_com');
		}

		function count_allo_corporacion($suc,$campo_corpo,$corpo)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_programmer');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis90_programmer.paciente', 0);
			$this->db->where($campo_corpo, $corpo);
            $result = $this->db->get();			
            $row = $result->row_array();
            return $row['regs'];
        }


		function count_allo_gsi($suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$gsi)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_programmer');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
			/*$this->db->where_in('emp_id',$gsi);*/
            $this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
            $result = $this->db->get();			
            $row = $result->row_array();
            return $row['regs'];
        }		 
		 
		function get_allo_gsi($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            
			$this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
			$this->db->where('sis90_programmer.paciente', 0);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();

            return $result->result_array();

        } 	 


		function get_allo_gsi_reclutadora($rows,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');
			if ($suc)
			{
				
				$this->db->where('desp_id', $suc);
			}	
            $this->db->where('status', 'activo');
            
			$this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis15_empresas.emp_corp', 'GSI');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();

            return $result->result_array();

        }

		function get_allo_emp_asig($rows,$empresas)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');
            $this->db->where('status', 'activo'); 
			$this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
			$this->db->where('sis90_programmer.emp_id', $empresas);
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();

        }

		 
	
		function get_allo_p($rows,$usr_emp_asig,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');
			if ($paciente==1)
			{
				$this->db->where('sis90_programmer.paciente',1);
				
				//$this->db->where('sis90_programmer.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis90_programmer.paciente !=',1); //SOLO DEJAR EVALUADOS
			}	
            if ($usr_emp_asig)
			{
				
				$this->db->where('med_emp_asig', $usr_emp_asig);
			}			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        } 

		function get_allo_e($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado, empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis90_programmer.hc',1);}
				else
				{$this->db->where('sis90_programmer.empleado',1);	}							
				$this->db->where('sis90_programmer.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis90_programmer.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }


		function get_allo_empleados($emp_id,$empleado=0)
        {

            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,clte_lab_ubicacion,desp_id,suc_id,emp_id, cei_id,clte_nss_crypt, hc, num_empleado, empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');
			
			$this->db->where('sis90_programmer.emp_id',$emp_id);
			
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis90_programmer.hc',1);}
				else
				{$this->db->where('sis90_programmer.empleado',1);	}							
				
			}
			else
			{
				$this->db->where('sis90_programmer.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
            $this->db->where('status', 'activo');
            $this->db->order_by('log_insrt_f','DESC');

            $result = $this->db->get();

            return $result->result_array();

        }



		function get_allo_m($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado, empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis90_programmer.hc',1);}
				else
				{$this->db->where('sis90_programmer.empleado',1);	}							
				$this->db->where('sis90_programmer.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis90_programmer.empleado !=',1); //SOLO DEJAR EVALUADOS
			}	
			
			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
			$names = array(28163,
19581,
27842,
21598,
28198,
26062,
22647,
26904,
29070,
14174,
27887,
28166,
25410,
19297,
7367,
4728,
28230,
21787,
25406,
28638,
22813,
16887,
17862,
25980,19472,30746,30743,30744,30745,27765,
27802,27187
) ;
			$this->db->where_in('sis90_programmer.clte_id', $names);
            $this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }
	
		function get_allo_a($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado, empleado";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');

				if ($emp_id==31)
				{$this->db->where('sis90_programmer.hc != ',1);}
				else
				{$this->db->where('sis90_programmer.empleado',1);	}							
				$this->db->where('sis90_programmer.emp_id',$emp_id);

			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }	

		function get_allo_b($rows,$emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id, cei_id,clte_nss_crypt, hc, num_empleado, empleado, status";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');

				if ($emp_id==31)
				{$this->db->where('sis90_programmer.hc',1);}
				else
				{$this->db->where('sis90_programmer.empleado',1);	}
			
				$this->db->where('sis90_programmer.emp_id',$emp_id);
				$this->db->like('sis90_programmer.status','NOACTIVO');

			if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}	
           
            $this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');
            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }		





	

		
		function get_all_emp($emp_id)
        {
            $select = "*";
            $this->db->select($select);
            $this->db->from('sis90_programmer');
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		
		
		function get_all_by_emp($emp_id)
        {
            $select = "*";
            $this->db->select($select);
            $this->db->from('sis90_programmer');
			$this->db->where('emp_id', $emp_id); 
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		
 
 
 
	
 
 
        function get_all($rows) /*ok clte_nss_crypt*/
        {
            $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_ocupa_cve, clte_nac_cve, clte_mex_resid_cve, clte_f_nac, clte_genero_cve, clte_rfc_crypt, clte_curp_crypt, clte_email_crypt, clte_tel_casa_crypt, clte_tel_of_crypt, clte_cel_crypt, clte_env_calle_crypt, clte_env_num_ext_crypt, clte_env_num_int_crypt, clte_env_colonia_crypt, clte_env_localidad, clte_env_municipio, clte_env_edo_cve, clte_env_pais_cve, clte_env_cp, clte_fis_calle_crypt, clte_fis_num_ext_crypt, clte_fis_num_int_crypt, clte_fis_colonia_crypt, clte_fis_localidad, clte_fis_municipio, clte_fis_edo_cve, clte_fis_pais_cve, clte_fis_cp,clte_path_foto, sis90_programmer.emp_id, clte_edo_civ_cve,log_insrt_f, log_insrt_usr_cve, log_insrt_prg, log_updt_f, log_updt_usr_cve, log_updt_prg,clte_grado_acad_cve,clte_puesto,emp_razon_social,clte_lab_ubicacion,desp_id,suc_id,cei_id,clte_nss_crypt";
            $this->db->select(parsea_select($select, 'humancenter'));
            $this->db->from('sis90_programmer');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas', 'sis90_programmer.emp_id=sis15_empresas.emp_id','left');

            if(get_perfil_id() == 4){
				/*$surcursal_id=get_sucursal_id();
				echo "$surcursal_id->".$surcursal_id."<--";
				if ($surcursal_id > 0)
				{	
				$this->db->where('suc_id', $surcursal_id); 	
				}
				echo " Punto A ";*/
                $empresas = get_empresas_array();
				//echo " Punto B ";
                $this->db->where_in('sis90_programmer.emp_id', $empresas);
				//echo " Punto C ";
            }
            

            $this->db->order_by('log_insrt_f','DESC');
            $this->db->limit($rows, $page);
            $result = $this->db->get();
			//echo " Punto D ";
            return $result->result_array();

        }
        
        function count_all()
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_programmer');
            

            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
            }

            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
        
		









		function count_allo_emp_asig($empresas)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_programmer');
			$this->db->where('sis90_programmer.paciente !=',1); //SOLO DEJAR EVALUADOS
			$this->db->where('sis90_programmer.empleado !=',1);
			$this->db->where_in('emp_id', $empresas);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }



		function count_allo_p($suc,$usr_emp_asig,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$paciente=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_programmer');
			
			if ($paciente==1)
			{
				$this->db->where('sis90_programmer.paciente',1);
			}
			else
			{
				$this->db->where('sis90_programmer.paciente !=',1); //SOLO DEJAR EVALUADOS				
			}

            if ($usr_emp_asig)
			{
				
				$this->db->where('med_emp_asig', $usr_emp_asig);
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }		
		
		function count_allo_e($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_programmer');
			$this->db->where('sis90_programmer.emp_id',$emp_id);
			if ($empleado==1)
			{
				if ($emp_id==31)
				{$this->db->where('sis90_programmer.hc',1);}
				else
				{$this->db->where('sis90_programmer.empleado',1);	}							
				$this->db->where('sis90_programmer.emp_id',$emp_id);
			}
			else
			{
				$this->db->where('sis90_programmer.empleado !=',1); //SOLO DEJAR EVALUADOS
			}
						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }	


		
		
		function count_allo_a($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_programmer');
			$this->db->where('sis90_programmer.emp_id',$emp_id);
				if ($emp_id==31)
				{$this->db->where('sis90_programmer.hc !=',1);}
				else
				{$this->db->where('sis90_programmer.empleado',1);	}							
				$this->db->where('sis90_programmer.emp_id',$emp_id);						
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
			$this->db->like('sis90_programmer.status','activo');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


		function count_allo_b($emp_id,$suc,$es_usr_de_un_despacho=0,$cei=0,$root1=0,$empleado=0)
        {
            $this->db->select("count(clte_id) as regs");
            $this->db->from('sis90_programmer');
			$this->db->where('sis90_programmer.emp_id',$emp_id);
				if ($emp_id==31)
				{$this->db->where('sis90_programmer.hc',1);}
				else
				{$this->db->where('sis90_programmer.empleado',1);	}							
				$this->db->where('sis90_programmer.emp_id',$emp_id);	
				$this->db->like('sis90_programmer.status','NOACTIVO');
            if ($suc)
			{
				
				$this->db->where('suc_id', $suc);
			}
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
		



        function get_roots($id)
        {
            $select = "root1,root2";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }


        function get_my_servicios($id)
        {
            $select = "servicios";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }


        
        function get_empresa_by_clte($clte_id)
        {
            $select = "sis15_empresas.*";
            $this->db->select($select);
            $this->db->from('sis90_programmer');
            $this->db->join('sis15_empresas', 'sis15_empresas.emp_id = sis90_programmer.emp_id');
            $this->db->where('prog_id', $clte_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function inserta($params)
        {
            $data = array_merge($params, log_insert('Nuevo cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->insert('sis90_programmer');
            return $this->db->insert_id();
        }
		

		
		


        function actualiza_nombre_doc($fsm_id, $params)
        {
            $this->db->where('doc_id',$fsm_id);
            return $this->db->update('sis90_programmer_doc',$params);
        }
		
  
        function actualiza_registro($clte_id, $params)
        {
            $data = array_merge($params, log_update_reg('Edita y registra nuevamente cliente'));
            parsea_insert($data, $this->db, 'humancenter');
            $this->db->where('prog_id',$clte_id);
            return $this->db->update('sis90_programmer');
        }
  
  
        function actualiza_registro_individual($clte_id, $params)
        {
            $this->db->where('prog_id',$clte_id);
            return $this->db->update('sis90_programmer',$params);
        }
  


  

        
        function get_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis90_programmer_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
		function inserta_borrado($data_insert)
		{
			$this->db->insert('sis_borrado_docs', $data_insert);
			return $this->db->insert_id();
		}		
        
		function delete_doc($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis90_programmer_doc');
		}			
		
        function add_doc($data_insert)
        {
            $this->db->insert('sis90_programmer_doc', $data_insert);
            return $this->db->insert_id();
        }		
/***************************COMPORTAMIENTO*******************************************/
        function get_compo_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_comportamiento_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
        function get_sgmty_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_sgmty_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }



        function get_covid_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_covid_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_AUDIO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_audio_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
         function get_VISTA_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_vista_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
          function get_ELECTRO_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_electro_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
           function get_PAPAN_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_papan_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
          function get_RADIOT_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_radiot_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
 
           function get_RADIOL_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_radiol_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
  
        function get_compo_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis13_comportamiento_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
  
        function add_covid_doc($data_insert)
        {
            $this->db->insert('sis12_covid_doc', $data_insert);
            return $this->db->insert_id();
        }
		
        function add_AUDIO_doc($data_insert)
        {
            $this->db->insert('sis12_audio_doc', $data_insert);
            return $this->db->insert_id();
        }		

        function add_VISTA_doc($data_insert)
        {
            $this->db->insert('sis12_vista_doc', $data_insert);
            return $this->db->insert_id();
        }	

        function add_INTE_doc($data_insert)
        {
            $this->db->insert('sis12_inte_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_PUESIC_doc($data_insert)
        {
            $this->db->insert('sis12_pruebas_psico_doc', $data_insert);
            return $this->db->insert_id();
        }		

        function add_PENSA_doc($data_insert)
        {
            $this->db->insert('sis12_pensa_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_ELECTRO_doc($data_insert)
        {
            $this->db->insert('sis12_electro_doc', $data_insert);
            return $this->db->insert_id();
        } 

        function add_PAPAN_doc($data_insert)
        {
            $this->db->insert('sis12_papan_doc', $data_insert);
            return $this->db->insert_id();
        }
        function add_RADIOT_doc($data_insert)
        {
            $this->db->insert('sis12_radiot_doc', $data_insert);
            return $this->db->insert_id();
        }

        function add_RADIOL_doc($data_insert)
        {
            $this->db->insert('sis12_radiol_doc', $data_insert);
            return $this->db->insert_id();
        }		

 
 
        function add_compo_doc($data_insert)
        {
            $this->db->insert('sis13_comportamiento_doc', $data_insert);
            return $this->db->insert_id();
        }
		
		 function add_sgmty_doc($data_insert)
        {
            $this->db->insert('sis12_sgmty_doc', $data_insert);
            return $this->db->insert_id();
        }


        function get_PENSA_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_pensa_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function get_INTE_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_inte_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }		
		


        function get_PUESIC_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_pruebas_psico_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }	


        function get_hon_docs($cliente_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_honestidad_doc');
            $this->db->where('prog_id', $cliente_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
        
        function get_hon_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis12_honestidad_doc');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }
        
        function add_hon_doc($data_insert)
        {
            $this->db->insert('sis12_honestidad_doc', $data_insert);
            return $this->db->insert_id();
        }
		
		
        function borra_sgmty_doc($id)
        {
            $this->db->where('prog_id', $id);
            return $this->db->delete('sis12_sgmty_doc`');
        }
		
        function borra_sgmty_venta($id,$tipo)
        {
            $this->db->where('prog_id', $id);
			$this->db->like('doc_nombre', $tipo);
            return $this->db->delete('sis12_sgmty_doc`');
        }	


/**********************************************************************/



	function trae_empresas()
    {
        $this->db->select('*');
        $this->db->from('sis15_empresas');
		
		if(get_perfil_id() == 4)
        {
                $empresas = get_empresas_array();
                $this->db->where_in('emp_id', $empresas);
        }
		else
		{
			$estatus='INACTIVO';
			 $this->db->not_like('emp_estatus_cve',$estatus);
		}		
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
    }

	
        function get_despachos()
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
			$n='1';
			$this->db->where('emp_desp', $n);
            $this->db->group_by('emp_id');
			$this->db->order_by('emp_razon_social','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }		
/**************************************************************************************/
        function buscate($nombre1 = '',$nombre2 = '',$paterno = '',$materno = '')
        {            
            //$select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,log_insrt_f,suc_id, cei_id";
            $select = "log_insrt_f";
			$this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_programmer');
            $this->db->where('status', 'activo');
            $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre1);
			$this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2);
			$this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno);
			$this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno);

            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
        function buscate_rfc($rfc = '',$emp_id = '')
        {            
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,log_insrt_f,suc_id, cei_id";
            //$select = "log_insrt_f";
			$this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_programmer');
            $this->db->where('status', 'activo');
            $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc);
			$this->db->like('emp_id',$emp_id);
            $result = $this->db->get();
            return $result->result_array();
        }		
		
/**************************************************************************************/        
	

/**************************************************************************************/
        function busca_a($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_programmer as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			$this->db->where('a.hc !=',1);
			//$this->db->or_where('a.hc', NULL);
           
  			
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

/**************************************************************************************/        
        function busca_p($empresa = '',$nombre = '',$nombre2 = '',$paterno='',$materno='', $empleado = '', $receta = '',$despacho='',$emp_asig_user='')
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt, emp_razon_social,log_insrt_f,suc_id, cei_id, desp_id,med_emp_asig";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_programmer as a');
            $this->db->where('status', 'activo');
			$this->db->where('a.paciente',1);
            $this->db->where('a.med_emp_asig',intval($emp_asig_user)); 
			$this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){$this->db->where('a.emp_id',$empresa);}
			
			if($nombre != ''){ $this->db->like('AES_DECRYPT(clte_nombre_crypt, "humancenter")',$nombre); }  
			if($nombre2 != ''){ $this->db->like('AES_DECRYPT(clte_2_nombre_crypt, "humancenter")',$nombre2); } 
            if($paterno != ''){ $this->db->like('AES_DECRYPT(clte_paterno_crypt, "humancenter")',$paterno); }            
			if($materno != ''){ $this->db->like('AES_DECRYPT(clte_materno_crypt, "humancenter")',$materno); } 
			if($receta != ''){ $this->db->where('a.clte_id',intval($receta)); }
            if($empleado != ''){ $this->db->like('a.num_empleado',$empleado); }
			
  			
         
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }




/**************************************************************************************/        
        function buscandote($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_programmer as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			//echo $fecha->format('Y-m-d') . "\n";
			
			//$f_fino=date_add($f_fin, date_interval_create_from_date_string('1 days'));
			//$this->db->where('log_insrt_f <=',date_format($f_fino,'Y-m-d' ));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            			
			//if($ubicacion != ''){ $this->db->where('clte_lab_ubicacion',$ubicacion); }
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/             

        function buscandote_evaluados($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_programmer as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			$this->db->where('a.paciente ',0);
			$this->db->where('a.empleado',0);
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }

         
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }

/**************************************************************************************/        
        function buscando_evaluados_gsi($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$orden=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac,clte_genero_cve, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_programmer as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            $this->db->where('b.emp_corp', 'GSI');
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));

			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
    			
            
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
            }

            if ($orden == 0)
			{	
				$this->db->order_by('log_insrt_f','DESC');
			}
			else
			{
				$this->db->order_by('log_insrt_f','ASC');				
			}		
			
			
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/             
        
/**************************************************************************************/        
        function buscandote_by_despacho($empresa = '',$cei='',$nombre = '', $rfc = '', $regby = '',$f_ini,$f_fin,$es_usr_de_un_despacho=0)
        {            
            //$this->db->select('*');
            $select = "clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_f_nac, clte_rfc_crypt,clte_path_foto,emp_razon_social,a.emp_id as emp_id,log_insrt_usr_cve,log_insrt_f,suc_id, cei_id,root,desp_id,clte_reclutador,clte_puesto";
            $this->db->select(parsea_select($select, 'humancenter'));
            
            $this->db->from('sis90_programmer as a');
            $this->db->where('status', 'activo');
            $this->db->join('sis15_empresas as b', 'a.emp_id = b.emp_id');
            
            if($empresa != ''){ $this->db->where('a.emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			if($regby != ''){ $this->db->where('log_insrt_usr_cve',$regby); }
			
			$this->db->where('log_insrt_f >=', $f_ini);
			
			$fecha = new DateTime($f_fin);
			$fecha->add(new DateInterval('P01D'));
			
			$this->db->where('log_insrt_f <=',$fecha->format('Y-m-d'));
            if($nombre != ''){ $this->db->like('CONCAT(AES_DECRYPT(clte_nombre_crypt, "humancenter")," ",AES_DECRYPT(clte_2_nombre_crypt, "humancenter"))',$nombre); }            
            if($rfc != ''){ $this->db->like('AES_DECRYPT(clte_rfc_crypt, "humancenter")',$rfc); }
            			
            /*
            if(get_perfil_id() == 4){
                $empresas = get_empresas_array();
                $this->db->where_in('a.emp_id', $empresas);
			}
			*/
			
			
			if(get_perfil_id() == 4)
			{
				if ($es_usr_de_un_despacho==0)
				{	
					$empresas = get_empresas_array();
					$this->db->where_in('a.emp_id', $empresas);
					$i=33;
					$this->db->where('desp_id !=',$i);
					
					
				}
				else
				{
					
					$this->db->where('a.desp_id', $es_usr_de_un_despacho);					
				}	
			}
			
           
            $this->db->order_by('log_insrt_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/ 

        
        function get_empresa_by_id($emp_id)
        {
            $this->db->select('*');
            $this->db->from('sis15_empresas');
            $this->db->where('emp_id', $emp_id);
            $result = $this->db->get();
            return $result->row_array();
        }

        /*function get_examenes($clte_id){
            $mapeo = unserialize(MAPEO_EXAMENES);

            $select = "SELECT a.clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt,clte_materno_crypt,clte_genero_cve, clte_rfc_crypt, emp_razon_social, b.emp_id";
            $select = parsea_select($select, 'humancenter');
            $inicio = FALSE;
            $sql = $select.',FROM (';
            
            foreach($mapeo as $tb) {
                if($inicio) $sql .= ' UNION ';
                $sql .= 'SELECT clte_id,"'.$tb['alias'].'" as alias, '.$tb['fecha'].' as fecha,emp_id FROM '.$tb['tabla'].' WHERE clte_id='.$clte_id;
                if(isset($tb['where'])) $sql .= ' AND '.$tb['where']['campo'].' = "'.$tb['where']['valor'].'"';
                $inicio = TRUE;
            }

            $sql .= ') as a ';
            $sql .= ' LEFT JOIN sis90_programmer as a ON y.clte_id = a.clte_id ';
            $sql .= ' LEFT JOIN sis15_empresas as b ON a.emp_id = b.emp_id ';
            if($emp_id != ''){
                $sql .= ' WHERE b.emp_id = "'.$emp_id.'"';
            }
            $sql .= ' GROUP BY y.clte_id ';
            $sql .= ' ORDER BY b.emp_id ASC;';
            echo $sql;
            //$result = $this->db->query($sql);
            //return $result->result_array();
        }*/
}