<div>
    <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="300px" />
    <h3 align="center">
        HISTORIA CLÍNICA
    </h3>
    <table border="1" cellpadding="3">
        <tr>
            <td align="center">
                <b>Apellido Paterno</b><br>
                <?php echo $persona['clte_paterno']; ?>
            </td>
            <td align="center">
                <b>Apellido Materno</b><br>
                <?php echo $persona['clte_materno']; ?>
            </td>
            <td align="center">
                <b>Nombre(s)</b><br>
                <?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre']; ?>
            </td>
        </tr>
        <tr>
            <td align="center">
                <b>Edad</b><br>
                <?php echo get_edad($persona['clte_f_nac']); ?>
            </td>
            <td align="center">
                <b>Género</b><br>
                <?php echo get_cat_nombre('GENERO',$persona['clte_genero_cve']); ?>
            </td>
        </tr>
    </table>
    <p>&nbsp;</p>
    <h4>ANTECEDENTES HEREDOFAMILIARES</h4>
    <table border="1" cellpadding="3">
            <tr>
                <th style="background-color: #00004d;"><b style="color: #fff;">Parentesco</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Enfermedad</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Causa de Muerte</b></th>
            </tr>
            <?php if($heredo): ?>
            <?php foreach ($heredo as $her): ?>
                <tr>
                    <td><?php echo get_cat_nombre('PARENT', $her['her_parent_cve']); ?></td>
                    <td><?php echo get_cie_nombre($her['cie_clave']); ?></td>
                    <td><?php echo get_cat_nombre('AFIRMA', $her['her_causo_muerte_cve']); ?></td>
                </tr>
            <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="3" align="center">SIN REGISTROS</td></tr>
            <?php endif; ?>
    </table>
    <p>&nbsp;</p>
    <h4>ANTECEDENTES NO PATOLÓGICOS</h4>
    <table border="1" cellpadding="3">
        <tr>
            <th style="background-color: #00004d;"><b style="color: #fff;">Sustancia</b></th>
            <th style="background-color: #00004d;"><b style="color: #fff;">Cantidad</b></th>
            <th style="background-color: #00004d;"><b style="color: #fff;">Frecuencia</b></th>
            <th style="background-color: #00004d;"><b style="color: #fff;">Fecha inicio</b></th>
            <th style="background-color: #00004d;"><b style="color: #fff;">Fecha fin</b></th>
        </tr>
        <?php if($nopat): ?>
            <?php foreach ($nopat as $npat): ?>
                <tr>
                    <td><?php echo get_cat_nombre('NOPAT', $npat['nopat_tipo_cve']); ?></td>
                    <td><?php echo $npat['nopat_cant']; ?></td>
                    <td><?php echo get_cat_nombre('FREC', $npat['nopat_frec_cve']); ?></td>
                    <td><?php echo formatea_fecha($npat['nopat_f_ini']); ?></td>
                    <td><?php echo formatea_fecha($npat['nopat_f_fin']); ?></td>
                </tr>
            <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="5" align="center">SIN REGISTROS</td></tr>
            <?php endif; ?>
    </table>
    
    <p>&nbsp;</p>
    <h4>ANTECEDENTES PATOLÓGICOS</h4>
    <table border="1" cellpadding="3">
        <tr>
            <th style="background-color: #00004d;"><b style="color: #fff;">Enfermedad</b></th>
            <th style="background-color: #00004d;"><b style="color: #fff;">Fecha detección</b></th>
            <th style="background-color: #00004d;"><b style="color: #fff;">Fecha alta</b></th>
        </tr>
        <?php if($pat): ?>
            <?php foreach ($pat as $pt): ?>
                <tr>
                    <td><?php echo get_cie_nombre($pt['cie_clave']); ?></td>
                    <td><?php echo formatea_fecha($pt['pat_fecha_detecto']); ?></td>
                    <td><?php echo formatea_fecha($pt['pat_fecha_fin']); ?></td>
                </tr>
            <?php endforeach; ?>
            <?PHP else: ?>
                <tr><td colspan="3" align="center">SIN REGISTROS</td></tr>
            <?php endif; ?>
    </table>
    
    <?php if($persona['clte_genero_cve'] == 'M'): ?>

        <p>&nbsp;</p>
        <h4>ANTECEDENTES GÍNECO OBSTÉTRICOS</h4>
        <table border="1" cellpadding="3">
            <tr>
                <td style="background-color: #00004d;"><b style="color: #fff;">Ritmo menstrual</b></td>
                <td><?php echo get_cat_nombre('RITMO', $gineco['gin_ritmo_cve']); ?></td>
                <td style="background-color: #00004d;"><b style="color: #fff;">Cada cuanto(Días)</b></td>
                <td><?php echo $gineco['gin_menst_cada']; ?></td>
            </tr>
            <tr>
                <td style="background-color: #00004d;"><b style="color: #fff;">Duracion(Días)</b></td>
                <td><?php echo $gineco['gin_menst_dura']; ?></td>
                
                <td style="background-color: #00004d;"><b style="color: #fff;">FUM</b></td>
                <td><?php echo formatea_fecha($gineco['gin_f_ult_menst']); ?></td>
            </tr>
            <tr>
                <td style="background-color: #00004d;"><b style="color: #fff;">IVSA(Edad)</b></td>
                <td><?php echo $gineco['gin_ivsa']; ?></td>
                
                <td style="background-color: #00004d;"><b style="color: #fff;">MPF</b></td>
                <td><?php echo get_cat_nombre('MPF', $gineco['gin_mpf_cve']); ?></td>
            </tr>
            <tr>
                <td colspan="4">&nbsp;</td>
            </tr>
            <tr>
                <td>&nbsp;</td>
                <td style="background-color: #00004d;"><b style="color: #fff;">Fecha Útimo Estudio</b></td>
                <td colspan="2" style="background-color: #00004d;"><b style="color: #fff;">Observaciones</b></td>
            </tr>
            <tr>
                <td>Cáncer de Mama</td>
                <td><?php echo formatea_fecha($gineco['gin_docma_f']); ?></td>
                <td colspan="2"><?php echo $gineco['gin_docma_nota']; ?></td>
            </tr>
            <tr>
                <td>Papanicolau</td>
                <td><?php echo formatea_fecha($gineco['gin_papanic_f']); ?></td>
                <td colspan="2"><?php echo $gineco['gin_papanic_nota']; ?></td>
            </tr>
            <tr>
                <td>Colposcopía</td>
                <td><?php echo formatea_fecha($gineco['gin_colposc_f']); ?></td>
                <td colspan="2"><?php echo $gineco['gin_colposc_nota']; ?></td>
            </tr>
            <tr>
                <td colspan="4">&nbsp;</td>
            </tr>
            <tr>
                <td style="background-color: #00004d;"><b style="color: #fff;">Num. gestas</b></td>
                <td><?php echo $gineco['gin_num_gestas']; ?></td>
                
                <td style="background-color: #00004d;"><b style="color: #fff;">Num. abortos</b></td>
                <td><?php echo $gineco['gin_num_abortos']; ?></td>
            </tr>
            <tr>
                <td style="background-color: #00004d;"><b style="color: #fff;">Num. partos</b></td>
                <td><?php echo $gineco['gin_num_partos']; ?></td>
                
                <td style="background-color: #00004d;"><b style="color: #fff;">Num. cesareas</b></td>
                <td><?php echo $gineco['gin_num_cesareas']; ?></td>
            </tr>
            <tr>
                <td style="background-color: #00004d;"><b style="color: #fff;">Ult. aborto</b></td>
                <td><?php echo formatea_fecha($gineco['gin_f_ult_aborto']); ?></td>
                
                <td style="background-color: #00004d;"><b style="color: #fff;">Ult. parto</b></td>
                <td><?php echo formatea_fecha($gineco['gin_f_ult_parto']); ?></td>
            </tr>
            <tr>
                <td colspan="4">&nbsp;</td>
            </tr>
            <tr>
                <td colspan="4" style="background-color: #00004d;"><b style="color: #fff;">Observaciones</b></td>
            </tr>
            <tr>
                <td colspan="4"><?php echo $gineco['gin_notas']; ?></td>
            </tr>
        </table>
    <?php endif; ?>
    
    <p>&nbsp;</p>
    <h4>CIRUGÍAS</h4>
    <table border="1" cellpadding="3">
            <tr>
                <th style="background-color: #00004d;"><b style="color: #fff;">Cirugía (Catálogo de procedimientos)</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Fecha</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Observaciones</b></th>
            </tr>
            <?php
                if($cirugia):
                    foreach ($cirugia as $cir_item):
                        ?>
                        <tr>
                            <td><?php echo $cir_item['proc_descrip'];?></td>
                            <td><?php echo formatea_fecha($cir_item['cir_fecha']);?></td>
                            <td><?php echo $cir_item['cir_notas'];?></td>
                        </tr>
                        <?php
                    endforeach;
                else: ?>
                        <tr><td colspan="3" align="center">SIN REGISTROS</td></tr>
            <?php endif; ?>
    </table>
    
    <p>&nbsp;</p>
    <h4>DISCAPACIDADES</h4>
    <table border="1" cellpadding="3">
            <tr>
                <th style="background-color: #00004d;"><b style="color: #fff;">Discapacidad (CIE-9)</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Observaciones</b></th>
            </tr>
            <?php
                if($discap): 
                    foreach( $discap as $discap_item ):
                ?>
                <tr>
                    <td><?php echo $discap_item['discap_descrip'];?></td>
                    <td><?php echo $discap_item['dis_cif_nota'];?></td>
                </tr>
                <?php
                endforeach;
                else: ?>
                <tr><td colspan="3" align="center">SIN REGISTROS</td></tr>
            <?php endif; ?>
    </table>
    
    <p>&nbsp;</p>
    <h4>DIFICULTADES</h4>
    <table border="1" cellpadding="3">
            <tr>
                <th style="background-color: #00004d;"><b style="color: #fff;">Dificultad</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Origen</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Grado</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Observación</b></th>
            </tr>
            <?php
                if($dificul): 
                    foreach( $dificul as $discap_item ):
                ?>
                <tr>
                    <td><?php echo $discap_item['tipo'];?></td>
                    <td><?php echo $discap_item['origen']; ?></td>
                    <td><?php echo $discap_item['grado']; ?></td>
                    <td><?php echo $discap_item['dis_cif_nota'];?></td>
                </tr>
                <?php
                endforeach;
                else: ?>
                <tr><td colspan="4" align="center">SIN REGISTROS</td></tr>
            <?php endif; ?>
    </table>
    
    <p>&nbsp;</p>
    <h4>ALERGIAS</h4>
    <table border="1" cellpadding="3">
            <tr>
                <th style="background-color: #00004d;"><b style="color: #fff;">Alérgeno</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Reacción</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Observación</b></th>
            </tr>
            <?php
                if($alergia): 
                    foreach($alergia as $alergia_item):

                ?>
                <tr>
                    <td><?php echo $alergia_item['alerg_alergeno'];?></td>
                    <td><?php echo $alergia_item['alerg_reaccion']; ?></td>
                    <td>
                        <a href="<?php echo base_url('persona/hc_borra_alergia/'.$alergia_item['alerg_id']); ?>" class='btn delete'><i class="fa fa-trash"></i></a>
                    </td>
                </tr>
                <?php
                endforeach;
                else: ?>
                <tr><td colspan="3" align="center">SIN REGISTROS</td></tr>
            <?php endif; ?>
    </table>
    
    <p>&nbsp;</p>
    <h4>SIGNOS VITALES</h4>
    <table border="1" cellpadding="3">
            <tr>
                <th style="background-color: #00004d;"><b style="color: #fff;">Fecha</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Peso</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Altura</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">IMC</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Temp.</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">P. sis</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">P. dias</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Frec. card</b></th>
                <th style="background-color: #00004d;"><b style="color: #fff;">Frec. resp</b></th>
            </tr>
            <?php if($signos): ?>
                <?php foreach ($signos as $signo): ?>
                    <tr>
                        <td><?php echo formatea_fecha($signo['sig_fecha']); ?></td>
                        <td><?php echo $signo['sig_peso']; ?> kg</td>
                        <td><?php echo $signo['sig_talla']; ?> cm</td>
                        <td><?php echo round($signo['sig_peso'] / ($signo['sig_talla']/100 * $signo['sig_talla']/100),2); ?></td>
                        <td><?php echo $signo['sig_temp']; ?> C°</td>
                        <td><?php echo $signo['sig_presion_sis']; ?></td>
                        <td><?php echo $signo['sig_presion_dias']; ?></td>
                        <td><?php echo $signo['sig_frec_card']; ?></td>
                        <td><?php echo $signo['sig_frec_resp']; ?></td>
                    </tr>
                <?php endforeach; ?>
                <?php else: ?>
                <tr><td colspan="9" align="center">SIN REGISTROS</td></tr>
            <?php endif; ?>
    </table>
</div>