<div class="col-xs-12">
<div class="panel panel-default">
    <div class="panel-heading">
        <a class="persona_link" href="<?php echo base_url('persona/id/'.$persona['clte_id']); ?>">
        <b>
            <?php echo $persona['clte_nombre']; ?> 
            <?php echo $persona['clte_2_nombre']; ?> 
            <?php echo $persona['clte_paterno']; ?> 
            <?php echo $persona['clte_materno']; ?> &nbsp; &nbsp;
            Edad: <?php echo get_edad($persona['clte_f_nac']); ?>
        </b>
        </a>
    </div>
    <form class="send-fsm form-horizontal" action="<?php echo base_url('persona/socio_economico_edita/'.$persona['clte_id'].'/'.$fsm['fsm_id']); ?>" method="POST">
        <input type="hidden" value="<?php echo $fsm['fsm_id']; ?>" id="fsm_id" />
    <div class="panel-body">
        <h4 class="text-center">ESTUDIO SOCIOECONÓMICO</h4>
        <table border="0" class="table table-sinborde">
            <tr>
                <td width="30%" align="right">
                    <?php if($persona['clte_path_foto'] ==! NULL): ?> 
                    <img src="<?php echo base_url('../fotos/'.strtolower($persona['clte_path_foto'])); ?>" width="100px" height="150px">
                    <?php else: ?>
                        <img src="<?php echo base_url('../dist/images/persona.png'); ?>"  width="100px" height="150px">
                    <?php endif; ?>
                </td>
                <td width="70%" align="left">
                    <table>
                        <tr>
                            <td align="right" width="20%">
                                <label><b>Puesto a cubrir:</b></label>
                            </td>
                            <td align="left">
                                <label><?php echo $persona['clte_puesto']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                <label><b>Motivo de evaluación:</b></label>
                            </td>
                            <td align="left">
                                <input type="text" name="motivo" class="form-control" value="<?php echo $fsm['motivo']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                <label><b>Fecha de evaluación:</b></label>
                            </td>
                            <td align="left">
                                <input type="text" name="fecha_eval" class="form-control fecha" style="width: 150px;" value="<?php echo formatea_fecha($fsm['fecha_eval']); ?>">
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <td colspan="3" class="header-table">
                    <b>1. INFORMACIÓN GENERAL</b>
                </td>
            </tr>
            <tr>
                <td>
                    <b>NOMBRE(S)</b><br>
                    <?php echo $persona['clte_nombre']; ?> <?php echo $persona['clte_2_nombre']; ?>
                </td>
                <td>
                    <b>APELLIDO PATERNO</b><br>
                    <?php echo $persona['clte_paterno']; ?>
                </td>
                <td>
                    <b>APELLIDO MATERNO</b><br>
                    <?php echo $persona['clte_materno']; ?>
                </td>
            </tr>
            <tr>
                <td>
                    <b>FECHA DE NACIMIENTO</b><br>
                    <?php echo formatea_fecha($persona['clte_f_nac']); ?>
                </td>
                <td>
                    <b>EDAD</b><br>
                    <?php echo get_edad($persona['clte_f_nac']); ?>
                </td>
                <td>
                    <b>LUGAR DE NACIMIENTO</b><br>
                    <?php echo get_cat_nombre('EDO',$persona['clte_nac_cve']); ?>
                </td>
            </tr>
            <tr>
                <td>
                    <b>LUGAR DE RESIDENCIA</b><br>
                    <?php echo get_cat_nombre('EDO',$persona['clte_mex_resid_cve']); ?>
                </td>
                <td>
                    <b>ESTADO CIVIL</b><br>
                    <?php echo get_cat_nombre('EDO_CIV',$persona['clte_edo_civ_cve']); ?>
                </td>
                <td>
                    <b>SEXO</b><br>
                    <?php echo get_cat_nombre('GENERO',$persona['clte_genero_cve']); ?>
                </td>
            </tr>
            <tr>
                <td>
                    <b>TELÉFONO DE CASA</b><br>
                    <?php echo formatea_tel($persona['clte_tel_casa']); ?>
                </td>
                <td>
                    <b>TELÉFONO CELULAR</b><br>
                    <?php echo formatea_tel($persona['clte_cel']); ?>
                </td>
                <td>
                    <b>CORREO ELECTRÓNICO</b><br>
                    <?php echo $persona['clte_email']; ?>
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <th colspan="4" align="center" class="header-table-secondary" >DOMICILIO ACTUAL</th>
            </tr>
            <tr>
                <td colspan="2">
                    <b>CALLE</b><br>
                    <?php echo $persona['clte_env_calle']; ?>
                </td>
                <td>
                    <b>NÚMERO EXTERIOR</b><br>
                    <?php echo $persona['clte_env_num_ext']; ?>
                </td>
                <td>
                    <b>NÚMERO INTERIOR</b><br>
                    <?php echo $persona['clte_env_num_int']; ?>
                </td>
            </tr>
            <tr>
                <td>
                    <b>COLONIA</b><br>
                    <?php echo $persona['clte_env_colonia']; ?>
                </td>
                <td>
                    <b>DELEGACIÓN O MUNICIPIO</b><br>
                    <?php echo $persona['clte_env_municipio']; ?>
                </td>
                <td>
                    <b>ESTADO</b><br>
                    <?php echo $persona['clte_env_localidad']; ?>
                </td>
                <td>
                    <b>C.P.</b><br>
                    <?php echo $persona['clte_env_cp']; ?>
                </td>
            </tr>
        </table>        
        <table border="1" class="table table-striped">
            <tr>
                <td colspan="7" class="header-table">
                    <b>2. INFORMACIÓN ACADÉMICA</b>
                    <button class="btn btn-primary btn-sm btn-add pull-right">
                        <span class=" glyphicon glyphicon-plus" aria-hidden="true"></span> 
                    </button>
                </td>
            </tr>
            <tr>
                <th align="center">NIVEL ESCOLAR</th>
                <th align="center">AÑOS</th>
                <th align="center">NOMBRE DE LA ESCUELA</th>
                <th align="center">POBLACIÓN</th>
                <th align="center">DOCUMENTO</th>
                <th align="center">&nbsp</th>
            </tr>
            <?php 
                if($fsm['escuelas']): 
                    foreach ($fsm['escuelas'] as $escuela): 
            ?>
                    <tr>
                        <td>
                            <?php echo get_cat_nombre('GRADOACAD', $escuela['nivel']); ?>
                        </td>
                        <td>
                            <?php echo $escuela['inicio']; ?>
                        </td>
                        <td>
                            <?php echo $escuela['nombre']; ?>
                        </td>
                        <td>
                            <?php echo $escuela['poblacion']; ?>
                        </td>
                        <td>
                            <?php echo $escuela['doc']; ?>
                        </td>
                        <td>
                            <a href="<?php echo base_url('persona/socio_eco_del_esc/'.$fsm['fsm_id'].'/'.$escuela['esc_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg"> </i></a>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr class="row-form">
                <td>
                    <select name="escuela[0][nivel]" class="form-control">
                        <option value="">Seleccione</option>
                        <?php echo get_options('GRADOACAD'); ?>
                    </select>
                </td>
                <td>
                    <input type="text" name="escuela[0][inicio]" class="form-control">
                </td>
                <td>
                    <input type="text" name="escuela[0][nombre]" class="form-control">
                </td>
                <td>
                    <input type="text" name="escuela[0][poblacion]" class="form-control">
                </td>
                <td colspan="2">
                    <input type="text" name="escuela[0][doc]" class="form-control">
                </td>
            </tr>
        </table>
        <table border="1" class="table table-striped">
            <tr>
                <td colspan="9" class="header-table">
                    <b>
                        3. ESTRUCTURA FAMILIAR
                    </b>
                    <button class="btn btn-primary btn-sm btn-add pull-right">
                        <span class=" glyphicon glyphicon-plus" aria-hidden="true"></span> 
                    </button>
                </td>
            </tr>
            <tr>
                <th align="center">NOMBRE</th>
                <th align="center">EDAD</th>
                <th align="center">EDO. CIVIL</th>
                <th align="center">ESCOLARIDAD</th>
                <th align="center">OCUPACIÓN</th>
                <th align="center">VIVE CON EL EVALUADO</th>
                <th align="center">DESDE CUÁNDO</th>
                <th align="center">DEPENDIENTE ECONÓMICO</th>
                <th align="center">&nbsp;</th>
            </tr>
            <?php 
                if($fsm['familiares']): 
                    foreach ($fsm['familiares'] as $fam): 
            ?>
                    <tr>
                        <td>
                            <?php echo $fam['nombre']; ?>
                        </td>
                        <td>
                            <?php echo $fam['edad']; ?>
                        </td>
                        <td>
                            <?php echo get_cat_nombre('EDO_CIV', $fam['edo_civil']); ?>
                        </td>
                        <td>
                            <?php echo get_cat_nombre('GRADOACAD', $fam['escolaridad']); ?>
                        </td>
                        <td>
                            <?php echo $fam['ocupacion']; ?>
                        </td>
                        <td>
                            <?php echo $fam['vive_eval']; ?>
                        </td>
                        <td>
                            <?php echo $fam['tiempo']; ?>
                        </td>
                        <td>
                            <?php echo $fam['dependiente']; ?>
                        </td>
                        <td>
                            <a href="<?php echo base_url('persona/socio_eco_del_fam/'.$fsm['fsm_id'].'/'.$fam['fam_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg"> </i></a>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr class="row-form">
                <td>
                    <input type="text" name="familia[0][nombre]" class="form-control">
                </td>
                <td>
                    <input type="text" name="familia[0][edad]" class="form-control">
                </td>
                <td>
                    <select name="familia[0][edo_civil]" class="form-control">
                        <option value="">Seleccione</option>
                        <?php echo get_options('EDO_CIV'); ?>
                    </select>
                </td>
                <td>
                    <select name="familia[0][escolaridad]" class="form-control">
                        <option value="">Seleccione</option>
                        <?php echo get_options('GRADOACAD'); ?>
                    </select>
                </td>
                <td>
                    <input type="text" name="familia[0][ocupacion]" class="form-control">
                </td>
                <td>
                    <!--<input type="text" name="familia[0][vive_eval]" class="form-control">-->
                    <?php echo get_radio_options('AFIRMA', 'familia[0][vive_eval]'); ?>
                </td>
                <td>
                    <input type="text" name="familia[0][tiempo]" class="form-control">
                </td>
                <td colspan="2">
                    <!--<input type="text" name="familia[0][dependiente]" class="form-control">-->
                    <?php echo get_radio_options('AFIRMA', 'familia[0][dependiente]'); ?>
                </td>
            </tr>
            <tr>
                <td colspan="4">
                    <label>Número de matrimonios: </label>
                    <input type="number" name="matrimonios" class="form-control" value="<?php echo $fsm['matrimonios']; ?>">
                </td>
                <td colspan="5">
                    <label>Cantidad de veces que ha vivido en unión libre: </label>
                    <input type="number" name="uniones" class="form-control" value="<?php echo $fsm['uniones']; ?>">
                </td>
            </tr>
        </table>
        <?php 
            $empleo_actual = array();
            if($fsm['empleos'])
            {
                foreach ($fsm['empleos'] as $empleo)
                {
                    if($empleo['tipo_cve'] == 'ACTUAL')
                    {
                        $empleo_actual = $empleo;
                    }
                }
            }
        ?>
        <table border="0" class="table table-sinborde">
            <tr>
                <td class="header-table" colspan="6">
                    <b>4. INVESTIGACIÓN LABORAL</b>
                </td>
            </tr>
            <tr>
                <th colspan="6" align="center" class="header-table-secondary" >EMPLEO ACTUAL</th>
            </tr>
            <tr>
                <td align="left">Empresa:</td>
                <td width="20%">
                    <input type="hidden" name="empleo[0][tipo_cve]" value="ACTUAL" />
                    <input type="hidden" name="empleo[0][empleo_id]" class="form-control" value="<?php echo (isset($empleo_actual['empleo_id']))?$empleo_actual['empleo_id']:''; ?>">
                    <input type="text" name="empleo[0][empresa]" class="form-control" value="<?php echo (isset($empleo_actual['empresa']))?$empleo_actual['empresa']:''; ?>">
                </td>
                <td align="left">Fecha de ingreso:</td>
                <td>
                    <input type="text" name="empleo[0][f_ingreso]" class="form-control fecha" value="<?php echo (isset($empleo_actual['tipo_cve']))?formatea_fecha($empleo_actual['f_ingreso']):''; ?>">
                </td>
                <td align="left">Tiempo que lleva laborando:</td>
                <td>
                    <input type="text" name="empleo[0][tiempo_lab]" class="form-control" value="<?php echo (isset($empleo_actual['tiempo_lab']))?$empleo_actual['tiempo_lab']:''; ?>">
                </td>
            </tr>
            <tr>
                <td align="left">Dirección:</td>
                <td colspan="3">
                    <input type="text" name="empleo[0][direccion]" class="form-control"  value="<?php echo (isset($empleo_actual['direccion']))?$empleo_actual['direccion']:''; ?>">
                </td>
                <td align="left">Teléfono:</td>
                <td>
                    <input type="text" name="empleo[0][telefono]" class="form-control"  value="<?php echo (isset($empleo_actual['telefono']))?$empleo_actual['telefono']:''; ?>"> 
                </td>
            </tr>
            <tr>
                
            </tr>
            <tr>
                <td align="left">Puesto inicial:</td>
                <td colspan="3">
                    <input type="text" name="empleo[0][puesto_i]" class="form-control"  value="<?php echo (isset($empleo_actual['puesto_i']))?$empleo_actual['puesto_i']:''; ?>">
                </td>
                <td align="left">Sueldo mensual inicial:</td>
                <td>
                    <input type="text" name="empleo[0][sueldo_i]" class="form-control"  value="<?php echo (isset($empleo_actual['sueldo_i']))?$empleo_actual['sueldo_i']:''; ?>">
                </td>
            </tr>
            <tr>
                <td align="left">Puesto final:</td>
                <td colspan="3">
                    <input type="text" name="empleo[0][puesto_f]" class="form-control"  value="<?php echo (isset($empleo_actual['puesto_f']))?$empleo_actual['puesto_f']:''; ?>">
                </td>
                <td align="left">Sueldo mensual final:</td>
                <td>
                    <input type="text" name="empleo[0][sueldo_f]" class="form-control"  value="<?php echo (isset($empleo_actual['sueldo_f']))?$empleo_actual['sueldo_f']:''; ?>">
                </td>
            </tr>
            <tr>
                <td align="left">Horario de labores:</td>
                <td>
                    <input type="text" name="empleo[0][horario]" class="form-control"  value="<?php echo (isset($empleo_actual['horario']))?$empleo_actual['horario']:''; ?>">
                </td>
                <td align="left">Jefe Inmediato:</td>
                <td colspan="3">
                    <input type="text" name="empleo[0][jefe]" class="form-control"  value="<?php echo (isset($empleo_actual['jefe']))?$empleo_actual['jefe']:''; ?>">
                </td>
            </tr>
            <tr>
                <td align="left" colspan="2">¿Por qué desea cambiar de trabajo?</td>
                <td colspan="4">
                    <input type="text" name="empleo[0][motivo]" class="form-control"  value="<?php echo (isset($empleo_actual['motivo']))?$empleo_actual['motivo']:''; ?>">
                </td>
            </tr>
            <tr>
                <td align="left" colspan="6"><b>EVALUACIÓN DEL DESEMPEÑO:</b></td>
            </tr>
            <tr>
                <td colspan="6">
                    <input type="text" name="empleo[0][evaluacion]" class="form-control" value="<?php echo (isset($empleo_actual['evaluacion']))?$empleo_actual['evaluacion']:''; ?>">
                </td>
            </tr>
            <tr>
                <td align="left">Nombre del informante:</td>
                <td colspan="2">
                    <input type="text" name="empleo[0][informante]" class="form-control" value="<?php echo (isset($empleo_actual['informante']))?$empleo_actual['informante']:''; ?>">
                </td>
                <td align="left">Puesto:</td>
                <td colspan="2">
                    <input type="text" name="empleo[0][puesto_infor]" class="form-control" value="<?php echo (isset($empleo_actual['puesto_infor']))?$empleo_actual['puesto_infor']:''; ?>">
                </td>
            </tr>
            <tr>
                <td align="left">Recontratable:</td>
                <td colspan="2">
                    <?php echo get_radio_options('AFIRMA', 'empleo[0][recontratable]', (isset($empleo_actual['recontratable']))?$empleo_actual['recontratable']:''); ?>
                </td>
                <td align="left">Recomendable:</td>
                <td colspan="2">
                    <?php echo get_radio_options('AFIRMA', 'empleo[0][recomendable]', (isset($empleo_actual['recomendable']))?$empleo_actual['recomendable']:''); ?>
                </td>
            </tr>
        </table>
        <table border="0" class="table table-sinborde">
            <tr>
                <th align="center" colspan="6" class="header-table-secondary" >
                    EMPLEO ANTERIOR
                    <button class="btn btn-primary btn-sm btn-add pull-right">
                        <span class=" glyphicon glyphicon-plus" aria-hidden="true"></span> 
                    </button>
                </th>
            </tr>
            <?php 
            $empleo_actual = array();
            if($fsm['empleos']): 
                foreach ($fsm['empleos'] as $empleo):
                    if($empleo['tipo_cve'] != 'ACTUAL'):
            ?>
            <tr>
                <td colspan="6">
                    <table border="0" class="table table-sinborde">
                        <tr>
                            <td width="20%" align="left">Empresa:</td>
                            <td>
                                <input type="hidden" name="empleo[1][empleo_id]" class="form-control" value="<?php echo $empleo['empleo_id']; ?>">
                                <input type="text" name="empleo[1][empresa]" class="form-control" value="<?php echo $empleo['empresa']; ?>">
                            </td>
                            <td align="left">Fecha de ingreso:</td>
                            <td>
                                <input type="text" name="empleo[1][f_ingreso]" class="form-control fecha" value="<?php echo formatea_fecha($empleo['f_ingreso']); ?>">
                            </td>
                            <td align="left">Fecha de salida:</td>
                            <td>
                                <input type="text" name="empleo[1][f_salida]" class="form-control fecha" value="<?php echo formatea_fecha($empleo['f_salida']); ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Dirección:</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][direccion]" class="form-control" value="<?php echo $empleo['direccion']; ?>">
                            </td>
                            <td align="left">Teléfono:</td>
                            <td>
                                <input type="text" name="empleo[1][telefono]" class="form-control" value="<?php echo $empleo['telefono']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Tiempo que laboró:</td>
                            <td colspan="5">
                                <input type="text" name="empleo[1][tiempo_lab]" class="form-control" value="<?php echo $empleo['tiempo_lab']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Puesto inicial:</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][puesto_i]" class="form-control" value="<?php echo $empleo['puesto_i']; ?>">
                            </td>
                            <td align="left">Sueldo mensual inicial:</td>
                            <td>
                                <input type="text" name="empleo[1][sueldo_i]" class="form-control" value="<?php echo $empleo['sueldo_i']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Puesto final:</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][puesto_f]" class="form-control" value="<?php echo $empleo['puesto_f']; ?>">
                            </td>
                            <td align="left">Sueldo mensual final:</td>
                            <td>
                                <input type="text" name="empleo[1][sueldo_f]" class="form-control" value="<?php echo $empleo['sueldo_f']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Principales actividades:</td>
                            <td colspan="5">
                                <input type="text" name="empleo[1][actividades]" class="form-control" value="<?php echo $empleo['actividades']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Horario de labores:</td>
                            <td>
                                <input type="text" name="empleo[1][horario]" class="form-control" value="<?php echo $empleo['horario']; ?>">
                            </td>
                            <td align="left">Jefe Inmediato:</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][jefe]" class="form-control" value="<?php echo $empleo['jefe']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Motivo de salida (especifique):</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][motivo]" class="form-control" value="<?php echo $empleo['motivo']; ?>">
                            </td>
                            <td align="left">¿Cuenta con carta de recomendación?</td>
                            <td>
                                <?php echo get_radio_options('AFIRMA', 'empleo[1][recomendacion]',$empleo['recomendacion']); ?>
                            </td>
                        </tr>
                        <tr colspan="6">
                            <td align="left" colspan="6" class=""><b>EVALUACIÓN DEL DESEMPEÑO:</b></td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                <input type="text" name="empleo[1][evaluacion]" class="form-control" value="<?php echo $empleo['evaluacion']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Nombre del informante:</td>
                            <td colspan="2">
                                <input type="text" name="empleo[1][informante]" class="form-control" value="<?php echo $empleo['informante']; ?>">
                            </td>
                            <td align="left">Puesto:</td>
                            <td colspan="2">
                                <input type="text" name="empleo[1][puesto_infor]" class="form-control" value="<?php echo $empleo['puesto_infor']; ?>">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Recontratable:</td>
                            <td colspan="2">
                                <?php echo get_radio_options('AFIRMA', 'empleo[1][recontratable]', $empleo['recontratable']); ?>
                            </td>
                            <td align="left">Recomendable:</td>
                            <td colspan="2">
                                <?php echo get_radio_options('AFIRMA', 'empleo[1][recomendable]', $empleo['recomendable']); ?>
                            </td>
                        </tr>
                        <tr>
                        <th colspan="6"></th>
                    </tr>
                    </table>
                </td>
            </tr>
            <?php
            endif; endforeach; endif;
            ?>
            <tr class="row-form">
                <td colspan="4">
                    <table border="0" class="table table-sinborde">
                        <tr>
                            <td width="20%" align="left">Empresa:</td>
                            <td>
                                <input type="text" name="empleo[1][empresa]" class="form-control" value="">
                            </td>
                            <td align="left">Fecha de ingreso:</td>
                            <td>
                                <input type="text" name="empleo[1][f_ingreso]" class="form-control fecha" value="">
                            </td>
                            <td align="left">Fecha de salida:</td>
                            <td>
                                <input type="text" name="empleo[1][f_salida]" class="form-control fecha" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Dirección:</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][direccion]" class="form-control" value="">
                            </td>
                            <td align="left">Teléfono:</td>
                            <td>
                                <input type="text" name="empleo[1][telefono]" class="form-control" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Tiempo que laboró:</td>
                            <td colspan="5">
                                <input type="text" name="empleo[1][tiempo_lab]" class="form-control" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Puesto inicial:</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][puesto_i]" class="form-control" value="">
                            </td>
                            <td align="left">Sueldo mensual inicial:</td>
                            <td>
                                <input type="text" name="empleo[1][sueldo_i]" class="form-control" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Puesto final:</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][puesto_f]" class="form-control" value="">
                            </td>
                            <td align="left">Sueldo mensual final:</td>
                            <td>
                                <input type="text" name="empleo[1][sueldo_f]" class="form-control" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Principales actividades:</td>
                            <td colspan="5">
                                <input type="text" name="empleo[1][actividades]" class="form-control" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Horario de labores:</td>
                            <td>
                                <input type="text" name="empleo[1][horario]" class="form-control" value="">
                            </td>
                            <td align="left">Jefe Inmediato:</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][jefe]" class="form-control" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Motivo de salida (especifique):</td>
                            <td colspan="3">
                                <input type="text" name="empleo[1][motivo]" class="form-control" value="">
                            </td>
                            <td align="left">¿Cuenta con carta de recomendación?</td>
                            <td>
                                <?php echo get_radio_options('AFIRMA', 'empleo[1][recomendacion]'); ?>
                            </td>
                        </tr>
                        <tr colspan="6">
                            <td align="left" colspan="6" class=""><b>EVALUACIÓN DEL DESEMPEÑO:</b></td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                <input type="text" name="empleo[1][evaluacion]" class="form-control" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Nombre del informante:</td>
                            <td colspan="2">
                                <input type="text" name="empleo[1][informante]" class="form-control" value="">
                            </td>
                            <td align="left">Puesto:</td>
                            <td colspan="2">
                                <input type="text" name="empleo[1][puesto_infor]" class="form-control" value="">
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Recontratable:</td>
                            <td colspan="2">
                                <?php echo get_radio_options('AFIRMA', 'empleo[1][recontratable]'); ?>
                            </td>
                            <td align="left">Recomendable:</td>
                            <td colspan="2">
                                <?php echo get_radio_options('AFIRMA', 'empleo[1][recomendable]'); ?>
                            </td>
                        </tr>
                        <tr>
                            <th colspan="6"></th>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <td colspan="7" class="header-table">
                    <b>5. REFERENCIAS PERSONALES Y VECINALES</b>
                    <button class="btn btn-primary btn-sm btn-add pull-right">
                        <span class=" glyphicon glyphicon-plus" aria-hidden="true"></span> 
                    </button>
                </td>
            </tr>
            <tr>
                <th align="center">NOMBRE</th>
                <th align="center">TELÉFONO</th>
                <th align="center">DIRECCIÓN</th>
                <th align="center">TIPO DE RELACIÓN</th>
                <th align="center">TIEMPO DE CONOCERLO</th>
                <th align="center">OCUPACIÓN</th>
                <th align="center">&nbsp;</th>
            </tr>
            <?php 
                if($fsm['referencias']): 
                    foreach ($fsm['referencias'] as $ref): 
            ?>
                    <tr>
                        <td>
                            <?php echo $ref['nombre']; ?>
                        </td>
                        <td>
                            <?php echo formatea_tel($ref['telefono']); ?>
                        </td>
                        <td>
                            <?php echo $ref['direccion']; ?>
                        </td>
                        <td>
                            <?php echo $ref['relacion']; ?>
                        </td>
                        <td>
                            <?php echo $ref['tiempo']; ?>
                        </td>
                        <td>
                            <?php echo $ref['ocupacion']; ?>
                        </td>
                        <td>
                            <a href="<?php echo base_url('persona/socio_eco_del_ref/'.$fsm['fsm_id'].'/'.$ref['ref_pers_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg"> </i></a>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr class="row-form">
                <td>
                    <input type="text" name="referencia_p[0][nombre]" class="form-control">
                </td>
                <td>
                    <input type="text" name="referencia_p[0][telefono]" class="form-control">
                </td>
                <td>
                    <input type="text" name="referencia_p[0][direccion]" class="form-control">
                </td>
                <td>
                    <input type="text" name="referencia_p[0][relacion]" class="form-control">
                </td>
                <td>
                    <input type="text" name="referencia_p[0][tiempo]" class="form-control">
                </td>
                <td colspan="2">
                    <input type="text" name="referencia_p[0][ocupacion]" class="form-control">
                </td>
            </tr>
        </table>
        
        <table border="1" class="table">
            <tr>
                <td colspan="4" class="header-table">
                    <b>6. REFERENCIAS BANCARIAS</b>
                    <button class="btn btn-primary btn-sm btn-add pull-right">
                        <span class=" glyphicon glyphicon-plus" aria-hidden="true"></span> 
                    </button>
                </td>
                
            </tr>
            <tr>
                <th align="center" >BANCO</th>
                <th align="center" >TIPO DE CUENTA</th>
                <th align="center" >LÍMITE DE CRÉDITO OTORGADO</th>
                <th align="center" >&nbsp;</th>
            </tr>
            <?php 
                if($fsm['bancos']): 
                    foreach ($fsm['bancos'] as $banco): 
            ?>
                    <tr>
                        <td>
                            <?php echo $banco['banco']; ?>
                        </td>
                        <td>
                            <?php echo $banco['cuenta']; ?>
                        </td>
                        <td>
                            <?php echo $banco['limite']; ?>
                        </td>
                        <td>
                            <a href="<?php echo base_url('persona/socio_eco_del_bco/'.$fsm['fsm_id'].'/'.$banco['ref_banc_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg"> </i></a>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr class="row-form">
                <td>
                    <input type="text" name="referencia_b[0][banco]" class="form-control">
                </td>
                <td>
                    <input type="text" name="referencia_b[0][cuenta]" class="form-control">
                </td>
                <td colspan="2">
                    <input type="text" name="referencia_b[0][limite]" class="form-control">
                </td>
            </tr>
        </table>
        
        <table border="1" class="table">
            <tr>
                <td class="header-table" colspan="4">
                    <b>7. SITUACIÓN ECONÓMICA</b>
                </td>
            </tr>
            <tr>
                <th colspan="4" align="center" class="header-table-secondary">PROPIEDADES</th>
            </tr>
            <tr>
                <td>La casa que habita es:</td>
                <td colspan="3">
                    <?php echo get_radio_options('CASA','tipo_casa', $fsm['tipo_casa']); ?>
                </td>
            </tr>
            <tr>
                <td>
                    Valor aproximado: $<input type="text" name="valor_PROPIA" class="form-control" value="<?php echo ($fsm['tipo_casa'] == 'PROPIA')?$fsm['valor_casa']:''; ?>">
                </td>
                <td>
                    Renta mensual: $<input type="text" name="valor_RENTA" class="form-control" value="<?php echo ($fsm['tipo_casa'] == 'RENTA')?$fsm['valor_casa']:''; ?>">
                </td>
                <td>
                    Valor de adeudo: $<input type="text" name="valor_BANCO" class="form-control" value="<?php echo ($fsm['tipo_casa'] == 'BANCO')?$fsm['valor_casa']:''; ?>">
                </td>
                <td>
                    Aportación mensual: $<input type="text" name="aportacion" class="form-control" value="<?php echo $fsm['aportacion_casa']; ?>">
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <th colspan="5" align="center" class="header-table-secondary">
                    AUTOMÓVILES
                    <button class="btn btn-primary btn-sm btn-add pull-right">
                        <span class=" glyphicon glyphicon-plus" aria-hidden="true"></span> 
                    </button>
                </th>
            </tr>
            <tr>
                <th>TIPO</th>
                <th>PROPIO</th>
                <th>MARCA</th>
                <th>MODELO</th>
                <th>&nbsp;</th>
            </tr>
            <?php 
                if($fsm['autos']): 
                    foreach ($fsm['autos'] as $auto): 
            ?>
                    <tr>
                        <td>
                            <?php echo $auto['tipo']; ?>
                        </td>
                        <td>
                            <?php echo $auto['propio']; ?>
                        </td>
                        <td>
                            <?php echo $auto['marca']; ?>
                        </td>
                        <td>
                            <?php echo $auto['modelo']; ?>
                        </td>
                        <td>
                            <a href="<?php echo base_url('persona/socio_eco_del_aut/'.$fsm['fsm_id'].'/'.$auto['autos_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg"> </i></a>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr class="row-form">
                <td>
                    <input type="text" name="autos[0][tipo]" class="form-control">
                </td>
                <td>
                    <input type="text" name="autos[0][propio]" class="form-control">
                </td>
                <td>
                    <input type="text" name="autos[0][marca]" class="form-control">
                </td>
                <td colspan="2">
                    <input type="text" name="autos[0][modelo]" class="form-control">
                </td>
            </tr>
            <tr>
                <td>
                    ¿Están totalmente liquidados?
                </td>
                <td>
                    <?php echo get_radio_options('AFIRMA','autos_liquidados', $fsm['autos_liquidados']); ?>
                </td>
                <td>
                    ¿Cuánto adeuda?
                </td>
                <td colspan="2">
                    <input type="text" name="autos_adeudo" class="form-control" value="<?php echo $fsm['autos_adeudo']; ?>">
                </td>
            </tr>
        </table>
        
        <table border="1" class="table">
            <tr>
                <th colspan="6" align="center" class="header-table-secondary" >
                    CRÉDITOS
                    <button class="btn btn-primary btn-sm btn-add pull-right">
                        <span class=" glyphicon glyphicon-plus" aria-hidden="true"></span> 
                    </button>
                </th>
            </tr>
            <tr>
                <th align="center" >Con quién</th>
                <th align="center" >Monto del crédito</th>
                <th align="center" >Mensualidad</th>
                <th align="center" >Plazo</th>
                <th align="center" >Saldo</th>
                <th>&nbsp;</th>
            </tr>
            <?php 
                if($fsm['creditos']): 
                    foreach ($fsm['creditos'] as $cred): 
            ?>
                    <tr>
                        <td>
                            <?php echo $cred['quien']; ?>
                        </td>
                        <td>
                            <?php echo $cred['monto']; ?>
                        </td>
                        <td>
                            <?php echo $cred['mensualidad']; ?>
                        </td>
                        <td>
                            <?php echo $cred['plazo']; ?>
                        </td>
                        <td>
                            <?php echo $cred['saldo']; ?>
                        </td>
                        <td>
                            <a href="<?php echo base_url('persona/socio_eco_del_cred/'.$fsm['fsm_id'].'/'.$cred['credito_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg"> </i></a>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr class="row-form">
                <td>
                    <input type="text" name="credito[0][quien]" class="form-control">
                </td>
                <td>
                    <input type="text" name="credito[0][monto]" class="form-control">
                </td>
                <td>
                    <input type="text" name="credito[0][mensualidad]" class="form-control">
                </td>
                <td>
                    <input type="text" name="credito[0][plazo]" class="form-control">
                </td>
                <td colspan="2">
                    <input type="text" name="credito[0][saldo]" class="form-control">
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <th colspan="4" align="center" class="header-table-secondary" >
                    SEGUROS
                    <button class="btn btn-primary btn-sm btn-add pull-right">
                        <span class=" glyphicon glyphicon-plus" aria-hidden="true"></span> 
                    </button>
                </th>
            </tr>
            <tr>
                <th align="center" >Tipo</th>
                <th align="center" >Aseguradora</th>
                <th align="center" >Monto Mensual</th>
                <th align="center" >&nbsp;</th>
            </tr>
            <?php 
                if($fsm['seguros']): 
                    foreach ($fsm['seguros'] as $seg): 
            ?>
                    <tr>
                        <td>
                            <?php echo get_cat_nombre('SEGURO', $seg['tipo']); ?>
                        </td>
                        <td>
                            <?php echo $seg['aseguradora']; ?>
                        </td>
                        <td>
                            <?php echo $seg['monto']; ?>
                        </td>
                        <td>
                            <a href="<?php echo base_url('persona/socio_eco_del_seg/'.$fsm['fsm_id'].'/'.$seg['seguro_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg"> </i></a>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr class="row-form">
                <td>
                    <select name="seguro[0][tipo]" class="form-control">
                        <option value="">Selecciona</option>
                        <?php echo get_options('SEGURO'); ?>
                    </select>
                </td>
                <td>
                    <input type="text" name="seguro[0][aseguradora]" class="form-control">
                </td>
                <td colspan="2">
                    <input type="text" name="seguro[0][monto]" class="form-control">
                </td>
            </tr>
        </table> 
        <table border="1" class="table">
            <tr>
                <th colspan="4" align="center" class="header-table-secondary" >INGRESOS</th>
                <th colspan="2" align="center" class="header-table-secondary">EGRESOS</th>
            </tr>
            <tr>
                <th align="center" >PERSONAS QUE APORTAN AL GASTO FAMILIAR</th>
                <th align="center" >INGRESO MENSUAL</th>
                <th align="center" >APORTACIÓN MENSUAL</th>
                <th align="center" >VIVE CON EL EVALUADO</th>
                <th align="center" >CONCEPTO</th>
                <th align="center" >EGRESOS MENSUALES</th>
            </tr>
            <?php 
                $ingresos_cat = get_radio_options_var('INGRESO');
                $egresos_cat = get_radio_options_var('EGRESO');
                
                $limite = (count($ingresos_cat) >= count($egresos_cat))?count($ingresos_cat):count($egresos_cat);
                
                $suma_ingreso_mensual = 0;
                $suma_ingreso_aporta = 0;
                $suma_egreso_mensual = 0;
                
                for($i = 0; $i < $limite; $i++)
                {
                    $indice = '';
                    $indice_egreso = '';
                ?>
            <tr>
                <td>
                    <?php if(isset($ingresos_cat[$i])): ?>
                        <?php echo $ingresos_cat[$i]['cat_nombre']; ?>
                        <input type="hidden" name="ingreso[<?php echo $i; ?>][tipo_cve]" value="<?php echo $ingresos_cat[$i]['cat_cve']; ?>" />
                        <?php $indice = busca_ingreso($ingresos_cat[$i]['cat_cve'], $fsm['ingresos']); ?>
                        <?php if($indice !== FALSE): ?>
                            <input type="hidden" name="ingreso[<?php echo $i; ?>][ingreso_id]" value="<?php echo get_ingreso($indice,$fsm['ingresos'],'ingreso_id'); ?>" />
                        <?php endif; ?>
                        <?php if($ingresos_cat[$i]['cat_cve'] == 'OTRO'): ?>
                            <input type="text" name="ingreso_otro" value="<?php echo $fsm['ingreso_otro']; ?>" class="form-control" />
                        <?php endif; ?>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if(isset($ingresos_cat[$i])): 
                        $ingreso_mensual = get_ingreso($indice,$fsm['ingresos'],'mensual'); 
                        $suma_ingreso_mensual = $suma_ingreso_mensual + $ingreso_mensual;
                    ?>
                    <input type="text" name="ingreso[<?php echo $i; ?>][mensual]" class="form-control ingreso_mensual" value="<?php echo $ingreso_mensual ?>" />
                    <?php endif; ?>
                </td>
                <td>
                    <?php if(isset($ingresos_cat[$i])):  
                        $aportacion_mensual = get_ingreso($indice,$fsm['ingresos'],'aportacion'); 
                        $suma_ingreso_aporta = $suma_ingreso_aporta + $aportacion_mensual;
                    ?>
                    <input type="text" name="ingreso[<?php echo $i; ?>][aportacion]" class="form-control ingreso_aportacion" value="<?php echo $aportacion_mensual; ?>"/>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if(isset($ingresos_cat[$i])): ?>
                        <?php if($ingresos_cat[$i]['cat_cve'] != 'EVAL'): ?>
                            <?php echo get_radio_options('AFIRMA', 'ingreso['.$i.'][vive_con]',get_ingreso($indice,$fsm['ingresos'],'vive_con')); ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if(isset($egresos_cat[$i])): ?>
                        <?php echo $egresos_cat[$i]['cat_nombre']; ?>
                        <?php if($egresos_cat[$i]['cat_cve'] == 'OTRO'): ?>
                            <input type="text" name="egreso_otro" value="<?php echo $fsm['egreso_otro']; ?>" class="form-control" />
                        <?php endif; ?>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if(isset($egresos_cat[$i])): ?>
                        <?php $indice_egreso = busca_ingreso($egresos_cat[$i]['cat_cve'], $fsm['egresos']); ?>
                        <?php if($indice_egreso !== FALSE): ?>
                            <input type="hidden" name="egreso[<?php echo $i; ?>][egreso_id]" value="<?php echo get_ingreso($indice_egreso,$fsm['egresos'],'egreso_id'); ?>" />
                        <?php endif; ?>
                        <?php 
                            $egreso_mensual = get_ingreso($indice_egreso,$fsm['egresos'],'mensual');
                            $suma_egreso_mensual = $suma_egreso_mensual + $egreso_mensual;
                        ?>
                        <input type="hidden" name="egreso[<?php echo $i ?>][tipo_cve]" value="<?php echo $egresos_cat[$i]['cat_cve']; ?>" />
                        <input type="text" name="egreso[<?php echo $i ?>][mensual]" class="form-control egreso_mensual" value="<?php echo $egreso_mensual; ?>" />
                    <?php endif; ?>
                </td>
            </tr>
        <?php } ?>
            <tr>
                <th align="center" class="header-table-secondary" >TOTAL</th>
                <th align="center" class="header-table-secondary" >
                    <input type="text" name="" id="ingreso_mensual" readonly class="form-control" value="<?php echo number_format($suma_ingreso_mensual,2); ?>">
                </th>
                <th align="center" class="header-table-secondary" >
                    <input type="text" name="" id="ingreso_aportacion" readonly class="form-control" value="<?php echo number_format($suma_ingreso_aporta,2); ?>">
                </th>
                <th align="center" class="header-table-secondary" ></th>
                <th align="center" class="header-table-secondary" >TOTAL</th>
                <th align="center" class="header-table-secondary" >
                    <input type="text" name="" id="egreso_mensual" readonly class="form-control" value="<?php echo number_format($suma_egreso_mensual,2); ?>">
                </th>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <td width="30%">Diferencia entre los ingresos y los egresos:</td>
                <td>
                    <input type="text" name="dif_ingr_egre" id="ingreso_egreso" readonly class="form-control" value="<?php echo number_format($suma_ingreso_aporta - $suma_egreso_mensual,2); ?>">
                </td>
            </tr>
            <tr>
                <td>¿Cómo se solventa el déficit?</td>
                <td>
                    <input type="text" name="deficit" class="form-control" value="<?php echo $fsm['deficit']; ?>" />
                </td>
            </tr>
            <tr>
                <td>¿Qué se hace con el excedente?</td>
                <td>
                    <input type="text" name="excedente" class="form-control" value="<?php echo $fsm['excedente']; ?>" />
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <td colspan="4" class="header-table">
                    <b>8. ASPECTO SOCIO - CULTURALES</b>
                </td>
            </tr>
            <tr>
                <td>Religión:</td>
                <td>
                    <select name="religion" class="form-control">
                        <option value="">Selecciona</option>
                        <?php echo get_options_relig($fsm['religion']); ?>
                    </select>
                </td>
                <td>Partido político al que pertenece:</td>
                <td>
                    <input type="text" name="partido_pol" class="form-control" value="<?php echo $fsm['partido_pol']; ?>" />
                </td>
            </tr>
            <tr>
                <td>Deporte que practica:</td>
                <td>
                    <input type="text" name="deporte" class="form-control" value="<?php echo $fsm['deporte']; ?>" />
                </td>
                <td>Frecuencia:</td>
                <td>
                    <input type="text" name="frecuencia" class="form-control" value="<?php echo $fsm['frecuencia']; ?>" />
                </td>
            </tr>
            <tr>
                <td>¿Pertenece a algún club social o deportivo?</td>
                <td>
                    <?php echo get_radio_options('AFIRMA', 'club_dep',$fsm['club_dep']); ?>
                </td>
                <td>¿Cuál?</td>
                <td>
                    <input type="text" name="nombre_club" class="form-control" value="<?php echo $fsm['nombre_club']; ?>" />
                </td>
            </tr>
            <tr>
                <td>Actividades que realiza en su tiempo libre:</td>
                <td colspan="3">
                    <input type="text" name="act_libre" class="form-control" value="<?php echo $fsm['act_libre']; ?>" />
                </td>
            </tr>
            <tr>
                <td>METAS A CORTO PLAZO (menos de un año)</td>
                <td colspan="3">
                    <input type="text" name="metas_cortas" class="form-control" value="<?php echo $fsm['metas_cortas']; ?>" />
                </td>
            </tr>
            <tr>
                <td>METAS A MEDIANO PLAZO (más de un año, menos de cinco)</td>
                <td colspan="3">
                    <input type="text" name="metas_mediano" class="form-control" value="<?php echo $fsm['metas_mediano']; ?>" />
                </td>
            </tr>
        </table>
        <br>
        <table border="1" class="table">
            <tr>
                <td colspan="5" class="header-table">
                    <b>9. VISITA DOMICILIARIA</b>
                </td>
            </tr>
            <tr>
                <td colspan="5" class="header-table-secondary">
                    <b>9.1 Características de la vivienda</b>
                </td>
            </tr>
            <tr>
                <th colspan="5">La vivienda es:</th>
            </tr>
            <tr>
                <td colspan="4">
                    <?php echo get_radio_options('TCASA', 'tipo_vivienda',$fsm['tipo_vivienda']); ?>
                </td>
                <td>
                    <input type="text" name="tipo_vivienda_otro" class="form-control" value="<?php echo ($fsm['tipo_vivienda'] == 'OTRO')?$fsm['tipo_vivienda_otro']:''; ?>">
                </td>
            </tr>
            <tr>
                <th colspan="5">Estructura de la vivienda:</th>
            </tr>
            <tr>
                <td colspan="5">
                    <?php echo get_radio_options('ECASA', 'est_vivienda',$fsm['est_vivienda']); ?>
                </td>
            </tr>
            <tr>
                <th colspan="5">Tipo de construcción:</th>
            </tr>
            <tr>
                <td>
                    Paredes:
                </td>
                <td colspan="3">
                    <?php echo get_radio_options('TMATERIAL', 'paredes',$fsm['paredes']); ?>
                </td>
                <td>
                    <input type="text" name="paredes_otro" class="form-control" value="<?php echo ($fsm['paredes'] == 'OTRO')?$fsm['paredes_otro']:''; ?>">
                </td>
            </tr>
            <tr>
                <td>
                    Techos:
                </td>
                <td colspan="3">
                    <?php echo get_radio_options('TMATERIAL', 'techos',$fsm['techos']); ?>
                </td>
                <td>
                    <input type="text" name="techos_otro" class="form-control" value="<?php echo ($fsm['techos'] == 'OTRO')?$fsm['techos_otro']:''; ?>">
                </td>
            </tr>
            <tr>
                <td>
                    Pisos:
                </td>
                <td colspan="3">
                    <?php echo get_radio_options('TPISO', 'pisos',$fsm['pisos']); ?>
                </td>
                <td>
                    <input type="text" name="pisos_otro" class="form-control" value="<?php echo ($fsm['pisos'] == 'OTRO')?$fsm['pisos_otro']:''; ?>">
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <th colspan="4">Distribución de la vivienda:</th>
            </tr>
            <tr>
                <th align="center"  ></th>
                <th align="center"  >CANTIDAD</th>
                <th align="center"  ></th>
                <th align="center"  >CANTIDAD</th>
            </tr>
            <tr>
                <td>Sala</td>
                <td>
                    <input type="number" name="sala" class="form-control" value="<?php echo $fsm['sala']; ?>">
                </td>
                <td>Número de dormitorios</td>
                <td>
                    <input type="number" name="dormitorios" class="form-control" value="<?php echo $fsm['dormitorios']; ?>">
                </td>
            </tr>
            <tr>
                <td>Comedor</td>
                <td>
                    <input type="number" name="comedor" class="form-control" value="<?php echo $fsm['comedor']; ?>">
                </td>
                <td>Zotehuela</td>
                <td>
                    <input type="number" name="zotehuela" class="form-control" value="<?php echo $fsm['zotehuela']; ?>">
                </td>
            </tr>
            <tr>
                <td>Cocina</td>
                <td>
                    <input type="number" name="cocina" class="form-control" value="<?php echo $fsm['cocina']; ?>">
                </td>
                <td>Jardín</td>
                <td>
                    <input type="number" name="jardin" class="form-control" value="<?php echo $fsm['jardin']; ?>">
                </td>
            </tr>
            <tr>
                <td>Baños completos</td>
                <td>
                    <input type="number" name="completos_b" class="form-control" value="<?php echo $fsm['completos_b']; ?>">
                </td>
                <td>Cochera o estacionamiento</td>
                <td>
                    <input type="number" name="cochera" class="form-control" value="<?php echo $fsm['cochera']; ?>">
                </td>
            </tr>
            <tr>
                <td>Medios baños</td>
                <td>
                    <input type="number" name="medios_b" class="form-control" value="<?php echo $fsm['medios_b']; ?>">
                </td>
                <td>Número de focos</td>
                <td>
                    <input type="number" name="focos" class="form-control" value="<?php echo $fsm['focos']; ?>">
                </td>
            </tr>
            <tr>
                <td>Baños compartidos</td>
                <td>
                    <input type="number" name="compartidos_b" class="form-control" value="<?php echo $fsm['compartidos_b']; ?>">
                </td>
                <td>Otros, cuáles:
                <input type="text" name="otros_dist" class="form-control" value="<?php echo $fsm['otros_dist']; ?>"></td>
                <td>
                    <input type="number" name="otros_dist_n" class="form-control" value="<?php echo $fsm['otros_dist_n']; ?>">
                </td>
            </tr>
            <tr>
                <td>¿Cómo comparten los dormitorios?</td>
                <td colspan="3">
                    <input type="text" name="como_dormitorios" class="form-control" value="<?php echo $fsm['como_dormitorios']; ?>">
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <th colspan="5">Servicios con que cuenta la vivienda:</th>
            </tr>
            <tr>
                <td colspan="5">
                    <?php echo get_checkbox_options('SERVICIOS', 'servicios[]', explode(',',$fsm['servicios'])); ?>
                </td>
            </tr>
            <tr>
                <td colspan="5">
                    <input type="text" name="servicio_otro" class="form-control" value="<?php echo (in_array('OTRO',explode(',',$fsm['servicios'])))?$fsm['servicio_otro']:''; ?>">
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <th colspan="3">Aparatos electrónicos:</th>
            </tr>
            <tr>
                <th align="center" class="" >ARTÍCULO</th>
                <th align="center" class="" >CANTIDAD</th>
                <th align="center" class="" >VALOR APROXIMADO</th>
            </tr>           
            
            <?php 
                $mobiliario_cat = get_radio_options_var('INMOBILIARIO');
                $i = 0;
                foreach ($mobiliario_cat as $mobi):
                    $indice = '';
            ?>
            <tr>
                <td>
                    <?php echo $mobi['cat_nombre']; ?>
                    <input type="hidden" name="mobiliario[<?php echo $i; ?>][tipo_cve]" value="<?php echo $mobi['cat_cve']; ?>" />
                    <?php $indice = busca_ingreso($mobi['cat_cve'], $fsm['mobiliarios']); ?>
                    <?php if($indice !== FALSE): ?>
                        <input type="hidden" name="mobiliario[<?php echo $i; ?>][mobiliario_id]" value="<?php echo get_ingreso($indice,$fsm['mobiliarios'],'mobiliario_id'); ?>" />
                    <?php endif; ?>
                </td>
                <td>
                    <input type="number" name="mobiliario[<?php echo $i; ?>][cantidad]" class="form-control" value="<?php echo get_ingreso($indice,$fsm['mobiliarios'],'cantidad'); ?>" />
                </td>
                <td>
                    <input type="text" name="mobiliario[<?php echo $i; ?>][valor]" class="form-control" value="<?php echo get_ingreso($indice,$fsm['mobiliarios'],'valor'); ?>" />
                </td>
            </tr>
            <?php $i++;  endforeach; ?>
            <tr>
                <td>
                    OTRO: <input type="text" name="mobiliario_otro" class="form-control" value="<?php echo $fsm['mobiliario_otro']; ?>">
                </td>
                <td>
                    <input type="number" name="mobiliario_cant" class="form-control" value="<?php echo $fsm['mobiliario_cant']; ?>">
                </td>
                <td>
                    <input type="text" name="mobiliario_valor" class="form-control" value="<?php echo $fsm['mobiliario_valor']; ?>">
                </td>
            </tr>
        </table>
        
        <table border="1" class="table">
            <tr>
                <td class="header-table-secondary">
                    <b>9.2 Vías de acceso</b>
                </td>
            </tr>
            <tr>
                <th>Avenida(s) principal(es):</th>
            </tr>
            <tr>
                <td>
                    <input type="text" name="avd_principales" class="form-control"  value="<?php echo $fsm['avd_principales']; ?>">
                </td>
            </tr>
            <tr>
                <th>Entre qué calles se localiza el domicilio:</th>
            </tr>
            <tr>
                <td>
                    <input type="text" name="entre_calles" class="form-control" value="<?php echo $fsm['entre_calles']; ?>">
                </td>
            </tr>
            <tr>
                <th>Referencias de ubicación:</th>
            </tr>
            <tr>
                <td>
                    <input type="text" name="referencias_ub" class="form-control" value="<?php echo $fsm['referencias_ub']; ?>">
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <td colspan="6" class="header-table-secondary">
                    <b>9.3 Transporte cercano</b>
                </td>
            </tr>
            <tr>
                <td colspan="5">
                    <?php echo get_checkbox_options('TRANS', 'transporte[]', explode(',',$fsm['transporte'])); ?>
                </td>
                <td>
                    <input type="text" name="transp_otro" class="form-control" value="<?php echo (in_array('OTRO',explode(',',$fsm['transporte'])))?$fsm['transp_otro']:''; ?>">
                </td>
            </tr>
        </table>
        
        <table border="1" class="table">
            <tr>
                <td colspan="6" class="header-table-secondary">
                    <b>9.4 Clase de vivienda</b>
                </td>
            </tr>
            <tr>
                <td colspan="5">
                    <?php echo get_radio_options('CCASA', 'clase_v', $fsm['clase_v']); ?>
                </td>
                <td>
                    <input type="text" name="clase_v_otro" class="form-control" value="<?php echo ($fsm['clase_v'] == 'OTRO')?$fsm['clase_v_otro']:''; ?>">
                </td>
            </tr>
        </table>
        
        <table border="1" class="table">
            <tr>
                <td colspan="4" class="header-table-secondary">
                    <b>9.5 Zona de ubicación</b>
                </td>
            </tr>
            <tr>
                <td colspan="4">
                    <?php echo get_radio_options('ZONAU', 'zona_ub', $fsm['zona_ub']); ?>
                </td>
            </tr>
        </table>
        
        <table border="1" class="table">
            <tr>
                <td colspan="3" class="header-table-secondary">
                    <b>9.6 Nivel socioeconómico de la vivienda</b>
                </td>
            </tr>
            <tr>
                <td colspan="3">
                    <?php echo get_radio_options('NIVESOC', 'nivel_v', $fsm['nivel_v']); ?>
                </td>
            </tr>
        </table>   
        <table border="1" class="table">
            <tr>
                <td class="header-table">
                    <b>10. DICTAMEN</b>
                </td>
            </tr>
            <tr>
                <td>
                    <textarea name="dictamen" class="form-control"><?php echo $fsm['dictamen']; ?></textarea>
                </td>
            </tr>
        </table>
        <table border="1" class="table">
            <tr>
                <td colspan="3" class="header-table">
                    <b>IMÁGENES</b>
                </td>
            </tr>
            <?php if($fsm['imagenes']): ?>
                <tr>
                    <?php foreach($fsm['imagenes'] as $img): ?>
                    <td><img src="<?php echo base_url('../soc/'.$img['path']); ?>" class="img-responsive socioeconomico" style="width: 250px; height: 250px;" /><br>
                        <label class="control-label"><?php echo $img['nombre']; ?></label>
                        <a href="<?php echo base_url('persona/del_soc_img/'.$fsm['fsm_id'].'/'.$img['img_id']); ?>" class="delete" /><i class="fa fa-trash-o fa-lg"></i></a>
                    </td>
                    <?php endforeach; ?>
                </tr>
            <?php endif; ?>
                <?php if(count($fsm['imagenes']) < 3): ?>
            <tr>
                <td colspan="3">
                    <input id="logo" name="socio-img" type="file" class="file-loading">
                    <label>Nombre de la imagen:</label>
                    <input type="text" id="input_name" value="" class="form-control">
                </td>
            </tr>
            <?php endif; ?>
        </table>
        <div class="text-center">
        <div class="text-center">
                <div class="firma">
                    <canvas id="signature-pad-pac" class="signature-pad-pac"  width="600px" height="400px"></canvas>
                </div>
                <div class="div-firma">
                  <a href="#" class="btn" id="save-pac">Guardar</a>
                  <a href="#" class="btn" id="clear-pac">Limpiar</a>
                  <input type="hidden" id="firma_pac" name="firma_pac" value="" />
                </div>
                <?php if($fsm['fsm_firma_pac'] != 'NULL'): ?>
                  <img class="firma-img" src="<?php echo $fsm['fsm_firma_pac']; ?>" />
                <?php endif; ?><br>
                <b>FIRMA PACIENTE </b>
            </div>
            <div class="text-center">
                <div class="firma">
                    <canvas id="signature-pad" class="signature-pad" width="600px" height="400px"></canvas>
                </div>
                <div class="div-firma">
                  <a href="#" class="btn" id="save">Guardar</a>
                  <a href="#" class="btn" id="clear">Limpiar</a>
                  <input type="hidden" id="firma_med" name="firma_med" value="" />
                </div>
                <?php if($fsm['fsm_firma_med'] != 'NULL'): ?>
                  <img class="firma-img" src="<?php echo $fsm['fsm_firma_med']; ?>" />
                <?php endif; ?><br>
                <b>FIRMA MÉDICO</b>
            </div>
        </div>
        <p>
            FECHA DE REALIZACIÓN: <?php echo formatea_fecha(date('Y-m-d'), strtotime($fsm['fecha_eval'])); ?>
        </p>
        <p align="right">
            <!--<b>FSM-04</b>-->
        </p>
    </div>
    <div class="panel-footer clearfix">
        <div class="pull-right">
            <button class="btn btn-success">Actualizar</button>
        </div>
    </div>
    </form>
</div>
</div>
<script src="<?php echo base_url('../dist/js/cliente.js'); ?>"></script>
<script src="<?php echo base_url('../vendor/signaturepad/js/signature_pad.js'); ?>"></script>
<script src="<?php echo base_url('../dist/js/firma.js'); ?>"></script>
<script>
$(function() {
    $('.ingreso_mensual').on('change', function(){
        
        $val_input = $(this).val();
        $id_total = '#ingreso_mensual';
        $val_float = parseFloat($val_input.replace(",", ""));
        $suma_ingreso = 0;
        
        if(isNaN($val_float)){
            $val_float = 0;
            $(this).val($val_float);
        }
        
        $.each($('.ingreso_mensual'),function(i,k){
            var num = parseFloat($(k).val());
            if(isNaN(num)){
                num = 0;
            }
            $suma_ingreso = $suma_ingreso + num;
        });

        $($id_total).val($suma_ingreso);
        
        $ingreso_mensual = (isNaN(parseFloat($('#ingreso_mensual').val())))?0:parseFloat($('#ingreso_mensual').val());
        $egreso_mensual =  (isNaN(parseFloat($('#egreso_mensual').val())))?0:parseFloat($('#egreso_mensual').val());
        
        $ingreso_egreso = $ingreso_mensual - $egreso_mensual;
        $('#ingreso_egreso').val($ingreso_egreso);
    });
    
    $('.ingreso_aportacion').on('change', function(){
        
        $val_input = $(this).val();
        $id_total = '#ingreso_aportacion';
        $val_float = parseFloat($val_input.replace(",", ""));
        $suma_ingreso = 0;
        
        if(isNaN($val_float)){
            $val_float = 0;
            $(this).val($val_float);
        }
        
        
        $.each($('.ingreso_aportacion'),function(i,k){
            var num = parseFloat($(k).val());
            if(isNaN(num)){
                num = 0;
            }
            $suma_ingreso = $suma_ingreso + num;
        });
        $($id_total).val($suma_ingreso);
    });
    
    $('.egreso_mensual').on('change', function(){
        
        $val_input = $(this).val();
        $id_total = '#egreso_mensual';
        $val_float = parseFloat($val_input.replace(",", ""));
        $suma_ingreso = 0;
        
        if(isNaN($val_float)){
            $val_float = 0;
            $(this).val($val_float);
        }
        
        
        $.each($('.egreso_mensual'),function(i,k){
            var num = parseFloat($(k).val());
            if(isNaN(num)){
                num = 0;
            }
            $suma_ingreso = $suma_ingreso + num;
        });
        $($id_total).val($suma_ingreso);
        
        $ingreso_mensual = (isNaN(parseFloat($('#ingreso_mensual').val())))?0:parseFloat($('#ingreso_mensual').val());
        $egreso_mensual =  (isNaN(parseFloat($('#egreso_mensual').val())))?0:parseFloat($('#egreso_mensual').val());
        
        $ingreso_egreso = $ingreso_mensual - $egreso_mensual;
        $('#ingreso_egreso').val($ingreso_egreso);
    });
    
    $('.btn-add').on('click', function(e){
        e.preventDefault();
        $tableCurrent = $(this).closest('table');
        $rowForms = $tableCurrent.find('.row-form').length;
        $rowForms = parseInt($rowForms) + 1;
        $htmlTr = $tableCurrent.find('.row-form').eq(0).clone().html();
        $htmlTrNew = $htmlTr.replace(/\[[0-9]\]/g, "[" + $rowForms + "]");
        $("<tr class='row-form'>" + $htmlTrNew + "</tr>").insertAfter($tableCurrent.find('.row-form').eq($rowForms - 2));
    });
    
    $('.btn-del').on('click', function(e){
        e.preventDefault();
        $(this).closest('tr').remove();
    });
});
</script>

<input type="hidden" value="persona/upload_soc/" id="form_soc" />

<!-- fileinputcss -->
<link href="<?php echo base_url('../vendor/bootstrap-fileinput/css/fileinput.min.css'); ?>" rel="stylesheet">
<!-- fileinput -->
<script src="<?php echo base_url('../vendor/bootstrap-fileinput/js/fileinput.min.js'); ?>"></script>
<script src="<?php echo base_url('../vendor/bootstrap-fileinput/js/locales/es.js'); ?>"></script>

<script src="<?php echo base_url('../dist/js/upload_file.js'); ?>"></script>