<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Entorno_social_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    function add($data_insert)
    {
        $this->db->insert('entorno_soc', $data_insert);
        return $this->db->insert_id();
    }

    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc');
        $this->db->where('fsm_id', $fsm_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }*/
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }			
        $result = $this->db->get();
        return $result->row_array();
    }
    
    function update($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('entorno_soc', $params);
    } 
    
    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc');
        $this->db->where('clte_id', $cliente_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());  
        }*/
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }			
        $this->db->order_by('fecha_eval','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*inserta los empleos*/
    function insert_empleos($empleos, $fsm_id)
    {
        $insert_id = null;
        if(!empty($empleos))
        {
            foreach($empleos as $empleo)
            {
                if(trim($empleo['empresa']) != "")
                {
                    $empleo['f_ingreso'] = formatea_fecha_mysql($empleo['f_ingreso']);
                    if(isset($empleo['f_salida']))
                    {
                        $empleo['f_salida'] = formatea_fecha_mysql($empleo['f_salida']);
                    }
                    $empleo['fsm_id'] = $fsm_id;
                    $this->db->insert('entorno_soc_empleo',$empleo);
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
    function insert_arreglo($array, $columna_val, $fsm_id, $tabla)
    {
        $insert_id = null;

        if(!empty($array))
        {
            foreach($array as $row)
            {
                if(trim($row[$columna_val]) != "")
                {
                    $row['fsm_id'] = $fsm_id;
                    $this->db->insert($tabla,  array_to_upper($row));
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
    function update_arreglo($array, $columna_val, $id, $fsm_id, $tabla)
    {
        $insert_id = null;
        if(!empty($array))
        {
            foreach($array as $row)
            {
                if(trim($row[$columna_val]) != "")
                {
                    if(isset($row[$id]))
                    {
                        $column_id = $row[$id];
                        unset($row[$id]);
                        $this->db->where($id, $column_id);
                        $this->db->update($tabla,  array_to_upper($row));
                    }
                    else
                    {
                        $row['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert($tabla,  array_to_upper($row));
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
    function update_empleos($empleos, $fsm_id, $id)
    {
        $insert_id = null;
        if(!empty($empleos))
        {
            foreach($empleos as $empleo)
            {
                if(trim($empleo['empresa']) != "")
                {
                    $empleo['f_ingreso'] = formatea_fecha_mysql($empleo['f_ingreso']);
                    if(isset($empleo['f_salida']))
					{
                        $empleo['f_salida'] = formatea_fecha_mysql($empleo['f_salida']);
                    }
                    
                    if($empleo['empleo_id'] > 0) //if(isset($empleo['empleo_id']))
                    {
                        $empleo_id = $empleo['empleo_id'];//$empleo_id = $empleo[$id];
                        //unset($empleo[$id]);
                        //$this->db->where($id, $empleo_id);
						
						$this->db->where('empleo_id', $empleo_id);
                        $this->db->update('entorno_soc_empleo',  array_to_upper($empleo));
                    }
                    else 
                    {
                        $empleo['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('entorno_soc_empleo',  array_to_upper($empleo));
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
    /*
     * Get all escuelas by fsm_id
     */
    function get_escuelas($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_academico');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * Get all familiares by fsm_id
     */
    function get_familiares($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_familiar');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * Get all empleos by fsm_id
     */
    function get_empleos($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_empleo');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * Get all referencias_personales by fsm_id
     */
    function get_ref_personales($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_ref_personal');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * Get all ingresos by fsm_id
     */
    function get_ingresos($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_ingreso');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * Get all egresos by fsm_id
     */
    function get_egresos($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_egreso');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    
    /*
     * Get all mobiliarios by fsm_id
     */
    function get_mobiliarios($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_mobiliario');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    function get_imagenes($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_imagenes');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    function insert_imagen($data_insert)
    {
        $this->db->insert('entorno_soc_imagenes', $data_insert);
        return $this->db->insert_id();
    }
    
    function delete_imagen($fsm_id,$id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('img_id', $id);
        return $this->db->delete('entorno_soc_imagenes');
    }
    
    function delete_escuela($fsm_id,$id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('acad_id', $id);
        return $this->db->delete('entorno_soc_academico');
    }
    
    function delete_familiar($fsm_id,$id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('fam_id', $id);
        return $this->db->delete('entorno_soc_familiar');
    }
    
    function delete_referencia($fsm_id,$id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('ref_pers_id', $id);
        return $this->db->delete('entorno_soc_ref_personal');
    }
}