<html>
<head>
    <meta charset="utf-8" />
    <style>
        .color-primary {
            color: #175b9b;
        }
        
        .color-secondary {
            color: #42B7F2;
        }
        
        .contenedor {
            width: 100%;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .header {
            background-color: #175b9b;
            font-size: 18px;
            color: #ffffff;
            padding: 1px 10px;
        }
        
        .header h3 {
            margin-top: 10px; 
            margin-bottom: 10px; 
        }
        
        .contenido {
            padding: 10px;
        }
        
        .footer {
            padding: 10px;
            background-color: #eee;
            border: 2px #ddd solid;
        }
    </style>
</head>
<body>
    <div class="contenedor">
        <div class="header">
            <h3>Mi<span class="color-secondary">Consultorio</span>.Digital</h3>
        </div>
        <div class="contenido">
            <p>
                <b>Hola <?php echo ucwords(mb_strtolower($user['usr_nombre'].' '.$user['usr_paterno'].' '.$user['usr_materno'])); ?></b>
            </p>
            <p>
                Tu cuenta se activó Exitosamente !!
            </p>
            <p>
                Te damos la más cordial bienvenida y agradecemos la oportunidad que nos brindas de conocernos.
                <br>
                Esperamos que tu experiencia sea muy satisfactoria !!!
                <br>
                <br>
                A continuación confirmamos las características del plan:
            </p>
            <div style="width: 80%; margin:0 auto;">
                <table width="100%" cellspacing="5" cellpading="5">
                    <tbody>
                        <tr>
                            <td><b>Plan:</b></td>
                            <td><?php echo $plan['plan_nombre']; ?></td>
                        </tr>
                        <tr>
                            <td><b>Precio (IVA Incluido):</b></td>
                            <td><?php echo number_format($plan['plan_precio_mxp']*1.16,2); ?> MXN / mensual</td>
                        </tr>
                        <tr>
                            <td><b>Descuento durante <?php echo $plan['plan_descto_vigencia']; ?> meses:</b></td>
                            <td><?php echo number_format($plan['plan_descto'],2); ?>%</td>
                        </tr>
                        <tr>
                            <td><b>Periodo de evaluación:</b></td>
                            <td><?php echo ($plan['plan_meses_eval'] > 1)?$plan['plan_meses_eval'].' meses':$plan['plan_meses_eval'].' mes' ?></td>
                        </tr>
                        <tr>
                            <td><b>Fecha de Activación:</b></td>
                            <td><?php echo formatea_fecha(date('Y-m-d')); ?></td>
                        </tr>
                        <tr>
                            <td><b>Fecha de término de evaluación:</b></td>
                            <td>
                                <?php
                                    $meses_prueba = $plan['plan_meses_eval'];
                                    $fecha = new DateTime('now');
                                    $fecha->add(new DateInterval('P'.$meses_prueba.'M'));
                                    echo formatea_fecha($fecha->format('Y-m-d'));
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr>
                            <td colspan="2" align="center">
                                Al término del periodo de evaluación podrás contratar el servicio de manera mensual con descuento durante <?php echo $plan['plan_descto_vigencia']; ?> meses, pagarás solo la cantidad de:
                                <br>
                                <p style="font-size:16px;"><b><?php echo number_format(($plan['plan_precio_mxp']*1.16) * ($plan['plan_descto']/100),2); ?> MXN</b> mensual (IVA Incluido)</p>
                            <td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <p>
                La liga para acceder al sistema es: <a href="http://miconsultorio.digital/login">http://miconsultorio.digital/login</a> te recomendamos la guardes en tus favoritos.
            </p>
            <p>
                Encontrarás adjunto en este correo el aviso de privacidad y el contrato de prestación de servicios que previamente aceptaste.
            </p>
            <p>
                Atentamente,<br>
                El equipo de <b>MiConsultorio.Digital</b>
            </p>
        </div>
        <div class="footer">
            <p class="color-primary">
                Este mensaje se envió mediante un sistema automático de notificaciones. <b>Por favor no lo respondas.</b>
            </p>
        </div>
    </div>
</body>
</html>