<?php
date_default_timezone_set('America/Mexico_City');

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bitácora de Servicio TI</title>
    <!-- Enlace a CSS Bootstrap para responsividad -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Enlace a Signature Pad para el campo de firma -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/signature_pad/1.5.3/signature_pad.min.js"></script>
    <link rel="stylesheet" href="./css/styles.css">

<style>
    /* Estilos para el canvas de la firma */
        .signature-pad {
            border: 2px solid #000; /* Establece un borde sólido */
            margin: 5px 0; /* Agrega un margen arriba y abajo */
        }
        /* Estilos para el botón de borrar firma */
        #clear-signature {
            border: 2px solid #000; /* Establece un borde sólido */
            margin: 5px 0; /* Agrega un margen arriba y abajo */
        }
</style>
</head>

<body>
    <div class="container-fluid">
        <div class="logo-container">
            <img src="./assets/logos/hc.png" alt="Logo" class="logo">
        </div>
        <!-- El resto de tu contenido aquí -->

    <div class="container">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h2>Bitácora de Servicio TI</h2>
            <!-- Botón para redireccionar a la página de búsqueda -->
            <div class="form-group">
                <a href="resultados.php" class="btn btn-info">Buscar por Fecha</a>
            </div>
        </div>
            <!-- Campos del formulario aquí -->
        <form method="POST" action="carga.php" id="formularioServicio">            
            <!-- Campo Programado/Directo/Ticket -->
            <div class="form-group">
                <label for="tipo">Programado/Directo/Ticket</label>
                <select class="form-control" id="tipo" name="t_tipo">
                    <option value="Programado">Programado</option>
                    <option value="Directo">Directo</option>
                    <option value="Ticket">Ticket</option>
                </select>
            </div>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    var tipoSelect = document.getElementById('tipo');
                    var campoNumeroTicket = document.getElementById('campo_numero_ticket'); // Referencia al div que contiene el campo y la etiqueta

                    tipoSelect.addEventListener('change', function() {
                        if (this.value === 'Ticket') {
                            campoNumeroTicket.style.display = ''; // Mostrar si la opción es 'Ticket'
                        } else {
                            campoNumeroTicket.style.display = 'none'; // Ocultar para cualquier otra opción
                        }
                    });
                });
            </script>
            <!-- Campo Número del Ticket, inicialmente oculto -->
            <div class="form-group" id="campo_numero_ticket" style="display:none;">
                <label for="numero_ticket"># Ticket</label>
                <input type="text" class="form-control" id="numero_ticket" name="t_nticket">
            </div>
            <!-- Campo Fecha -->
            <div class="form-group">
                <label for="fecha">Fecha</label>
                <input type="date" class="form-control" id="fecha" name="t_fecha" value="<?php echo date('Y-m-d'); ?>">
            </div>
            <!-- Campo Nombre del Usuario -->
            <div class="form-group">
                <label for="nombre_usuario">Nombre del Usuario</label>
                <input type="text" class="form-control" id="nombre_usuario" name="t_usuario">
            </div>
            <!-- Campo Unidad Funcional -->
            <div class="form-group">
                <label for="unidad_funcional">Unidad Funcional</label>
                <select class="form-control" id="unidad_funcional" name="t_unidad">
                    <option value="SAN BORJA">SAN BORJA</option>
                    <option value="LA VIGA">LA VIGA</option>
                    <option value="MTY">MONTERREY</option>
                    <option value="SAN JUAN">SAN JUAN DEL RIO</option>
                </select>
            </div>
            <!-- Campo Espacio Funcional -->
            <div class="form-group">
                <label for="espacio_funcional">Espacio Funcional</label>
                <select class="form-control" id="espacio_funcional" name="t_espacio">
                    <option value="Administracion">Administración</option>
                    <option value="Calidad">Calidad</option>
                    <option value="Compras">Compras</option>
                    <option value="Consultorio">Consultorio</option>
                    <option value="Direccion">Dirección</option>
                    <option value="Juridico">Jurídico</option>
                    <option value="Laboratorio">Laboratorio</option>
                    <option value="Poligrafia">Poligrafía</option>
                    <option value="Recursos_humanos">Recursos Humanos</option>
                </select>
            </div>
            <input type="hidden" id="espacio_funcional_seleccionado" name="espacio_funcional_seleccionado">
            <!-- Campo Tipo de Servicio -->
            <div class="form-group">
                <label for="tipo_servicio">Tipo de Servicio</label>
                <select class="form-control" id="tipo_servicio" name="t_servicio">
                    <option value="SIH">SIH (Sistemas de información)</option>
                    <option value="CAP">CAP (Capacitación)</option>
                    <option value="SAP">SAP (Servicios de Apoyo)</option>
                    <option value="IMP">IMP (Soporte Impresión e Imagen)</option>
                    <option value="COM">COM (Soporte Eqp. Computo)</option>
                    <option value="TEL">TEL (Soporte de Teléfono)</option>
                    <option value="SEG">SEG (Seguridad)</option>
                    <option value="CVE">CVE (Entrega Clave)</option>
                    <option value="OT">OTROS</option>
                </select>
            </div>
            <!-- Campo Hora de Inicio -->
            <div class="form-group">
                <label for="hora_inicio">Hora de Inicio</label>
                <input type="time" class="form-control" id="hora_inicio" name="t_horainicio" value="<?php echo date('H:i'); ?>" readonly>
                </div>
                <!-- Campo Hora de Fin -->
                <div class="form-group">
                <input type="hidden" class="form-control" id="hora_fin" name="t_horafinal" value="<?php echo date('H:i'); ?>">
                </div>
                <!-- Campo Descripción del Servicio -->
                <div class="form-group">
                <label for="descripcion_servicio">Descripción del Servicio</label>
                <textarea class="form-control" id="descripcion_servicio" name="t_descripcion"></textarea>
                </div>
                <!-- Campo de firma -->
                <div class="form-group">
                <input type="hidden" id="signature" name="t_firma">
                <!-- Se elimina el input duplicado para evitar conflictos -->
                <label>Firma</label>
                <!-- En index.php -->
                 <br>
                <canvas id="signature-pad" class="signature-pad"></canvas>                
                <button type="button" id="clear-signature" class="btn btn-secondary">Borrar Firma</button>
                <button type="button" id="confirm-signature" class="btn btn-success">Confirmar Firma</button>
                <input type="hidden" id="photo" name="t_foto">
                <button type="button" id="take-photo" class="btn btn-secondary">Tomar Foto</button>
                <button type="submit" class="btn btn-primary">Enviar</button>
                </div>
                <!-- Campo de foto -->
                <div class="form-group">
                    <label>Foto</label>
                    <br>
                    <video id="video" width="320" height="240" autoplay style="display:none;"></video>

                </div>
                
                <script>
                document.addEventListener('DOMContentLoaded', function() {
                    var video = document.getElementById('video');
                    var photoInput = document.getElementById('photo');
                    var takePhotoButton = document.getElementById('take-photo');
                
                    takePhotoButton.addEventListener('click', function() {
                        // Solicitar acceso a la cámara
                        navigator.mediaDevices.getUserMedia({ video: true })
                            .then(function(stream) {
                                video.srcObject = stream;
                                video.style.display = 'block';
                            })
                            .catch(function(err) {
                                console.error("Error al acceder a la cámara: ", err);
                                alert("No se pudo acceder a la cámara. Por favor, asegúrate de que los permisos están habilitados.");
                            });
                    });

                });
                </script>
                
                <script>
document.addEventListener('DOMContentLoaded', function() {
    var signaturePadCanvas = document.getElementById('signature-pad');
    var signaturePad = new SignaturePad(signaturePadCanvas);
    var form = document.querySelector('form');
    var signatureInput = document.getElementById('signature');
    var isSignatureConfirmed = false; // Estado de confirmación de la firma
    var isPhotoTaken = false; // Estado de toma de la foto

    document.getElementById('clear-signature').addEventListener('click', function() {
        signaturePad.clear();
        isSignatureConfirmed = false; // Restablecer la confirmación de la firma
    });

    document.getElementById('confirm-signature').addEventListener('click', function() {
        if (signaturePad.isEmpty()) {
            alert("Por favor, proporcione una firma.");
        } else {
            // Convertir la firma a base64 y almacenarla en el campo oculto
            var signatureData = signaturePad.toDataURL('image/png');
            signatureInput.value = signatureData;
            isSignatureConfirmed = true; // Marcar la firma como confirmada
            alert("Firma confirmada.");
        }
    });

    var video = document.getElementById('video');
    var photoInput = document.getElementById('photo');
    var takePhotoButton = document.getElementById('take-photo');

    takePhotoButton.addEventListener('click', function() {
        // Solicitar acceso a la cámara
        navigator.mediaDevices.getUserMedia({ video: true })
            .then(function(stream) {
                video.srcObject = stream;
                video.style.display = 'block';
            })
            .catch(function(err) {
                console.error("Error al acceder a la cámara: ", err);
                alert("No se pudo acceder a la cámara. Por favor, asegúrate de que los permisos están habilitados.");
            });
    });

    video.addEventListener('click', function() {
        var canvas = document.createElement('canvas');
        canvas.width = video.videoWidth;
        canvas.height = video.videoHeight;
        var context = canvas.getContext('2d');
        context.drawImage(video, 0, 0, canvas.width, canvas.height);
        var photoData = canvas.toDataURL('image/png');
        photoInput.value = photoData;
        video.style.display = 'none';
        video.srcObject.getTracks().forEach(track => track.stop());
        isPhotoTaken = true; // Marcar la foto como tomada
        alert("Foto tomada.");
    });

    form.addEventListener('submit', function(event) {
        if (!isSignatureConfirmed) {
            event.preventDefault();
            alert("Por favor, confirme su firma antes de enviar el formulario.");
        }
        if (!isPhotoTaken) {
            event.preventDefault();
            alert("Por favor, tome una foto antes de enviar el formulario.");
        }
    });
});


function resizeCanvas() {
    var canvas = document.querySelector('.signature-pad');
    var container = canvas.parentElement;

    // Asegura que el tamaño del canvas se ajusta correctamente al contenedor para evitar problemas de escala
    canvas.style.width ='100%';
    canvas.style.height='100%';
    canvas.width  = canvas.offsetWidth;
    canvas.height = canvas.offsetHeight;
}

function getTouchPos(canvasDom, touchEvent) {
    var rect = canvasDom.getBoundingClientRect();
    // Escala las coordenadas del toque para que coincidan con el tamaño real del canvas
    var scaleX = canvasDom.width / rect.width;   
    var scaleY = canvasDom.height / rect.height; 

    return {
        x: (touchEvent.touches[0].clientX - rect.left) * scaleX,
        y: (touchEvent.touches[0].clientY - rect.top) * scaleY
    };
}

document.addEventListener('DOMContentLoaded', function() {
    var canvas = document.querySelector('.signature-pad');

    function handleStart(evt) {
        evt.preventDefault();
        var touch = getTouchPos(canvas, evt);

        // Ahora 'touch.x' y 'touch.y' están escalados correctamente
        // Usa estas coordenadas para tus operaciones de dibujo
    }

    canvas.addEventListener('touchstart', handleStart, false);

    // No olvides agregar manejadores para 'touchmove' y 'touchend' también

    resizeCanvas();
    window.addEventListener('resize', resizeCanvas);
});
                </script>
                
                <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.getElementById('espacio_funcional').addEventListener('change', function() {
                        document.getElementById('espacio_funcional_seleccionado').value = this.value;
                    });
                });
                </script>
                <script>
                document.getElementById('espacio_funcional').addEventListener('change', function() {
                    var valorSeleccionado = this.value;
                    document.getElementById('espacio_funcional_seleccionado').value = valorSeleccionado;
                });
                </script>

                <script>
                document.addEventListener('DOMContentLoaded', function() {
                    var formulario = document.getElementById('formularioServicio'); // Asegúrate de asignar el ID correcto a tu formulario
                
                    formulario.addEventListener('submit', function() {
                        var fechaActual = new Date();
                        var hora = fechaActual.getHours().toString().padStart(2, '0');
                        var minutos = fechaActual.getMinutes().toString().padStart(2, '0');
                        document.getElementById('hora_fin').value = hora + ':' + minutos;
                    });
                });
                </script>
<?php
if (isset($_POST['imagen'])) {
    $imagen = $_POST['imagen'];
    $espacio_funcional = $_POST['espacio_funcional_seleccionado'];

    // Decodificar la imagen
    $imagen = str_replace('data:image/png;base64,', '', $imagen);
    $imagen = str_replace(' ', '+', $imagen);
    $datosImagen = base64_decode($imagen);

    // Definir la ruta donde se guardará la imagen
    $nombreArchivo = "firma_{$espacio_funcional}_" . time() . '.png';
    $rutaArchivo = 'D:/form/firmas/' . $nombreArchivo;

    // Verificar si la carpeta existe y tiene permisos de escritura
    if (!is_dir('D:/form/firmas/') || !is_writable('D:/form/firmas/')) {
        die("Error: La carpeta 'firmas' no existe o no tiene permisos de escritura.");
    }

    // Guardar la imagen en el servidor
    $resultado = file_put_contents($rutaArchivo, $datosImagen);
    if ($resultado === false) {
        die("Error al guardar la imagen en el servidor.");
    } else {
        echo "Imagen guardada correctamente en: $rutaArchivo";
    }
}

if (isset($_POST['t_foto'])) {
    $foto = $_POST['t_foto'];
    $espacio_funcional = $_POST['espacio_funcional_seleccionado'];

    // Decodificar la foto
    $foto = str_replace('data:image/png;base64,', '', $foto);
    $foto = str_replace(' ', '+', $foto);
    $datosFoto = base64_decode($foto);

    // Definir la ruta donde se guardará la foto
    $nombreArchivoFoto = "foto_{$espacio_funcional}_" . time() . '.png';
    $rutaArchivoFoto = 'D:/form/fotos/' . $nombreArchivoFoto;

    // Verificar si la carpeta existe y tiene permisos de escritura
    if (!is_dir('D:/form/fotos/') || !is_writable('D:/form/fotos/')) {
        die("Error: La carpeta 'fotos' no existe o no tiene permisos de escritura.");
    }

    // Guardar la foto en el servidor
    $resultadoFoto = file_put_contents($rutaArchivoFoto, $datosFoto);
    if ($resultadoFoto === false) {
        die("Error al guardar la foto en el servidor.");
    } else {
        echo "Foto guardada correctamente en: $rutaArchivoFoto";
    }
}
?>
</body>

</html>