﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cargasura extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','evaluado');
		
		
		$this->load->model('cargasura/Cargasura_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		
		
		$this->load->model('examen/Toxicologico_model','toxicologico5');
		$this->load->model('examen/Toxicologico_model7','toxicologico7');
		$this->load->model('examen/Quimica_sanguinea_model','qui_san');
		$this->load->model('examen/Quimica_sanguinea6_model','qui_san6');
		$this->load->helper('util');
    }
 
     public function lanza_proceso($cliente_id)
    {	
		$user = $this->session->user;
        $archivo_de_carga= $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(1)
            {

				$data_insert['serv_id']  = 0;
				$data_insert['carga_status']  = 'CARGADO';
				$data_insert['log_updt_f']  = date('Y-m-d H:i:s');
				

				$ruta_de_archivo='./../../files/cargas/'.$archivo_de_carga['carga_path_archivo'];
				$el_archivo = fopen($ruta_de_archivo, "r");
				//$data_evaluado = array();
				
				$linea=0;
				$contador=0;
				$actualizados=0;
				$insertados=0;
				while (!feof($el_archivo)) 
				{
					$data_evaluado = fgets($el_archivo);
					//$data_evaluado1=$data_evaluado;
					if ($data_evaluado)
					{	
						if ($linea > 0)
						{

							$data_evaluado=strtoupper($data_evaluado);
							$campos=explode("|",$data_evaluado);


							//$data_clte['pol_id'] =  trim($campos[0]);
							$data_clte['pol_oficina'] =  trim($campos[0]);	
							$data_clte['pol_ramo'] =  trim($campos[1]);	
							$data_clte['pol_poliza'] =  trim($campos[2]);
							$fechas=explode("/",strtoupper((trim($campos[3]))));							
								if ($fechas[0] == 1)
								{ $dia= '01';}
								elseif ($fechas[0] == 2)
								{ $dia= '02';}
								elseif ($fechas[0] == 3)
								{ $dia= '03';}
								elseif ($fechas[0] == 4)
								{ $dia= '04';}
								elseif ($fechas[0] == 5)
								{ $dia= '05';}
								elseif ($fechas[0] == 6)
								{ $dia= '06';}
								elseif ($fechas[0] == 7)
								{ $dia= '07';}
								elseif ($fechas[0] == 8)
								{ $dia= '08';}
								elseif ($fechas[0] == 9)
								{ $dia= '09';}
								else {$dia= strval($fechas[0]);}						
								
								if ($fechas[1] == 1)
								{ $mes= '01';}
								elseif ($fechas[1] == 2)
								{ $mes= '02';}
								elseif ($fechas[1] == 3)
								{ $mes= '03';}
								elseif ($fechas[1] == 4)
								{ $mes= '04';}
								elseif ($fechas[1] == 5)
								{ $mes= '05';}
								elseif ($fechas[1] == 6)
								{ $mes= '06';}
								elseif ($fechas[1] == 7)
								{ $mes= '07';}
								elseif ($fechas[1] == 8)
								{ $mes= '08';}
								elseif ($fechas[1] == 9)
								{ $mes= '09';}
								else {$mes= strval($fechas[1]);}							
								$anio=strval($fechas[2]);						
								$data_clte['pol_f'] = $anio.'-'.$mes.'-'.$dia;		

								$data_clte['pol_grupo'] =  $data_clte['pol_oficina'].'-'.$data_clte['pol_ramo'].'-'.$data_clte['pol_poliza'];	
								$data_clte['pol_nota']=$data_clte['pol_grupo'];
								$data_clte['log_insrt_prg'] =  'CARGA PÓLIZA SURA';	
								$fsm_poliza=$this->cliente->busca_poliza($data_clte['pol_oficina'],$data_clte['pol_ramo'],$data_clte['pol_poliza']); 
								
								if ($fsm_poliza)
								{
									$data_clte['log_updt_f'] =  date('Y-m-d H:i:s');
									$data_clte['log_updt_usr_cve'] =  $user['usr_id'];		
									$data_clte['log_updt_prg'] =  'CARGA PÓLIZA SURA';
									$this->cliente->actualiza_poliza($fsm_poliza['pol_id'],$data_clte);
									$actualizados++;
				
								}	
								else
								{
									$data_clte['log_insrt_f'] =  date('Y-m-d H:i:s');	
									$data_clte['log_insrt_usr_cve'] =  $user['usr_id'];
									$evaluado_id=$this->cliente->inserta_poliza($data_clte);	
									$insertados++;
								}	

								$contador++;

							/*
							$data_clte['pol_nota'] =  trim($campos[4]);						
								$fechas=explode("/",strtoupper((trim($campos[4]))));							
								if ($fechas[0] == 1)
								{ $dia= '01';}
								elseif ($fechas[0] == 2)
								{ $dia= '02';}
								elseif ($fechas[0] == 3)
								{ $dia= '03';}
								elseif ($fechas[0] == 4)
								{ $dia= '04';}
								elseif ($fechas[0] == 5)
								{ $dia= '05';}
								elseif ($fechas[0] == 6)
								{ $dia= '06';}
								elseif ($fechas[0] == 7)
								{ $dia= '07';}
								elseif ($fechas[0] == 8)
								{ $dia= '08';}
								elseif ($fechas[0] == 9)
								{ $dia= '09';}
								else {$dia= strval($fechas[0]);}						
								
								if ($fechas[1] == 1)
								{ $mes= '01';}
								elseif ($fechas[1] == 2)
								{ $mes= '02';}
								elseif ($fechas[1] == 3)
								{ $mes= '03';}
								elseif ($fechas[1] == 4)
								{ $mes= '04';}
								elseif ($fechas[1] == 5)
								{ $mes= '05';}
								elseif ($fechas[1] == 6)
								{ $mes= '06';}
								elseif ($fechas[1] == 7)
								{ $mes= '07';}
								elseif ($fechas[1] == 8)
								{ $mes= '08';}
								elseif ($fechas[1] == 9)
								{ $mes= '09';}
								else {$mes= strval($fechas[1]);}							
								$anio=strval($fechas[2]);
						
							$data_clte['pol_f'] = $anio.'-'.$mes.'-'.$dia;						
							
							$data_clte['pol_grupo'] =  trim($campos[6]);	
							$data_clte['log_insrt_f'] =  trim($campos[7]);	
							$data_clte['log_insrt_usr_cve'] =  trim($campos[8]);	
							$data_clte['log_insrt_prg'] =  trim($campos[9]);	
							$data_clte['log_updt_f'] =  trim($campos[10]);	
							$data_clte['log_updt_usr_cve'] =  trim($campos[11]);	
							$data_clte['log_updt_prg'] =  trim($campos[12]);*/

												
							


						}
						else
						{
							$linea++;	
						}	
					}
				}
				fclose($el_archivo);
				$data_insert['actualizados']=$actualizados;
				$data_insert['insertados']=$insertados;				
				$data_insert['carga_total']=$contador;
				$this->db->trans_start();
                if($this->cliente->actualiza($cliente_id,$data_insert))
                {
					$paso_actualizacion=1;
				}

                if($paso_actualizacion)
                {
                    send_json_ok('Se completo el proceso de Carga Masiva');
                }
                else
                {
                    send_json_error('Ocurrió un error al iniciar el proceso.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $archivo_de_carga;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'cargasura/lanza_proceso',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    public function nuevo()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('carga_nombre','Nombre de la Carga','required');

            if($this->form_validation->run())
            {
					$data_clte['usr_id'] = $user['usr_id'];	
					$data_clte['med_id'] = $this->input->post('medico');
					$data_clte['lab_id'] = $this->input->post('laboratorista');
					$data_clte['cei_id'] = $this->input->post('cei');
					$data_clte['emp_id'] =  $this->input->post('empresa');	
					
					$data_clte['carga_nombre'] = $this->input->post('carga_nombre');
					$data_clte['carga_descripcion'] = $this->input->post('descripcion');

					$data_clte['log_insrt_f'] = date('Y-m-d H:i:s');
					$data_clte['log_insrt_usr_cve'] =  $user['usr_id'];
					$data_clte['log_updt_f'] = date('Y-m-d H:i:s');
					$data_clte['log_updt_usr_cve'] =  $user['usr_id'];		
					$data_clte['carga_status'] =  'NO CARGADO';	
					
					$data_clte=array_to_upper($data_clte);
					
					if(!empty($_FILES['archivo_carga']['name']))
					{
						$this->load->library('upload');
						//$filename = md5(time());
						$filename = 'sura_polizas_'.date('Ymd_His');
						$config = array(
								'upload_path'   => './../../files/cargas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'png|jpg|jpeg|csv',
								'max_size'      => '25000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('archivo_carga'))
						{
							send_json_error($this->upload->display_errors());
						}
						else 
						{
							$data = $this->upload->data();
							$data_clte['carga_path_archivo'] = $data['file_name'];
						}
					}
					

				if($cliente_id = $this->cliente->inserta($data_clte))
                {
                    send_json_ok(array('msg' =>'Se registro de forma correcta el proceso.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar ingreseo del vehículo.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$this->load->model('empresa/Empresa_model','empresa');
			$data['empresas'] = $this->empresa->trae_emp_asig(324);		
			
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'cargasura/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    } 

    public function edita($cliente_id)
    {   
		//echo 'A';
        $user = $this->session->user;
		//echo 'B';
		$cliente = $this->cliente->get($cliente_id);
		//echo 'b';
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
				$this->form_validation->set_rules('servicio','Servicio','required');

                if($this->form_validation->run())
                {
					$data_clte['usr_id'] = $user['usr_id'];	
					$data_clte['med_id'] = $user['usr_id'];	
					$data_clte['emp_id'] =  31;	
					$data_clte['log_updt_f'] = date('Y-m-d H:i:s');
					$data_clte['log_updt_usr_cve'] =  $user['usr_id'];				
					
                    $data_clte['cats_nombre_servicio'] = $this->input->post('servicio');
					$data_clte['cats_grupo_nombre'] = $this->input->post('area_responsable');
					$data_clte['cats_categoria'] = $this->input->post('categoria');
					$data_clte['cats_descripcion'] = $this->input->post('descripcion');
					
					$data_clte['cats_precio_base'] = $this->input->post('precio_base');
					$data_clte['cats_porc_ganancia'] = $this->input->post('porcentaje_ganancia');
					$data_clte['cat_porc_vol1'] = $this->input->post('porcentaje_desc_vol1');
					$data_clte['cat_porc_vol2'] = $this->input->post('porcentaje_desc_vol2');
					$data_clte['cats_precio_unitario ']=(($data_clte['cats_precio_base']*(100.0+$data_clte['cats_porc_ganancia']))/100.0);
					$data_clte['cats_precio_10d']=((($data_clte['cats_precio_base']*(100.0+$data_clte['cats_porc_ganancia']))/100.0)*((100.0-$data_clte['cat_porc_vol1'])/100.0));
					$data_clte['cats_precio_20d ']=((($data_clte['cats_precio_base']*(100.0+$data_clte['cats_porc_ganancia']))/100.0)*((100.0-$data_clte['cat_porc_vol2'])/100.0));

					if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el registro.');
					}

                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
               
				$data['cliente'] = 	$cliente;
				$data['empresas'] = $this->cliente->get_all_caliza_clientes();	
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'cargasura/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function lista()
    {   

	$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('cargasura/lista/');

		$config['total_rows'] = $this->cliente->count_allo();
	
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);	

		$data['clientes'] = $this->cliente->get_allo($rows);

		$this->load->model('empresa/Empresa_model','empresa');
		
		$data['empresas'] = $this->empresa->trae_emp_asig(324);
		
        $this->load->helper('template');
        $params_view = array(
            'title' => 'cargasura',
            'view' => 'cargasura/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

   public function borra($fsm_id)
    {
        if($this->cliente->borra_evaluado($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function id($id)
    {  
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();		
		
        $data['cliente'] = $this->cliente->get($id);
		
		if($data['cliente'])
        {
            $user = $this->session->user;
            $data['medico']=$user;
		
			//$data['docs'] = $this->cliente->get_docs($id);
			//$data['coms'] = $this->cliente->get_coms($id);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Persona',
                'view' => 'cargasura/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }


    function busca()
    {   
		$user = $this->session->user; 
		$id = strtoupper(trim($this->input->post('id')));
		$nombre_carga = strtoupper(trim($this->input->post('nombre_carga')));
		$empresa = $this->input->post('empresa');
		$estatus= $this->input->post('estatu');		
        $data['clientes'] = $this->cliente->busca($id,$nombre_carga,$empresa,$estatus);
        send_json_ok($this->load->view('cargasura/busca',$data,TRUE));
    }
 

	
    public function solrep()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'cargasura/inicio_rep_cat',
            'view_data' => $data
            );
        render_template($params_view);
    } 	
	
    function rep_catalogo()
    {
		$user = $this->session->user;
        $this->load->model('empresa/Empresa_model','empresa');
		$this->load->helper('util');
       
		$area = $this->input->post('area_responsable');
		$emp_id=31;	

		$date2today = date("Y-m-d");
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
			<meta content="es-mx" http-equiv="Content-Language" />
			<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
			<?php
				header("Content-type: application/octet-stream; charset=latin1");
				header("Content-Disposition: attachment; filename=hc_catalogo_".$date2today.".xls");
				header("Pragma: no-cache");
				header("Expires: 0");
			?>

			<title>catalogo</title>
			<style type="text/css">
				.auto-style1 {
					font-family: Arial, Helvetica, sans-serif;
					color: #FFFFFF;
					background-color: #3D5588;
					font-size: small;
				}
				.auto-style4 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
				}
				.auto-style5 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: medium;
				}
				.auto-style6 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-large;
					text-align: right;
					font-weight: normal;
				}
				.auto-style7 {
					font-size: small;
				}
				.auto-style8 {
					color: #3D5588;
				}
				.auto-style9 {
					color: #3AD4A7;
				}
							.auto-style11 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: small;
					text-align: right;
				}
				.auto-style12 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: small;
					text-align: center;
				}
				.auto-style13 {
					font-size: xx-small;
				}
				.auto-style14 {
					font-family: Arial, Helvetica, sans-serif;
					color: #FFFFFF;
					background-color: #3D5588;
					font-size: xx-small;
				}
				.auto-style15 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
				}
				.auto-style16 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
					text-align: right;
				}
				.auto-style17 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
					text-align: left;
				}
				.auto-style18 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					text-align: center;
				}
				.auto-style19 {
					color: #3D5588;
					font-size: medium;
				}
				.auto-style20 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					text-align: center;
					background-color: #BFEADD;
				}
				.auto-style21 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					background-color: #BFEADD;
				}

			</style>
		</head>
		
		<body>
				<table> 
					<thead>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th style="width: 281px" class="auto-style11">&nbsp;</th>
							<th style="width: 625px" class="auto-style12">
							Catálogo de Servicios</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

						<?php if ($emp_id == "")
						{ ?>
							<th style="width: 281px" class="auto-style16">Varias</th>
							<th style="width: 625px" class="auto-style17">&nbsp;Empresas</th>	
						<?php }
						else
						{ 
							$empresa=$this->empresa->get_empresa($emp_id);
							?>
							<th style="width: 281px" class="auto-style16">Empresa:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo $empresa['emp_razon_social']; ?></th>							
						<?php } ?>

							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Área:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php if ($area == '') {echo 'TODAS LAS ÁREAS';} else {echo $areas;}; ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Generado el día:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style15">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
					<thead>
				</table> 
<!--				
clte_id
usr_id
med_id
emp_id
cats_codigo
cats_codigo_ex
cats_codigo_ex_id





cat_porc_vol2


cats_precio_20d

log_insrt_f
log_insrt_usr_cve
log_insrt_prg}
log_updt_f
log_updt_usr_cve
log_updt_prg 
cats_status 
-->	
				
				<table>
					<thead>
                    <tr>
						<th class="auto-style14" >#</th>
						<th class="auto-style14" >Id</th>
                        <th class="auto-style14" >Servicio</th>
						<th class="auto-style14" >Área</th>
						<th class="auto-style14" >Categoría</th>
						<th class="auto-style14" >Código</th>
						<th class="auto-style14" >Codigo HC</th>
						<th class="auto-style14" >Precio Base</th>
                        <th class="auto-style14" >Precio Unitario</th>
						<th class="auto-style14" >% Ganancia</th>
						<th class="auto-style14" >Precio Vol 1</th>
                        <th class="auto-style14" >% Descuento Vol 1</th>	
						<th class="auto-style14" >Precio Vol 2</th>						
                        <th class="auto-style14" >% Descuento Vol 2</th>	
						<th class="auto-style14" >Última Revisión</th>						
                        <th class="auto-style14" >Autorización</th>	
					<!--	<th class="auto-style14" >Descripción</th>	-->
                    </tr>
                </thead>
				
                <tbody id="resultado">
                    <?php
						$data['clientes'] = $this->cliente->get_allo_servicios_by_emp_area($emp_id,$area);

						$class18=" ";
						$i=1;
                        if($data['clientes']):
                            foreach ($data['clientes'] as $cliente): 
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";							
								}										
								$empleado = $this->medico->get($cliente['med_id']);
							?> 	
                                <tr>
									<td class=<?php echo $class18; ?>><?php echo $i; $i++;?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_id']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_nombre_servicio']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_grupo_nombre']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_categoria']; ?></td>									
                                    <td class=<?php echo $class18; ?>><?php echo $cliente['cats_codigo']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_codigo_ex']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_precio_base']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_precio_unitario']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_porc_ganancia']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_precio_10d']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cat_porc_vol1']; ?></td>									
									<td class=<?php echo $class18; ?>><?php echo $cliente['cats_precio_20d']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['cat_porc_vol2']; ?></td>		
									<td class=<?php echo $class18; ?>><?php echo formatea_fechahora($cliente['log_updt_f']); ?></td>
									<td class=<?php echo $class18; ?>>
										<?php echo $empleado['usr_nombre'].' '.$empleado['usr_paterno'].' '.$empleado['usr_materno'];?>
									</td>
								<!--	<td class=<?php echo $class18; ?>><?php echo $cliente['cats_descripcion']; ?></td>	-->
								</tr>
				            <?php              
                            endforeach;
							
							?>
                    <tr>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
                        <td class="auto-style14"></td>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td> 	
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
					<!--	<td class="auto-style14"></td> -->
                    </tr>							
					<?php			
                        endif;

                    ?>
                </tbody>
				</table>
				</html><?php 	
	 }	
/***********************************************************************/
    public function rep_eva()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'vehiculo/inicio_view_rep_evaluados',
            'view_data' => $data
            );
        render_template($params_view);
    } 

    public function rep_emp()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'vehiculo/inicio_view_rep_empleados',
            'view_data' => $data
            );
        render_template($params_view);
    } 


    public function rep_lab()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'vehiculo/inicio_view_rep_eva_lab',
            'view_data' => $data
            );
        render_template($params_view);
    }











    public function edita_g($fsm_id,$cliente_id)
    {    //vehiculos       
		$cliente = $this->cliente->get($cliente_id);		
		$documento=$this->cliente->get_doc($fsm_id);         
		
        if($documento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nuevo_nombre','Nuevo Nombre del Archivo','required');


                if($this->form_validation->run())
                {

                    $data_clte['doc_nombre'] =  trim($this->input->post('nuevo_nombre'));
					
					if($this->cliente->actualiza_nombre_doc($fsm_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['persona'] = 	$cliente;
				$data['documento'] = 	$documento;
				

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'vehiculo/edit_g',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }
/*************************************************************************************/
    


 
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
	
	


    function busca_evaluado()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
		$id_persona = strtoupper($this->input->post('id_persona'));
        $nombre  = strtoupper($this->input->post('nombre'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona);
        send_json_ok($this->load->view('vehiculo/busca',$data,TRUE));
    }


    function busca_p()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$user = $this->session->user; 
		//$usuario = $CIs->empleado->get($user['usr_id']);
		$medico=$this->medico->get($user['usr_id']);
		
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));

		//echo '--'.$medico['usr_emp_asig'].'--';
        $data['clientes'] = $this->cliente->busca_p($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$medico['usr_emp_asig']);
        
		send_json_ok($this->load->view('vehiculo/busca_p',$data,TRUE));
    }

	


/*************************************************************************************/
    public function lista_e()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('vehiculo/lista_e/');
        //$config['total_rows'] = $this->cliente->count_all();
		
		if ($user['usr_id'] == 482)
		{
		$config['total_rows'] = $this->cliente->count_allo_m($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        }
		else
		{
		$config['total_rows'] = $this->cliente->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        }
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		//echo " Punto ".$emp_id;
		

		if ($user['usr_id'] == 482)
		{
		$data['clientes'] = $this->cliente->get_allo_m($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        }
		else
		{
		$data['clientes'] = $this->cliente->get_allo_e($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        }

		
		//echo " Punto C ";
		
        //$this->load->model('empresa/Empresa_model','empresa');
		//echo " Punto D ";
		
        //$data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		//$data['empresas'] = $this->empresa->get_all_empresas_gsi();
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'vehiculo/index_e',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_a()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('vehiculo/lista_a/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_a($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_a($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'vehiculo/index_a',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_b()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('vehiculo/lista_b/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_b($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_b($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'vehiculo/index_b',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function nuevo_e()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');                				
				$data_clte['clte_curp_crypt'] = $this->input->post('curp');
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');				
				
                $data_clte['empleado'] = 1;
                
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				//sucursal
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  4;

				$nomserv='NOM0351;NOM0352;NOM0353;';
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				$data_clte['clte_email_crypt'] =  $this->input->post('correo');
				if ($cliente_id = $this->cliente->inserta($data_clte))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_e',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/	
    function busca_e()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
		if ($user['usr_id'] == 482)
		{
        $data['clientes'] = $this->cliente->busca_m($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);
        }
		else
		{
		  $data['clientes'] = $this->cliente->busca_e($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	
		}
		
		send_json_ok($this->load->view('vehiculo/busca_e',$data,TRUE));
    } 

 /*************************************************************************************/	
    function busca_a()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $data['clientes'] = $this->cliente->busca_a($empresa, $nombre, $nombre2,$paterno, $materno);
        
		send_json_ok($this->load->view('vehiculo/busca_a',$data,TRUE));
    } 
	
	
    public function borra_comentario($fsm_id)
    {
        if($this->cliente->borrar_comentario($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	

    public function borra_documento($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }



	
 
}