﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quimica_sanguinea33 extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Quimica_sanguinea38_model','qui_san33');
		$this->load->helper('util');
		$this->load->helper('laboratorio_qs');
		$this->load->helper('report');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;


        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}

			$this->form_validation->set_rules('glucosa','GLUCOSA BASAL','required');
			$this->form_validation->set_rules('urea','UREA','required');
			$this->form_validation->set_rules('creatinina','CREATININA','required');
			$this->form_validation->set_rules('rel-buncreat','RELACIÓN BUN/CREATININA','required');
			$this->form_validation->set_rules('nitro-ureico','NITRÓGENO UREICO (BUN)','required'); 
			$this->form_validation->set_rules('acidourico','ACIDO URICO','required'); 
			$this->form_validation->set_rules('colesterol-total','COLESTEROL TOTAL','required');  
			$this->form_validation->set_rules('colesterol-hdl','COLESTEROL DHL','required'); 
			$this->form_validation->set_rules('colesterol-ldl','COLESTEROL LDL','required');  
			$this->form_validation->set_rules('colesterol-hdl','COLESTEROL VLDL','required');  
			$this->form_validation->set_rules('trigliceridos','TRIGLICÉRIDOS','required'); 
			$this->form_validation->set_rules('billi-total','BILIRRUBINA TOTAL','required');   
			$this->form_validation->set_rules('billi-directa','BILIRRUBINA DIRECTA','required');  
			$this->form_validation->set_rules('billi-indirecta','BILIRRUBINA INDIRECTA','required');   
			$this->form_validation->set_rules('got-ast','ASPARTATO AMINOTRANSFERASA (GOT/AST)','required');    
			$this->form_validation->set_rules('ggt','GAMMA GLUTAMIL TRANSFERASA (GGT)','required');  
			$this->form_validation->set_rules('tgp','ALANINA-AMINO TRANSFERASA (ALT O TGP)','required');   
			$this->form_validation->set_rules('fosfa-alcalina','FOSFATASA ALCALINA','required');  
			$this->form_validation->set_rules('lactato-deshidro','LACTATO DESHIDROGENASA','required'); 
			$this->form_validation->set_rules('prot-totales','PROTEÍNAS TOTALES','required');
			$this->form_validation->set_rules('albumina','ALBÚMINA','required'); 
			$this->form_validation->set_rules('globulina','GLOBÚLINAS','required');  
			$this->form_validation->set_rules('alb-glob','RELACIÓN ALBÚMINA/GLOBÚLINA','required');    
			$this->form_validation->set_rules('amilasa','AMILASA','required');   
 			$this->form_validation->set_rules('calcio','CALCIO','required'); 
			$this->form_validation->set_rules('fosforo','FÓSFORO','required');  
			$this->form_validation->set_rules('sodio','SODIO','required');  
			$this->form_validation->set_rules('potasio','POTASIO','required');   
			$this->form_validation->set_rules('cloro','CLORO','required'); 
			$this->form_validation->set_rules('diox-carbono','DIÓXIDO DE CARBONO','required');
			$this->form_validation->set_rules('hierro','HIERRO','required'); 
			
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $this->input->post('laboratorista'); 
				
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
		
				$data_insert['qui_medico_sol'] = $this->input->post('medico_sol');
				
                $data_insert['qui_f_recibido']   = formatea_fecha_mysql($this->input->post('fecha_rec')); //date('Y-m-d H:i:s'); 
                $data_insert['qui_f_impresion']  = formatea_fecha_mysql($this->input->post('fecha_imp')); //date('Y-m-d H:i:s');
                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				
                $data_insert['qui_glucosa']  = $this->input->post('glucosa');
                $data_insert['qui_urea']=	$this->input->post('urea');
                $data_insert['qui_creatinina']=	$this->input->post('creatinina');
                $data_insert['qui_rel-buncreat']=	$this->input->post('rel-buncreat');
                $data_insert['qui_nitro-ureico']=	$this->input->post('nitro-ureico');
                $data_insert['qui_acidourico']=	$this->input->post('acidourico');
                $data_insert['qui_colesterol-total']=	$this->input->post('colesterol-total');
                $data_insert['qui_colesterol-hdl']=	$this->input->post('colesterol-hdl');
                $data_insert['qui_colesterol-ldl']=	$this->input->post('colesterol-ldl');
                $data_insert['qui_colesterol-vldl']=	$this->input->post('colesterol-vldl');
                $data_insert['qui_trigliceridos']=	$this->input->post('trigliceridos');
                $data_insert['qui_lipidos-tot']=	$this->input->post('lipidos-tot');
				$data_insert['qui_relacion-col-hdl']=	$this->input->post('relacion-col-hdl');
				
				$data_insert['qui_billi-total']=	$this->input->post('billi-total');
				$data_insert['qui_billi-directa']=	$this->input->post('billi-directa');
				$data_insert['qui_billi-indirecta']=	$this->input->post('billi-indirecta');
				$data_insert['qui_got-ast']   =	$this->input->post('got-ast');
				$data_insert['qui_ggt']=	$this->input->post('ggt');
                $data_insert['qui_tgp']=	$this->input->post('tgp');
				
				$data_insert['qui_fosfa-alcalina']=	$this->input->post('fosfa-alcalina');
				$data_insert['qui_fosfa-acida-total']=	$this->input->post('fosfa-acida-total');

                $data_insert['qui_lactato-deshidro']=	$this->input->post('lactato-deshidro');
                $data_insert['qui_prot-totales']=	$this->input->post('prot-totales');
                $data_insert['qui_albumina']=	$this->input->post('albumina');
                $data_insert['qui_globulina']=	$this->input->post('globulina'); 
                $data_insert['qui_alb-glob']=	$this->input->post('alb-glob');
			  
				$data_insert['qui_amilasa']=	$this->input->post('amilasa');
				$data_insert['qui_lipasa']=	$this->input->post('lipasa');
				$data_insert['qui_creatina-ck']=	$this->input->post('creatina-ck');
				$data_insert['qui_creatina-ck-mb']=	$this->input->post('creatina-ck-mb');
				
                $data_insert['qui_calcio']=	$this->input->post('calcio');
				$data_insert['qui_fosforo']=	$this->input->post('fosforo');
				$data_insert['qui_magnesio']=	$this->input->post('magnesio');
                $data_insert['qui_sodio']=	$this->input->post('sodio');
                $data_insert['qui_potasio']=	$this->input->post('potasio');
				$data_insert['qui_cloro']=	$this->input->post('cloro');
				$data_insert['qui_diox-carbono']=	$this->input->post('diox-carbono');
                $data_insert['qui_hierro']=	$this->input->post('hierro');

                
				$data_insert['qui_lab'] = $this->input->post('laboratorista');
				
				$data_insert['qui_qs'] = 'QS33';
				$data_insert['qui_metodo'] = $this->input->post('laboratorio_metodo');
				$data_insert['qui_indice_aterogenico'] = $this->input->post('indice_aterogenico');
				$data_insert['qui_anion-gap'] = $this->input->post('anion-gap');
				
				$data_insert= array_to_upper($data_insert);
				$data_insert['qui_obs']  = $this->input->post('q_sang_obs');
				//$data_insert['qui_fuera_rango'] = $this->input->post('fuera_rango');

				
				
                if($this->qui_san33->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/quimica_sanguinea33/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->qui_san33->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		
		$med_name=$data['fsm']['qui_lab']; 
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['qui_obs'];
		$fuera_rango=$data['fsm']['qui_fuera_rango'];
        $data_empresa = $this->cliente->get_empresa_by_id($emp_id);	
       // $ruta = base_url('../dist/images/hclogo.jpg');
	   $date2todayl = date("Y_m_d-His");
		$med_name=agrega_cedula_ext($data['fsm']['med_id']);
		genera_pdf_lab_new_x($this->load->view('examen/quimica_sanguinea33/pdf',$data,TRUE),'quimica_sanguinea33_'.$date2todayl,'quimica_sanguinea33_'.$date2todayl,$med_name,$observaciones,$fuera_rango);	
 	}
	

    public function borra_qui_san($fsm_id)
    {
        if($this->qui_san33->delete_qui_san($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
	
}
