<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Toxicologico3 extends CI_Controller {
    function __construct() {
        parent::__construct();
		
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('examen/Toxicologico_model3','toxicologico');
		$this->load->helper('util');
		$this->load->helper('report');	
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/
            $this->form_validation->set_rules('coc','Coca�na','required');
            $this->form_validation->set_rules('mar','Marihuana','required');
            $this->form_validation->set_rules('opi','Opiaceos','required');
            
            if($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['med_id']  = $this->input->post('laboratorista'); 
				
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
				
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
				$data_insert['fsm_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['fsm_coc_cve'] = $this->input->post('coc');
                $data_insert['fsm_mar_cve'] = $this->input->post('mar');
                $data_insert['fsm_opi_cve'] = $this->input->post('opi');

                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
                if($this->toxicologico->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');

					$servicios=$persona['domserv'];					
					
					$servicio='TOXIT;';
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$data_clte['clte_status_proc'] = 'EN PROCESO';
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
				
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/toxicologico/nuevo_form3',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function nuevo1($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/
            $this->form_validation->set_rules('coc','Cocaína','required');
            //$this->form_validation->set_rules('mar','Marihuana','required');
            //$this->form_validation->set_rules('opi','Opiaceos','required');
            
            if($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['med_id']  = $this->input->post('laboratorista'); 
				
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
				
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
				$data_insert['fsm_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['fsm_coc_cve'] = $this->input->post('coc');
                $data_insert['fsm_mar_cve'] = $this->input->post('mar');
                $data_insert['fsm_opi_cve'] = $this->input->post('opi');

                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
                if($this->toxicologico->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');

					$servicios=$persona['domserv'];					
					
					$servicio='TOXIT;';
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
				
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/toxicologico/nuevo_form1',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }	
	
	public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->toxicologico->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=agrega_cedula_ext($data['fsm']['med_id']);

		genera_pdf_lab_new_x($this->load->view('examen/toxicologico/pdf3',$data,TRUE),'toxicologico3','toxicologico3',$med_name,$observaciones,$fuera_rango);	
	}
	
	public function pdf1($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->toxicologico->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=agrega_cedula_ext($data['fsm']['med_id']);

		genera_pdf_lab_new_x($this->load->view('examen/toxicologico/pdf1',$data,TRUE),'toxicologico3','toxicologico3',$med_name,$observaciones,$fuera_rango);	
	}

    public function borra_toxicologico3($fsm_id)
    {
        if($this->toxicologico->delete_toxicologico($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
	
 }




