<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Enfermedad extends CI_Controller {
    
        function __construct() {
            parent::__construct();
            $this->load->model('cat/Catalogo_model','cat');
        }
        
        public function busca_enfermedad_cap($cap)
	{
            $cies = $this->cat->get_cies_by_caitulo($cap);
            $cies_formated = array();
            if($cies)
            {
                foreach ($cies as $cie) {
                    $cies_formated[] = array('label' => mb_strtoupper($cie['cie_clave'].' - '.$cie['cie_nombre']),'value' => $cie['cie_id'],'clave' => $cie['cie_clave']);
                }
                send_json_ok($cies_formated);
            }
            else
            {
                send_json_error('vacio');
            }
	}
        
        public function busca_enfermedad_L1()
	{
            $term = $this->input->get('term');
            $cies = $this->cat->busca_cie_L1($term);
            $cies_formated = array();
            foreach ($cies as $cie) {
                $cies_formated[] = array('label' => mb_strtoupper($cie['cie_clave'].' - '.$cie['cie_nombre']),'value' => $cie['cie_id'],'clave' => $cie['cie_clave']);
            }
            echo json_encode($cies_formated);
	}
        
        public function busca_enfermedad_L2($cie_clave)
	{
            $cies = $this->cat->busca_cie_L2($cie_clave);
            if($cies)
            {
                $cies_formated = array();
                foreach ($cies as $cie) {
                    $cies_formated[] = array('label' => mb_strtoupper($cie['cie_clave'].' - '.$cie['cie_nombre']),'value' => $cie['cie_id']);
                }
                send_json_ok($cies_formated);
            }
            else
            {
                send_json_error('vacio');
            }
	}
        
        public function id($cie_id)
        {
            $cie['cie'] = $this->cat->get_cie($cie_id);
            if($cie)
            {
                send_json_ok($this->load->view('catalogos/cie_view',$cie,TRUE));
            }   
            else
            {
                send_json_error('No existe');
            }
        }
}