<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Medicamento extends CI_Controller {
    
        function __construct() {
            parent::__construct();
            $this->load->model('cat/Catalogo_model','cat');
        }
        
        function index()
        {
            $this->load->helper('template');
            $this->load->model('mkt/Mkt_model','mkt');
                
            $camps['todo'] = $this->mkt->get_camp_all();
            $camps['abn'] = $this->mkt->get_camp_abn();
            
            $data_view['grupos'] = $this->cat->get_grupos_medicamentos();
            
            $params_view = array(
                            'title' => 'MiConsultorio.Digital',
                            'view' => 'catalogos/medicamentos_view',
                            'mkt' => $camps,
                            'view_data' => $data_view
                           );
            render_template($params_view);
        }
        
        function modal()
        {
            $data_cat['grupos'] = $this->cat->get_grupos_medicamentos();
            $data_cat['title_modal'] = 'Medicamentos (Búsqueda por sustancia activa)';
            $view = $this->load->view('catalogos/medicamentos_modal_view',$data_cat,TRUE);
            send_json_ok($view);
        }
        
        function grupo($id)
        {
            $mds = $this->cat->get_medicamentos($id);
            if($mds)
            {
                send_json_ok($mds);
            }   
            else
            {
                send_json_error('No hay medicamentos');
            }
        }
        
        function id($id)
        {
            $md['md'] = $this->cat->get_medicamento($id);
            if($md)
            {
                send_json_ok($this->load->view('catalogos/medicamento_view',$md,TRUE));
            }   
            else
            {
                send_json_error('No hay medicamentos');
            }
        }
        
        function busca()
        {
            $text = $this->input->get('term');
            $mds = $this->cat->find_medicamentos($text);
            $mds_formated = array();
            foreach ($mds as $row)
            {
                $mds_formated[] = array('label' => mb_strtoupper($row['md_generico'].' - '.$row['md_forma_farm'].' - '.$row['md_concent']),'value' => $row['md_id'],'subclave' => $row['md_subclave'] );
            }
            echo json_encode($mds_formated);
        }
}