<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Costosxserv_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->helper('util');
    }
    
    /*
     * Get servicio by emp_id
     */
    function get($serv_id)
    {
        $this->db->select('a.*,b.*');
        $this->db->from('sis30_servicios as a');
        $this->db->join('sis15_empresas as b','a.emp_id = b.emp_id','left');
        $this->db->where('serv_id',$serv_id);
        if(get_perfil_id() == 4)
        {
            $this->db->where('a.emp_id', get_emp_id());
        }
        $this->db->group_by('a.serv_id');
        return $this->db->get()->row_array();
    }
    
    function get_by_empresa($emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis30_servicios');
        $this->db->where('emp_id',$emp_id);
        $this->db->where_in('serv_estatus_cve',array('PROCESO','CONCLUIDO'));
        return $this->db->get()->result_array();
    }
    
    /*
     * Get servicio by emp_id
     */
    function get_all($emp_id = '', $estatus = '', $rows = 30)
    {
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

        /*$sql = "SELECT a.*,b.*,SUM(c.exam_cantidad) as examenes FROM sis30_servicios as a LEFT JOIN sis15_empresas as b ON a.emp_id = b.emp_id LEFT JOIN sis35_servicios_examenes as c ON a.serv_id = c.serv_id ";
        $sql .= " GROUP BY serv_id"*/
        $this->db->select('a.*,b.*,SUM(c.exam_cantidad) as examenes, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
        $this->db->from('sis30_servicios as a');
        $this->db->join('sis15_empresas as b','a.emp_id = b.emp_id','left');
        $this->db->join('sis35_servicios_examenes as c','a.serv_id = c.serv_id','left');
        if($emp_id != '')
        {
            $this->db->where('a.emp_id', $emp_id);
        }
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }
        if(get_perfil_id() == 4)
        {
            $this->db->where('a.emp_id', get_emp_id());
        }
        $this->db->group_by('a.serv_id');
        $this->db->order_by('a.serv_f_inicio','DESC');
        $this->db->limit($rows, $page);
        $result = $this->db->get();
        return $result->result_array();
    }

    function count_all()
        {
            $this->db->select("count(serv_id) as regs");
            $this->db->from('sis30_servicios');
            if(get_perfil_id() == 4)
            {
                $this->db->where('emp_id', get_emp_id());
            }
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
    
    /*
     * function to add new servicio
     */
    function inserta($params)
    {
        $data = array_merge($params,log_insert('ADD_SERV'));
        $this->db->insert('sis30_servicios',$data);
        return $this->db->insert_id();
    }
    
    function inserta_nota($params)
    {
        $data = array_merge($params,log_insert('ADD_SERV_NOTA'));
        $this->db->insert('sis45_servicios_notas',$data);
        return $this->db->insert_id();
    }
    
    function inserta_anexos($array)
    {
        $this->db->insert_batch('sis40_servicios_anexos', $array);
    }
    
    /*inserta los examenes a realizar*/
    function inserta_examenes($examenes, $serv_id)
    {
        $insert_id = null;
        if( ! empty($examenes))
        {
            foreach($examenes as $examen)
            {
                if(trim($examen['cve']) != "")
                {
                    $examen_ins['serv_id'] = $serv_id;
                    $examen_ins['exam_cve'] = $examen['cve'];
                    $examen_ins['exam_cantidad'] = $examen['cantidad'];
                    $examen_ins['exam_estatus_cve'] = 'PEND';
                    $this->inserta_examen($examen_ins, $serv_id);
                }
            }
        }
        return $insert_id;
    }
    
    function inserta_examen($params)
    {
        $data = array_merge($params,log_insert('ADD_SERV_EXAM'));
        $this->db->insert('sis35_servicios_examenes',$data);
        return $this->db->insert_id();
    }
    
    /*
     * function to update servicio
     */
    function update($serv_id,$params)
    {
        $data = array_merge($params, log_update('UPD_SERV_EXAM'));
        $this->db->where('serv_id',$serv_id);
        return $this->db->update('sis30_servicios',$data);
    }
    
    /*
     * function to delete servicio
     */
    function delete_empresa($serv_id)
    {
        return $this->db->delete('sis30_servicios',array('serv_id'=>$serv_id));
    }
    
    function get_examenes($serv_id)
    {
        $this->db->select('*');
        $this->db->from('sis35_servicios_examenes');
        $this->db->where('serv_id',$serv_id);
        $this->db->order_by('exam_id','ASC');
        return $this->db->get()->result_array();
    }
    
    function get_notas($serv_id)
    {
        $this->db->select('a.*,b.*');
        $this->db->from('sis45_servicios_notas as a');
        $this->db->join('sis20_usuarios as b','a.usr_id = b.usr_id','left');
        $this->db->where('a.serv_id',$serv_id);
        $this->db->order_by('a.nota_f','DESC');
        return $this->db->get()->result_array();
    }
    
    function get_anexos($serv_id)
    {
        $this->db->select('*');
        $this->db->from('sis40_servicios_anexos');
        $this->db->where('serv_id',$serv_id);
        $this->db->order_by('anexo_id','ASC');
        return $this->db->get()->result_array();
    }
    
    function delete_examen($serv_id, $exam_id)
    {
        return $this->db->delete('sis35_servicios_examenes',array('serv_id'=>$serv_id, 'exam_id' => $exam_id));
    }
    
    function delete_anexo($serv_id, $anexo_id)
    {
        return $this->db->delete('sis40_servicios_anexos',array('serv_id'=>$serv_id, 'anexo_id' => $anexo_id));
    }
    
    function get_examenes_serv($serv_id)
    {
        $select = "SELECT a.clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, GROUP_CONCAT( CONCAT(a.tipo,'|',a.fsm_id) ORDER BY a.tipo DESC ) as examenes ";
        $sql = parsea_select($select, 'humancenter');
        $sql .= " FROM (
                select clte_id, fsm_id, 'POL' as tipo from fsm_poligrafico where serv_id = $serv_id and polig_tipo_cve = 'POLI'
                UNION 
                select clte_id, fsm_id, 'CED' as tipo from fsm_poligrafico where serv_id = $serv_id and polig_tipo_cve = 'CEDULA'
                UNION 
                select clte_id, fsm_id, 'MEDFIS' as tipo  from fsm_medico_fisico where serv_id = $serv_id 
                UNION 
                select clte_id, fsm_id, 'PSIC' as tipo  from fsm_psicologico where serv_id = $serv_id 
                UNION 
                select clte_id, fsm_id, 'TOXI' as tipo from fsm_toxicologico where serv_id = $serv_id 
                UNION
                select clte_id, fsm_id, 'TOXIS' as tipo from fsm_toxicologico7 where serv_id = $serv_id 
                UNION
                select clte_id, fsm_id, 'TOXIN' as tipo from fsm_toxi where serv_id = $serv_id 
                UNION     
                select clte_id, fsm_id, 'ACRED' as tipo  from fsm_acreditacion where serv_id = $serv_id 
                UNION                
                select clte_id, fsm_id, 'HIST' as tipo  from fsm_historia_clinica where serv_id = $serv_id 
                UNION 
                select clte_id, fsm_id, 'SOCIE' as tipo  from socio_eco where serv_id = $serv_id 
                UNION 
                select clte_id, fsm_id, 'ENTSOC' as tipo  from entorno_soc where serv_id = $serv_id ) as a 
                LEFT JOIN sis05_clientes as b ON a.clte_id = b.clte_id 
                GROUP BY a.clte_id ORDER BY clte_nombre ASC, clte_paterno ASC;"; 
        $result = $this->db->query($sql);
        return $result->result_array();
    }
}
