<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Empleado_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }


		function count_allo_sura_conduce()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
			$this->db->like('portal','C0NDUC3');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


	    function get_allo_sura_conduce($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('portal','C0NDUC3');
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );	
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }



		function count_allo_sura()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
			$this->db->like('portal','SURA');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


	    function get_allo_sura($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('portal','SURA');
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );	
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }


	    function get_allo_sura_s($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('portal','SURA');
			$this->db->not_like('usr_puesto','ADMINISTRADOR - HC');
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );	
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

	    function get_all_conductores()
        {			
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->like('usr_puesto','CONDUCTOR' );
			$this->db->like('usr_estatus_cve','Activo' );
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );	
            $result = $this->db->get();
            return $result->result_array();
        }


	    function get_all_conductores_libres()
        {			
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->like('usr_puesto','CONDUCTOR' );
			$this->db->like('usr_estatus_cve','Activo' );
			$this->db->where('usr_unidad_reclutadora !=',-1);
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );	
            $result = $this->db->get();
            return $result->result_array();
        }



function busca_asistencia_g2($nombre = '', $paterno='',$materno='', $elempleado = '',$usuario = '',$f_ini = '', $f_fin = '',$quincena='',$usuario_p='')
		{            
            $this->db->select('DISTINCT(usr_id)');
            
            $this->db->from('sis25_asistencias_log');
		
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			
			if($elempleado != ''){ $this->db->where('usr_id',$elempleado); }
			
            if($quincena != ''){ $this->db->where('qui_num',$quincena); }
			
			//if($cei != ''){ $this->db->where('cei_id',$cei); }
			
			
			$ceis[]=0;
			if ($usuario_p['usr_id'] == 261 )
			{
				$ceis = array(1,2,3,4,5,7,8);
				$this->db->where_in('cei_id',$ceis );	
			}
			else
			{
				if (strstr($usuario_p['acciones'],'C31501')) { $ceis[]=1;}
				if (strstr($usuario_p['acciones'],'C31502')) { $ceis[]=2;}
				if (strstr($usuario_p['acciones'],'C31503')) { $ceis[]=3;}
				if (strstr($usuario_p['acciones'],'C31504')) { $ceis[]=4;}
				if (strstr($usuario_p['acciones'],'C31505')) { $ceis[]=5;}
				if (strstr($usuario_p['acciones'],'C31506')) { $ceis[]=6;}
				if (strstr($usuario_p['acciones'],'C31507')) { $ceis[]=7;}
				if (strstr($usuario_p['acciones'],'C31508')) { $ceis[]=8;}
				if (strstr($usuario_p['acciones'],'C3150T')) { $ceis = array(1,2,3,4,5,7,8);}
				$this->db->where_in('cei_id',$ceis);	
			}			
			
			
			
			if($usuario != ''){ $this->db->like('usr_username',$usuario); }
			if($f_ini != ''){ $this->db->where('usrlog_ingreso_f >=',$f_ini.' 00:00:00'); } 
			if($f_fin != ''){ $this->db->where('usrlog_ingreso_f <=', $f_fin.' 11:59:59'); } 

            $this->db->order_by('fsm_id','DESC');
            $result = $this->db->get();
			$arreglo_base=$result->result_array();
			
				$i=0;
				foreach ($arreglo_base as $arreglo) 
				{
					$arreglo_final[$i]=$arreglo['usr_id'];
					$i++;
				}		
		
			return  $arreglo_final;
        }



    function busca_asistencia_empleados($elempleado)
		{            


			if($elempleado != '')
			{ 
				$arreglo_final[0]=$elempleado; 
			}
			else
			{ 
				$this->db->select('DISTINCT(usr_id)');
				$this->db->from('sis25_asistencias_log');
				$result = $this->db->get();
				$arreglo_base=$result->result_array();
				$i=0;
				foreach ($arreglo_base as $arreglo) 
				{
					$arreglo_final[$i]=$arreglo['usr_id'];
					$i++;
				}		
			}	
			return  $arreglo_final;
        }


    function busca_empleados_especificos($elempleado)
		{            
            $this->db->select('*');
            //$elempleado = array(2976,261,3004);
            $this->db->from('sis20_usuarios');
			$this->db->where_in('usr_id',$elempleado); 
            $this->db->order_by('usr_paterno','ASC');
			$this->db->order_by('usr_materno','ASC');
			$this->db->order_by('usr_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }








    function busca_asistencia($nombre = '', $paterno='',$materno='', $elempleado = '',$usuario = '',$f_ini = '', $f_fin = '',$quincena='',$usuario_p='')
		{            
            $this->db->select('*');
            
            $this->db->from('sis25_asistencias_log');
			
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			
			if($elempleado != ''){ $this->db->where('usr_id',$elempleado); }
			
            if($quincena != ''){ $this->db->where('qui_num',$quincena); }
			
			//if($cei != ''){ $this->db->where('cei_id',$cei); }
						$ceis[]=0;
			if ($usuario_p['usr_id'] == 261 )
			{
				$ceis = array(1,2,3,4,5,7,8);
				$this->db->where_in('cei_id',$ceis );	
			}
			else
			{
				if (strstr($usuario_p['acciones'],'C31501')) { $ceis[]=1;}
				if (strstr($usuario_p['acciones'],'C31502')) { $ceis[]=2;}
				if (strstr($usuario_p['acciones'],'C31503')) { $ceis[]=3;}
				if (strstr($usuario_p['acciones'],'C31504')) { $ceis[]=4;}
				if (strstr($usuario_p['acciones'],'C31505')) { $ceis[]=5;}
				if (strstr($usuario_p['acciones'],'C31506')) { $ceis[]=6;}
				if (strstr($usuario_p['acciones'],'C31507')) { $ceis[]=7;}
				if (strstr($usuario_p['acciones'],'C31508')) { $ceis[]=8;}
				if (strstr($usuario_p['acciones'],'C3150T')) { $ceis = array(1,2,3,4,5,7,8);}
				$this->db->where_in('cei_id',$ceis);	
			}			
			
			
			if($usuario != ''){ $this->db->like('usr_username',$usuario); }
			if($f_ini != ''){ $this->db->where('usrlog_ingreso_f >=',$f_ini.' 00:00:00'); } 
			if($f_fin != ''){ $this->db->where('usrlog_ingreso_f <=', $f_fin.' 11:59:59'); } 

			//$this->db->like('usr_estatus_cve',$estatus); 
			
            $this->db->order_by('usrlog_ingreso_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


	    function busca_asistencia_r($elempleado = '',$f_ini = '', $quincena='')
		{            
            $this->db->select('*');            
            $this->db->from('sis25_asistencias_log');
			
			if($elempleado != ''){ $this->db->where('usr_id',$elempleado); }
			
            if($quincena != ''){ $this->db->where('qui_num',$quincena); }
			
			if($f_ini != ''){ 
							 $this->db->where('usrlog_ingreso_f >=',$f_ini.' 00:00:00'); 
							 $this->db->where('usrlog_ingreso_f <=',$f_ini.' 23:59:59'); 
							 } 

            $this->db->order_by('fsm_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }



	    function get_allo_asistencias($rows,$usuario)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis25_asistencias_log');
			
			$ceis[]=0;
			if (strstr($usuario['acciones'],'C31501')) { $ceis[]=1;}
			if (strstr($usuario['acciones'],'C31502')) { $ceis[]=2;}
			if (strstr($usuario['acciones'],'C31503')) { $ceis[]=3;}
			if (strstr($usuario['acciones'],'C31504')) { $ceis[]=4;}
			if (strstr($usuario['acciones'],'C31505')) { $ceis[]=5;}
			if (strstr($usuario['acciones'],'C31506')) { $ceis[]=6;}
			if (strstr($usuario['acciones'],'C31507')) { $ceis[]=7;}
			if (strstr($usuario['acciones'],'C31508')) { $ceis[]=8;}
			if (strstr($usuario['acciones'],'C3150T')) { $ceis = array(1,2,3,4,5,7,8);}
			
			if ($usuario['usr_id'] == 261)
			{
				$ceis = array(1,2,3,4,5,7,8);
				$this->db->where_in('cei_id',$ceis );	
			}	
			else
			{ 	
				$this->db->where_in('cei_id',$ceis);	
			}	
			//$this->db->order_by('fsm_id DESC' );
			$this->db->order_by('usrlog_ingreso_f DESC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

    function get_asistencias($id)
        {
            $this->db->select("*");
            $this->db->from('sis25_asistencias_log');
			$this->db->where('fsm_id',$id);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row;
        }



    function count_all_asistencias($usuario)
        {
            $this->db->select("count(fsm_id) as regs");
            $this->db->from('sis25_asistencias_log');
			
			$ceis[]=0;
			if (strstr($usuario['acciones'],'C31501')) { $ceis[]=1;}
			if (strstr($usuario['acciones'],'C31502')) { $ceis[]=2;}
			if (strstr($usuario['acciones'],'C31503')) { $ceis[]=3;}
			if (strstr($usuario['acciones'],'C31504')) { $ceis[]=4;}
			if (strstr($usuario['acciones'],'C31505')) { $ceis[]=5;}
			if (strstr($usuario['acciones'],'C31506')) { $ceis[]=6;}
			if (strstr($usuario['acciones'],'C31507')) { $ceis[]=7;}
			if (strstr($usuario['acciones'],'C31508')) { $ceis[]=8;}
			if (strstr($usuario['acciones'],'C3150T')) { $ceis = array(1,2,3,4,5,7,8);}
			
			if ($usuario['usr_id'] == 261)
			{
				$ceis = array(1,2,3,4,5,7,8);
				$this->db->where_in('cei_id',$ceis );	
			}	
			else
			{ 	
				$this->db->where_in('cei_id',$ceis);	
			}
			
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

		function borra_asistencia($fsm_id)
		{
			$this->db->where('fsm_id', $fsm_id);
			return $this->db->delete('sis25_asistencias_log');
		}


        function asistencia($params)
        {
            //$data = array_merge($params, log_insert('Nuevo empleado'));
            $this->db->insert('sis25_asistencias_log', $params);
            return $this->db->insert_id();
        }


        function ultima_asistencia($id)
        {   
            $this->db->select('*');
            $this->db->from('sis25_asistencias_log');
            $this->db->where('usr_id',$id);
			$this->db->order_by('fsm_id DESC');
			$this->db->limit(1);
            $result = $this->db->get();
			return $result->row_array();
        }

        function asistencia_actualiza($fsm_id, $params)
        {            
			$this->db->where('fsm_id',$fsm_id);
            return $this->db->update('sis25_asistencias_log',$params);
		
        }		

	    function get_all_empleados_asisten($usuario)
        {			
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('emp_id', 31 );
			$this->db->where('clte_id', null );
			
			$ceis[]=0;
			if ($usuario['usr_id'] == 261 )
			{
				$ceis = array(1,2,3,4,5,7,8);
				$this->db->where_in('cei_id',$ceis );	
			}
			else
			{
				if (strstr($usuario['acciones'],'C31501')) { $ceis[]=1;}
				if (strstr($usuario['acciones'],'C31502')) { $ceis[]=2;}
				if (strstr($usuario['acciones'],'C31503')) { $ceis[]=3;}
				if (strstr($usuario['acciones'],'C31504')) { $ceis[]=4;}
				if (strstr($usuario['acciones'],'C31505')) { $ceis[]=5;}
				if (strstr($usuario['acciones'],'C31506')) { $ceis[]=6;}
				if (strstr($usuario['acciones'],'C31507')) { $ceis[]=7;}
				if (strstr($usuario['acciones'],'C31508')) { $ceis[]=8;}
				if (strstr($usuario['acciones'],'C3150T')) { $ceis = array(1,2,3,4,5,7,8);}
				$this->db->where_in('cei_id',$ceis);	
			}	
			
			$this->db->like('usr_estatus_cve','Activo' );
			$this->db->order_by('usr_paterno,usr_materno,usr_nombre DESC' );
            $result = $this->db->get();
            return $result->result_array();
        }



	    function get_all_empleados()
        {			
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('emp_id', 31 );
			$this->db->where('usr_id !=', 261 );
			$this->db->like('usr_estatus_cve','Activo' );
			$this->db->order_by('usr_paterno,usr_materno,usr_nombre DESC' );
            $result = $this->db->get();
            return $result->result_array();
        }




        function get_all()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            if(get_perfil_id() == 4)
            {
                $this->db->where('emp_id', get_emp_id());
            }
			$this->db->order_by('usr_nombre ASC','usr_paterno ASC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_all_report()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            //$this->db->where('emp_id',$emp_id);
            //$this->db->where('cei_id',$cei);
            //$this->db->where('usr_puesto',$puesto);
            //if ($estatus != '') {$this->db->where('usr_estatus_cve',$estatus);}
			$this->db->order_by('perfil_id','usr_nombre','usr_paterno');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_all_report_hc($emp_id='', $estatus='' , $cei='', $puesto='', $usuario='')
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('emp_id',$emp_id);
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            if($puesto != ''){ $this->db->like('usr_puesto',$puesto); }
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            $this->db->where('usr_estatus_cve','Activo');
			$this->db->where('clte_id is NULL');
			$this->db->order_by('usr_paterno','usr_materno','usr_nombre');
            $result = $this->db->get();
            return $result->result_array();
        }




        function get_all_report_desactivado($emp_id='', $estatus='' , $cei='', $puesto='', $usuario='')
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            
			if ($emp_id != '') { $this->db->where('emp_id',$emp_id); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            if($puesto != ''){ $this->db->like('usr_puesto',$puesto); }
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            $this->db->where('usr_estatus_cve','Desactivado');
			$this->db->where('clte_id is NULL');
			$this->db->order_by('emp_id, usr_paterno','usr_materno','usr_nombre');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_all_report_nom035($emp_id='', $estatus='' , $cei='', $puesto='', $usuario='')
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');            
			if($emp_id != ''){ $this->db->where('emp_id',$emp_id); }
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            if($puesto != ''){ $this->db->like('usr_puesto',$puesto); }
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            $this->db->where('usr_estatus_cve','Activo');
			$this->db->where('clte_id >', 0);
			$this->db->order_by('emp_id, usr_paterno','usr_materno','usr_nombre');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_all_report_cliente($emp_id='', $estatus='' , $cei='', $puesto='', $usuario='')
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
           // $this->db->where('emp_id',$emp_id);
			$this->db->where('emp_id !=',31);
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            if($puesto != ''){ $this->db->like('usr_puesto',$puesto); }
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            $this->db->where('usr_estatus_cve','Activo');
			$this->db->where('clte_id is NULL');
			$this->db->order_by('emp_id, usr_paterno','usr_materno','usr_nombre');
            $result = $this->db->get();
            return $result->result_array();
        }



        function get_all_report_empresa($emp_id='', $estatus='' , $cei='', $puesto='', $usuario='')
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('emp_id',$emp_id);
            
            //$this->db->where('usr_puesto',$puesto);
            //$this->db->where('usr_username',$usuario);
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            if($puesto != ''){ $this->db->like('usr_puesto',$puesto); }
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            if ($estatus != '') {$this->db->where('usr_estatus_cve',$estatus);}
			$this->db->order_by('perfil_id','usr_nombre','usr_paterno');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_all_report_empresa_by_portal($emp_id='', $estatus='' , $cei='', $puesto='', $usuario='',$portal)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('emp_id',$emp_id);
            
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            if($puesto != ''){ $this->db->like('usr_puesto',$puesto); }
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            if ($estatus != '') {$this->db->where('usr_estatus_cve',$estatus);}
			$this->db->not_like('usr_puesto','ADMINISTRADOR - HC');
			$this->db->like('portal',$portal); 
			$this->db->order_by('perfil_id','usr_nombre','usr_paterno');
            $result = $this->db->get();
            return $result->result_array();
        }


	    function get_allo_hco($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('emp_id',31);
			$this->db->order_by('usr_nombre ASC','usr_paterno ASC');
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }		


	    function get_allo_empresa($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('perfil_id', 4);
			$this->db->order_by('usr_nombre ASC','usr_paterno ASC');
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

    function borra_empleado($fsm_id)
    {
        $this->db->where('usr_id', $fsm_id);
        return $this->db->delete('sis20_usuarios');
    }
		
	    function get_allo($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->order_by('usr_username ASC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }	



    function count_all_clientes()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
			$this->db->where('perfil_id',4);
			$where = "clte_id is NULL";
			$this->db->where($where);
			$this->db->where('usr_estatus_cve','Activo');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

	    function get_all_clientes($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('perfil_id',4);  	
			$this->db->where('usr_estatus_cve','Activo');   
			$where = "clte_id is NULL";
			$this->db->where($where);
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }


		function count_all_desactivados()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
			$this->db->where('usr_estatus_cve','Desactivado');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


	    function get_all_desactivados($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('usr_estatus_cve','Desactivado'); 
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }



    function count_all_nom035()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
			$this->db->where('clte_id >', 0);
			$this->db->where('usr_estatus_cve','Activo');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

	    function get_all_nom035($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');			 	
			$this->db->where('usr_estatus_cve','Activo');   
			$this->db->where('clte_id >', 0);
			//$this->db->order_by('emp_id ASC' );
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );			
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

	    function get_all_nom035_by_emp($rows,$emp)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');			 	
			$this->db->where('usr_estatus_cve','Activo');   
			$this->db->where('emp_id',$emp); 
			$this->db->where('clte_id >', 0);
			//$this->db->order_by('emp_id ASC' );
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );			
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

    function count_all_hc()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
			$this->db->where('emp_id',31);
			$where = "clte_id is NULL";
			$this->db->where($where);
			$this->db->where('usr_estatus_cve','Activo');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

	    function get_allo_hc($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('emp_id',31);  	
			$this->db->where('usr_estatus_cve','Activo');   
			$where = "clte_id is NULL";
			$this->db->where($where);
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }
		
		function get_allo_x($rows,$emp_id)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('emp_id',$emp_id );
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }	
		
	
	
	    function count_all_x($emp_id)
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
			$this->db->where('emp_id',$emp_id );
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
 


 
    function count_all()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

    function count_all_empresa()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
            $this->db->where('perfil_id',4);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }



    function count_all_hco()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
            $this->db->where('emp_id', 31);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
   
        function get_id($id)
        {   
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);
            $result = $this->db->get();
			return $result->row_array();
        }
        


        function get_medicos_recetas()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('receta','SI' );
			$this->db->order_by('usr_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_medicos_recetas_activos()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('receta','SI' );
			$this->db->like('usr_estatus_cve','Activo' );
			$this->db->order_by('usr_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_in($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }
		
        function get($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }


        function get_pesonal_outsourcing()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('emp_id', 31);
			 $this->db->where('usr_eje', 1);
			$this->db->like('usr_estatus_cve', 'Activo');
			$titulos= array('DR.', 'DRA.', 'LIC.','ENF.');
			$this->db->where_in('usr_titulo',$titulos );	
			$this->db->where('clte_id is NULL');
			$this->db->order_by('usr_titulo','ASC');
			$this->db->order_by('usr_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }



		
        function get_worker_usuario($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('usr_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }		

        function get_sp($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }

        function get_usr_username($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('usr_username', $id);
            $result = $this->db->get();
            return $result->row_array();
        }		
    
        function actualiza($usr_id, $params)
        {
            $data = array_merge($params, log_update('Actualiza Empleado'));
            $this->db->where('usr_id',$usr_id);
            return $this->db->update('sis20_usuarios',$data);
        }
        
        function inserta($params)
        {
            $data = array_merge($params, log_insert('Nuevo empleado'));
            $this->db->insert('sis20_usuarios', $data);
            return $this->db->insert_id();
        }
		
        function get_roots($id)
        {
            $select = "root1,root2,root3,root4,root5,root6,usr_emp_asig";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }	


        function get_unidad_reclutador($id)
        {
            $select = "usr_unidad_reclutadora";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }		


        function get_cei_filtro($id)
        {
            $select = "filtro_cei_id";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
			$result->row_array();			
			$row = $result->row_array();
            return $row['filtro_cei_id'];
           
        }	

        function get_filtro($id)
        {
            $select = "filtro_id";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
			$result->row_array();			
			$row = $result->row_array();
            return $row['filtro_id'];
           
        }	
		
		function get_so_filtro($id)
        {
            $select = "filtro_so_id";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
			$result->row_array();			
			$row = $result->row_array();
            return $row['filtro_so_id'];
           
        }
		
        function get_emp_asig($id)
        {
            $select = "usr_emp_asig";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
			$result->row_array();			
			$row = $result->row_array();
            return $row['usr_emp_asig'];
           
        }		

/**************************************************************************************/         


        function busca_sura($nombre = '', $paterno='',$materno='',$empresa = '', $cei='', $usuario='', $puesto='',$estatus='')
        {            
            $this->db->select('usr_id,usr_username,emp_id,cei_id,
			usr_nombre,usr_paterno,usr_materno,usr_puesto,usr_estatus_cve');
            $this->db->from('sis20_usuarios');
			
			
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			if($puesto != ''){ $this->db->like('usr_puesto',$puesto); } 
            
			if($estatus != ''){ $this->db->like('usr_estatus_cve',$estatus); } 
			$this->db->not_like('usr_puesto','ADMINISTRADOR - HC');
			$this->db->like('portal','SURA');
            $this->db->order_by('usr_nombre','ASC');
			$this->db->order_by('emp_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }



        function busca_hc($nombre = '', $paterno='',$materno='',$empresa = '', $cei='', $usuario='', $puesto='',$estatus='')
        {            
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			
			
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            $this->db->where('emp_id',31);
			$this->db->where('clte_id is NULL');
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			if($puesto != ''){ $this->db->like('usr_puesto',$puesto); } 
            
			$this->db->like('usr_estatus_cve','Activo');  
			
			
            $this->db->order_by('usr_nombre','ASC');
			$this->db->order_by('emp_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/ 
        function busca_desactivados($nombre = '', $paterno='',$materno='',$empresa = '', $cei='', $usuario='', $puesto='',$estatus='')
        {            
            $this->db->select('usr_id,usr_username,emp_id,cei_id,
			usr_nombre,usr_paterno,usr_materno,usr_puesto,usr_estatus_cve');
            $this->db->from('sis20_usuarios');
			
			
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			if($puesto != ''){ $this->db->like('usr_puesto',$puesto); } 
            
			if($estatus != ''){ $this->db->like('usr_estatus_cve',$estatus); } 
			
			
            $this->db->order_by('usr_nombre','ASC');
			$this->db->order_by('emp_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }	
        function busca_x($nombre = '', $paterno='',$materno='',$empresa = '', $cei='', $usuario='', $puesto='',$estatus='')
        {            
            $this->db->select('usr_id,usr_username,emp_id,cei_id,
			usr_nombre,usr_paterno,usr_materno,usr_puesto,usr_estatus_cve');
            $this->db->from('sis20_usuarios');
			
			
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			if($puesto != ''){ $this->db->like('usr_puesto',$puesto); } 
            
			if($estatus != ''){ $this->db->like('usr_estatus_cve',$estatus); } 
			$this->db->where('clte_id >',0);
			$this->db->order_by('usr_paterno ASC' );
			$this->db->order_by('usr_materno ASC' );
			$this->db->order_by('usr_nombre ASC' );
			$this->db->order_by('emp_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/ 
        function busca_nom035($nombre = '', $paterno='',$materno='',$empresa = '', $cei='', $usuario='', $puesto='',$estatus='')
        {            
            $this->db->select('usr_id,usr_username,emp_id,cei_id,
			usr_nombre,usr_paterno,usr_materno,usr_puesto,usr_estatus_cve');
            $this->db->from('sis20_usuarios');
			
			
            if($usuario != '') { $this->db->where('usr_username',381451); }
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			
        	if($cei != ''){ $this->db->where('cei_id',$cei); }
            
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			if($puesto != ''){ $this->db->like('usr_puesto',$puesto); } 
            
			if($estatus != ''){ $this->db->where('usr_estatus_cve',$estatus); }
			$this->db->where('clte_id >',0);
			
            $this->db->order_by('usr_nombre','ASC');
			$this->db->order_by('emp_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }		
/**************************************************************************************/ 
        function busca_cliente($nombre = '', $paterno='',$materno='',$empresa = '', $cei='', $usuario='', $puesto='',$estatus='')
        {            
            $this->db->select('usr_id,usr_username,emp_id,cei_id,
			usr_nombre,usr_paterno,usr_materno,usr_puesto,usr_estatus_cve');
            $this->db->from('sis20_usuarios');
			
			
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			if($puesto != ''){ $this->db->like('usr_puesto',$puesto); } 
            $this->db->where('clte_id is NULL');
			if($estatus != ''){ $this->db->like('usr_estatus_cve',$estatus); } 
			
			
            $this->db->order_by('usr_nombre','ASC');
			$this->db->order_by('emp_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/ 

        function busca($nombre = '', $paterno='',$materno='',$empresa = '', $cei='', $usuario='', $puesto='',$estatus='')
        {            
            $this->db->select('usr_id,usr_username,emp_id,cei_id,
			usr_nombre,usr_paterno,usr_materno,usr_puesto,usr_estatus_cve');
            $this->db->from('sis20_usuarios');
			
			
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
			
			if($cei != ''){ $this->db->where('cei_id',$cei); }
            
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			if($puesto != ''){ $this->db->like('usr_puesto',$puesto); } 
            
			if($estatus != ''){ $this->db->like('usr_estatus_cve',$estatus); } 
			
			
            $this->db->order_by('usr_nombre','ASC');
			$this->db->order_by('emp_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }
/**************************************************************************************/        
	
        function busca_usuario_empresa($nombre = '', $paterno='',$materno='',$empresa = '')
        {            
            $this->db->select('*');
            
            $this->db->from('sis20_usuarios');
            $this->db->where('perfil_id', 4);
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
            if($nombre != ''){ $this->db->like(usr_nombre,$nombre); }            
            if($paterno != ''){ $this->db->like(usr_paterno,$paterno); }            
			if($materno != ''){ $this->db->like(usr_materno,$materno); }            
            $this->db->order_by('usr_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
}