<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Matdif_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }

       function get_docs($emp_id)
        {
            $this->db->select('*');
            $this->db->from('sis_matdif');
            $this->db->where('emp_id', $emp_id);
            $this->db->order_by('doc_f','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_docs_section($cliente_id,$section)
        {
            $this->db->select('*');
            $this->db->from('sis_matdif');
            $this->db->where('clte_id', $cliente_id);
			$this->db->where('empresa', $section);
			$this->db->order_by('doc_nombre','ASC');
            $this->db->order_by('doc_f','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }		
        
        function get_doc($doc_id)
        {
            $this->db->select('*');
            $this->db->from('sis_matdif');
            $this->db->where('doc_id', $doc_id);
            $result = $this->db->get();
            return $result->row_array();
        }

		function borra_doc($doc_name,$empresa)
		{
            return $this->db->delete('sis_matdif');
		}
		
		function delete_doc($fsm_id)
		{
			$this->db->where('doc_id', $fsm_id);
			return $this->db->delete('sis_matdif');
		}

		function inserta_borrado($data_insert)
		{
			$this->db->insert('sis_borrado_docs', $data_insert);
			return $this->db->insert_id();
		}
		
        function add_doc($data_insert)
        {
			//$this->db->while('doc_name', 'ARMANDO');
            //$s=$this->db->delete('sis_matdif');
			
			
			$this->db->insert('sis_matdif', $data_insert);
            return $this->db->insert_id();
        }
        


}