<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Empresa extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('empresa/Empresa_model','empresa');
    }

    /*
     * Listing of empresas
     */
    function index()
    {
        $data['empresas'] = $this->empresa->get_all_empresas();
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Empresas',
            'view' => 'empresa/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    /*
     * Adding a new empresa
     */
    
    function find()
    {
        $term = $this->input->get('term');
        $empresas = $this->empresa->find_empresa($term);
        $empresas_formated = array();
        foreach ($empresas as $empresa) {
            $empresas_formated[] = array('label' => $empresa['emp_nombre'],'value' => $empresa['emp_id']);
        }
        echo json_encode($empresas_formated);
    }
    
    function get($emp_id)
    {
        if($emp_id)
        {
            send_json('OK',$this->empresa->get_empresa($emp_id));
        }
        else
        {
            send_json('ERROR','');
        }
    }
    
    function nueva()
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('razonsocial','Razón Social','required');
            $this->form_validation->set_rules('rfc','RFC','required');
            $this->form_validation->set_rules('pais','País','required');
            $this->form_validation->set_rules('cp','cp','required');
            $this->form_validation->set_rules('entidad','Entidad','required');
            $this->form_validation->set_rules('colonia','Colonia','required');
            $this->form_validation->set_rules('ciudad','Ciudad','required');
            $this->form_validation->set_rules('municipio','Municipio','required');
            $this->form_validation->set_rules('calle','Calle','required');
            $this->form_validation->set_rules('next','N° exterior','required');
            //$this->form_validation->set_rules('nint','N° interior','required');
            $this->form_validation->set_rules('resp','Responsable','required');
            $this->form_validation->set_rules('tel1','Teléfono de contacto 1','required');
            //$this->form_validation->set_rules('tel2','Teléfono de contacto 2','required');
            $this->form_validation->set_rules('email','Correo electrónico','required');

            if($this->form_validation->run())
            {
                $data_emp['emp_razon_social'] = $this->input->post('razonsocial');
                $data_emp['emp_rfc'] = $this->input->post('rfc');
                $data_emp['emp_calle'] = $this->input->post('calle');
                $data_emp['emp_num_ext'] = $this->input->post('next');
                $data_emp['emp_num_int'] = $this->input->post('nint');
                $data_emp['emp_colonia'] = $this->input->post('colonia');
                $data_emp['emp_ciudad'] = $this->input->post('ciudad');
                $data_emp['emp_municipio'] = $this->input->post('municipio');
                $data_emp['emp_estado'] = $this->input->post('entidad');
                $data_emp['emp_cp'] = $this->input->post('cp');
                $data_emp['emp_responsable'] = $this->input->post('resp');
                $data_emp['emp_telefono'] = limpia_telefono($this->input->post('tel1'));
                $data_emp['emp_telefono_2'] = limpia_telefono($this->input->post('tel2'));
                $data_emp['emp_correo'] = $this->input->post('email');
                $data_emp['emp_estatus_cve'] = 'ACTIVO';
                $data_emp['emp_alta_f'] = date('Y-m-d');
                
                $data_emp = array_to_upper($data_emp);
                if(!empty($_FILES['logo']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './empresa/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('logo'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_emp['emp_logo'] = $data['file_name'];
                    }
                }

                if($this->empresa->inserta($data_emp))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la empresa.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empresa',
                'view' => 'empresa/add'
               );
            render_template($params_view);  
        }
    }  

    /*
     * Editing a empresa
     */
    function edita($emp_id)
    {
        $empresa = $this->empresa->get_empresa($emp_id);
        
        if($empresa)
        {
            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('razonsocial','Razón Social','required');
                $this->form_validation->set_rules('rfc','RFC','required');
                $this->form_validation->set_rules('pais','País','required');
                $this->form_validation->set_rules('cp','cp','required');
                $this->form_validation->set_rules('entidad','Entidad','required');
                $this->form_validation->set_rules('colonia','Colonia','required');
                $this->form_validation->set_rules('ciudad','Ciudad','required');
                $this->form_validation->set_rules('municipio','Municipio','required');
                $this->form_validation->set_rules('calle','Calle','required');
                $this->form_validation->set_rules('next','N° exterior','required');
                //$this->form_validation->set_rules('nint','N° interior','required');
                $this->form_validation->set_rules('resp','Responsable','required');
                $this->form_validation->set_rules('tel1','Teléfono de contacto 1','required');
                //$this->form_validation->set_rules('tel2','Teléfono de contacto 2','required');
                $this->form_validation->set_rules('email','Correo electrónico','required');
                $this->form_validation->set_rules('estatus','Estatus','required');

                if($this->form_validation->run())
                {
                    $data_emp['emp_razon_social'] = $this->input->post('razonsocial');
                    $data_emp['emp_rfc'] = $this->input->post('rfc');
                    $data_emp['emp_calle'] = $this->input->post('calle');
                    $data_emp['emp_num_ext'] = $this->input->post('next');
                    $data_emp['emp_num_int'] = $this->input->post('nint');
                    $data_emp['emp_colonia'] = $this->input->post('colonia');
                    $data_emp['emp_ciudad'] = $this->input->post('ciudad');
                    $data_emp['emp_municipio'] = $this->input->post('municipio');
                    $data_emp['emp_estado'] = $this->input->post('entidad');
                    $data_emp['emp_cp'] = $this->input->post('cp');
                    $data_emp['emp_responsable'] = $this->input->post('resp');
                    $data_emp['emp_telefono'] = limpia_telefono($this->input->post('tel1'));
                    $data_emp['emp_telefono_2'] = limpia_telefono($this->input->post('tel2'));
                    $data_emp['emp_correo'] = $this->input->post('email');
                    $data_emp['emp_estatus_cve'] = $this->input->post('estatus');
                    
                    $data_emp = array_to_upper($data_emp);
                    if(!empty($_FILES['logo']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './empresa/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('logo'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_emp['emp_logo'] = $data['file_name'];
                        }
                    }

                    if($this->empresa->actualiza($empresa['emp_id'],$data_emp ))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar la empresa.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['empresa'] = $empresa;
                $data['sucursal'] = $this->empresa->get_sucursal($emp_id);
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Empresa',
                    'view' => 'empresa/edit',
                    'view_data' => $data,

                   );
                render_template($params_view);  
            }
        }
        else
        {
            show_error('La empresa no existe.');
        }
    } 

    /*
     * Deleting empresa
     */
    function remove($emp_id)
    {
        $empresa = $this->empresa->get_empresa($emp_id);

        // check if the empresa exists before trying to delete it
        if(isset($empresa['emp_id']))
        {
            $this->empresa->delete_empresa($emp_id);
            redirect('empresa/index');
        }
        else
            show_error('The empresa you are trying to delete does not exist.');
    }
    function nueva_sucursal($emp_id)
    {
        $empresa = $this->empresa->get_empresa_by_id($emp_id);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $data_suc['suc_alias'] = $this->input->post('nombre');
            $data_suc['suc_pais'] = $this->input->post('pais');
            $data_suc['suc_cp'] = $this->input->post('cp');
            $data_suc['suc_edo'] = $this->input->post('edo');
            $data_suc['suc_colonia'] = $this->input->post('colonia');
            $data_suc['suc_localidad'] = $this->input->post('localidad');
            $data_suc['suc_municipio'] = $this->input->post('municipio');
            $data_suc['suc_calle'] = $this->input->post('calle');
            $data_suc['suc_next'] = $this->input->post('next');
            $data_suc['suc_nint'] = $this->input->post('nint');
            $data_suc['suc_telefono'] = $this->input->post('telefono');
            $data_suc['suc_correo'] = $this->input->post('correo');
            $data_suc['emp_id'] = $empresa['emp_id'];
     
            if($this->empresa->inserta_sucursal($data_suc))
            {
                send_json_ok('Se guardó de forma correcta');
                
            }
            else
            {
                send_json_error('Ocurrió un error al guardar la empresa.');
            }
        }
        else
        {
            //no necesitas las sucursales aqui
            //$data['sucursales'] = $this->empresa->get_sucursal($emp_id);
            //$data['test'] = 'test';//
            //todo los arreglos que le pases a la vista se declaran aqui en el data

            //ejemplo si quieres pasarle todos los datos de la empresa
            //fijate en el nombre de la variable
            //ese de empresa es como identificas la variable en la vista, el 'empresa' se convierte en una variable
            //por algo no se ve
            $data['empresa'] = $empresa;
            $data['sucursales'] =  $this->empresa->get_sucursal($emp_id);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empresa',
                'view' => 'empresa/nueva_sucursal',
                 'view_data' => $data
            );
            render_template($params_view);   
        }
    }
    function sucursales_edita($suc_id)
    {
      $sucursal = $this->empresa->get_sucursal2($suc_id);
          if($sucursal)
          {
            if(isset($_POST) && count($_POST) > 0)     
                {
                    $data_suc['suc_alias'] = $this->input->post('nombre');
                    $data_suc['suc_pais'] = $this->input->post('pais');
                    $data_suc['suc_cp'] = $this->input->post('cp');
                    $data_suc['suc_edo'] = $this->input->post('edo');
                    $data_suc['suc_colonia'] = $this->input->post('colonia');
                    $data_suc['suc_localidad'] = $this->input->post('localidad');
                    $data_suc['suc_municipio'] = $this->input->post('municipio');
                    $data_suc['suc_calle'] = $this->input->post('calle');
                    $data_suc['suc_next'] = $this->input->post('next');
                    $data_suc['suc_nint'] = $this->input->post('nint');
                    $data_suc['suc_telefono'] = $this->input->post('telefono');
                    $data_suc['suc_correo'] = $this->input->post('correo');
                    $data_suc['emp_id'] = $sucursal['emp_id'];
               
              
                    if($this->empresa->actualiza_sucursal($sucursal['suc_id'],$data_suc))
                    {
                        send_json_ok('Se guardó de forma correcta');
                        
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al guardar la sucursal.');
                    }
                }
                else
                {
                    
                    $data['sucursal'] = $sucursal;
                    $this->load->helper('template');
                    $params_view = array(
                        'title' => 'Empresa',
                        'view' => 'empresa/sucursales_edita',
                         'view_data' => $data
                    );
                    render_template($params_view);   
                }
          }
      
    }

    function elimina_sucursal($suc_id)
    {
        $sucursal = $this->empresa->get_sucursal2($suc_id);
        if($sucursal)
        {
            if($this->empresa->delete_sucursal($suc_id))
            {
                send_json_ok('Se elimino de forma correcta');

            }
            else
            {
                send_json_error('Ocurrió un error al eliminar la sucursal.');
            }
            

        }

    }


}


    