//////////////////////////////////////AJAX//////////////////////////////////////
function getDataAjax(obj) {
    //comprueba que es una instancia de jquery sino es instancia se da por entendido que es url
    if (obj instanceof jQuery)
    {
        //si es a o submit
        if ($(obj).attr('action'))
        {
            this.url = $(obj).attr('action');
            this.data = $(obj).serialize();
            this.type = $(obj).attr('method');
        }
        else if ($(obj).attr('href'))
        {
            this.url = $(obj).attr('href');
            this.data = null;
        }
    }
    else
    {
        this.url = obj;
        this.data = null;
    }
    this.async = true;
    this.type = 'POST';
    this.dataType = 'json';
    this.receivedData = null;
    this.ok = null;
    this.complete = null;
    this.error = null;
    this.form = null;
    this.fail = null;
    this.spin = null;
    this.getData = function () {
        var nurl = this.url;
        var nobj = this.obj;
        var ndata = this.data;
        var nasync = this.async;
        var ntype = this.type;
        var ndataType = this.dataType;
        var error = this.error;
        var ok = this.ok;
        var complete = this.complete;
        var fail = this.fail;
        var spin = this.spin;
        var element = null;
        //para el spin
        if (obj instanceof jQuery)
        {
            if (obj.attr('action'))
            {
                //desabilita doble click solo si es button o form
                element = $(obj).find('button');
            }
            if (obj.attr('href'))
            {
                element = obj;
                $(element).attr( "disabled", true);
            }
            $(element).prop( "disabled", true);
            //crea el elemento para el spiner
            spin = $('<div id="spin" />');
            element.append(spin);

            //muestra el spin
            show_spin(spin);
        }
        else
        {
            //show_spin(spin);
        }
        $.ajax({
            url: nurl,
            data: ndata,
            type: ntype,
            dataType: ndataType,
            async: nasync
        })
        .done(function (data) {
            if (data.status == 'OK') {
                if (ok) {
                    ok(data);
                }
                else {
                    show_exito_onShow(data.content);
                }
            } else {
                if (error) {
                    error(data);
                }
                else {
                    show_error(data.content);
                }
            }
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
            hide_spin(spin);
            //falla la peticion
            if(jqXHR.status == 401)
            {
                show_error('La sesión finalizó, deberá iniciar sesión de nuevo.', function(){
                    window.location = base_url + 'user/registro';
                });
            }
            else
            {
                show_error('Error code: ' + jqXHR.status + '<br>Error msg: ' + jqXHR.statusText);
            }
        })
        .always(function (data) {
            if (obj instanceof jQuery)
            {
                $(element).prop( "disabled", false);
                if (element.attr('href'))
                {
                    $(element).attr( "disabled", false);
                }
            }
            
            hide_spin(spin);
            if (complete) {
                complete(data);
            }
        });
    }
}
//////////////////////////////////////AJAX//////////////////////////////////////

//////////////////////////////////////SPIN//////////////////////////////////////
function show_spin(element) {
    if (element !== false)
    {
        $.fn.spin.presets.flower = {
            lines: 9,
            length: 2,
            width: 6,
            radius: 6,
            scale: 0.7,
            color: '#000',
            opacity: 0.4,
            speed: 1.5
        }
        if (element) {
            $(element).spin('flower', 'black');
        }
    }
}

function hide_spin(element) {
    if (element === false)
        ;
    else {
        if (element) {
            $(element).spin(false);
            $(element).remove();
        }
    }
}
//////////////////////////////////////SPIN//////////////////////////////////////



/////////////////////////////////////ALERT//////////////////////////////////////

function show_error(texto, callBack) {
    noty({
        //text: texto + '<div><i>click para cerrar</i></div>',
        text: texto,
        theme: 'defaultTheme',
        type: 'error',
        timeout: 2000,
        layout: 'center',
        template: '<div class="noty_message"><button type="button" style="color: darkred; opacity: 0.6" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button><span class="noty_text"></span><div class="noty_close"></div></div>',
        progressBar: true,
        animation: {
            open: {height: 'toggle'},
            close: {height: 'toggle'},
            easing: 'swing',
            speed: 500 // opening & closing animation speed
        },
        callback: {
            onShow: function () {
            },
            afterShow: function () {
            },
            onClose: function () {
            },
            afterClose: function () {
                if (callBack) {
                    callBack();
                }
            }
        }
    });
}

function show_exito_onShow(texto, callBack) {
    noty({
        text: texto,
        type: 'success',
        theme: 'defaultTheme',
        timeout: 2000,
        layout: 'center',
        progressBar: true,
        callback: {
            onShow: function () {
                if (callBack) {
                    callBack();
                }
            },
            afterShow: function () {
            },
            onClose: function () {
            },
            afterClose: function () {
            }
        }
    });
}

function show_exito_afterClose(texto, callBack) {
    noty({
        text: texto,
        type: 'success',
        theme: 'defaultTheme',
        timeout: 2000,
        layout: 'center',
        progressBar: true,
        callback: {
            onShow: function () {
            },
            afterShow: function () {
            },
            onClose: function () {
            },
            afterClose: function () {
                if (callBack) {
                    callBack();
                }
            }
        }
    });
}

function show_alert(texto) {
    noty({
        text: texto,
        type: 'alert',
        theme: 'defaultTheme',
        layout: 'center',
        timeout: 2000,
        progressBar: true
    });
}

function show_warning(texto) {
    noty({
        text: texto,
        type: 'warning',
        theme: 'defaultTheme',
        layout: 'center',
        timeout: 2000,
        progressBar: true
    });
}

function show_information(texto) {
    noty({
        text: texto,
        type: 'information',
        theme: 'defaultTheme',
        layout: 'center',
        timeout: 2000,
        progressBar: true
    });
}

function show_confirm(texto, callBack, element) {
    if (element) {
        $(element).noty({
            text: texto,
            type: 'confirm',
            theme: 'defaultTheme',
            layout: 'center',
            modal:true,
            animation: {
                open: {height: 'toggle'},
                close: {height: 'toggle'},
                easing: 'swing',
                speed: 500 // opening & closing animation speed
            },
            buttons: [
                {addClass: 'btn btn-default',
                    text: 'Cancelar',
                    onClick: function ($noty) {
                        $noty.close();
                    }
                },
                {addClass: 'btn btn-primary',
                    text: 'Si',
                    onClick: function ($noty) {
                        $noty.close();
                        callBack();
                    }
                }
            ]
        });
    } else {
        noty({
            text: texto,
            type: 'confirm',
            theme: 'defaultTheme',
            layout: 'center',
            modal:true,
            buttons: [
                {addClass: 'btn btn-default',
                    text: 'Cancelar',
                    onClick: function ($noty) {
                        $noty.close();
                    }
                },
                {addClass: 'btn btn-primary',
                    text: 'Si',
                    onClick: function ($noty) {
                        $noty.close();
                        callBack();
                    }
                }
            ]
        });
    }
}

/////////////////////////////////////ALERT//////////////////////////////////////


/////////////////////////////////////DIALOG//////////////////////////////////////

function show_layer(ancho, alto, content, obj){
    obj = obj || '#layer';
    $(obj).html(content);
    $(obj).dialog({
        dialogClass: 'no-close',
        height: alto,
        width: ancho,
        draggable: true,
        modal:true,
        resizable: true,
        title: $(obj).find('.title_dialog').val(),
        show: {
            effect: "scale",
            duration: 200
        },
        hide: {
            effect: "scale",
            duration: 200
        }
    });
    $(obj).dialog({
        close: function( event, ui ) {
            hide_layer(obj);
        }
    });
}

function hide_layer(obj, callBack){
    obj = obj || '#layer';
    $(obj).html('');
    $(obj).dialog('destroy');
    if (callBack) {
        callBack();
    }
}

/////////////////////////////////////DIALOG//////////////////////////////////////