$(function() {

    var signaturePadPac = new SignaturePad(document.getElementById('signature-pad'), {
        backgroundColor: 'rgba(255, 255, 255, 0)',
        penColor: 'rgb(0, 0, 0)'
    });
    var saveButtonPac = document.getElementById('save-firma');
    var cancelButtonPac = document.getElementById('clear-firma');

    saveButtonPac.addEventListener('click', function(event) {
        event.preventDefault();
        var data = signaturePadPac.toDataURL('image/png');
        document.getElementById('firma').value = data;

        saveButtonPac.style.pointerEvents = "none";
        saveButtonPac.style.cursor = "default";

        $('#save-firma').closest('.div-firma').closest('.text-center').find('.firma').append($('<img src="' + data + '" >'));
        $('#save-firma').closest('.div-firma').closest('.text-center').find('canvas').addClass('hide');
        $('#clear-firma').removeClass('hide');
        $('#save-firma').addClass('hide');
    });

    cancelButtonPac.addEventListener('click', function(event) {
        event.preventDefault();
        signaturePadPac.clear();

        $('#save-firma').removeClass('hide');
        $('#clear-firma').addClass('hide');
        $('#clear-firma').closest('.div-firma').closest('.text-center').find('.firma').find('img').remove();
        $('#clear-firma').closest('.div-firma').closest('.text-center').find('.firma').find('canvas').removeClass('hide');
        document.getElementById('firma').value = '';

        saveButtonPac.style.pointerEvents = "auto";
        saveButtonPac.style.cursor = "pointer";
    });
});