$(document).ready(function() {    
    base_url = $('#base_url').val();
    var date = new Date(),
            d = date.getDate(),
            m = date.getMonth(),
            y = date.getFullYear(),
            started,
            categoryClass;
    var eventos = new Array();
    load_events(eventos);
    nueva_cita();
});

function header_events()
{
    $('.fc-prev-button').click(function(){
        var fecha = $('#calendar').fullCalendar('getDate').format('YYYY-MM-DD');
        var dataAjax = new getDataAjax(base_url + 'Agendac/eventjson/' + fecha);
        dataAjax.type = 'GET';
        dataAjax.ok = function(data){
            push_events(data.content);
        };
        dataAjax.error = function(data){
            console.log('No hay eventos');
        };
        dataAjax.getData();
    });

    $('.fc-next-button').click(function(){
       var fecha = $('#calendar').fullCalendar('getDate').format('YYYY-MM-DD');
        var dataAjax = new getDataAjax(base_url + 'Agendac/eventjson/' + fecha);
        dataAjax.type = 'GET';
        dataAjax.ok = function(data){
            push_events(data.content);
        };
        dataAjax.error = function(data){
            console.log('No hay eventos');
        };
        dataAjax.getData();
    });

    $(".fc-today-button").click(function(){
        var fecha = $('#calendar').fullCalendar('getDate').format('YYYY-MM-DD');
        var dataAjax = new getDataAjax(base_url + 'Agendac/eventjson/' + fecha);
        dataAjax.type = 'GET';
        dataAjax.ok = function(data){
            push_events(data.content);
        };
        dataAjax.error = function(data){
            console.log('No hay eventos');
        };
        dataAjax.getData();
    });
}

function click_event(calEvent)
{
    var obj = $(this);
    var dataAjax = new getDataAjax(calEvent.url);
    dataAjax.type = 'GET';
    dataAjax.ok = function(data){
        $('.modal').html(data.content);
        recordatorio();
        show_modal();
        cancel_modal();
        autocompleta_emp();
        //requerimiento HC-02
        send_form_cita(function(){
            hide_modal();
            $('#calendar').fullCalendar('removeEvents');
            //$('#calendar_citas').fullCalendar('removeEvents');
            var eventos = new Array();
            var dataAjax = new getDataAjax(base_url + 'Agendac/eventjson');
            dataAjax.type = 'GET';
            dataAjax.ok = function(data){
                $.each(data.content, function(k, i){
                    eventos.push({
                        title: i.title,
                        //start: new Date((i.fecha_ini_y), parseInt(i.fecha_ini_m), parseInt(i.fecha_ini_d), parseInt(i.fecha_ini_h), parseInt(i.fecha_ini_mm),0,0),
                        //end: new Date(parseInt(i.fecha_fin_y), parseInt(i.fecha_fin_m), parseInt(i.fecha_fin_d), parseInt(i.fecha_fin_h), parseInt(i.fecha_fin_mm),0,0),
                        start: i.fecha_ini, 
                        end: i.fecha_fin,
                        allDay: false,
                        url: base_url + 'Agendac/evento/' + i.id
                        });
                });
                $('#calendar').fullCalendar('renderEvents', eventos);
                $('#calendar_citas').fullCalendar('renderEvents', eventos);
            };
            dataAjax.error = function(data){
                console.log('No hay eventos');
            };
            dataAjax.getData();
        });
        borra(function(){
            hide_modal();
            $('#calendar').fullCalendar('removeEvents');
            $('#calendar_citas').fullCalendar('removeEvents');
            var eventos = new Array();
            var dataAjax = new getDataAjax(base_url + 'Agendac/eventjson');
            dataAjax.type = 'GET';
            dataAjax.ok = function(data){
                $.each(data.content, function(k, i){
                    eventos.push({
                        title: i.title,
                        //start: new Date((i.fecha_ini_y), parseInt(i.fecha_ini_m), parseInt(i.fecha_ini_d), parseInt(i.fecha_ini_h), parseInt(i.fecha_ini_mm),0,0),
                        //end: new Date(parseInt(i.fecha_fin_y), parseInt(i.fecha_fin_m), parseInt(i.fecha_fin_d), parseInt(i.fecha_fin_h), parseInt(i.fecha_fin_mm),0,0),
                        start: i.fecha_ini, 
                        end: i.fecha_fin,
                        allDay: false,
                        url: base_url + 'Agendac/evento/' + i.id
                        });
                });
                $('#calendar').fullCalendar('renderEvents', eventos);
                $('#calendar_citas').fullCalendar('renderEvents', eventos);
            };
            dataAjax.error = function(data){
                console.log('No hay eventos');
            };
            dataAjax.getData();
        });
        view_daterangepicker();
    };
    dataAjax.getData();
}

function click_day(fecha)
{
    //si el dia y hora es menor a hoy no agregarlo
    var f1 = new Date();
    var f2 = new Date(fecha.format());
    f2.setDate (f2.getDate() + 1);

    if(f2 < f1)
    {
        //no hace nada cuando el dia es menor a hoy
    }
    else 
    {
        var url = base_url + 'Agendac/add_evento/' + fecha.format();
        var dataAjax = new getDataAjax(url);
        dataAjax.type = 'GET';
        dataAjax.ok = function(data){
            $('#myModal').html(data.content);
            recordatorio();
            show_modal();
            cancel_modal();
            //requerimiento HC-02
            send_form_cita(function(){
                var eventos = new Array();
                var dataAjax = new getDataAjax(base_url + 'Agendac/eventjson');
                dataAjax.type = 'GET';
                dataAjax.ok = function(data){
                    $.each(data.content, function(k, i){
                        eventos.push({
                            title: i.title,
                            //start: new Date((i.fecha_ini_y), parseInt(i.fecha_ini_m), parseInt(i.fecha_ini_d), parseInt(i.fecha_ini_h), parseInt(i.fecha_ini_mm),0,0),
                            //end: new Date(parseInt(i.fecha_fin_y), parseInt(i.fecha_fin_m), parseInt(i.fecha_fin_d), parseInt(i.fecha_fin_h), parseInt(i.fecha_fin_mm),0,0),
                            start: i.fecha_ini, 
                            end: i.fecha_fin,
                            allDay: false,
                            url: base_url + 'Agendac/evento/' + i.id
                        });
                    });
                    $('#calendar').fullCalendar('renderEvents', eventos);
                    $('#calendar_citas').fullCalendar('renderEvents', eventos);
                };
                dataAjax.error = function(data){
                    console.log('No hay eventos');
                };
                dataAjax.getData();
            });
            view_daterangepicker();
        };
        dataAjax.getData();
    }
}

function push_events(array_eventos)
{
    var eventost = new Array();
    $('#calendar').fullCalendar('removeEvents');
    $.each(array_eventos, function(k, i){
        eventost.push({
            title: i.title,
            start: new Date(i.fecha_ini),
            end: new Date(i.fecha_fin),
            allDay: false,
            url: base_url + 'Agendac/evento/' + i.id
            });
    });
    $('#calendar').fullCalendar( 'renderEvents', eventost);
}

function ini_cal_mes()
{
    $('#calendar').fullCalendar({
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,list'
        },
        navLinks: true, // can click day/week names to navigate views
        editable: false,
        eventLimit: true, // allow "more" link when too many events
        monthNames: ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'],
        dayNames: ['Domingo','Lunes','Martes','Miercoles','Jueves','Viernes','Sabado'],
        dayNamesShort: ['Dom','Lun','Mar','Mie','Juv','Vie','Sab'],
        dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sa'],
        timeFormat: 'h(:mm)A',
        buttonText:{
            month:"Mes",
            week:"Semana",
            day:"Día",
            list:"Agenda",
            today: 'Hoy'
        },
        allDayHtml:"Todo<br/>el día",
        eventLimitText:"más",
        noEventsMessage:"No hay eventos para mostrar",
        prevText:"&#x3C;Ant",
        nextText:"Sig&#x3E;",
        currentText:"Hoy",
        height: 650,
        dayClick: function(date, jsEvent, view) {
            //click_day(date);
        },
        eventClick: function(calEvent, jsEvent, view) {
            jsEvent.preventDefault();
            click_event(calEvent);
        }
    });
}

function ini_cal_hoy()
{
    $('#calendar_citas').fullCalendar({
        header: {
            left: '',
            center: 'title',
            right: ''
        },
        navLinks: false, // can click day/week names to navigate views
        editable: false,
        eventLimit: false, // allow "more" link when too many events
        timeFormat: 'h(:mm)A',
        defaultView: 'listDay',
        views: {
            day: { // name of view
                titleFormat: '[Próximas citas]'
            }
        },
        monthNames: ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'],
        dayNames: ['Domingo','Lunes','Martes','Miercoles','Jueves','Viernes','Sabado'],
        dayNamesShort: ['Dom','Lun','Mar','Mie','Juv','Vie','Sab'],
        dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sa'],
        buttonText:{
            month:"Mes",
            week:"Semana",
            day:"Día",
            list:"Agenda",
            today: 'Hoy'
        },
        allDayHtml:"Todo<br/>el día",
        eventLimitText:"más",
        noEventsMessage:"No hay eventos para mostrar",
        prevText:"&#x3C;Ant",
        nextText:"Sig&#x3E;",
        currentText:"Hoy",
        height: 387,
        eventClick: function(calEvent, jsEvent, view) {
            jsEvent.preventDefault();
            click_event(calEvent);
        }
    });
}

function load_events(eventos)
{
    $('#calendar').fullCalendar('removeEvents');
    //$('#calendar_citas').fullCalendar('removeEvents');
    var dataAjax = new getDataAjax(base_url + 'Agendac/eventjson');
    dataAjax.type = 'GET';
    var spin = $('<div id="spin" />');
    $('.form-view').html('<div style="text-align:center;"></div>');
    var div = $('<div style="text-align:center;"></div>');
    div.append(spin);
    $('.panel-body').prepend(div);
    show_spin(spin);
    dataAjax.ok = function(data){
        $.each(data.content, function(k, i){
            eventos.push({
                title: i.title,
                //start: new Date((i.fecha_ini_y), parseInt(i.fecha_ini_m), parseInt(i.fecha_ini_d), parseInt(i.fecha_ini_h), parseInt(i.fecha_ini_mm),0,0),
                //end: new Date(parseInt(i.fecha_fin_y), parseInt(i.fecha_fin_m), parseInt(i.fecha_fin_d), parseInt(i.fecha_fin_h), parseInt(i.fecha_fin_mm),0,0),
                start: i.fecha_ini, 
                end: i.fecha_fin,
                allDay: false,
                url: base_url + 'Agendac/evento/' + i.id
                });
        });
        ini_cal_mes();
        //ini_cal_hoy();
        header_events();
        $('#calendar').fullCalendar('renderEvents', eventos);
        //$('#calendar_citas').fullCalendar('renderEvents', eventos);
        hide_spin(spin);
    };
    dataAjax.error = function(data){
        //console.log('No se pudieron cargar los eventos');
        ini_cal_mes();
        //ini_cal_hoy();
        header_events();
        hide_spin(spin);
    };
    dataAjax.getData();
}

function nueva_cita()
{
    $('a.nueva-cita').off();
    $('a.nueva-cita').on('click',function(e){
       e.preventDefault();
       var dataAjax = new getDataAjax($(this));
        dataAjax.type = 'GET';
        dataAjax.ok = function(data){
            $('#myModal').html(data.content);
            recordatorio();
            show_modal();
            view_daterangepicker();
            autocompleta_emp();
            //requerimiento HC-02
            send_form_cita(function(){
                hide_modal();
                $('#calendar').fullCalendar('removeEvents');
                //$('#calendar_citas').fullCalendar('removeEvents');
                var eventos = new Array();
                var dataAjax = new getDataAjax(base_url + '/Agendac/eventjson');
                dataAjax.type = 'GET';
                dataAjax.ok = function(data){
                    $.each(data.content, function(k, i){
                        eventos.push({
                            title: i.title,
                            //start: new Date((i.fecha_ini_y), parseInt(i.fecha_ini_m), parseInt(i.fecha_ini_d), parseInt(i.fecha_ini_h), parseInt(i.fecha_ini_mm),0,0),
                            //end: new Date(parseInt(i.fecha_fin_y), parseInt(i.fecha_fin_m), parseInt(i.fecha_fin_d), parseInt(i.fecha_fin_h), parseInt(i.fecha_fin_mm),0,0),
                            start: i.fecha_ini, 
                            end: i.fecha_fin,
                            allDay: false,
                            url: base_url + 'Agendac/evento/' + i.id
                            });
                    });
                    $('#calendar').fullCalendar('renderEvents', eventos);
                    //$('#calendar_citas').fullCalendar('renderEvents', eventos);
                };
                dataAjax.error = function(data){
                    console.log('No se pudieron cargar los eventos');
                };
                dataAjax.getData();
            });
        };
        dataAjax.getData();
    });
}

function recordatorio()
{
    $('.recordatorio').off('click');
    $('.recordatorio').on('click', function(e){
        if($(this).val() == 'si')
        {
            if($('#pac_id').val() != '')
            {
                $('.recordatorio-input').html('<input type="text" name="mail" placeholder="Ingrese el correo" class="form-control" value="'+pac_email+'" ><br />');
            }
            else
            {
                $('.recordatorio-input').html('<input type="text" name="mail" placeholder="Ingrese el correo" class="form-control" value="" ><br />');
            }
        }
        else
        {
            $('.recordatorio-input').html('');
        }
    });
}

function view_daterangepicker()
{
    $('#fecha_ini').datepicker({
       yearRange: "1900:2025",
       changeMonth: true,
       changeYear: true,
       minDate: new Date(),
       onSelect: function(date, obj)
       {
            $("#fecha_fin").datepicker( "option", "setDate", date);
            $("#fecha_fin").datepicker( "option", "minDate", date);
            
            var hoy = new Date();
            var seleccionada = new Date(obj.selectedYear, obj.selectedMonth, obj.selectedDay);
            
            if(hoy > seleccionada)
            {
                $('#hora_ini').data("DateTimePicker").minDate(moment());
                $('#hora_ini').val(moment().format('h:mmA'));
                $('#hora_fin').data("DateTimePicker").minDate(moment().add(15, 'm'));
                $('#hora_fin').val(moment().add(30, 'm').format('h:mmA'));
            }
            else 
            {
                $('#hora_ini').data("DateTimePicker").minDate(false);
                $('#hora_fin').data("DateTimePicker").minDate(false);
            }
       }
    });
    
    $('#fecha_fin').datepicker({
       yearRange: "1900:2025",
       changeMonth: true,
       changeYear: true,
       minDate: new Date(),
       onSelect: function(date, obj)
       {
           
       }
    });
    
    $('#hora_ini').datetimepicker({
        useCurrent: false,
        format: 'h:mmA',
        stepping: 15,
        showClose: false,
        disabledHours: [00,01,02,03,04,05,06],
        //minDate: moment(),
        collapse: false,
        locale: moment.locale('es')
    });
    
    $('#hora_fin').datetimepicker({
        useCurrent: false,
        format: 'h:mmA',
        stepping: 15,
        disabledHours: [00,01,02,03,04,05,06],
        //minDate: moment().add(15, 'm'),
        locale: moment.locale('es')
    });
        
    $("#hora_ini").on("dp.change", function (e) {
        var hora_ini2 = moment(new Date(e.date));
        $('#hora_fin').val(hora_ini2.add(30, 'm').format('h:mmA'));
        $('#hora_fin').data("DateTimePicker").minDate(e.date.add(15, 'm'));
    });
    
    $("#fecha_fin").on("dp.change", function (e) {
        var hora_ini2 = moment(new Date(e.date));
        $('#hora_fin').data("DateTimePicker").minDate(e.date);
    });
}

function autocompleta_emp()
{
    $("#emp").autocomplete({
      source: base_url + 'Agendac/get_emp_json',
      minLength: 4,
      appendTo: ".result_emp",
      select: function( event, ui ) {
        if(ui.item.value !== '')
        {
            $('#emp').val(ui.item.label);
            $('#emp_id').val(ui.item.value);
            pac_email = ui.item.email;
            //$('#recordatorio_si').attr('checked','checked');
            $('#recordatorio_si').trigger('click');
            //$('.recordatorio-input').html('<input type="text" name="mail" placeholder="Ingrese el correo" class="form-control" value="'+ui.item.email+'" ><br />');
        }
            return false;
      },
      change: function( event, ui ) {
          
      },
      response: function(event, ui) {
          if(ui.content.length <= 0)
          {
              ui.content.push({'label' : 'Sin resultados', 'value' : ''});
          }
      }
    });
}

//requerimiento HC-02
function send_form_cita(obj)
{
    $('.send-form-file').off('submit');
    $('.send-form-file').on('submit',function(e){
        e.preventDefault();
        var url = $(this).attr('action');
        var formData = new FormData(this);
        var element = $(this).find('button:last');
        var spin = $('<div id="spin" />');
        element.append(spin);
        //muestra el spin
        show_spin(spin);
        
        $.ajax({
            type: "POST",
            url:  url,
            enctype: 'multipart/form-data',
            data: formData,
            dataType: "json",
            cache: false,
            contentType: false,
            processData: false
        })
        .done(function(data){
            if(data.status == 'OK')
            {
                show_exito_afterClose(data.content,function(){
                    if(obj)
                        obj(data);
                });
            }
            else
            {
                show_error(data.content);
            }
        })
        .always(function(){
            hide_spin(spin);
        }) 
        .fail(function (){
            show_error('Ha ocurrido un error. Intentelo de nuevo m&aacute;s tarde.');
        });
    });
}