$(function() {

    var signaturePad = new SignaturePad(document.getElementById('signature-pad'), {
        backgroundColor: 'rgba(255, 255, 255, 0)',
        penColor: 'rgb(0, 0, 0)'
    });
    var saveButton = document.getElementById('save');
    var cancelButton = document.getElementById('clear');

    saveButton.addEventListener('click', function(event) {
        event.preventDefault();
        var data = signaturePad.toDataURL('image/png');
        document.getElementById('firma_med').value = data;

        saveButton.style.pointerEvents = "none";
        saveButton.style.cursor = "default";

        $('#save').closest('.div-firma').append($('<img src="' + data + '" >'));

    });

    cancelButton.addEventListener('click', function(event) {
        event.preventDefault();
        signaturePad.clear();

        $('#clear').closest('.div-firma').find('img').remove();
        document.getElementById('firma_med').value = '';

        saveButton.style.pointerEvents = "auto";
        saveButton.style.cursor = "pointer";
    });


    var signaturePadPac = new SignaturePad(document.getElementById('signature-pad-pac'), {
        backgroundColor: 'rgba(255, 255, 255, 0)',
        penColor: 'rgb(0, 0, 0)'
    });
    var saveButtonPac = document.getElementById('save-pac');
    var cancelButtonPac = document.getElementById('clear-pac');

    saveButtonPac.addEventListener('click', function(event) {
        event.preventDefault();
        var data = signaturePadPac.toDataURL('image/png');
        document.getElementById('firma_pac').value = data;

        saveButtonPac.style.pointerEvents = "none";
        saveButtonPac.style.cursor = "default";

        $('#save-pac').closest('.div-firma').append($('<img src="' + data + '" >'));
    });

    cancelButtonPac.addEventListener('click', function(event) {
        event.preventDefault();
        signaturePadPac.clear();

        $('#clear-pac').closest('.div-firma').find('img').remove();
        document.getElementById('firma_pac').value = '';

        saveButtonPac.style.pointerEvents = "auto";
        saveButtonPac.style.cursor = "pointer";
    });
});