$(function() {
    base_url = $('#base_url').val();
    Base64 = {
        _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
        encode: function(e) {
            var t = "";
            var n, r, i, s, o, u, a;
            var f = 0;
            e = Base64._utf8_encode(e);
            while (f < e.length) {
                n = e.charCodeAt(f++);
                r = e.charCodeAt(f++);
                i = e.charCodeAt(f++);
                s = n >> 2;
                o = (n & 3) << 4 | r >> 4;
                u = (r & 15) << 2 | i >> 6;
                a = i & 63;
                if (isNaN(r)) { u = a = 64 } else if (isNaN(i)) { a = 64 }
                t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a)
            }
            return t
        },
        decode: function(e) {
            var t = "";
            var n, r, i;
            var s, o, u, a;
            var f = 0;
            e = e.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (f < e.length) {
                s = this._keyStr.indexOf(e.charAt(f++));
                o = this._keyStr.indexOf(e.charAt(f++));
                u = this._keyStr.indexOf(e.charAt(f++));
                a = this._keyStr.indexOf(e.charAt(f++));
                n = s << 2 | o >> 4;
                r = (o & 15) << 4 | u >> 2;
                i = (u & 3) << 6 | a;
                t = t + String.fromCharCode(n);
                if (u != 64) { t = t + String.fromCharCode(r) }
                if (a != 64) { t = t + String.fromCharCode(i) }
            }
            t = Base64._utf8_decode(t);
            return t
        },
        _utf8_encode: function(e) {
            e = e.replace(/\r\n/g, "\n");
            var t = "";
            for (var n = 0; n < e.length; n++) {
                var r = e.charCodeAt(n);
                if (r < 128) { t += String.fromCharCode(r) } else if (r > 127 && r < 2048) {
                    t += String.fromCharCode(r >> 6 | 192);
                    t += String.fromCharCode(r & 63 | 128)
                } else {
                    t += String.fromCharCode(r >> 12 | 224);
                    t += String.fromCharCode(r >> 6 & 63 | 128);
                    t += String.fromCharCode(r & 63 | 128)
                }
            }
            return t
        },
        _utf8_decode: function(e) {
            var t = "";
            var n = 0;
            var r = c1 = c2 = 0;
            while (n < e.length) {
                r = e.charCodeAt(n);
                if (r < 128) {
                    t += String.fromCharCode(r);
                    n++
                } else if (r > 191 && r < 224) {
                    c2 = e.charCodeAt(n + 1);
                    t += String.fromCharCode((r & 31) << 6 | c2 & 63);
                    n += 2
                } else {
                    c2 = e.charCodeAt(n + 1);
                    c3 = e.charCodeAt(n + 2);
                    t += String.fromCharCode((r & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
                    n += 3
                }
            }
            return t
        }
    };
    ini_fecha();
    telefono_has_foco();
});

function send_form(obj) {
    //envia datos de usuario
    $('.send-form').off('submit');
    $('.send-form').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        //form.find("button").prop("disabled", true);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            show_exito_afterClose(data.content, function() {
                //actiones por definir
                if (obj)
                    obj(form);
            });
        };
        dataAjax.getData();
    });
}

function send_form_v2(obj) {
    //envia datos de usuario
    $('.send-form').off('submit');
    $('.send-form').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        //form.find("button").prop("disabled", true);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            if (obj)
                obj(data, form);
        };
        dataAjax.getData();
    });
}

function send_form_filtro(obj) {
    //envia datos de usuario
    $('.send-form-filtro').off('submit');
    $('.send-form-filtro').on('submit', function(e) {
        e.preventDefault();
        //form.find("button").prop("disabled", true);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            $('#resultado').html(data.content);
            edita();
            borra();
        };
        dataAjax.getData();
    });
}

function send_form_file(obj) {
    $('.send-form-file').off('submit');
    $('.send-form-file').on('submit', function(e) {
        e.preventDefault();
        var url = $(this).attr('action');
        var formData = new FormData(this);
        var element = $(this).find('button:first');
        var spin = $('<div id="spin" />');
        element.append(spin);
        //muestra el spin
        show_spin(spin);

        $.ajax({
                type: "POST",
                url: url,
                enctype: 'multipart/form-data',
                data: formData,
                dataType: "json",
                cache: false,
                contentType: false,
                processData: false
            })
            .done(function(data) {
                if (data.status == 'OK') {
                    if (obj)
                        obj(data);
                } else {
                    show_error(data.content);
                }
            })
            .always(function() {
                hide_spin(spin);
            })
            .fail(function() {
                show_error('Ha ocurrido un error. Intentelo de nuevo m&aacute;s tarde.');
            });
    });
}

function paginador(obj) {
    $('.pagination').off('click');
    $('.pagination').on('click', function(e) {
        e.preventDefault();
        var obj_new = obj || $(this);
        var a = $(this);

        if ($(obj_new).attr('action')) {
            $(obj_new).attr('action', $(a).attr('href'));
            $(obj_new).submit();
        } else {
            var dataAjax = new getDataAjax($(a));
            dataAjax.ok = function(data) {
                $('#resultado').html(data.content);
            };
            dataAjax.getData();
        }
    });
}

function edita() {
    $('.edita').off('click');
    $('.edita').on('click', function(e) {
        e.preventDefault();
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            $('.row').html(data.content);
            send_form(data.obj);
        };
        dataAjax.getData();
    });
}

function cancela() {
    $('.cancela').off('click');
    $('.cancela').on('click', function(e) {
        e.preventDefault();
        var a = $(this);
        var dataSend = function() {
            var dataAjax = new getDataAjax(a);
            dataAjax.ok = function(data) {
                show_exito_onShow(data.msg, function() {
                    //$(a).closest('tr').remove();
                    //sin acciones aun
                });
            };
            dataAjax.getData();
        };
        show_confirm('Desea cancelar?', function() {
            dataSend();
        });
    });
}

function agrega() {
    $('.add').off('click');
    $('.add').on('click', function(e) {
        e.preventDefault();
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            //show_layer(data.width, data.height, data.msg, data.obj);
            $('.row').html(data.msg);
            send_form();
            fecha();
        };
        dataAjax.getData();
    });
}

function borra(obj) {
    $('.delete').off('click');
    $('.delete').on('click', function(e) {
        e.preventDefault();
        var a = $(this);
        var dataSend = function() {
            var dataAjax = new getDataAjax(a);
            dataAjax.ok = function(data) {
                show_exito_afterClose(data.content, function() {
                    //actiones por definir
                    if (obj)
                        obj();
                });
            };
            dataAjax.getData();
        };
        show_confirm('Desea eliminar?', function() {
            dataSend();
        });
    });
}

function formato_numero(numero, decimales, separador_decimal, separador_miles) {
    numero = parseFloat(numero);
    if (isNaN(numero)) {
        return "";
    }

    if (decimales !== undefined) {
        // Redondeamos
        numero = numero.toFixed(decimales);
    }

    // Convertimos el punto en separador_decimal
    numero = numero.toString().replace(".", separador_decimal !== undefined ? separador_decimal : ",");

    if (separador_miles) {
        // Añadimos los separadores de miles
        var miles = new RegExp("(-?[0-9]+)([0-9]{3})");
        while (miles.test(numero)) {
            numero = numero.replace(miles, "$1" + separador_miles + "$2");
        }
    }
    return numero;
}

function to_number(numero) {
    var dscto = numero;
    var currency = "$";

    var signo = dscto.replace("$ ", "");
    var comas = signo.replace(",", "");

    return parseFloat(comas);
}

function show_modal() {
    $('#myModal').modal('show');
    cancel_modal();
}

function hide_modal() {
    $('#myModal').modal('hide');
}

function imprimir() {
    $('.imprimir').off('click');
    $('.imprimir').on('click', function(e) {
        e.preventDefault();
        window.print();
    });
}

function cancel_modal() {
    $('.cancel-modal').off();
    $('.cancel-modal').on('click', function(e) {
        e.preventDefault();
        hide_modal();
    });
}

function fecha() {
    $('.fecha').datepicker({
        yearRange: "1905:2025",
        changeMonth: true,
        changeYear: true,
        onSelect: function(date, obj) {
            console.log(date);
        }
    });
}


function ini_fecha() {
    $.fn.modal.Constructor.prototype.enforceFocus = function() {};
    $.datepicker.regional['es'] = {
        closeText: 'Cerrar',
        prevText: '&#x3c;Ant',
        nextText: 'Sig&#x3e;',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        dayNames: ['Domingo', 'Lunes', 'Martes', 'Mi&eacute;rcoles', 'Jueves', 'Viernes', 'Sabado'],
        dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mi&eacute;', 'Juv', 'Vie', 'Sab'],
        dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sa'],
        weekHeader: 'Sm',
        dateFormat: 'dd/M/yy',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };
    $.datepicker.setDefaults($.datepicker.regional['es']);
    fecha();
}

function telefono_has_foco() {
    $('.tel').off('focus');
    $('.tel').on('focus', function() {
        var $telefono = $(this).val();
        $(this).val($telefono.replace(/[-[\]{}()+?.,\\/^$|#\s]/g, ""));
        telefono_lost_foco();
    });
}

function telefono_lost_foco() {
    $('.tel').off('focusout');
    $('.tel').on('focusout', function() {
        var $telefono = $(this).val();
        $(this).val(formatea_tel($telefono));
    });
}

function formatea_tel($telefono) {
    var $lada_int = '';
    var $lada_nac = '';
    var $telseg1 = '';
    var $telseg2 = '';
    var $lada = '';
    $telefono = $telefono.replace(" ", "");
    if ($telefono.length >= 10) {
        //si es mayor a 10, solo toma los primeros 10
        if ($telefono.length > 10) {
            $telefono = $telefono.substr(0, 10);
        }
        $lada_int = '';
        $lada_nac = '';
        $telseg1 = '';
        $telseg2 = '-' + $telefono.substr(-4);
        $lada = $telefono.substr(0, 3);
        //si es gringo
        if ($lada == '001') {
            $lada_int = '001 ';
            $lada_nac = '(' + $telefono.substr(3, 3) + ') ';
            $telseg1 = $telefono.substr(6, 3);
        } else {
            var ladas = ['33', '55', '81'];
            //si los dos primero digitos de la lada es 33,55 u 81
            if (ladas.indexOf($lada.substr(0, 2)) !== -1) {
                $lada_nac = '(' + $lada.substr(0, 2) + ') ';
                $telseg1 = $telefono.substr(2, 4);
            } else {
                $lada_nac = '(' + $lada + ') ';
                $telseg1 = $telefono.substr(3, 3);
            }
        }
    } else if ($telefono.length < 10 && $telefono.strlen >= 8) {
        $telseg1 = $telefono.substr(0, 4);
        $telseg2 = '-' + $telefono.substr(-4);
    } else {
        $telseg1 = '';
        $telseg2 = '';
    }
    return $lada_int + $lada_nac + $telseg1 + $telseg2;
}

function valida_cp(obj) {
    $(obj).off('change');
    $(obj).on('change', function() {
        var panel = $(this).closest('.panel-body');
        if ($(panel).find('.pais').val() == 'MX') {
            if ($(this).val() == '') {
                show_warning('Ingrese un Código Postal para llenar los campos.');
            } else {
                var cp_val = $(this).val();

                if (cp_val.length == 5 && !isNaN(cp_val)) {
                    var dataAjax = new getDataAjax(base_url + 'util/busca_cp/' + cp_val);
                    var div_padre = $(this).closest('div');
                    $(div_padre).append('<div id="spin" />');
                    dataAjax.spin = $('#spin');
                    dataAjax.ok = function(data) {
                        if (data.content.length) {
                            var obj_colonia = $(panel).find('.colonia');
                            var obj_municipio = $(panel).find('.municipio');
                            var obj_localidad = $(panel).find('.localidad');
                            var obj_estado = $(panel).find('.estado');

                            $(obj_colonia).val('');
                            if (data.content.length > 1) {
                                if ($(obj_colonia).hasClass('selecta')) {
                                    $.each(data.content, function(i, k) {
                                        if (i == 0)
                                            select_option = 'selected="selected"';
                                        else
                                            select_option = '';
                                        options += '<option value="' + k.cp_asenta + '" ' + select_option + ' >' + k.cp_asenta + '</option>';
                                    });
                                    $(obj_colonia).html(options);
                                    $(obj_colonia).focus();
                                } else {
                                    var name_obj = $(obj_colonia).attr('name');
                                    var select_option = '';
                                    var options = '';

                                    $.each(data.content, function(i, k) {
                                        if (i == 0)
                                            select_option = 'selected="selected"';
                                        else
                                            select_option = '';
                                        options += '<option value="' + k.cp_asenta + '" ' + select_option + ' >' + k.cp_asenta + '</option>';
                                    });
                                    $(obj_colonia).replaceWith('<select name="' + name_obj + '" class="form-control colonia selecta" >' + options + '</select>');
                                    $(panel).find('.colonia').focus();
                                }
                            } else {
                                if ($(obj_colonia).hasClass('selecta')) {
                                    var name_obj = $(obj_colonia).attr('name');
                                    var class_obj = $(obj_colonia).attr('class');
                                    $(obj_colonia).replaceWith('<input readonly name="' + name_obj + '" class="form-control colonia" style="height: 20px; font-size: 12px; padding-top: 1px; padding-bottom: 1px;" value="' + data.content[0].cp_asenta + '" />');
                                } else {
                                    $(obj_colonia).val('');
                                    $(obj_colonia).val(data.content[0].cp_asenta);
                                }
                            }

                            $(obj_localidad).val('');
                            $(obj_localidad).val(data.content[0].cp_ciudad);

                            $(obj_municipio).val('');
                            $(obj_municipio).val(data.content[0].mpio_nombre);

                            $(obj_estado).html('');
                            $(obj_estado).append('<option value="' + data.content[0].edo_cve + '">' + data.content[0].estado + '</option>');
                        } else {
                            show_warning('No se encontró el código postal.');
                        }
                    };
                    dataAjax.getData();
                } else {
                    show_warning('El código postal solo debe tener números y ser igual a 5 caracteres.');
                }
            }
        }
    });
}