$(function() {
    base_url = $('#base_url').val();
    fecha();


    send_form_registro_logo();
    //send_form_registro();
    valida_cp('.cp');

    nueva_sucursal();


    borra(function() {
        location.reload();
    });

    agrega_examen();

    ver_costos();

    send_costos();

    autocompleta_empresa();
    agregar_despacho();


});



function send_form_registro() {
    //envia datos de usuario
    $('.send-form').off('submit');
    $('.send-form').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        //form.find("button").prop("disabled", true);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            show_exito_afterClose(data.content, function() {
                window.location = base_url + 'bitauser'
            });
        };
        dataAjax.getData();
    });
}




function send_form_registro_logo() {
    $('.send-form-emp').off('submit');
    $('.send-form-emp').on('submit', function(e) {
        e.preventDefault();
        var url = $(this).attr('action');
        var formData = new FormData(this);
        var element = $(this).find('button:first');
        var spin = $('<div id="spin" />');
        element.append(spin);
        //muestra el spin
        show_spin(spin);

        $.ajax({
                type: "POST",
                url: url,
                enctype: 'multipart/form-data',
                data: formData,
                dataType: "json",
                cache: false,
                contentType: false,
                processData: false
            })
            .done(function(data) {
                if (data.status == 'OK') {
                    show_exito_afterClose(data.content, function() {
                        window.location = base_url + 'bitauser'
                    });
                } else {
                    show_error(data.content);
                }
            })
            .always(function() {
                hide_spin(spin);
            })
            .fail(function() {
                show_error('Ha ocurrido un error. Intentelo de nuevo m&aacute;s tarde.');
            });
    });
}

function nueva_sucursal() {
    //envia datos de usuario
    $('.modal-sucursal').off('click');
    $('.modal-sucursal').on('click', function(e) {
        e.preventDefault();
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            $('.modal').html(data.content);
            show_modal();
            guarda_sucursal();
            valida_cp('.cp');
        };
        dataAjax.getData();
    });
}

function edita_sucursal() {
    //envia datos de usuario
    $('.btn-edit-sucursal').off('click');
    $('.btn-edit-sucursal').on('click', function(e) {
        e.preventDefault();
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            $('.modal').html(data.content);
            show_modal();
            guarda_sucursal();
            valida_cp('.cp');
        };
        dataAjax.getData();
    });
}

function guarda_sucursal() {
    //envia datos de usuario
    $('.send-form-suc').off('submit');
    $('.send-form-suc').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        //form.find("button").prop("disabled", true);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            show_exito_afterClose(data.content, function() {
                location.reload();
            });
        };
        dataAjax.getData();
    });
}

function agrega_examen() {
    //envia datos de usuario
    $('.add-examn').off('click');
    $('.add-examn').on('click', function(e) {
        e.preventDefault();

        var $texto_val = $('.examen-opt').val();
        if ($texto_val != '') {
            var $texto = $('.examen-opt option:selected').text();
            var $val = $('.examen-opt').val();
            var $cant = $('.examen-can').val();
            if ($cant != '') {
                if (esEntero($cant)) {
                    if ($cant > 0) {
                        var $indice = $('.resumen-table').find('tr.examen').length;
                        console.log($indice);
                        if ($indice == 0) {
                            $indice == 1;
                        }
                        var $tr = $("<tr  class='examen'>");
                        $tr.append("<td>" + $texto + "<input type='hidden' name='examen[" + $indice + "][cve]' value='" + $val + "'></td>");
                        $tr.append('<td align="right" class="cant">' + $cant + '<input type="hidden" name="examen[' + $indice + '][cantidad]" value="' + $cant + '"></td>');
                        $tr.append('<td><a href="#" class="pull-right del-examn"><i class="fa fa-trash"></i> </a></td>');

                        $('.resumen-table').append($tr);

                        $total_cant = 0;
                        $.each($('.resumen-table').find('tr.examen'), function(i, k) {
                            $total_cant = $total_cant + parseInt($(k).find('td.cant').text());
                        });

                        $('.total-cant').text($total_cant);
                        borra_examen();
                    } else {
                        show_error('Ingrese una cantidad correcta.');
                    }
                } else {
                    show_error('Ingrese una cantidad correcta.');
                }
            } else {
                show_error('Ingrese una cantidad correcta.');
            }
        } else {
            show_error('Seleccione un exámen.');
        }
    });
}

function esEntero(numero) {
    if (isNaN(numero)) {
        return false;
    } else {
        if (numero % 1 == 0) {
            return true;
        } else {
            return false;
        }
    }
}

function borra_examen() {
    //envia datos de usuario
    $('.del-examn').off('click');
    $('.del-examn').on('click', function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        $total_cant = 0;
        $.each($('.resumen-table').find('tr.examen'), function(i, k) {
            $total_cant = $total_cant + parseInt($(k).find('td.cant').text());
        });

        $('.total-cant').text($total_cant);
    });
}

function ver_costos() {
    //envia datos de usuario
    $('.ver-costos').off('click');
    $('.ver-costos').on('click', function(e) {
        e.preventDefault();
        var dataAjax = new getDataAjax($(this));
        dataAjax.data = {
            'f_ini': $('.f_ini').val(),
            'f_fin': $('.f_fin').val()
        };
        dataAjax.ok = function(data) {
            $('.resumen-table').html(data.content);
        };
        dataAjax.getData();
    });
}

function send_costos() {
    //envia datos de usuario
    $('.send-form-costos').off('submit');
    $('.send-form-costos').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            show_exito_afterClose(data.content, function() {
                location.reload();
            });
        };
        dataAjax.getData();
    });
}

function autocompleta_empresa() {
    $("#emp").autocomplete({
        source: base_url + 'Agenda/get_emp_json',
        minLength: 4,
        appendTo: ".result_emp",
        select: function(event, ui) {
            if (ui.item.value !== '') {
                $('#emp').val(ui.item.label);
                $('#emp_id').val(ui.item.value);
            }
            return false;
        },
        change: function(event, ui) {

        },
        response: function(event, ui) {
            if (ui.content.length <= 0) {
                ui.content.push({ 'label': 'Sin resultados', 'value': '' });
            }
        }
    });
}

function agregar_despacho() {
    //envia datos de usuarios
    $('.agrega-despacho').off('submit');
    $('.agrega-despacho').on('submit', function(e) {
        e.preventDefault();
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            show_exito_afterClose(data.content, function() {
                location.reload();
            });
        };
        dataAjax.getData();
    });
}