 <?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Empleado extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('empleado/Empleado_model','empleado');
		$this->load->model('persona/Persona_model','cliente');
		$this->load->model('empresa/Empresa_model','empresa');
		$this->load->helper('util');
		$this->load->helper('catalogo');
    }



    public function copia_sura_conduce($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');


                $this->form_validation->set_rules('puesto','Puesto','required');

                $this->form_validation->set_rules('user','Usuario','required');


                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_username'] =  $this->input->post('user');
                    $data_usr['usr_puesto'] =  $this->input->post('puesto');
					$data_usr['portal'] =  'C0NDUC3;';
					$data_usr['cei_id'] =  2;
					$data_usr['emp_id'] =  $empleado['emp_id'];
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['servicios'] =  'TODOS';
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}
					
					$data_usr['emp_id'] =  31;
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}
					
					if ($data_usr['usr_puesto'] == 'ADMINISTRADOR')
					{
						$data_usr['modulos'] =  'C0NDUC3;KDADO;5UR4;C4RG45;USU4R10S;';
						$data_usr['acciones'] =  'C0NDUC3+;C0NDUC3:;C0NDUC3-;F+;C-;ADMIN;';
					}
					elseif ($data_usr['usr_puesto'] == 'ANALISTA SURA')
					{
						$data_usr['modulos'] =  'C0NDUC3;KDADO;';
						$data_usr['acciones'] =  'C0NDUC3+;';
						$data_usr['emp_id'] =  324;
					}
					elseif ($data_usr['usr_puesto'] == 'CONDUCTOR')
					{
						$data_usr['modulos'] =  'C0NDUC3;KDADO;';
						$data_usr['acciones'] =  'CH0F3R:;F+;';
						
					}
					elseif ($data_usr['usr_puesto'] == 'MONITORISTA HUMANDRIVE')
					{
						$data_usr['modulos'] =  'C0NDUC3;KDADO;';
						$data_usr['acciones'] =  'C0NDUC3+;C0NDUC3:;C0NDUC3-;F+;C-;';
						
					}

					$data_usr['perfil_id'] =  1;	

					if ( $this->empleado->inserta($data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/copy_sura_conduce',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }



    public function copia_sura($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');


                $this->form_validation->set_rules('puesto','Puesto','required');

                $this->form_validation->set_rules('user','Usuario','required');


                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_username'] =  $this->input->post('user');
                    $data_usr['usr_puesto'] =  $this->input->post('puesto');
					$data_usr['portal'] =  'SURA';
					$data_usr['cei_id'] =  4;
					$data_usr['emp_id'] =  $empleado['emp_id'];
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['servicios'] =  'TODOS';
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}
					
					if ($data_usr['usr_puesto'] == 'ADMINISTRADOR - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;5UR4;USU4R10S';
						$data_usr['acciones'] =  'SURACORREO;SURABORRA;SURAREPORTE;SURAREGISTRO;SURASUPERVISOR;';
						$data_usr['perfil_id'] =  1;						
					}
					elseif ($data_usr['usr_puesto'] == 'ANALISTA - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;5UR4;';
						$data_usr['acciones'] =  'SURACORREO;SURABORRA;SURAREGISTRO;ANALISTA';
						
					}
					elseif ($data_usr['usr_puesto'] == 'SUPERVISOR - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;5UR4;';
						$data_usr['acciones'] =  'SURAREPORTE;SURASUPERVISOR;SURACORREO;SURABORRA;SURAREGISTRO;';
						
					}
					elseif ($data_usr['usr_puesto'] == 'SINIESTROS - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KKDADO;1NSV1R;5UR4;S1N13STR0S;';
						$data_usr['acciones'] =  'SURASUPERVISOR;4CC10N35;';
						
					}

					if ( $this->empleado->inserta($data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/copy_sura',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }

    public function edita_sura($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');


                $this->form_validation->set_rules('puesto','Puesto','required');

                $this->form_validation->set_rules('user','Usuario','required');


                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_username'] =  $this->input->post('user');
                    $data_usr['usr_puesto'] =  $this->input->post('puesto');
					$data_usr['cei_id'] =  4;
					$data_usr['emp_id'] =  $empleado['emp_id'];
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['servicios'] =  'TODOS';
					$data_usr['portal'] =  'SURA';
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}
					
					if ($data_usr['usr_puesto'] == 'ADMINISTRADOR - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;USU4R10S';
						$data_usr['acciones'] =  'SURACORREO;SURABORRA;SURAREPORTE;SURAREGISTRO;SURASUPERVISOR;';
						$data_usr['perfil_id'] =  1;
						
					}
					
					elseif ($data_usr['usr_puesto'] == 'ANALISTA - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;5UR4;';
						$data_usr['acciones'] =  'SURACORREO;SURABORRA;SURAREGISTRO;ANALISTA';
						
					}
					elseif ($data_usr['usr_puesto'] == 'SUPERVISOR - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;5UR4;B1T4C0R4;';
						$data_usr['acciones'] =  'SURAREPORTE;SURASUPERVISOR;B1T4C0R4;SURACORREO;SURABORRA;SURAREGISTRO;';
						
					}
					elseif ($data_usr['usr_puesto'] == 'SINIESTROS - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KKDADO;1NSV1R;5UR4;S1N13STR0S;';
						$data_usr['acciones'] =  'SURASUPERVISOR;4CC10N35;S1N13STR0S;';
						
					}






                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_sura',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }



    public function edita_sura_conduce($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');


                $this->form_validation->set_rules('puesto','Puesto','required');

                $this->form_validation->set_rules('user','Usuario','required');


                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_username'] =  $this->input->post('user');
                    $data_usr['usr_puesto'] =  $this->input->post('puesto');
					$data_usr['cei_id'] =  4;
					$data_usr['emp_id'] =  $empleado['emp_id'];
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['servicios'] =  'TODOS';
					$data_usr['portal'] =  'C0NDUC3;';
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					$data_usr['emp_id'] =  31;
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}
					
					if ($data_usr['usr_puesto'] == 'ADMINISTRADOR')
					{
						$data_usr['modulos'] =  'C0NDUC3;KDADO;5UR4;C4RG45;USU4R10S;';
						$data_usr['acciones'] =  'C0NDUC3+;C0NDUC3:;C0NDUC3-;F+;C-;ADMIN;';
					}
					elseif ($data_usr['usr_puesto'] == 'ANALISTA SURA')
					{
						$data_usr['modulos'] =  'C0NDUC3;KDADO;';
						$data_usr['acciones'] =  'C0NDUC3+;';
						$data_usr['emp_id'] =  324;
					}
					elseif ($data_usr['usr_puesto'] == 'CONDUCTOR')
					{
						$data_usr['modulos'] =  'C0NDUC3;KDADO;';
						$data_usr['acciones'] =  'CH0F3R:;F+;';
						
					}
					elseif ($data_usr['usr_puesto'] == 'MONITORISTA HUMANDRIVE')
					{
						$data_usr['modulos'] =  'C0NDUC3;KDADO;';
						$data_usr['acciones'] =  'C0NDUC3+;C0NDUC3:;C0NDUC3-;F+;C-;';
						
					}
					
					$data_usr['perfil_id'] =  1;	
					

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_sura_conduce',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }






    public function nuevo_sura()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            $this->form_validation->set_rules('puesto','Puesto','required');
            $this->form_validation->set_rules('user','Usuario','required');
            $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');

            if($this->form_validation->run())
            {
                $data_usr['usr_nombre'] =  $this->input->post('nombre');
                $data_usr['usr_paterno'] =  $this->input->post('paterno');
                $data_usr['usr_materno'] =  $this->input->post('materno');
                $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                $data_usr['usr_rfc'] =  $this->input->post('rfc');
                $data_usr['usr_cedula'] =  $this->input->post('cedula');
                $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                $data_usr['usr_puesto'] =  $this->input->post('puesto');
                $data_usr['esp_id'] =  $this->input->post('esp_id');
                $data_usr['perfil_id'] =  $this->input->post('rol');
                $data_usr['usr_username'] =  $this->input->post('user');
				$data_usr['emp_id'] = 324;
                

                //informacion de conrtaxcto de la persona
                $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                $data_usr['usr_correo'] =  $this->input->post('correo');

				$data_usr['cei_id'] =  4; //$this->input->post('cei');
                
			
				$data_usr['usr_rfc'] =  $this->input->post('rfc');

				
				
				$data_usr['portal'] =  'SURA';
				
				
					if ($data_usr['usr_puesto'] == 'ADMINISTRADOR - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;USU4R10S';
						$data_usr['acciones'] =  'SURACORREO;SURABORRA;SURAREPORTE;SURAREGISTRO;SURASUPERVISOR;';
						$data_usr['perfil_id'] =  1;
						
					}
					elseif ($data_usr['usr_puesto'] == 'ANALISTA - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;5UR4;';
						$data_usr['acciones'] =  'SURACORREO;SURABORRA;SURAREGISTRO;ANALISTA';
						
					}
					elseif ($data_usr['usr_puesto'] == 'SUPERVISOR - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KDADO;1NSV1R;5UR4;B1T4C0R4;';
						$data_usr['acciones'] =  'SURAREPORTE;SURASUPERVISOR;B1T4C0R4;SURACORREO;SURABORRA;SURAREGISTRO;';
						
					}
					elseif ($data_usr['usr_puesto'] == 'SINIESTROS - INSPECCIÓN VIRTUAL')
					{
						$data_usr['modulos'] =  'KKDADO;1NSV1R;5UR4;S1N13STR0S;';
						$data_usr['acciones'] =  'SURASUPERVISOR;4CC10N35;';
						
					}
				
				
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_usr['usr_path_foto'] = $data['file_name'];
                    }
                }
                $data_usr = array_to_upper($data_usr);
                $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
				$data_usr['usr_tous']=$this->input->post('pass');				
				$data_usr['servicios'] =  'TODOS';
				


                if($this->empleado->inserta($data_usr))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas_clean();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'empleado/add_sura',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_sura_conduce()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            $this->form_validation->set_rules('puesto','Puesto','required');
            $this->form_validation->set_rules('user','Usuario','required');
            $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');

            if($this->form_validation->run())
            {
                $data_usr['usr_nombre'] =  $this->input->post('nombre');
                $data_usr['usr_paterno'] =  $this->input->post('paterno');
                $data_usr['usr_materno'] =  $this->input->post('materno');
                $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                $data_usr['usr_rfc'] =  $this->input->post('rfc');
                $data_usr['usr_cedula'] =  $this->input->post('cedula');
                $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                $data_usr['usr_puesto'] =  $this->input->post('puesto');
                $data_usr['esp_id'] =  $this->input->post('esp_id');
                $data_usr['perfil_id'] =  $this->input->post('rol');
                $data_usr['usr_username'] =  $this->input->post('user');
                

                //informacion de conrtaxcto de la persona
                $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                $data_usr['usr_correo'] =  $this->input->post('correo');

				$data_usr['cei_id'] =  4; //$this->input->post('cei');
                $data_usr['usr_rfc'] =  $this->input->post('rfc');
				$data_usr['portal'] =  'C0NDUC3';
				$data_usr['emp_id'] =  31;
				$data_usr['perfil_id'] =  1;
				if ($data_usr['usr_puesto'] == 'ADMINISTRADOR')
				{
					$data_usr['modulos'] =  'C0NDUC3;KDADO;5UR4;C4RG45;USU4R10S;';
					$data_usr['acciones'] =  'C0NDUC3+;C0NDUC3:;C0NDUC3-;F+;C-;ADMIN;';
				}
				elseif ($data_usr['usr_puesto'] == 'ANALISTA SURA')
				{
					$data_usr['modulos'] =  'C0NDUC3;KDADO;';
					$data_usr['acciones'] =  'C0NDUC3+;';
					$data_usr['emp_id'] =  324;
				}
				elseif ($data_usr['usr_puesto'] == 'CONDUCTOR')
				{
					$data_usr['modulos'] =  'C0NDUC3;KDADO;';
					$data_usr['acciones'] =  'CH0F3R:;F+;';
					
				}
				elseif ($data_usr['usr_puesto'] == 'MONITORISTA HUMANDRIVE')
				{
					$data_usr['modulos'] =  'C0NDUC3;KDADO;';
					$data_usr['acciones'] =  'C0NDUC3+;C0NDUC3:;C0NDUC3-;F+;C-;';
					
				}
				
				
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_usr['usr_path_foto'] = $data['file_name'];
                    }
                }
                $data_usr = array_to_upper($data_usr);
                $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
				$data_usr['usr_tous']=$this->input->post('pass');				
				$data_usr['servicios'] =  'TODOS';
				$data_usr['perfil_id'] =  1;	
                if($this->empleado->inserta($data_usr))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas_clean();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'empleado/add_sura_conduce',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


   public function index_sura_conduce()
    {
		
        $rows = 30; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_sura/');
        $config['total_rows'] = $this->empleado->count_allo_sura_conduce();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
        $data['empleados'] = $this->empleado->get_allo_sura_conduce($rows);
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index_sura_conduce',
            'view_data' => $data 
           );
        render_template($params_view);  
    }



   public function index_sura()
    {

		$user = $this->session->user; 
		$usuario=$this->empleado->get($user['usr_id']);
        $rows = 30; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_sura/');
        $config['total_rows'] = $this->empleado->count_allo_sura();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
 
		if  ($usuario['usr_puesto'] == 'ADMINISTRADOR - HC') 
		{
			$data['empleados'] = $this->empleado->get_allo_sura($rows);
			
		}
		else
		{
			$data['empleados'] = $this->empleado->get_allo_sura_s($rows);			
		}

 
        
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index_sura',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    public function index_pres()
    {
		$user = $this->session->user; 
			
        $this->load->helper('template');
		$data['usuario']=$user;
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'rhhc/inicio_sim',
            'view_data' => $data
            );
        render_template($params_view);
    }
	
    function x_simp()
    {
        $this->load->helper('template');
		
		//$f_ini = formatea_fecha_mysql($this->input->post('f_ini'));
        //$f_fin = formatea_fecha_mysql($this->input->post('f_fin')); 
		
		$data['f_ingreso']=formatea_fecha_mysql($this->input->post('f_ingreso')); 
		$data['sueldo_mes']=$this->input->post('sueldo_mes');
		$data['monto_sol']=$this->input->post('monto_sol');
		
		
		$f_ini = $this->input->post('f_ini');
        $f_fin = $this->input->post('f_fin'); 
		
		
		$data['f_ini_o']=$this->input->post('f_ini');
		$data['f_fin_o']=$this->input->post('f_fin');
		$data['f_ini']=$f_ini;
		$data['f_fin']=$f_fin;
		$data['emp_id_l']=$this->input->post('empresa');
		$data['empresa_l']=get_empresa($this->input->post('empresa'));


			$params_view = array(
				'title' => 'Inicio',
				'view' => 'rhhc/gen_rep_sim',
				'view_data' => $data
				);
			render_template($params_view);
	
	}		
	

	public function pdf($periodo,$monto_sol)
    {

		$user = $this->session->user; 
		$usuario=$this->empleado->get($user['usr_id']);
		$cliente = $this->cliente->get($usuario['esp_id'],$n);
		$data['periodo']=$periodo;
		$data['monto_sol']=$monto_sol;
		$data['cliente']=$cliente;		
        $this->load->helper('pdf');
        genera_pdf($this->load->view('rhhc/pdf',$data,TRUE),'prestamo','prestamo','prestamo');
    }	
	
    public function index_empresa()
    {
		
        $rows = 30; //30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_hco/');
        $config['total_rows'] = $this->empleado->count_all_empresa();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		//$data['empleados'] = $this->empleado->get_all();		
        $data['empleados'] = $this->empleado->get_allo_empresa($rows);
        $data['empresas'] = $this->cliente->trae_empresas();
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Empleados',
            'view' => 'empleado/index_empresa',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function index_asistencia()
    {
		//echo 'a';
		$user = $this->session->user; 
		$usuario=$this->empleado->get($user['usr_id']);
		
		$rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_asistencia/');
        $config['total_rows'] = $this->empleado->count_all_asistencias($usuario);
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo 'b';
		$data['empleados'] = $this->empleado->get_allo_asistencias($rows,$usuario);		
		//echo 'c';
		$data['quincenas'] = $this->empresa->get_all_quincenas();	
		//echo 'd';
		$data['busca_empleados'] = $this->empleado->get_all_empleados_asisten($usuario);
		//echo 'e';
		$data['usuario'] = $usuario;
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index_asistencia',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function reporte_asistencia()
    {
		$user = $this->session->user; 
		$usuario=$this->empleado->get($user['usr_id']);
        $this->load->helper('template');
		$data['quincenas'] = $this->empresa->get_all_quincenas();		
		$data['busca_empleados'] = $this->empleado->get_all_empleados_asisten($usuario);
		$data['usuario'] = $usuario;
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'empleado/inicio_view_rep_asistencias',
            'view_data' => $data
            );
        render_template($params_view);
    }



    public function index_x()
    {
		$emp_id=get_x();	
        $rows = 50;
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_x/');
        $config['total_rows'] = $this->empleado->count_all_x($emp_id);
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
			
        $data['empleados'] = $this->empleado->get_allo_x($rows,$emp_id);
        $data['empresas'] = $this->empresa->get_all_empresas_clean_x($emp_id);   
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index_x',
            'view_data' => $data 
           );
        render_template($params_view);  
    }




    public function index_hc()
    {
		
        $rows = 30; //30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_hc/');
        $config['total_rows'] = $this->empleado->count_all_hc();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
	
        $data['empleados'] = $this->empleado->get_allo_hc($rows);
        $data['empresas'] = $this->empresa->get_all_empresas_clean();   
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index_hc',
            'view_data' => $data 
           );
        render_template($params_view);  
    }




    public function index_clientes()
    {
		
        $rows = 30; //30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_clientes/');
        $config['total_rows'] = $this->empleado->count_all_clientes();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
        $data['empleados'] = $this->empleado->get_all_clientes($rows);
        $data['empresas'] = $this->empresa->get_all_empresas_clean_31();   
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index_clientes',
            'view_data' => $data 
           );
        render_template($params_view);  
    }





    public function index_desactivados()
    {
		
        $rows = 30; //30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_desactivados/');
        $config['total_rows'] = $this->empleado->count_all_desactivados();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		
        $data['empleados'] = $this->empleado->get_all_desactivados($rows);
        $data['empresas'] = $this->empresa->get_all_empresas_clean();   
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index_desactivados',
            'view_data' => $data 
           );
        render_template($params_view);  
    }



    public function index_nom035()
    {
		
        $rows = 30; //30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index_nom035/');
        $config['total_rows'] = $this->empleado->count_all_nom035();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        			
        $data['empleados'] = $this->empleado->get_all_nom035($rows);
        $data['empresas'] = $this->empresa->get_all_empresas_clean();   
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index_nom035',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
 

 
 
 
 
   public function index()
    {
		
        $rows = 30; //30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('empleado/index/');
        $config['total_rows'] = $this->empleado->count_all();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		//$data['empleados'] = $this->empleado->get_all();		
        $data['empleados'] = $this->empleado->get_allo($rows);
        $data['empresas'] = $this->empresa->get_all_empresas_clean();   
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'empleado/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    function busca_asistencia()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$elempleado = $this->input->post('elempleado');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$quincena = trim($this->input->post('quincena')); 
		
		
		$f_ini = trim(strtoupper($this->input->post('f_ini'))); 
		$f_fin = trim(strtoupper($this->input->post('f_fin')));

		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_asistencia($nombre,$paterno,$materno, $elempleado,$usuario,$f_ini, $f_fin,$quincena,$cei);
        send_json_ok($this->load->view('empleado/busca_asistencia',$data,TRUE));
    }


    function busca_hc()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = 31; 
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$puesto = trim(strtoupper($this->input->post('puesto'))); 
		$estatus = 'Activo'; //trim($this->input->post('estatus')); 
		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_hc($nombre,$paterno,$materno, $empresa, $cei, $usuario, $puesto,$estatus);
        send_json_ok($this->load->view('empleado/busca_hc',$data,TRUE));
    }

   function busca_x()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = $this->input->post('empresa');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$puesto = trim(strtoupper($this->input->post('puesto'))); 
		$estatus = 'Activo'; //trim($this->input->post('estatus')); 
		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_x($nombre,$paterno,$materno, $empresa, $cei, $usuario, $puesto,$estatus);
        send_json_ok($this->load->view('empleado/busca_x',$data,TRUE));
    }

   function busca_nom035()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = $this->input->post('empresa');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$puesto = trim(strtoupper($this->input->post('puesto'))); 
		$estatus = 'Activo'; //trim($this->input->post('estatus')); 
		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_nom035($nombre,$paterno,$materno, $empresa, $cei, $usuario, $puesto,$estatus);
        send_json_ok($this->load->view('empleado/busca_nom035',$data,TRUE));
    }


    function busca_cliente()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = $this->input->post('empresa');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$puesto = trim(strtoupper($this->input->post('puesto'))); 
		$estatus = 'Activo'; //trim($this->input->post('estatus')); 
		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_cliente($nombre,$paterno,$materno, $empresa, $cei, $usuario, $puesto,$estatus);
        send_json_ok($this->load->view('empleado/busca_cliente',$data,TRUE));
    }




    function busca_desactivados()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = $this->input->post('empresa');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$puesto = trim(strtoupper($this->input->post('puesto'))); 
		$estatus = 'Desactivado'; //trim($this->input->post('estatus')); 
		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_desactivados($nombre,$paterno,$materno, $empresa, $cei, $usuario, $puesto,$estatus);
        send_json_ok($this->load->view('empleado/busca_desactivados',$data,TRUE));
    }



    function busca()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = $this->input->post('empresa');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$puesto = trim(strtoupper($this->input->post('puesto'))); 
		$estatus = trim($this->input->post('estatus')); 
		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca($nombre,$paterno,$materno, $empresa, $cei, $usuario, $puesto,$estatus);
        send_json_ok($this->load->view('empleado/busca',$data,TRUE));
    }


    function busca_sura()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = $this->input->post('empresa');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$puesto = trim(strtoupper($this->input->post('puesto'))); 
		$estatus = trim($this->input->post('estatus')); 
		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_sura($nombre,$paterno,$materno, $empresa, $cei, $usuario, $puesto,$estatus);
        send_json_ok($this->load->view('empleado/busca_sura',$data,TRUE));
    }

   public function borra($fsm_id)
    {
        if($this->empleado->borra_empleado($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }



   public function borra_asistencia($fsm_id)
    {
        if($this->empleado->borra_asistencia($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    function busca_usuario_empresa()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = $this->input->post('empresa');        
        $data['empleados'] = $this->empleado->busca_usuario_empresa($nombre,$paterno,$materno, $empresa);
        send_json_ok($this->load->view('empleado/busca',$data,TRUE));
    }
    



    public function edita_usuario_empresa($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('user','Usuario','required');
                $this->form_validation->set_rules('empresa','Empresa','required');

                
                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    /*$data_usr['usr_genero_cve'] =  $this->input->post('genero');*/
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    /*$data_usr['usr_cedula'] =  $this->input->post('cedula');*/

                    /*$data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');*/
                    /*$data_usr['esp_id'] =  $this->input->post('esp_id');*/

                    $data_usr['usr_puesto'] =  $this->input->post('puesto');
					$data_usr['perfil_id'] =  4;
					$data_usr['usr_username'] =  $this->input->post('user');
                    $data_usr['emp_id'] =  $this->input->post('empresa');

                    //domicilio de la usuario
					/*
                    $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                    $data_usr['usr_env_cp'] =  $this->input->post('cp');
                    $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                    $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                    $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                    $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                    $data_usr['usr_env_calle'] =  $this->input->post('calle');
                    $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                    $data_usr['usr_env_num_int'] =  $this->input->post('nint');
					*/
					
					
                    //informacion de contacto de la usuario
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					
					// sucursales y cei
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//datos profesionales
					/*$data_usr['usr_carrera'] =  $this->input->post('carrera');
					$data_usr['usr_institucion'] =  $this->input->post('institucion');
					$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
					$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');
					$data_usr['receta'] =  $this->input->post('receta');*/
					
					$data_usr['servicios'] =  'TODOS';

					$modulos='';
					//if ($this->input->post('fsm_ingenieria') == 'SI') {$modulos.='ingenieria;';}
					//if ($this->input->post('fsm_control') == 'SI') {$modulos.='control;';}
					//if ($this->input->post('fsm_gsi') == 'SI') {$modulos.='gsi;';}
					//if ($this->input->post('fsm_empresa') == 'SI') {$modulos.='empresas;';}					
					if ($this->input->post('fsm_CostosXServciosEDO') == 'SI') {$modulos.='edo;';}
					if ($this->input->post('fsm_pacientes') == 'SI') {$modulos.='pacientes;';}
					if ($this->input->post('fsm_evaluados') == 'SI') {$modulos.='evaluados;';}
					if ($this->input->post('fsm_servicios') == 'SI') {$modulos.='servicios;';}
					//if ($this->input->post('fsm_usuarios') == 'SI') {$modulos.='usuarios;';}
					if ($this->input->post('fsm_agenda') == 'SI') {$modulos.='agenda;';}
					if ($this->input->post('fsm_admin') == 'SI') {$modulos.='admin;';}
					$data_usr['modulos'] =  $modulos;


					
					if ($this->input->post('nom035') != '') 
					{
						if ( strstr($this->input->post('nom035'),'NOM ADMIN'))
						{
							$data_usr['modulos'] = 'NOM ADMIN';
						}else
						{
							$data_usr['modulos'] = 'NO USA NOM';
						}
					}

					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
                    $data_usr = array_to_upper($data_usr);
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous'] = $this->input->post('pass');					
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_usuario_empresa',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }



  
    public function edita_hco($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('grado','Grado acadédmico','required');
                $this->form_validation->set_rules('puesto','Puesto','required');
                $this->form_validation->set_rules('user','Usuario','required');

              
                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');
                    

					$data_usr['usr_puesto'] =  $this->input->post('puesto');

					$data_usr['perfil_id'] =  1;

					$data_usr['usr_username'] =  $this->input->post('user');

					$data_usr['root1'] =  $this->input->post('root1');
					$data_usr['root2'] =  $this->input->post('root2');

					$data_usr['emp_id'] =  31;


                    //domicilio de la usuario
                    $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                    $data_usr['usr_env_cp'] =  $this->input->post('cp');
                    $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                    $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                    $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                    $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                    $data_usr['usr_env_calle'] =  $this->input->post('calle');
                    $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                    $data_usr['usr_env_num_int'] =  $this->input->post('nint');

                    //informacion de contacto de la usuario
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					
					$data_usr['usr_email_personal'] =  $this->input->post('correopersonal'); 	
					$data_usr['usr_ext_hc'] =  $this->input->post('extensión'); 
					$data_usr['usr_tel_eme'] =  limpia_telefono($this->input->post('tel_eme'));					
					
					
					// sucursales y cei
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//datos profesionales
					$data_usr['usr_carrera'] =  $this->input->post('carrera');
					$data_usr['usr_institucion'] =  $this->input->post('institucion');
					$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
					$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');
					$data_usr['receta'] =  $this->input->post('receta');

					$modulos='';
					if ($this->input->post('fsm_ingenieria') == 'SI') {$modulos.='ingenieria;';}
					if ($this->input->post('fsm_control') == 'SI') {$modulos.='control;';}
					if ($this->input->post('fsm_gsi') == 'SI') {$modulos.='gsi;';}
					if ($this->input->post('fsm_empresa') == 'SI') {$modulos.='empresas;';}
					if ($this->input->post('fsm_pacientes') == 'SI') {$modulos.='pacientes;';}
					if ($this->input->post('fsm_evaluados') == 'SI') {$modulos.='evaluados;';}
					if ($this->input->post('fsm_servicios') == 'SI') {$modulos.='servicios;';}
					if ($this->input->post('fsm_usuarios') == 'SI') {$modulos.='usuarios;';}
					if ($this->input->post('fsm_agenda') == 'SI') {$modulos.='agenda;';}
					if ($this->input->post('fsm_admin') == 'SI') {$modulos.='admin;';}
					$data_usr['modulos'] =  $modulos;
					
					if ($this->input->post('rol') == 4)
					{
						$data_usr['servicios'] =  'TODOS';
					}
					else
					{
					$examenes='';						
					if ($this->input->post('fsm_CURSOS') == 'SI') {$examenes.='CURSOS;';}
					if ($this->input->post('fsm_ESPECIALES') == 'SI') {$examenes.='ESPECIALES;';}
					if ($this->input->post('fsm_LABORATORIO') == 'SI') {$examenes.='LABORATORIO;';}
					if ($this->input->post('fsm_EYEDETECT') == 'SI') {$examenes.='EYEDETECT;';}
					if ($this->input->post('fsm_MEDICO-FISICO') == 'SI') {$examenes.='MEDICO-FISICO;';}
					if ($this->input->post('fsm_NOM035') == 'SI') {$examenes.='NOM035;';}
					if ($this->input->post('fsm_ODONTOLOGICOS') == 'SI') {$examenes.='ODONTOLOGICOS;';}
					if ($this->input->post('fsm_POLIGRAFICOS') == 'SI') {$examenes.='POLIGRAFICOS;';}
					if ($this->input->post('fsm_PSICOLOGICOS') == 'SI') {$examenes.='PSICOLOGICOS;';}
					if ($this->input->post('fsm_SOCIOECONOMICOS') == 'SI') {$examenes.='SOCIOECONOMICOS;';}					
					if ($this->input->post('fsm_TOXICOLOGICOS') == 'SI') {$examenes.='TOXICOLOGICOS;';}
					if ($this->input->post('fsm_SEGUROS') == 'SI') {$examenes.='SEGUROS;';}
					$data_usr['servicios'] =  $examenes;

					/*$examenes=$examenes.$this->input->post('rolservtox'); 
					$examenes=$examenes.$this->input->post('rolservlb1'); 
					$examenes=$examenes.$this->input->post('rolservlb2'); 
					$examenes=$examenes.$this->input->post('rolservsoc'); 
					$examenes=$examenes.$this->input->post('rolservpsi'); 
					$examenes=$examenes.$this->input->post('rolservpol'); 
					$examenes=$examenes.$this->input->post('rolservmed'); 
					$examenes=$examenes.$this->input->post('rolservnom'); 				
					$data_usr['servicios'] =  $examenes;*/
					}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
                    $data_usr = array_to_upper($data_usr);
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous'] = $this->input->post('pass');
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_hco',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function asistencia($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);	
		$ultima_asistencia= $this->empleado->ultima_asistencia($empleado_id);
		$user = $this->session->user;
       		
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
              // $this->load->library('form_validation');
				//$this->form_validation->set_rules('nombre','Nombre','required');

                //if($this->form_validation->run())
				if(1)	
               {
					$this->load->library('user_agent');
				
					$data_insert['usrlog_accion_cve'] = $this->input->post('clave');
					
					if ($data_insert['usrlog_accion_cve'] == 'INGRESO')
					{
						$data_insert['usr_id'] =  $user['usr_id'];
						$data_insert['usr_nombre'] = $user['usr_nombre'];
						$data_insert['usr_paterno'] = $user['usr_paterno'];
						$data_insert['usr_materno'] = $user['usr_materno'];															
						$data_insert['usr_username'] = $user['usr_username'];					
						$data_insert['usrlog_acceso_f'] = date('Y-m-d H:i:s');
					
						$data_insert['usrlog_ingreso_f'] = date('Y-m-d H:i:s');
						$data_insert['usrlog_ingreso_ip'] =  $this->input->ip_address();
						if ($this->agent->is_browser())
							$data_insert['usrlog_ingreso_navegador'] = $this->agent->browser().' '.$this->agent->version();
						if ($this->agent->is_robot())
							$data_insert['usrlog_ingreso_navegador'] = $this->agent->robot();
						if ($this->agent->is_mobile())
							$data_insert['usrlog_ingreso_navegador'] = $this->agent->mobile();
						$data_insert['usrlog_ingreso_os'] = $this->agent->platform();
						$data_insert['usrlog_ingreso_agente'] = $this->agent->agent_string();
						$data_insert['usrlog_ingreso_comment'] = $this->input->post('comentario');
						
						$data_insert['usr_emp_asig']= $empleado['usr_emp_asig'];
						$data_insert['usr_suc_asig']= $empleado['usr_suc_asig'];  	 
						$data_insert['usr_consultorio_asig']= $empleado['usr_consultorio_asig'];  
						$data_insert['cei_id']= $empleado['cei_id'];
						$data_insert['suc_id']= $empleado['suc_id']; 
						$data_insert['usrlog_latitud_in'] = $this->input->post('latitude');
						$data_insert['usrlog_longitud_in'] = $this->input->post('longitude');
						$quincena=get_quincena_nomina(date('Y-m-d')); 
						$data_insert['qui_num']=	$quincena['quin_num'];
						
						
						$data_insert = array_to_upper($data_insert);						

						if($this->empleado->asistencia($data_insert))
						{
							send_json_ok('Se registro de forma correcto tu Ingreso a las '.formatea_fechahora($data_insert['usrlog_ingreso_f']));
						}
						else
						{
							send_json_error('Ocurrió un error al registrar la asistencia.');
						}

					}
					else
					{
						
						$fecha_medium=substr($ultima_asistencia['usrlog_ingreso_f'],0,10).' 00:00:00';
						$date1 = new DateTime($fecha_medium);
						$date2 = new DateTime(date('Y-m-d H:i:s'));
						$diff = $date1->diff($date2);	
						$dias=$diff->days;
						do
						{
							if ($dias == 0) /*buscando mas días*/
							{	
								$data_insert['usrlog_salida_f'] = date('Y-m-d H:i:s');
								$data_insert['usrlog_salida_ip'] =  $this->input->ip_address();
								if ($this->agent->is_browser())
									$data_insert['usrlog_salida_navegador'] = $this->agent->browser().' '.$this->agent->version();
								if ($this->agent->is_robot())
									$data_insert['usrlog_salida_navegador'] = $this->agent->robot();
								if ($this->agent->is_mobile())
									$data_insert['usrlog_salida_navegador'] = $this->agent->mobile();
								$data_insert['usrlog_salida_os'] = $this->agent->platform();
								$data_insert['usrlog_salida_agente'] = $this->agent->agent_string();
								$fsm_id_anteriores = $this->input->post('fsm_id_anteriores');
								$data_insert['usrlog_salida_comment'] = $this->input->post('comentario');
								
								$quincena=get_quincena_nomina(date('Y-m-d')); 
								$data_insert['qui_num_salida']=	$quincena['quin_num'];
								
								$data_insert = array_to_upper($data_insert);						
								
								
								$inicio= new DateTime($ultima_asistencia['usrlog_ingreso_f']); 
								$fin= new DateTime($data_insert['usrlog_salida_f']);
								$diferencia=$inicio->diff($fin);
								$data_insert['usrlog_tiempo_asistencia'] = $diferencia->format('%Y años %m meses %d días %H hrs %i mins %s segs');
								//$data_insert['usrlog_tiempo_asistencia'] = $inicio->format('Y-m-d H:i:s');
								$data_insert['usrlog_latitud_out'] = $this->input->post('latitude');
								$data_insert['usrlog_longitud_out'] = $this->input->post('longitude');
								if($this->empleado->asistencia_actualiza($ultima_asistencia['fsm_id'],$data_insert))
								{
									$this->session->unset_userdata('user');
									//redirect('usuario/login');
									send_json_ok('Se registro de forma correcta tu SALIDA a las '.formatea_fechahora($data_insert['usrlog_salida_f']));
									
								
								}
								else
								{
									send_json_error('Ocurrió un error al registrar la asistencia.');
								}
							}
							else /*buscando mas días*/
							{
									$fecha_mediana=substr($ultima_asistencia['usrlog_ingreso_f'],0,10);
									$data_insert['usrlog_salida_f'] = date($fecha_mediana.' 23:59:59');
									$data_insert['usrlog_salida_ip'] =  $this->input->ip_address();
									if ($this->agent->is_browser())
										$data_insert['usrlog_salida_navegador'] = $this->agent->browser().' '.$this->agent->version();
									if ($this->agent->is_robot())
										$data_insert['usrlog_salida_navegador'] = $this->agent->robot();
									if ($this->agent->is_mobile())
										$data_insert['usrlog_salida_navegador'] = $this->agent->mobile();
									$data_insert['usrlog_salida_os'] = $this->agent->platform();
									$data_insert['usrlog_salida_agente'] = $this->agent->agent_string();
									$fsm_id_anteriores = $this->input->post('fsm_id_anteriores');
									$data_insert['usrlog_salida_comment'] = $this->input->post('comentario');
									
									$quincena=get_quincena_nomina($fecha_mediana); 
									$data_insert['qui_num_salida']=	$quincena['quin_num'];
									
									$data_insert = array_to_upper($data_insert);						
									
									
									$inicio= new DateTime($ultima_asistencia['usrlog_ingreso_f']); 
									$fin= new DateTime($data_insert['usrlog_salida_f']);
									$diferencia=$inicio->diff($fin);
									$data_insert['usrlog_tiempo_asistencia'] = $diferencia->format('%Y años %m meses %d días %H hrs %i mins %s segs');
									//$data_insert['usrlog_tiempo_asistencia'] = $inicio->format('Y-m-d H:i:s');
									$this->empleado->asistencia_actualiza($ultima_asistencia['fsm_id'],$data_insert);
									
		
									unset($data_insert);
									$data_insert= array(); 

									$fecha_mediana=date("Y-m-d",strtotime($fecha_mediana."+ 1 days")); 
									
									//$data_insert['usrlog_accion_cve'] = 'INGRESO';
									$data_insert['usrlog_accion_cve'] = 'SALIDA';
									$data_insert['usr_id'] =  $user['usr_id'];
									$data_insert['usr_nombre'] = $user['usr_nombre'];
									$data_insert['usr_paterno'] = $user['usr_paterno'];
									$data_insert['usr_materno'] = $user['usr_materno'];															
									$data_insert['usr_username'] = $user['usr_username'];					
									$data_insert['usrlog_acceso_f'] = $fecha_mediana.' 00:00:00';							
									$data_insert['usrlog_ingreso_f'] = $fecha_mediana.' 00:00:00';
									$data_insert['usrlog_ingreso_ip'] =  $this->input->ip_address();
									
									
									
									
									
									if ($this->agent->is_browser())
										$data_insert['usrlog_ingreso_navegador'] = $this->agent->browser().' '.$this->agent->version();
									if ($this->agent->is_robot())
										$data_insert['usrlog_ingreso_navegador'] = $this->agent->robot();
									if ($this->agent->is_mobile())
										$data_insert['usrlog_ingreso_navegador'] = $this->agent->mobile();
									$data_insert['usrlog_ingreso_os'] = $this->agent->platform();
									$data_insert['usrlog_ingreso_agente'] = $this->agent->agent_string();
									$data_insert['usrlog_ingreso_comment'] = $this->input->post('comentario');
									
									$data_insert['usr_emp_asig']= $empleado['usr_emp_asig'];
									$data_insert['usr_suc_asig']= $empleado['usr_suc_asig'];  	 
									$data_insert['usr_consultorio_asig']= $empleado['usr_consultorio_asig'];  
									$data_insert['cei_id']= $empleado['cei_id'];
									$data_insert['suc_id']= $empleado['suc_id']; 
									
									$quincena=get_quincena_nomina(date('Y-m-d')); 
									$data_insert['qui_num']= $quincena['quin_num'];
									$data_insert = array_to_upper($data_insert);						
									$fsm_id=$this->empleado->asistencia($data_insert);
									$data_insert['fsm_id']=$fsm_id;
									$ultima_asistencia=$data_insert;
									unset($data_insert);
									$data_insert= array(); 
									
								//send_json_ok('dias mayores de 0: '.$dias);
								//send_json_ok('|'.$data_insert['fsm_id'].'|'.$data_insert['usrlog_ingreso_f'].'|');
								//$ultima_asistencia= $this->empleado->ultima_asistencia($empleado_id);
									//
									//$dias--;
									//$ultima_asistencia= $this->empleado->ultima_asistencia($user['usr_id']);
	/**************************************************************************/


	/*************************************************************************/			
							}	
							$dias--;
						}
						while ( $dias > -1 );
					}		
               }
               else
               {
                    send_json_error(validation_errors('<div />'));
               }
            }
            else 
            {
				
              //  $this->load->model('empresa/Empresa_model','empresa');
              //  $data['empresas'] = $this->empresa->get_all_empresas();
			//	$data['sucursals'] = $this->empresa->get_all_sucursales();
		
				$data['empleado'] = $empleado;
			    $data['ultima_asistencia'] = $ultima_asistencia;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/asistencia',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el Usuario');
        }
    }


    public function edita2($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
               // $this->load->library('form_validation');
              //  $this->form_validation->set_rules('nombre','Nombre','required');
               // $this->form_validation->set_rules('paterno','Apellido Paterno','required');
              //  $this->form_validation->set_rules('materno','Apellido Materno','required');
              //  $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
              //  $this->form_validation->set_rules('genero','Género','required');
               // $this->form_validation->set_rules('grado','Grado acadédmico','required');
                
                //if($user['perfil_id'] == '1')
                //{
                //$this->form_validation->set_rules('puesto','Puesto','required');
				//if (get_my_user_root1() < 1)
				//{
					//$this->form_validation->set_rules('rol','Rol','required');
				//}
                //$this->form_validation->set_rules('user','Usuario','required');
                //}
                //si el rol es empresa se vuelve pbligatorio el campo de empresa
                //if($this->input->post('rol') == 4)
                //{
                    //$this->form_validation->set_rules('empresa','Empresa','required');
                //}
                
                //if($this->input->post('pass') != '')
                //{
                //    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
                 //   $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                //}

               // if($this->form_validation->run())
                //{
                    //informncion general del empleado
                    //$data_usr['usr_nombre'] =  $this->input->post('nombre');
                   // $data_usr['usr_paterno'] =  $this->input->post('paterno');
                   // $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                   // $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');
                    
                    //if($user['perfil_id'] == '1')
                    //{
                       // $data_usr['usr_puesto'] =  $this->input->post('puesto');
						//if (get_my_user_root1() < 1)
						//{
							//$data_usr['perfil_id'] =  $this->input->post('rol');
                        //}
						//$data_usr['usr_username'] =  $this->input->post('user');
                    //}
                    //($this->input->post('rol') == 4)
                    //{
                    //    $data_usr['emp_id'] =  $this->input->post('empresa');
                    //}
					
					//if($this->input->post('rol') < 4)
					//{
					//	$data_usr['emp_id'] =  31;
					//}

                    //dopmcicio de la persona
                    $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                    $data_usr['usr_env_cp'] =  $this->input->post('cp');
                    $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                    $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                    $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                    $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                    $data_usr['usr_env_calle'] =  $this->input->post('calle');
                    $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                    $data_usr['usr_env_num_int'] =  $this->input->post('nint');

                    //informacion de conrtaxcto de la persona
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					
					// sucursales y cei
					//$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//if  ($this->input->post('examenes'))
					//{
					//	$data_usr['servicios'] =  implode(',',$this->input->post('examenes'));
					//}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
                    $data_usr = array_to_upper($data_usr);
                    
					//if($this->input->post('pass') != '')
                   // {
                    //    $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
                    //}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
               // }
               // else
               // {
               //     send_json_error(validation_errors('<div />'));
               // }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit2',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function empleadohc($empleado_id)
    {
        $usuario = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($usuario)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
               // $this->load->library('form_validation');
              //  $this->form_validation->set_rules('nombre','Nombre','required');
               // $this->form_validation->set_rules('paterno','Apellido Paterno','required');
              //  $this->form_validation->set_rules('materno','Apellido Materno','required');
              //  $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
              //  $this->form_validation->set_rules('genero','Género','required');
               // $this->form_validation->set_rules('grado','Grado acadédmico','required');
                
                //if($user['perfil_id'] == '1')
                //{
                //$this->form_validation->set_rules('puesto','Puesto','required');
				//if (get_my_user_root1() < 1)
				//{
					//$this->form_validation->set_rules('rol','Rol','required');
				//}
                //$this->form_validation->set_rules('user','Usuario','required');
                //}
                //si el rol es empresa se vuelve pbligatorio el campo de empresa
                //if($this->input->post('rol') == 4)
                //{
                    //$this->form_validation->set_rules('empresa','Empresa','required');
                //}
                
                //if($this->input->post('pass') != '')
                //{
                //    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
                 //   $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                //}

               // if($this->form_validation->run())
                //{
                    //informncion general del empleado
                    //$data_usr['usr_nombre'] =  $this->input->post('nombre');
                   // $data_usr['usr_paterno'] =  $this->input->post('paterno');
                   // $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                   // $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');
                    
                    //if($user['perfil_id'] == '1')
                    //{
                       // $data_usr['usr_puesto'] =  $this->input->post('puesto');
						//if (get_my_user_root1() < 1)
						//{
							//$data_usr['perfil_id'] =  $this->input->post('rol');
                        //}
						//$data_usr['usr_username'] =  $this->input->post('user');
                    //}
                    //($this->input->post('rol') == 4)
                    //{
                    //    $data_usr['emp_id'] =  $this->input->post('empresa');
                    //}
					
					//if($this->input->post('rol') < 4)
					//{
					//	$data_usr['emp_id'] =  31;
					//}

                    //dopmcicio de la persona
                    $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                    $data_usr['usr_env_cp'] =  $this->input->post('cp');
                    $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                    $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                    $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                    $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                    $data_usr['usr_env_calle'] =  $this->input->post('calle');
                    $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                    $data_usr['usr_env_num_int'] =  $this->input->post('nint');

                    //informacion de conrtaxcto de la persona
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					
					// sucursales y cei
					//$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//if  ($this->input->post('examenes'))
					//{
					//	$data_usr['servicios'] =  implode(',',$this->input->post('examenes'));
					//}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
                    $data_usr = array_to_upper($data_usr);
                    
					//if($this->input->post('pass') != '')
                   // {
                    //    $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
                    //}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
               // }
               // else
               // {
               //     send_json_error(validation_errors('<div />'));
               // }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				
				$empleado = $this->cliente->get($usuario['clte_id']);
                $data['empleado'] = $empleado;
				$data['usuario'] = $usuario;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/empleadohc',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function valida($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
               // $this->load->library('form_validation');
              //  $this->form_validation->set_rules('nombre','Nombre','required');
               // $this->form_validation->set_rules('paterno','Apellido Paterno','required');
              //  $this->form_validation->set_rules('materno','Apellido Materno','required');
              //  $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
              //  $this->form_validation->set_rules('genero','Género','required');
               // $this->form_validation->set_rules('grado','Grado acadédmico','required');
                
                //if($user['perfil_id'] == '1')
                //{
                //$this->form_validation->set_rules('puesto','Puesto','required');
				//if (get_my_user_root1() < 1)
				//{
					//$this->form_validation->set_rules('rol','Rol','required');
				//}
                //$this->form_validation->set_rules('user','Usuario','required');
                //}
                //si el rol es empresa se vuelve pbligatorio el campo de empresa
                //if($this->input->post('rol') == 4)
                //{
                    //$this->form_validation->set_rules('empresa','Empresa','required');
                //}
                
                //if($this->input->post('pass') != '')
                //{
                //    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
                 //   $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                //}

               // if($this->form_validation->run())
                //{
                    //informncion general del empleado
                    //$data_usr['usr_nombre'] =  $this->input->post('nombre');
                   // $data_usr['usr_paterno'] =  $this->input->post('paterno');
                   // $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                   // $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');
                    
                    //if($user['perfil_id'] == '1')
                    //{
                       // $data_usr['usr_puesto'] =  $this->input->post('puesto');
						//if (get_my_user_root1() < 1)
						//{
							//$data_usr['perfil_id'] =  $this->input->post('rol');
                        //}
						//$data_usr['usr_username'] =  $this->input->post('user');
                    //}
                    //($this->input->post('rol') == 4)
                    //{
                    //    $data_usr['emp_id'] =  $this->input->post('empresa');
                    //}
					
					//if($this->input->post('rol') < 4)
					//{
					//	$data_usr['emp_id'] =  31;
					//}

                    //dopmcicio de la persona
                    $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                    $data_usr['usr_env_cp'] =  $this->input->post('cp');
                    $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                    $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                    $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                    $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                    $data_usr['usr_env_calle'] =  $this->input->post('calle');
                    $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                    $data_usr['usr_env_num_int'] =  $this->input->post('nint');

                    //informacion de conrtaxcto de la persona
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					
					// sucursales y cei
					//$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//if  ($this->input->post('examenes'))
					//{
					//	$data_usr['servicios'] =  implode(',',$this->input->post('examenes'));
					//}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
                    $data_usr = array_to_upper($data_usr);
                    
					//if($this->input->post('pass') != '')
                   // {
                    //    $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
                    //}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
               // }
               // else
               // {
               //     send_json_error(validation_errors('<div />'));
               // }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'agenda/valida',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    } 

     public function nuevo_hco()
     {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            $this->form_validation->set_rules('grado','Grado acadédmico','required');
            $this->form_validation->set_rules('puesto','Puesto','required');
            //$this->form_validation->set_rules('rol','Rol','required');
            $this->form_validation->set_rules('user','Usuario','required');
            $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
            

            if($this->form_validation->run())
            {
                $data_usr['usr_nombre'] =  $this->input->post('nombre');
                $data_usr['usr_paterno'] =  $this->input->post('paterno');
                $data_usr['usr_materno'] =  $this->input->post('materno');
                $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                $data_usr['usr_rfc'] =  $this->input->post('rfc');
                $data_usr['usr_cedula'] =  $this->input->post('cedula');
                $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                $data_usr['usr_puesto'] =  $this->input->post('puesto');
                $data_usr['esp_id'] =  $this->input->post('esp_id');
				
				if ($this->input->post('modo') == 'SI')
				{
					$data_usr['perfil_id'] =  4;
				}
				else
				{
					$data_usr['perfil_id'] =  1;
				}
                
				
				$data_usr['usr_username'] =  $this->input->post('user');
                
                $data_usr['emp_id'] =  31;

                //dopmcicio de la persona
                $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                $data_usr['usr_env_cp'] =  $this->input->post('cp');
                $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                $data_usr['usr_env_calle'] =  $this->input->post('calle');
                $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                $data_usr['usr_env_num_int'] =  $this->input->post('nint');

                //informacion de conrtaxcto de la persona
                $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                $data_usr['usr_correo'] =  $this->input->post('correo');
				
				/*$data_usr['usr_email_personal'] =  $this->input->post('correopersonal'); 	
				$data_usr['usr_ext_hc'] =  $this->input->post('extensión'); 
				$data_usr['usr_tel_eme'] =  limpia_telefono($this->input->post('tel_eme'));	*/			
				
				// sucursales y cei
				$data_usr['suc_id'] =  $this->input->post('sucursal');
				$data_usr['cei_id'] =  $this->input->post('cei');
                
				//datos profesionales
				$data_usr['usr_carrera'] =  $this->input->post('carrera');
				$data_usr['usr_institucion'] =  $this->input->post('institucion');
				$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
				$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');				
				
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_usr['usr_path_foto'] = $data['file_name'];
                    }
                }
				
				//$tag=get_qr_code("HUMANCENTER 2021");
				
				
					$data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
					$data_usr['usr_tous'] = $this->input->post('pass');
                

					//datos profesionales
					$data_usr['usr_carrera'] =  $this->input->post('carrera');
					$data_usr['usr_institucion'] =  $this->input->post('institucion');
					$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
					$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');
					$data_usr['receta'] =  $this->input->post('receta');

					$modulos='';
					if ($this->input->post('fsm_ingenieria') == 'SI') {$modulos.='ingenieria;';}
					if ($this->input->post('fsm_control') == 'SI') {$modulos.='control;';}
					if ($this->input->post('fsm_gsi') == 'SI') {$modulos.='gsi;';}
					if ($this->input->post('fsm_empresa') == 'SI') {$modulos.='empresas;';}
					if ($this->input->post('fsm_pacientes') == 'SI') {$modulos.='pacientes;';}
					if ($this->input->post('fsm_evaluados') == 'SI') {$modulos.='evaluados;';}
					if ($this->input->post('fsm_servicios') == 'SI') {$modulos.='servicios;';}
					if ($this->input->post('fsm_usuarios') == 'SI') {$modulos.='usuarios;';}
					if ($this->input->post('fsm_agenda') == 'SI') {$modulos.='agenda;';}
					if ($this->input->post('fsm_admin') == 'SI') {$modulos.='admin;';}
					$data_usr['modulos'] =  $modulos;
					
				
					
					if (($data_usr['perfil_id'] == 4))
					{
						$data_usr['servicios'] =  'TODOS';
					}
					else
					{
						
					$examenes='';						
					/*if ($this->input->post('fsm_CURSOS') == 'SI') {$examenes.='CURSOS;';}
					if ($this->input->post('fsm_ESPECIALES') == 'SI') {$examenes.='ESPECIALES;';}
					if ($this->input->post('fsm_LABORATORIO') == 'SI') {$examenes.='LABORATORIO;';}
					if ($this->input->post('fsm_EYEDETECT') == 'SI') {$examenes.='EYEDETECT;';}
					if ($this->input->post('fsm_MEDICO-FISICO') == 'SI') {$examenes.='MEDICO-FISICO;';}
					if ($this->input->post('fsm_NOM035') == 'SI') {$examenes.='NOM035;';}
					if ($this->input->post('fsm_ODONTOLOGICOS') == 'SI') {$examenes.='ODONTOLOGICOS;';}
					if ($this->input->post('fsm_POLIGRAFICOS') == 'SI') {$examenes.='POLIGRAFICOS;';}
					if ($this->input->post('fsm_PSICOLOGICOS') == 'SI') {$examenes.='PSICOLOGICOS;';}
					if ($this->input->post('fsm_SOCIOECONOMICOS') == 'SI') {$examenes.='SOCIOECONOMICOS;';}					
					if ($this->input->post('fsm_TOXICOLOGICOS') == 'SI') {$examenes.='TOXICOLOGICOS;';}
					if ($this->input->post('fsm_SEGUROS') == 'SI') {$examenes.='SEGUROS;';}*/
					$data_usr['servicios'] =  $examenes;
					}

				$data_usr = array_to_upper($data_usr);
				$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
				
                if($this->empleado->inserta($data_usr))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'empleado/add_hco',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
      public function edita_x($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
             /*   $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('grado','Grado acadédmico','required');
                
			/*	
                $this->form_validation->set_rules('puesto','Puesto','required');
				if (get_my_user_root1() < 1)
				{
					$this->form_validation->set_rules('rol','Rol','required');
				}
                $this->form_validation->set_rules('user','Usuario','required');

                if($this->input->post('rol') == 4)
                {
                    $this->form_validation->set_rules('empresa','Empresa','required');
                }
             */   
                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] ="2000-01-01";  //formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');
                    

                        $data_usr['usr_puesto'] = "COLABORADOR";// $this->input->post('puesto');
						if (get_my_user_root1() < 1)
						{
							$data_usr['perfil_id'] =  $this->input->post('rol');
                        }
				/*		
					$data_usr['usr_username'] =  $this->input->post('user');

                    if($this->input->post('rol') == 4)
                    {
                        $data_usr['emp_id'] =  $this->input->post('empresa');
                    }
					
					if($this->input->post('rol') < 4)
					{
						$data_usr['emp_id'] =  31;
					}
					*/

                    //informacion de contacto de la usuario
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_titulo'] =  $this->input->post('titulo');
					
					 	
					// sucursales y cei
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//datos profesionales
					$data_usr['usr_carrera'] =  $this->input->post('carrera');
					$data_usr['usr_institucion'] =  $this->input->post('institucion');
					$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
					$data_usr['usr_consultorio_asig'] =  $this->input->post('consultorio_asignado');
					$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');
					$data_usr['receta'] =  $this->input->post('receta');
					
					
					
					$todos=$this->input->post('servicio_general');			
					$data_usr['servicios'] =  'TODOS';
					$data_usr['portal'] =  'NOM035';
					$data_usr['modulos'] =  'KDADO;';					
					/*if (($this->input->post('rol') == 4) || ( $todos === 'SI'))
					{
						$data_usr['servicios'] =  'TODOS';
					}
					else
					{
						$examenes='';
						
						$t=$this->input->post('especial');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ESPECIAL');
						}						
						
						$t=$this->input->post('toxi');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('TOXICOLOGÍA');
						}

						$t=$this->input->post('laboratorio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('LABORATORIO');
						}

						$t=$this->input->post('psicologia');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('PSICOLÓGICO');
						}	

						$t=$this->input->post('medico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('MÉDICO-FÍSICO');
						}
						
						$t=$this->input->post('socio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('SOCIOECONÓMICO');
						}
						
						
						$t=$this->input->post('poli');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('POLÍGRAFO');
						}	


						$t=$this->input->post('eye');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('EYEDETECT');
						}	

						$t=$this->input->post('odontologico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ODONTOLÓGICO');
						}	

						$t=$this->input->post('curso');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('CURSO');
						}
					
						$t=$this->input->post('nom035');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('NOM035');
						}	

						$t=$this->input->post('seguros');						
						if ( $t === 'SI')
						{
							$examenes .= 'SEGUROS,'; //get_list_examenes_by_grupo_nombre('SEGUROS');
						}
						
						
						if ($data_usr['receta'] === 'SI')
						{
							$examenes .='RECETARIO,';
						}
		
						$data_usr['servicios'] =  $examenes;
					}*/
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
						
						
						
						
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_x',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 
 
 
 
     public function envia_cnom035($empleado_id)
    {
        $empleado_registrado = $this->empleado->get($empleado_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(1)
            {
				$empleado= $this->input->post('empleado');
				$correo_electronico= $this->input->post('correo_electronico');
				$usuario = $this->input->post('usuario');
				$password= $this->input->post('password');
				$archivo_nom= $this->input->post('archivo_nom');
				$asunto= $this->input->post('asunto');
				$titulo= $this->input->post('titulo');
				$this->load->helper('mail');
				$data_email['empleado'] =  $empleado;
				$data_email['email'] =  $correo_electronico;
				$data_email['usuario'] =  $usuario;
				$data_email['password'] =  $password;
				$data_email['asunto'] =  $asunto;
				$data_email['titulo'] =  $titulo;

				$html = $this->load->view('empleado/email_cnom035',$data_email,TRUE);
				send_mail_cnom035($correo_electronico,$empleado, $html,$archivo_nom,$asunto);

				if(1)
				{
					send_json_ok('Se envió de forma correcta el email de NOM-035');
				}
				else
				{
					send_json_error('Ocurrió un error al enviar el email de NOM-035.');
				}
            }
            else
            {
                //send_json_error(validation_errors('<div />'));
				send_json_error('Ocurrió un error en el proceso de envio del email.');
            }
        }
        else 
        {

        }
    }
 
 
    public function edita_hc($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('grado','Grado acadédmico','required');

                $this->form_validation->set_rules('puesto','Puesto','required');
				
				$this->form_validation->set_rules('rol','Rol','required');
				
                $this->form_validation->set_rules('user','Usuario','required');

                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }


                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');

                    $data_usr['usr_puesto'] =  $this->input->post('puesto');

					$data_usr['perfil_id'] =  1;
        

					$data_usr['usr_username'] =  $this->input->post('user');


					$data_usr['emp_id'] =  31;


                    //informacion de contacto de la usuario
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_titulo'] =  $this->input->post('titulo');
					 	
					// sucursales y cei
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//datos profesionales
					$data_usr['usr_carrera'] =  $this->input->post('carrera');
					$data_usr['usr_institucion'] =  $this->input->post('institucion');
					$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
					$data_usr['usr_consultorio_asig'] =  $this->input->post('consultorio_asignado');
					$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');
					$data_usr['receta'] =  $this->input->post('receta');
					
					
					
					$todos=$this->input->post('servicio_general');			
					
					if (($this->input->post('rol') == 4) || ( $todos === 'SI'))
					{
						$data_usr['servicios'] =  'TODOS';
					}
					else
					{
						$examenes='';
						
						$t=$this->input->post('especial');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ESPECIAL');
						}						
						
						$t=$this->input->post('toxi');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('TOXICOLOGÍA');
						}

						$t=$this->input->post('laboratorio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('LABORATORIO');
						}

						$t=$this->input->post('psicologia');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('PSICOLÓGICO');
						}	

						$t=$this->input->post('medico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('MÉDICO-FÍSICO');
						}
						
						$t=$this->input->post('socio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('SOCIOECONÓMICO');
						}
						
						
						$t=$this->input->post('poli');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('POLÍGRAFO');
						}	


						$t=$this->input->post('eye');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('EYEDETECT');
						}	

						$t=$this->input->post('odontologico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ODONTOLÓGICO');
						}	

						$t=$this->input->post('curso');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('CURSO');
						}
					
						$t=$this->input->post('nom035');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('NOM035');
						}	

						$t=$this->input->post('seguros');						
						if ( $t === 'SI')
						{
							$examenes .= 'SEGUROS,'; //get_list_examenes_by_grupo_nombre('SEGUROS');
						}
						
						
						if ($data_usr['receta'] === 'SI')
						{
							$examenes .='RECETARIO,';
						}
		
						$data_usr['servicios'] =  $examenes;
					}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
					$data_usr['usr_cat_puesto']=$this->input->post('cat_puesto');
					$data_usr['usr_area']=$this->input->post('area_depto');
					$data_usr['usr_depto']=$this->input->post('area_depto');
					$data_usr['usr_email_personal']=$this->input->post('correo_personal');
					$data_usr['usr_eje']=$this->input->post('usr_eje');
					$data_usr['usr_clte_id']=$this->input->post('usr_clte_id');					
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_hc',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    } 

    public function edita_cliente($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('puesto','Puesto','required');
                $this->form_validation->set_rules('user','Usuario','required');
                $this->form_validation->set_rules('empresa','Empresa','required');
                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');
                    
                    //if($user['perfil_id'] == '1')
                    //{
                        $data_usr['usr_puesto'] =  $this->input->post('puesto');
						if (get_my_user_root1() < 1)
						{
							$data_usr['perfil_id'] =  $this->input->post('rol');
                        }
						$data_usr['usr_username'] =  $this->input->post('user');
                    //}
                    if($this->input->post('rol') == 4)
                    {
                        $data_usr['emp_id'] =  $this->input->post('empresa');
                    }
					
					if($this->input->post('rol') < 4)
					{
						$data_usr['emp_id'] =  31;
					}

                    //domicilio de la usuario
                  /*  $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                    $data_usr['usr_env_cp'] =  $this->input->post('cp');
                    $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                    $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                    $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                    $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                    $data_usr['usr_env_calle'] =  $this->input->post('calle');
                    $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                    $data_usr['usr_env_num_int'] =  $this->input->post('nint');*/

                    //informacion de contacto de la usuario
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_titulo'] =  $this->input->post('titulo');
					
					 	
					// sucursales y cei
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//datos profesionales
					/*$data_usr['usr_carrera'] =  $this->input->post('carrera');
					$data_usr['usr_institucion'] =  $this->input->post('institucion');
					
					$data_usr['usr_consultorio_asig'] =  $this->input->post('consultorio_asignado');
					$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');
					$data_usr['receta'] =  $this->input->post('receta');*/
					
					$data_usr['usr_emp_asig'] = $empleado['emp_id'];
					
					$todos=$this->input->post('servicio_general');			
					
					if (($this->input->post('rol') == 4) || ( $todos === 'SI'))
					{
						$data_usr['servicios'] =  'TODOS';
					}
					else
					{
						$examenes='';
						
						$t=$this->input->post('especial');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ESPECIAL');
						}						
						
						$t=$this->input->post('toxi');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('TOXICOLOGÍA');
						}

						$t=$this->input->post('laboratorio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('LABORATORIO');
						}

						$t=$this->input->post('psicologia');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('PSICOLÓGICO');
						}	

						$t=$this->input->post('medico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('MÉDICO-FÍSICO');
						}
						
						$t=$this->input->post('socio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('SOCIOECONÓMICO');
						}
						
						
						$t=$this->input->post('poli');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('POLÍGRAFO');
						}	


						$t=$this->input->post('eye');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('EYEDETECT');
						}	

						$t=$this->input->post('odontologico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ODONTOLÓGICO');
						}	

						$t=$this->input->post('curso');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('CURSO');
						}
					
						$t=$this->input->post('nom035');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('NOM035');
						}	

						$t=$this->input->post('seguros');						
						if ( $t === 'SI')
						{
							$examenes .= 'SEGUROS,'; //get_list_examenes_by_grupo_nombre('SEGUROS');
						}
						
						
						if ($data_usr['receta'] === 'SI')
						{
							$examenes .='RECETARIO,';
						}
		
						$data_usr['servicios'] =  $examenes;
					}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_cliente',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }

 
 
 
     public function edita_desactivados($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('grado','Grado acadédmico','required');
                
                //if($user['perfil_id'] == '1')
                //{
                $this->form_validation->set_rules('puesto','Puesto','required');
				if (get_my_user_root1() < 1)
				{
					$this->form_validation->set_rules('rol','Rol','required');
				}
                $this->form_validation->set_rules('user','Usuario','required');
                //}
                //si el rol es empresa se vuelve pbligatorio el campo de empresa
                if($this->input->post('rol') == 4)
                {
                    $this->form_validation->set_rules('empresa','Empresa','required');
                }
                
                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');
                    
                    //if($user['perfil_id'] == '1')
                    //{
                        $data_usr['usr_puesto'] =  $this->input->post('puesto');
						if (get_my_user_root1() < 1)
						{
							$data_usr['perfil_id'] =  $this->input->post('rol');
                        }
						$data_usr['usr_username'] =  $this->input->post('user');
                    //}
                    if($this->input->post('rol') == 4)
                    {
                        $data_usr['emp_id'] =  $this->input->post('empresa');
                    }
					
					if($this->input->post('rol') < 4)
					{
						$data_usr['emp_id'] =  31;
					}

                    //domicilio de la usuario
                  /*  $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                    $data_usr['usr_env_cp'] =  $this->input->post('cp');
                    $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                    $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                    $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                    $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                    $data_usr['usr_env_calle'] =  $this->input->post('calle');
                    $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                    $data_usr['usr_env_num_int'] =  $this->input->post('nint');*/

                    //informacion de contacto de la usuario
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_titulo'] =  $this->input->post('titulo');
					
					 	
					// sucursales y cei
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//datos profesionales
					$data_usr['usr_carrera'] =  $this->input->post('carrera');
					$data_usr['usr_institucion'] =  $this->input->post('institucion');
					$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
					$data_usr['usr_consultorio_asig'] =  $this->input->post('consultorio_asignado');
					$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');
					$data_usr['receta'] =  $this->input->post('receta');
					
					
					
					$todos=$this->input->post('servicio_general');			
					
					if (($this->input->post('rol') == 4) || ( $todos === 'SI'))
					{
						$data_usr['servicios'] =  'TODOS';
					}
					else
					{
						$examenes='';
						
						$t=$this->input->post('especial');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ESPECIAL');
						}						
						
						$t=$this->input->post('toxi');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('TOXICOLOGÍA');
						}

						$t=$this->input->post('laboratorio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('LABORATORIO');
						}

						$t=$this->input->post('psicologia');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('PSICOLÓGICO');
						}	

						$t=$this->input->post('medico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('MÉDICO-FÍSICO');
						}
						
						$t=$this->input->post('socio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('SOCIOECONÓMICO');
						}
						
						
						$t=$this->input->post('poli');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('POLÍGRAFO');
						}	


						$t=$this->input->post('eye');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('EYEDETECT');
						}	

						$t=$this->input->post('odontologico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ODONTOLÓGICO');
						}	

						$t=$this->input->post('curso');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('CURSO');
						}
					
						$t=$this->input->post('nom035');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('NOM035');
						}	

						$t=$this->input->post('seguros');						
						if ( $t === 'SI')
						{
							$examenes .= 'SEGUROS,'; //get_list_examenes_by_grupo_nombre('SEGUROS');
						}
						
						
						if ($data_usr['receta'] === 'SI')
						{
							$examenes .='RECETARIO,';
						}
		
						$data_usr['servicios'] =  $examenes;
					}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_desactivados',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 
 
 public function edita_nom035($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
				$this->form_validation->set_rules('rol','Rol','required');
                $this->form_validation->set_rules('empresa','Empresa','required');
				if($this->input->post('pass') != '')
                {
                $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
          		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
				}

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');
                    $data_usr['usr_puesto'] =  $this->input->post('puesto');
					$data_usr['perfil_id'] =  $this->input->post('rol');
					$data_usr['usr_username'] =  $this->input->post('user');
                    $data_usr['emp_id'] =  $this->input->post('empresa');
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					$data_usr['servicios'] =  'TODOS';

					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_nom035',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 
 
 
 
    public function edita($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('grado','Grado acadédmico','required');
                
                //if($user['perfil_id'] == '1')
                //{
                $this->form_validation->set_rules('puesto','Puesto','required');
				if (get_my_user_root1() < 1)
				{
					$this->form_validation->set_rules('rol','Rol','required');
				}
                $this->form_validation->set_rules('user','Usuario','required');
                //}
                //si el rol es empresa se vuelve pbligatorio el campo de empresa
                if($this->input->post('rol') == 4)
                {
                    $this->form_validation->set_rules('empresa','Empresa','required');
                }
                
                if($this->input->post('pass') != '')
                {   
                    $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
                }

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');

                    $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                    $data_usr['esp_id'] =  $this->input->post('esp_id');
                    
                    //if($user['perfil_id'] == '1')
                    //{
                        $data_usr['usr_puesto'] =  $this->input->post('puesto');
						if (get_my_user_root1() < 1)
						{
							$data_usr['perfil_id'] =  $this->input->post('rol');
                        }
						$data_usr['usr_username'] =  $this->input->post('user');
                    //}
                    if($this->input->post('rol') == 4)
                    {
                        $data_usr['emp_id'] =  $this->input->post('empresa');
                    }
					
					if($this->input->post('rol') < 4)
					{
						$data_usr['emp_id'] =  31;
					}

                    //domicilio de la usuario
                  /*  $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                    $data_usr['usr_env_cp'] =  $this->input->post('cp');
                    $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                    $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                    $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                    $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                    $data_usr['usr_env_calle'] =  $this->input->post('calle');
                    $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                    $data_usr['usr_env_num_int'] =  $this->input->post('nint');*/

                    //informacion de contacto de la usuario
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['usr_titulo'] =  $this->input->post('titulo');
					
					 	
					// sucursales y cei
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					
					//datos profesionales
					$data_usr['usr_carrera'] =  $this->input->post('carrera');
					$data_usr['usr_institucion'] =  $this->input->post('institucion');
					$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
					$data_usr['usr_consultorio_asig'] =  $this->input->post('consultorio_asignado');
					$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');
					$data_usr['receta'] =  $this->input->post('receta');
					
					
					
					$todos=$this->input->post('servicio_general');			
					
					if (($this->input->post('rol') == 4) || ( $todos === 'SI'))
					{
						$data_usr['servicios'] =  'TODOS';
					}
					else
					{
						$examenes='';
						
						$t=$this->input->post('especial');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ESPECIAL');
						}						
						
						$t=$this->input->post('toxi');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('TOXICOLOGÍA');
						}

						$t=$this->input->post('laboratorio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('LABORATORIO');
						}

						$t=$this->input->post('psicologia');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('PSICOLÓGICO');
						}	

						$t=$this->input->post('medico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('MÉDICO-FÍSICO');
						}
						
						$t=$this->input->post('socio');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('SOCIOECONÓMICO');
						}
						
						
						$t=$this->input->post('poli');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('POLÍGRAFO');
						}	


						$t=$this->input->post('eye');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('EYEDETECT');
						}	

						$t=$this->input->post('odontologico');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('ODONTOLÓGICO');
						}	

						$t=$this->input->post('curso');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('CURSO');
						}
					
						$t=$this->input->post('nom035');						
						if ( $t === 'SI')
						{
							$examenes .= get_list_examenes_by_grupo_nombre('NOM035');
						}	

						$t=$this->input->post('seguros');						
						if ( $t === 'SI')
						{
							$examenes .= 'SEGUROS,'; //get_list_examenes_by_grupo_nombre('SEGUROS');
						}
						
						
						if ($data_usr['receta'] === 'SI')
						{
							$examenes .='RECETARIO,';
						}
		
						$data_usr['servicios'] =  $examenes;
					}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 
  public function edita_asistencia($asistencia_id)
    {
        $asistencia = $this->empleado->get_asistencias($asistencia_id);

		$user = $this->session->user;
        
        if($asistencia)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                if(1)
                {
                    
                    $data_usr['cei_id'] =  $this->input->post('cei');
					$data_usr['qui_num'] =  $this->input->post('quincena');
                    $data_usr['usrlog_ingreso_f'] =  $this->input->post('ingreso');
					$data_usr['usrlog_salida_f'] =  $this->input->post('salida');
					$data_usr['usrlog_tiempo_asistencia'] =  $this->input->post('asistencia');
					$data_usr['usrlog_accion_cve'] =  $this->input->post('tasistencia');
	
                    if ($this->empleado->asistencia_actualiza($asistencia_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				$data['quincenas'] = $this->empresa->get_all_quincenas();	
				$data['asistencia']=$asistencia;
				$this->load->helper('template');
				
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'empleado/edit_asistencia',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 
 
 
 
     public function nuevo_hc()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            $this->form_validation->set_rules('grado','Grado acadédmico','required');
            $this->form_validation->set_rules('puesto','Puesto','required');
            $this->form_validation->set_rules('rol','Rol','required');
            $this->form_validation->set_rules('user','Usuario','required');
            $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');

            if($this->form_validation->run())
            {
                $data_usr['usr_nombre'] =  $this->input->post('nombre');
                $data_usr['usr_paterno'] =  $this->input->post('paterno');
                $data_usr['usr_materno'] =  $this->input->post('materno');
                $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                $data_usr['usr_rfc'] =  $this->input->post('rfc');
                $data_usr['usr_cedula'] =  $this->input->post('cedula');
                $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                $data_usr['usr_puesto'] =  $this->input->post('puesto');
                $data_usr['esp_id'] =  $this->input->post('esp_id');
                $data_usr['perfil_id'] =  $this->input->post('rol');
                $data_usr['usr_username'] =  $this->input->post('user');
                $data_usr['emp_id'] =  31;
                

                $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                $data_usr['usr_correo'] =  $this->input->post('correo');
				
				// sucursales y cei
				$data_usr['suc_id'] =  $this->input->post('sucursal');
				$data_usr['cei_id'] =  $this->input->post('cei');
                
				//datos profesionales
				$data_usr['usr_carrera'] =  $this->input->post('carrera');
				$data_usr['usr_institucion'] =  $this->input->post('institucion');
				$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
				$data_usr['usr_consultorio_asig'] =  $this->input->post('consultorio_asignado');
				 	
				$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');				
				$data_usr['usr_rfc'] =  $this->input->post('rfc');
				$data_usr['usr_titulo'] =  $this->input->post('titulo');
				
				
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_usr['usr_path_foto'] = $data['file_name'];
                    }
                }
                $data_usr = array_to_upper($data_usr);
				
				
				
				if ($this->input->post('pass') == 'GENERA_CONTRASEÑA')
				{	
					
					$usuario['usr_nombre']=$this->input->post('nombre');
					$usuario['usr_paterno']=$this->input->post('paterno');
					$usuario['emp_id']=31;
					
					$password = genera_password($usuario);
				
					$data_usr['usr_password'] = password_hash($password,PASSWORD_DEFAULT);
					$data_usr['usr_tous']= $password;
				}
				else
				{	
					$data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
					$data_usr['usr_tous']=$this->input->post('pass');
				}
				
				$data_usr['usr_clte_id']=$this->input->post('usr_clte_id');
				$data_usr['usr_eje']=$this->input->post('usr_eje');
				$data_usr['usr_email_personal']=$this->input->post('correo_personal');
				
				$data_usr['usr_cat_puesto']=$this->input->post('cat_puesto');
				$data_usr['usr_area']=$this->input->post('area_depto');
				$data_usr['usr_depto']=$this->input->post('area_depto');				
				$data_usr['usr_email_personal']=$this->input->post('correo_personal');
				$data_usr['usr_eje']=$this->input->post('usr_eje');
				$data_usr['usr_clte_id']=$this->input->post('usr_clte_id');	

				
			
				$todos=$this->input->post('servicio_general');			
				
				if (($this->input->post('rol') == 4) || ( $todos === 'SI'))
				{
					$data_usr['servicios'] =  'TODOS';
				}
				else
				{
					$examenes='';
					
					$t=$this->input->post('especial');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('ESPECIAL');
					}						
					
					$t=$this->input->post('toxi');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('TOXICOLOGÍA');
					}

					$t=$this->input->post('laboratorio');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('LABORATORIO');
					}

					$t=$this->input->post('psicologia');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('PSICOLÓGICO');
					}	

					$t=$this->input->post('medico');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('MÉDICO-FÍSICO');
					}
					
					$t=$this->input->post('socio');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('SOCIOECONÓMICO');
					}
					
					
					$t=$this->input->post('poli');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('POLÍGRAFO');
					}	


					$t=$this->input->post('eye');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('EYEDETECT');
					}	

					$t=$this->input->post('odontologico');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('ODONTOLÓGICO');
					}	

					$t=$this->input->post('curso');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('CURSO');
					}
				
					$t=$this->input->post('nom035');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('NOM035');
					}	

					$t=$this->input->post('seguros');						
					if ( $t === 'SI')
					{
						$examenes .='SEGUROS,'; //get_list_examenes_by_grupo_nombre('SEGUROS');
					}						
					
					$data_usr['receta'] =  $this->input->post('receta');
					
					if ($data_usr['receta'] === 'SI')
					{
						$examenes .='RECETARIO,';
					}
	
					$data_usr['servicios'] =  $examenes;
				}



                if($this->empleado->inserta($data_usr))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas_clean();
			$data['sucursals'] = $this->empresa->get_all_sucursales(31);
			$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'empleado/add_hc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
 
     public function nuevo_cliente()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
         //   $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
           // $this->form_validation->set_rules('grado','Grado acadédmico','required');
            $this->form_validation->set_rules('puesto','Puesto','required');
           // $this->form_validation->set_rules('rol','Rol','required');
            $this->form_validation->set_rules('user','Usuario','required');
            $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
            
            //si el rol es empresa se vuelve pbligatorio el campo de empresa
            if($this->input->post('rol') == 4)
            {
                $this->form_validation->set_rules('empresa','Empresa','required');
            }

            if($this->form_validation->run())
            {
                $data_usr['usr_nombre'] =  $this->input->post('nombre');
                $data_usr['usr_paterno'] =  $this->input->post('paterno');
                $data_usr['usr_materno'] =  $this->input->post('materno');
                $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                $data_usr['usr_rfc'] =  $this->input->post('rfc');
                $data_usr['usr_cedula'] =  $this->input->post('cedula');
                $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                $data_usr['usr_puesto'] =  $this->input->post('puesto');
                $data_usr['esp_id'] =  $this->input->post('esp_id');
                $data_usr['perfil_id'] =  $this->input->post('rol');
                $data_usr['usr_username'] =  $this->input->post('user');
                
                if($this->input->post('rol') == 4)
                {
                    $data_usr['emp_id'] =  $this->input->post('empresa');
                }

                if($this->input->post('rol') < 4)
                {
                    $data_usr['emp_id'] =  31;
                }

                //dopmcicio de la persona
               /* $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                $data_usr['usr_env_cp'] =  $this->input->post('cp');
                $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                $data_usr['usr_env_calle'] =  $this->input->post('calle');
                $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                $data_usr['usr_env_num_int'] =  $this->input->post('nint');*/

                //informacion de conrtaxcto de la persona
                $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                $data_usr['usr_correo'] =  $this->input->post('correo');
				
				// sucursales y cei
				$data_usr['suc_id'] =  $this->input->post('sucursal');
				$data_usr['cei_id'] =  $this->input->post('cei');
                
				//datos profesionales
				/*$data_usr['usr_carrera'] =  $this->input->post('carrera');
				$data_usr['usr_institucion'] =  $this->input->post('institucion');
				$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
				$data_usr['usr_consultorio_asig'] =  $this->input->post('consultorio_asignado');
				 	
				$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');				
				$data_usr['usr_rfc'] =  $this->input->post('rfc');
				$data_usr['usr_titulo'] =  $this->input->post('titulo');*/
				
				
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_usr['usr_path_foto'] = $data['file_name'];
                    }
                }
                $data_usr = array_to_upper($data_usr);
                $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
				$data_usr['usr_tous']=$this->input->post('pass');
				
			
				$todos=$this->input->post('servicio_general');			
				
				if (($this->input->post('rol') == 4) || ( $todos === 'SI'))
				{
					$data_usr['servicios'] =  'TODOS';
				}
				else
				{
					$examenes='';
					
					$t=$this->input->post('especial');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('ESPECIAL');
					}						
					
					$t=$this->input->post('toxi');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('TOXICOLOGÍA');
					}

					$t=$this->input->post('laboratorio');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('LABORATORIO');
					}

					$t=$this->input->post('psicologia');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('PSICOLÓGICO');
					}	

					$t=$this->input->post('medico');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('MÉDICO-FÍSICO');
					}
					
					$t=$this->input->post('socio');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('SOCIOECONÓMICO');
					}
					
					
					$t=$this->input->post('poli');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('POLÍGRAFO');
					}	


					$t=$this->input->post('eye');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('EYEDETECT');
					}	

					$t=$this->input->post('odontologico');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('ODONTOLÓGICO');
					}	

					$t=$this->input->post('curso');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('CURSO');
					}
				
					$t=$this->input->post('nom035');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('NOM035');
					}	

					$t=$this->input->post('seguros');						
					if ( $t === 'SI')
					{
						$examenes .='SEGUROS,'; //get_list_examenes_by_grupo_nombre('SEGUROS');
					}						
					
					$data_usr['receta'] =  $this->input->post('receta');
					
					if ($data_usr['receta'] === 'SI')
					{
						$examenes .='RECETARIO,';
					}
	
					$data_usr['servicios'] =  $examenes;
				}

				$data_usr['usr_emp_asig'] = $this->input->post('empresa');

                if($this->empleado->inserta($data_usr))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas_clean();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'empleado/add_cliente',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
 
 
 
 
    public function nuevo()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
           // $this->form_validation->set_rules('grado','Grado acadédmico','required');
            $this->form_validation->set_rules('puesto','Puesto','required');
            $this->form_validation->set_rules('rol','Rol','required');
            $this->form_validation->set_rules('user','Usuario','required');
            $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
            $this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
            
            //si el rol es empresa se vuelve pbligatorio el campo de empresa
            if($this->input->post('rol') == 4)
            {
                $this->form_validation->set_rules('empresa','Empresa','required');
            }

            if($this->form_validation->run())
            {
                $data_usr['usr_nombre'] =  $this->input->post('nombre');
                $data_usr['usr_paterno'] =  $this->input->post('paterno');
                $data_usr['usr_materno'] =  $this->input->post('materno');
                $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                $data_usr['usr_rfc'] =  $this->input->post('rfc');
                $data_usr['usr_cedula'] =  $this->input->post('cedula');
                $data_usr['usr_grado_acad_cve'] =  $this->input->post('grado');
                $data_usr['usr_puesto'] =  $this->input->post('puesto');
                $data_usr['esp_id'] =  $this->input->post('esp_id');
                $data_usr['perfil_id'] =  $this->input->post('rol');
                $data_usr['usr_username'] =  $this->input->post('user');
                
                if($this->input->post('rol') == 4)
                {
                    $data_usr['emp_id'] =  $this->input->post('empresa');
                }

                if($this->input->post('rol') < 4)
                {
                    $data_usr['emp_id'] =  31;
                }

                //dopmcicio de la persona
               /* $data_usr['usr_env_pais_cve'] =  $this->input->post('pais');
                $data_usr['usr_env_cp'] =  $this->input->post('cp');
                $data_usr['usr_env_edo_cve'] =  $this->input->post('entidad');
                $data_usr['usr_env_colonia'] =  $this->input->post('colonia');
                $data_usr['usr_env_localidad'] =  $this->input->post('localidad');
                $data_usr['usr_env_municipio'] =  $this->input->post('municipio');
                $data_usr['usr_env_calle'] =  $this->input->post('calle');
                $data_usr['usr_env_num_ext'] =  $this->input->post('next');
                $data_usr['usr_env_num_int'] =  $this->input->post('nint');*/

                //informacion de conrtaxcto de la persona
                $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                $data_usr['usr_correo'] =  $this->input->post('correo');
				
				// sucursales y cei
				$data_usr['suc_id'] =  $this->input->post('sucursal');
				$data_usr['cei_id'] =  $this->input->post('cei');
                
				//datos profesionales
				$data_usr['usr_carrera'] =  $this->input->post('carrera');
				$data_usr['usr_institucion'] =  $this->input->post('institucion');
				$data_usr['usr_emp_asig'] =  $this->input->post('empresa_asignada');
				$data_usr['usr_consultorio_asig'] =  $this->input->post('consultorio_asignado');
				 	
				$data_usr['usr_emp_asig_dir'] =  $this->input->post('empresa_direccion');				
				$data_usr['usr_rfc'] =  $this->input->post('rfc');
				$data_usr['usr_titulo'] =  $this->input->post('titulo');
				
				
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_usr['usr_path_foto'] = $data['file_name'];
                    }
                }
                $data_usr = array_to_upper($data_usr);
                $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
				$data_usr['usr_tous']=$this->input->post('pass');
				
			
				$todos=$this->input->post('servicio_general');			
				
				if (($this->input->post('rol') == 4) || ( $todos === 'SI'))
				{
					$data_usr['servicios'] =  'TODOS';
				}
				else
				{
					$examenes='';
					
					$t=$this->input->post('especial');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('ESPECIAL');
					}						
					
					$t=$this->input->post('toxi');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('TOXICOLOGÍA');
					}

					$t=$this->input->post('laboratorio');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('LABORATORIO');
					}

					$t=$this->input->post('psicologia');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('PSICOLÓGICO');
					}	

					$t=$this->input->post('medico');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('MÉDICO-FÍSICO');
					}
					
					$t=$this->input->post('socio');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('SOCIOECONÓMICO');
					}
					
					
					$t=$this->input->post('poli');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('POLÍGRAFO');
					}	


					$t=$this->input->post('eye');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('EYEDETECT');
					}	

					$t=$this->input->post('odontologico');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('ODONTOLÓGICO');
					}	

					$t=$this->input->post('curso');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('CURSO');
					}
				
					$t=$this->input->post('nom035');						
					if ( $t === 'SI')
					{
						$examenes .= get_list_examenes_by_grupo_nombre('NOM035');
					}	

					$t=$this->input->post('seguros');						
					if ( $t === 'SI')
					{
						$examenes .='SEGUROS,'; //get_list_examenes_by_grupo_nombre('SEGUROS');
					}						
					
					$data_usr['receta'] =  $this->input->post('receta');
					
					if ($data_usr['receta'] === 'SI')
					{
						$examenes .='RECETARIO,';
					}
	
					$data_usr['servicios'] =  $examenes;
				}



                if($this->empleado->inserta($data_usr))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas_clean();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'empleado/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    

    
    public function nuevo_doc($empleado_id)
    {
        $persona = $this->empleado->get($empleado_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_usr['usr_id'] =  $empleado_id;
                $data_usr['doc_nombre'] =  $this->input->post('nombre');
                $data_usr['doc_f'] =  date('Y-m-d H:i:s');
                
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_usr['doc_path'] = $data['file_name'];
                        if($this->empleado->add_doc($data_usr))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }


    function reporte_asistencias_xls()
    {

        $this->load->helper('template');		
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<?php
					header("Content-type: application/octet-stream; charset=latin1");
					header("Content-Disposition: attachment; filename=Rep_Usuarios.xls");
					header("Pragma: no-cache");
					header("Expires: 0");
				?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}
				</style>
			</head>
					<?php
						date_default_timezone_set('America/Mexico_City');
						$date2today = date("Y-m-d H:i:s");
					?>	
			<body>
				
<!------------ nueva estructura ------------------->
	<?php 
	
		$user = $this->session->user; 
		$usuario_p=$this->empleado->get($user['usr_id']);
	
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$elempleado = $this->input->post('elempleado');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$quincena = trim($this->input->post('quincena')); 		
		
		$f_ini = trim(strtoupper($this->input->post('f_ini'))); 
		$f_fin = trim(strtoupper($this->input->post('f_fin')));

		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_asistencia($nombre,$paterno,$materno, $elempleado,$usuario,$f_ini, $f_fin,$quincena,$usuario_p);
		$data_2 = $this->empleado->busca_asistencia_g2($nombre,$paterno,$materno, $elempleado,$usuario,$f_ini, $f_fin,$quincena,$usuario_p);
	?>
	
				<table>
					<thead>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px">&nbsp;</th>
							<th class="auto-style5" style="width: 100px">&nbsp;</th>
							<th class="auto-style5" style="width: 550px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 100px">&nbsp;</th>
							<th class="auto-style5" style="width: 550px">Reporte de Asistencia de Empleados 
							Human Center</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px; height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" style="width: 100px">&nbsp;</th>
							<th class="auto-style5" style="width: 550px; height: 27px;"><?php echo $date2today; ?></th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px">&nbsp;</th>
							<th class="auto-style5" style="width: 100px">&nbsp;</th>
							<th class="auto-style5" style="width: 550px">Periódo</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px">&nbsp;</th>
							<th class="auto-style5" style="width: 100px">&nbsp;</th>
							<th class="auto-style5" style="width: 550px">Del&nbsp;<?php echo formatea_fecha($f_ini); ?>&nbsp;al&nbsp;<?php echo formatea_fecha($f_fin); ?></th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px">&nbsp;</th>
							<th class="auto-style5" style="width: 100px">&nbsp;</th>
							<th class="auto-style5" style="width: 550px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px">&nbsp;</th>
							<th class="auto-style5" style="width: 100px">&nbsp;</th>
							<th class="auto-style5" style="width: 550px">&nbsp;</th>
						</tr>						
						<tr>
							<th class="auto-style14" style="width: 82px">ID</th>
							<th class="auto-style14" style="width: 325px">Nombre</th>
							<th class="auto-style14" style="width: 100px">Usuario</th>
							<th class="auto-style14" style="width: 550px">Puesto</th>
							<th class="auto-style14" style="width: 100px">Asignación</th>
							
							<?php
								$fecha_factor = $f_ini;	

								$date1 = new DateTime($f_ini);
								$date2 = new DateTime($f_fin);
								$diff = $date1->diff($date2);	
								$dias=$diff->days;
								
								
								for ($i=0; $i <= $dias; $i++)
								{
								$fecha_factor =date("Y-m-d",strtotime($f_ini."+ ".$i." days")); 
								?>
								<th class="auto-style14" style="width: 125px"><?php echo formatea_fecha($fecha_factor).'<br style="mso-data-placement:same-cell;" />'.dia_de_hoy(date('l', strtotime($fecha_factor))); ?></th>
								<?php
								}
							?>
							<th class="auto-style14" style="width: 100px">Tiempo acumulado</th>
							<th class="auto-style14" style="width: 100px">Dias asistidos</th>
							<th class="auto-style14" style="width: 100px">Tiempo promedio</th>
						</tr>
					</thead>
	<?php 
        //$resutaldos_empleados = $this->empleado->busca_asistencia_empleados($elempleado);
		//$asistencia_empleados = $data['empleados']; 
		$asistencia_empleados = $this->empleado->busca_empleados_especificos($data_2);
	?>					
					
					<tbody id="resultado">
						<?php
						$class18=" ";
						if($asistencia_empleados): 
						//$array_rol = get_cat_nombre_var('ROL'); 
							foreach ($asistencia_empleados as $empleado): 
							    
								
								$data_empleado = $this->empleado->get($empleado['usr_id']);
								$tiempo_acumulado=0;
								$días_acumulados=0;
							
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";							
								}						
							?>							
								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_id'].'<br style="mso-data-placement:same-cell;" />'; ?></td>
									<td class=<?php echo $class18; ?> style="width: 325px">
										<?php echo get_code_html($empleado['usr_nombre']); ?> 
										<?php echo get_code_html($empleado['usr_paterno']); ?> 
										<?php echo get_code_html($empleado['usr_materno']).'<br style="mso-data-placement:same-cell;" />'; ?>
									</td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_username'].'<br style="mso-data-placement:same-cell;" />'; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $data_empleado['usr_puesto'].'<br style="mso-data-placement:same-cell;" />'; ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_cei($empleado['cei_id']).'<br style="mso-data-placement:same-cell;" />'; ?></td>
																	
									<?php
											
												$fecha_factor = $f_ini;	

												$date1 = new DateTime($f_ini);
												$date2 = new DateTime($f_fin);
												$diff = $date1->diff($date2);	
												$dias=$diff->days;
												
													for ($i=0; $i <= $dias; $i++)
													{
														$fecha_factor =date("Y-m-d",strtotime($f_ini."+ ".$i." days")); 
													
														$registro_asistencia = $this->empleado->busca_asistencia_r($empleado['usr_id'],$fecha_factor, $quincena);
													
													?>
													
													<td class=<?php echo $class18; ?>><?php 
																							foreach ($registro_asistencia as $el_registro)
																							{	
																								if (($el_registro['usrlog_ingreso_f'] !='') && ( $el_registro['usrlog_salida_f'] !='0000-00-00 00:00:00'))
																								{
																									$diff=abs(strtotime($el_registro['usrlog_salida_f']) - strtotime($el_registro['usrlog_ingreso_f']));
																																														
																									$bodytag = str_replace("00 años ", "", $el_registro['usrlog_tiempo_asistencia']);
																									$bodytag = str_replace("0 meses ", "", $bodytag);
																									$bodytag = str_replace("0 días ", "", $bodytag);
																									$bodytag = str_replace("horas", "hrs", $bodytag);
																									$bodytag = str_replace("minutos", "mins", $bodytag);
																									$bodytag = str_replace("segundos", "segs", $bodytag);
																									
																									$body_tag=$bodytag;
																									$body_tag = str_replace("hrs",";" ,$body_tag);
																									$body_tag = str_replace("mins",";", $body_tag);
																									$body_tag = str_replace("segs","" ,$body_tag);
																									$body_parts= explode(";", $body_tag); 
																									
																									$tiempo=$body_parts[0]+($body_parts[1]/60)+(($body_parts[2]/60)/60); 
																									$tiempo_acumulado+=$tiempo;
																									$días_acumulados++;
																									//echo $bodytag.'-'.$tiempo;
																									
																									echo '<br style="mso-data-placement:same-cell;" />'.'<b  style="color: green;">'.'ENT: '.substr($el_registro['usrlog_ingreso_f'],-8,-3).' Hrs</b>'.'<br style="mso-data-placement:same-cell;" />'.'<b style="color: blue;">'.'SAL: '.substr($el_registro['usrlog_salida_f'],-8,-3).' Hrs</b><br style="mso-data-placement:same-cell;" /><b>'.round($tiempo,2).' Horas</b> ';
																								}
																								else
																								{
																									echo '<br style="mso-data-placement:same-cell;" />'.'<b style="color: red;">'.'ENT: '.substr($el_registro['usrlog_ingreso_f'],-8,-3).' Hrs</b><br style="mso-data-placement:same-cell;" /><br style="mso-data-placement:same-cell;" /><br style="mso-data-placement:same-cell;" />';
																								}	
																							}
																						?>
																						</td>
																						
																																				
													<?php
													}	
													
									?>			
									<td class=<?php echo $class18; ?> ><?php echo round($tiempo_acumulado,2),' hrs'; ?></td>
									<td class=<?php echo $class18; ?> ><?php echo $días_acumulados.' días'; ?></td> 
									<td class=<?php echo $class18; ?> ><?php echo round($tiempo_acumulado/$días_acumulados,2).' hrs'; ?></td> 
								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>

<!------------------------------------------------->				
				
			</body>
		</html>
		<?php 
	}


    public function nuevo_reporte_desactivados()
    {       $this->load->helper('template');
			$data['empresas'] = $this->cliente->trae_empresas();
			$params_view = array(
				'title' => 'Servicios',
				'view' => 'empleado/ficha_desactivados',
				'view_data' => $data
			   );
			
            render_template($params_view);  
    }


    public function nuevo_reporte_nom035()
    {       $this->load->helper('template');
			$data['empresas'] = $this->cliente->trae_empresas();
			$params_view = array(
				'title' => 'Servicios',
				'view' => 'empleado/ficha_nom035',
				'view_data' => $data
			   );
			
            render_template($params_view);  
    }



    public function nuevo_reporte_hc()

    {       $this->load->helper('template');
			$data['empresas'] = $this->cliente->trae_empresas();
			$params_view = array(
				'title' => 'Servicios',
				'view' => 'empleado/ficha_hc',
				'view_data' => $data
			   );
			
            render_template($params_view);  
    }



    public function nuevo_reporte_clientes()

    {       $this->load->helper('template');
			$data['empresas'] = $this->empresa->get_all_empresas_clean_31();
			$params_view = array(
				'title' => 'Servicios',
				'view' => 'empleado/ficha_cliente',
				'view_data' => $data
			   );
			
            render_template($params_view);  
    }




    public function nuevo_reporte()

    {       $this->load->helper('template');
			$data['empresas'] = $this->cliente->trae_empresas();
			$params_view = array(
				'title' => 'Servicios',
				'view' => 'empleado/ficha_empresas',
				'view_data' => $data
			   );
			
            render_template($params_view);  
    }


    public function nuevo_reporte_sura()

    {       $this->load->helper('template');
			$data['empresas'] = $this->cliente->get_una_empresa(324);
			$params_view = array(
				'title' => 'Servicios',
				'view' => 'empleado/ficha_empresa',
				'view_data' => $data
			   );
			
            render_template($params_view);  
    }

	function reporte_empleado_sura()
    {
           $usuario = trim(strtoupper($this->input->post('usuario'))); 
           $puesto = trim(strtoupper($this->input->post('puesto'))); 
           $estatus = trim($this->input->post('estatus')); 
		   $cei = $this->input->post('cei'); 
           $empresa = $this->input->post('emp_id'); 
          

			$data['empleados'] = $this->empleado->get_all_report_empresa_by_portal($empresa,$estatus, $cei, $puesto, $usuario,'SURA');
            
            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php

                date_default_timezone_set('America/Mexico_City');
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_Usuarios_Inspeccion_Virtual_".$empresa."_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
                    <tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px"> <span class="auto-style8" style="text-align: right">Reporte de Plataforma Inspección Virtual</th>
                            

                            
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>

							<th class="auto-style5" style="width: 325px; height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px; height: 27px;"> <?php echo $date2today; ?></th>
						</tr>


						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>



						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        


						<tr>
							<th class="auto-style14" style="width: 82px">ID</th>
							<th class="auto-style14" style="width: 325px">NOMBRE</th>
							<th class="auto-style14" style="width: 82px">USUARIO</th>
                            <th class="auto-style14" style="width: 164px">CONTRASEÑA</th>
							<th class="auto-style14" style="width: 150px">PUESTO</th>
							<th class="auto-style14" style="width: 424px">EMPRESA</th>
							<th class="auto-style14" style="width: 164px">EMAIL</th>
							<th class="auto-style14" style="width: 164px">ESTATUS</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($data['empleados']): 
						$array_rol = get_cat_nombre_var('ROL'); 
							foreach ($data['empleados'] as $empleado): 

                    
                                                
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}

                                if ( $empleado['usr_estatus_cve'] === 'ACTIVO')
								{ $color='black';} else { $color='red';}
				
                                
                                
							?>

								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_id']; ?></td>
									<td class=<?php echo $class18; ?> style="width: 325px">
										<?php echo get_code_html($empleado['usr_nombre']); ?> 
										<?php echo get_code_html($empleado['usr_paterno']); ?> 
										<?php echo get_code_html($empleado['usr_materno']); ?>
									</td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_username']; ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_tous']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_puesto']; ?></td>

									<td class=<?php echo $class18; ?> style="width: 424px"><?php echo get_code_html(get_empresa($empleado['emp_id'])); ?></td>


                                    
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_correo']; ?></td>

									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_estatus_cve']; ?></td>

								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }



    function reporte_empleado_desactivados()
    {
           $usuario = trim(strtoupper($this->input->post('usuario'))); 
           $puesto = trim(strtoupper($this->input->post('puesto'))); 
           $estatus ='Desactivado' ;//trim($this->input->post('estatus')); 
		   $cei = $this->input->post('cei'); 
           $empresa = $this->input->post('emp_id'); 
          

           $data['empleados'] = $this->empleado->get_all_report_desactivado($empresa,$estatus, $cei, $puesto, $usuario); 
		   
           $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php

                date_default_timezone_set('America/Mexico_City');
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_Usuarios_".$empresa."_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
					.auto-style18a {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: left;
					}					
					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
                    <tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							
							<th class="auto-style5" style="width: 424px"> <span class="auto-style8" style="text-align: right">Reporte de Usuarios Desactivados 
							en Plataforma</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px; height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 80px">&nbsp;</th>							
							<th class="auto-style5" style="width: 424px; height: 27px;"> <?php echo $date2today; ?></th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>


						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>



						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        


						<tr>
							<th class="auto-style14" style="width: 82px">ID</th>
							<th class="auto-style14" style="width: 325px">NOMBRE</th>
							<th class="auto-style14" style="width: 82px">USUARIO</th>
							<th class="auto-style14" style="width: 150px">PUESTO</th>
							<th class="auto-style14" style="width: 424px">EMPRESA</th>
							<th class="auto-style14" style="width: 164px">CEI</th>
							<th class="auto-style14" style="width: 164px">EMAIL</th>
							<th class="auto-style14" style="width: 164px">ESTATUS</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($data['empleados']): 
						$array_rol = get_cat_nombre_var('ROL'); 
							foreach ($data['empleados'] as $empleado): 

                    
                                                
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}

                                if ( $empleado['usr_estatus_cve'] === 'ACTIVO')
								{ $color='black';} else { $color='red';}
				
                                
                                
							?>

								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_id']; ?></td>
									<td class=<?php echo $class18; ?>  align="left" style="width: 325px">
										<?php echo get_code_html($empleado['usr_paterno']); ?> 
										<?php echo get_code_html($empleado['usr_materno']); ?>
										<?php echo get_code_html($empleado['usr_nombre']); ?> 
									</td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_username']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_puesto']; ?></td>
									<td class=<?php echo $class18; ?> style="width: 424px"><?php echo get_code_html(get_empresa($empleado['emp_id'])); ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_cei($empleado['cei_id']); ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_correo']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_estatus_cve']; ?></td>
								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }


    function reporte_empleado_nom035()
    {
           $usuario = trim(strtoupper($this->input->post('usuario'))); 
           $puesto = trim(strtoupper($this->input->post('puesto'))); 
           $estatus ='Activo' ;//trim($this->input->post('estatus')); 
		   $cei = $this->input->post('cei'); 
           $empresa = $this->input->post('emp_id'); 
 
           $data['empleados'] = $this->empleado->get_all_report_nom035($empresa,$estatus, $cei, $puesto, $usuario); 

            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php

                date_default_timezone_set('America/Mexico_City');
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_Usuarios_".$empresa."_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
					.auto-style18a {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: left;
					}					
					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
                    <tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px"> <span class="auto-style8" style="text-align: right">Reporte de Usuarios NOM-035 en Plataforma</th>
                            

                            
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>

							<th class="auto-style5" style="width: 325px; height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px; height: 27px;"> <?php echo $date2today; ?></th>
						</tr>


						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>



						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        


						<tr>
							<th class="auto-style14" style="width: 82px">ID</th>
							<th class="auto-style14" style="width: 325px">NOMBRE</th>
							<th class="auto-style14" style="width: 82px">USUARIO</th>
                            <th class="auto-style14" style="width: 164px">CONTRASEÑA</th>
							<th class="auto-style14" style="width: 150px">PUESTO</th>
							<th class="auto-style14" style="width: 424px">EMPRESA</th>
							<th class="auto-style14" style="width: 164px">SUCURSAL</th>
							<th class="auto-style14" style="width: 164px">CEI</th>
							<th class="auto-style14" style="width: 164px">EMAIL</th>
							<th class="auto-style14" style="width: 164px">ESTATUS</th>
							<th class="auto-style14" style="width: 164px">SERVICIOS</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($data['empleados']): 
						$array_rol = get_cat_nombre_var('ROL'); 
							foreach ($data['empleados'] as $empleado): 

                    
                                                
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}

                                if ( $empleado['usr_estatus_cve'] === 'ACTIVO')
								{ $color='black';} else { $color='red';}
				
                                
                                
							?>

								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_id']; ?></td>
									<td class=<?php echo $class18; ?>  align="left" style="width: 325px">
										<?php echo get_code_html($empleado['usr_paterno']); ?> 
										<?php echo get_code_html($empleado['usr_materno']); ?>
										<?php echo get_code_html($empleado['usr_nombre']); ?> 
									</td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_username']; ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_tous']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_puesto']; ?></td>
									<td class=<?php echo $class18; ?> style="width: 424px"><?php echo get_code_html(get_empresa($empleado['emp_id'])); ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_una_sucursal($empleado['suc_id']); ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_cei($empleado['cei_id']); ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_correo']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_estatus_cve']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['servicios']; ?></td>
								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }


		

    function reporte_empleado_cliente()
    {
           $usuario = trim(strtoupper($this->input->post('usuario'))); 
           $puesto = trim(strtoupper($this->input->post('puesto'))); 
           $estatus ='Activo' ;//trim($this->input->post('estatus')); 
		   $cei = $this->input->post('cei'); 
           $empresa = $this->input->post('emp_id'); 
          

            if ($empresa == '')
            { $data['empleados'] = $this->empleado->get_all_report_cliente($empresa,$estatus, $cei, $puesto, $usuario); }
            else
            { $data['empleados'] = $this->empleado->get_all_report_hc($empresa,$estatus, $cei, $puesto, $usuario);}
            
            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php

                date_default_timezone_set('America/Mexico_City');
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_Usuarios_".$empresa."_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
					.auto-style18a {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: left;
					}					
					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
                    <tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px"> <span class="auto-style8" style="text-align: right">Reporte de Usuarios de Clientes 
							en Plataforma</th>
                            

                            
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>

							<th class="auto-style5" style="width: 325px; height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px; height: 27px;"> <?php echo $date2today; ?></th>
						</tr>


						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>



						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        


						<tr>
							<th class="auto-style14" style="width: 82px">ID</th>
							<th class="auto-style14" style="width: 325px">NOMBRE</th>
							<th class="auto-style14" style="width: 82px">USUARIO</th>
                            <th class="auto-style14" style="width: 164px">CONTRASEÑA</th>
							<th class="auto-style14" style="width: 150px">PUESTO</th>
							<th class="auto-style14" style="width: 424px">EMPRESA</th>
							<th class="auto-style14" style="width: 164px">SUCURSAL</th>
							<th class="auto-style14" style="width: 164px">CEI</th>
							<th class="auto-style14" style="width: 164px">EMAIL</th>
							<th class="auto-style14" style="width: 164px">ESTATUS</th>
							<th class="auto-style14" style="width: 164px">SERVICIOS</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($data['empleados']): 
						$array_rol = get_cat_nombre_var('ROL'); 
							foreach ($data['empleados'] as $empleado): 

                    
                                                
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}

                                if ( $empleado['usr_estatus_cve'] === 'ACTIVO')
								{ $color='black';} else { $color='red';}
				
                                
                                
							?>

								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_id']; ?></td>
									<td class=<?php echo $class18; ?>  align="left" style="width: 325px">
										<?php echo get_code_html($empleado['usr_paterno']); ?> 
										<?php echo get_code_html($empleado['usr_materno']); ?>
										<?php echo get_code_html($empleado['usr_nombre']); ?> 
									</td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_username']; ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_tous']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_puesto']; ?></td>
									<td class=<?php echo $class18; ?> style="width: 424px"><?php echo get_code_html(get_empresa($empleado['emp_id'])); ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_una_sucursal($empleado['suc_id']); ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_cei($empleado['cei_id']); ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_correo']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_estatus_cve']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['servicios']; ?></td>
								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }



    function reporte_empleado_hc()
    {
           $usuario = trim(strtoupper($this->input->post('usuario'))); 
           $puesto = trim(strtoupper($this->input->post('puesto'))); 
           $estatus ='Activo' ;//trim($this->input->post('estatus')); 
		   $cei = $this->input->post('cei'); 
           $empresa = $this->input->post('emp_id'); 
          

            if ($empresa == '')
            { $data['empleados'] = $this->empleado->get_all_report(); }
            else
            { $data['empleados'] = $this->empleado->get_all_report_hc($empresa,$estatus, $cei, $puesto, $usuario);}
            
            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php

                date_default_timezone_set('America/Mexico_City');
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_Usuarios_".$empresa."_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
					.auto-style18a {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: left;
					}					
					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
                    <tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px"> <span class="auto-style8" style="text-align: right">Reporte de Empleados Humancenter 
							en Plataforma</th>
                            

                            
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>

							<th class="auto-style5" style="width: 325px; height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px; height: 27px;"> <?php echo $date2today; ?></th>
						</tr>


						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>



						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        


						<tr>
							<th class="auto-style14" style="width: 82px">ID</th>
							<th class="auto-style14" style="width: 325px">NOMBRE</th>
							<th class="auto-style14" style="width: 82px">USUARIO</th>
                            <th class="auto-style14" style="width: 164px">CONTRASEÑA</th>
							<th class="auto-style14" style="width: 150px">PUESTO</th>
							<th class="auto-style14" style="width: 80px">CÉDULA PROFESIONAL</th>
							<th class="auto-style14" style="width: 424px">EMPRESA</th>
							<th class="auto-style14" style="width: 164px">SUCURSAL</th>
							<th class="auto-style14" style="width: 164px">CEI</th>
							<th class="auto-style14" style="width: 164px">EMAIL</th>
							<th class="auto-style14" style="width: 164px">ESTATUS</th>
							<th class="auto-style14" style="width: 164px">SERVICIOS</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($data['empleados']): 
						$array_rol = get_cat_nombre_var('ROL'); 
							foreach ($data['empleados'] as $empleado): 

                    
                                                
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}

                                if ( $empleado['usr_estatus_cve'] === 'ACTIVO')
								{ $color='black';} else { $color='red';}
				
                                
                                
							?>

								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_id']; ?></td>
									<td class=<?php echo $class18; ?>  align="left" style="width: 325px">
										
										<?php echo get_code_html($empleado['usr_paterno']); ?> 
										<?php echo get_code_html($empleado['usr_materno']); ?>
										<?php echo get_code_html($empleado['usr_nombre']); ?> 
									</td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_username']; ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_tous']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_puesto']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_cedula']; ?></td>

									<td class=<?php echo $class18; ?> style="width: 424px"><?php echo get_code_html(get_empresa($empleado['emp_id'])); ?></td>


									<td class=<?php echo $class18; ?>><?php echo get_una_sucursal($empleado['suc_id']); ?></td>
                                    
									<td class=<?php echo $class18; ?>><?php echo get_cei($empleado['cei_id']); ?></td>
                            

                                    
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_correo']; ?></td>

									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_estatus_cve']; ?></td>

									<td class=<?php echo $class18; ?>><?php echo $empleado['servicios']; ?></td>

								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }



	
     function reporte_empleado()
    {
           $usuario = trim(strtoupper($this->input->post('usuario'))); 
           $puesto = trim(strtoupper($this->input->post('puesto'))); 
           $estatus = trim($this->input->post('estatus')); 
		   $cei = $this->input->post('cei'); 
           $empresa = $this->input->post('emp_id'); 
          

            if ($empresa == '')
            { $data['empleados'] = $this->empleado->get_all_report(); }
            else
            { $data['empleados'] = $this->empleado->get_all_report_empresa($empresa,$estatus, $cei, $puesto, $usuario);}
            
            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php

                date_default_timezone_set('America/Mexico_City');
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_Usuarios_".$empresa."_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
                    <tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px"> <span class="auto-style8" style="text-align: right">Reporte de Empleados 
							en Plataforma</th>
                            

                            
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>

							<th class="auto-style5" style="width: 325px; height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px; height: 27px;"> <?php echo $date2today; ?></th>
						</tr>


						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>



						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        


						<tr>
							<th class="auto-style14" style="width: 82px">ID</th>
							<th class="auto-style14" style="width: 325px">NOMBRE</th>
							<th class="auto-style14" style="width: 82px">ROL</th>
							<th class="auto-style14" style="width: 82px">USUARIO</th>
                            <th class="auto-style14" style="width: 164px">CONTRASEÑA</th>
							<th class="auto-style14" style="width: 150px">PUESTO</th>
							<th class="auto-style14" style="width: 80px">CÉDULA PROFESIONAL</th>
							<th class="auto-style14" style="width: 424px">EMPRESA</th>
							<th class="auto-style14" style="width: 164px">SUCURSAL</th>
							<th class="auto-style14" style="width: 164px">CEI</th>
							<th class="auto-style14" style="width: 164px">EMAIL</th>
							<th class="auto-style14" style="width: 164px">ESTATUS</th>
							<th class="auto-style14" style="width: 164px">SERVICIOS</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($data['empleados']): 
						$array_rol = get_cat_nombre_var('ROL'); 
							foreach ($data['empleados'] as $empleado): 

                    
                                                
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}

                                if ( $empleado['usr_estatus_cve'] === 'ACTIVO')
								{ $color='black';} else { $color='red';}
				
                                
                                
							?>

								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_id']; ?></td>
									<td class=<?php echo $class18; ?> style="width: 325px">
										<?php echo get_code_html($empleado['usr_nombre']); ?> 
										<?php echo get_code_html($empleado['usr_paterno']); ?> 
										<?php echo get_code_html($empleado['usr_materno']); ?>
									</td>
									<td class=<?php echo $class18; ?>><?php echo get_cat_nombre_cache($array_rol, $empleado['perfil_id']); ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_username']; ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_tous']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_puesto']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_cedula']; ?></td>

									<td class=<?php echo $class18; ?> style="width: 424px"><?php echo get_code_html(get_empresa($empleado['emp_id'])); ?></td>


									<td class=<?php echo $class18; ?>><?php echo get_una_sucursal($empleado['suc_id']); ?></td>
                                    
									<td class=<?php echo $class18; ?>><?php echo get_cei($empleado['cei_id']); ?></td>
                            

                                    
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_correo']; ?></td>

									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_estatus_cve']; ?></td>

									<td class=<?php echo $class18; ?>><?php echo $empleado['servicios']; ?></td>

								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }
		
	
    }
