<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Acreditacion extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Acreditacion_model','acreditacion');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
		$this->load->helper('util'); 
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('servicio','Orden de servicio','required');
            $this->form_validation->set_rules('toxi','Toxicológico','alpha_numeric');
            $this->form_validation->set_rules('med','Médico-Físico','alpha_numeric');
            $this->form_validation->set_rules('psi','Psicológico','alpha_numeric');
            $this->form_validation->set_rules('pol','Poligráfico','alpha_numeric');
            $this->form_validation->set_rules('soc','Entorno Social','alpha_numeric');
            $this->form_validation->set_rules('odo','Odontológico','alpha_numeric');
 			//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}  
            
            if($this->form_validation->run())
            {

				//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}				
				
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $medico['usr_id'];
               // $data_insert['serv_id']  = $this->input->post('servicio');
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
                $data_insert['fsm_aclaracion']     =   $this->input->post('aclaraciones');
                $data_insert['fsm_toxi']    =	$this->input->post('toxi');
                $data_insert['fsm_med']     =	$this->input->post('med');
                $data_insert['fsm_psi']     =	$this->input->post('psi');
                $data_insert['fsm_pol']     =	$this->input->post('pol');
				$data_insert['fsm_socioeconomico']     =	$this->input->post('socioeconomico');
                $data_insert['fsm_ondon']   =	$this->input->post('odo');
                $data_insert['fsm_entsoc']  =$this->input->post('soc');
                
                if($this->acreditacion->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/acreditacion/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function nuevo_serviseg($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('servicio','Orden de servicio','required');
            $this->form_validation->set_rules('toxi','Toxicológico','alpha_numeric');
            $this->form_validation->set_rules('med','Médico-Físico','alpha_numeric');
            $this->form_validation->set_rules('psi','Psicológico','alpha_numeric');
            $this->form_validation->set_rules('pol','Poligráfico','alpha_numeric');
            $this->form_validation->set_rules('soc','Entorno Social','alpha_numeric');
            $this->form_validation->set_rules('odo','Odontológico','alpha_numeric');
            //$this->form_validation->set_rules('aclaraciones','Aclaraciones','alpha_numeric');  
 			//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			} 

 
            if($this->form_validation->run())
            {				
				//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}					
				
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $medico['usr_id'];
                //$data_insert['serv_id']  = $this->input->post('servicio');
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
                $data_insert['fsm_aclaracion']     =   $this->input->post('aclaraciones');
                $data_insert['fsm_toxi']    =	$this->input->post('toxi');
                $data_insert['fsm_med']     =	$this->input->post('med');
                $data_insert['fsm_psi']     =	$this->input->post('psi');
                $data_insert['fsm_pol']     =	$this->input->post('pol');
                $data_insert['fsm_ondon']   =	$this->input->post('odo');
                $data_insert['fsm_entsoc']  =$this->input->post('soc');
                
                if($this->acreditacion->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/acreditacion/nuevo_form_serviseg',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }	
	
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['medico'] = $this->session->user;
        $data['fsm'] = $this->acreditacion->get($fsm_id,get_desp_id_usr());
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		
		$evaluado= $data['persona']['clte_nombre'].' ';		
		if ( strlen($data['persona']['clte_2_nombre']) > 0)
		{
			$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
		}				
		$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
		$evaluado= $evaluado.$data['persona']['clte_materno'].' ';
       // 		 genera_pdf
       genera_pdf_new_reporte_poli($this->load->view('examen/acreditacion/pdf',$data,TRUE),'acreditacion','acreditacion',$evaluado);
    }
	
    public function pdf_serviseg($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['medico'] = $this->session->user;
        $data['fsm'] = $this->acreditacion->get($fsm_id,get_desp_id_usr());
		$fsm=$this->acreditacion->get_in($fsm_id);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
		
		$evaluado= $data['persona']['clte_nombre'].' ';		
		if ( strlen($data['persona']['clte_2_nombre']) > 0)
		{
			$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
		}				
		$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
		$evaluado= $evaluado.$data['persona']['clte_materno'].' ';
		
		
			$fsm_f = strtotime($fsm['fsm_f']);

			if ($fsm_f >= strtotime('2023-02-21 00:00:00') )
			{
				$data_expediente= '  Expediente: '. 'N-004-23';
			}
			elseif ($fsm_f >= strtotime('2022-02-11 00:00:00') && ($fsm_f <= strtotime('2023-02-20 23:59:59')) )
			{
				$data_expediente= '  Expediente: '. '009-22';
			}
			elseif (($fsm_f >= strtotime('2021-02-15 00:00:00') ) && ($fsm_f <= strtotime('2022-02-10 23:59:59')) )
			{				
				$data_expediente= '  Expediente: '. '007-21';
			}
			elseif (($fsm_f >= strtotime('2020-02-14 00:00:00')) && ($fsm_f <= strtotime('2021-02-14 23:59:59')))
			{				
				$data_expediente= '  Expediente: '. '008-20';
			}
			elseif (($fsm_f >= strtotime('2019-02-13 00:00:00')) && ($fsm_f >= strtotime('2020-02-13 23:59:59')))
			{
				$data_expediente= '  Expediente: '. '009-19';
			}	
			elseif (($fsm_f <= strtotime('2019-02-12 23:59:59')))
			{
				$data_expediente= '  Expediente: '. '005-18';
			}
		
		
		
		//$data_expediente= '  Expediente: '.get_SSPCDMX($fsm['fsm_f']).$fsm['fsm_f'];
        $this->load->helper('pdf');
        //genera_pdf($this->load->view('examen/acreditacion/pdf_serviseg',$data,TRUE),'acreditacion','acreditacion','acreditacion');
		genera_pdf_new_reporte_poli($this->load->view('examen/acreditacion/pdf_serviseg',$data,TRUE),'acreditacion','acreditacion',$evaluado,'Humancenter Review S.A de C.V.','P',$data_expediente);
		//genera_pdf_new_reporte_poli($this->load->view('examen/acreditacion/graph',$data,TRUE),'acreditacion','acreditacion',$evaluado);
   }	
}