﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Essoec extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('examen/FSM_ODON/Essoec_model','gsi');
		$this->load->model('examen/Historia_clinica_model','historia_clinica');
		$this->load->helper('util');
    }
 
    public function borra_odo($fsm_id)
    {
        if ($this->historia_clinica->delete_odo($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	
 
    public function nuevo($cliente_id)
    { 
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/ 
			            
            
            if($this->form_validation->run())
            {

                
 				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['usr_id'] = $medico['usr_id'];
				$data_insert['emp_id'] = $empresa['emp_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				$data_insert['fodon_f'] = $this->input->post('odon_fecha_eva');
				$data_insert['fodon_fechaeva'] = $this->input->post('odon_fecha_eva'); 

				$data_insert['fodon_varicela_ques']  = $this->input->post('odon_varicela_ques');
				$data_insert['fodon_varicela_edad']  = $this->input->post('odon_varicela_edad');
				$data_insert['fodon_etsexual_ques']  = $this->input->post('odon_etsexual_ques');
				$data_insert['fodon_etsexual_edad']  = $this->input->post('odon_etsexual_edad');
				$data_insert['fodon_rubeola_ques']  = $this->input->post('odon_rubeola_ques');
				$data_insert['fodon_rubeola_edad']  = $this->input->post('odon_rubeola_edad');
				$data_insert['fodon_epilepsia_ques']  = $this->input->post('odon_epilepsia_ques');
				$data_insert['fodon_epilepcia_edad']  = $this->input->post('odon_epilepcia_edad');
				$data_insert['fodon_sarampion_ques']  = $this->input->post('odon_sarampion_ques');
				$data_insert['fodon_sarampion_edad']  = $this->input->post('odon_sarampion_edad');
				$data_insert['fodon_amigdalitis_ques']  = $this->input->post('odon_amigdalitis_ques');
				$data_insert['fodon_amigdalitis_edad']  = $this->input->post('odon_amigdalitis_edad');
				$data_insert['fodon_paperas_ques']  = $this->input->post('odon_paperas_ques');
				$data_insert['fodon_paperas_edad']  = $this->input->post('odon_paperas_edad');
				$data_insert['fodon_tuberculosis_ques']  = $this->input->post('odon_tuberculosis_ques');
				$data_insert['fodon_tuberculosis_edad']  = $this->input->post('odon_tuberculosis_edad');
				$data_insert['fodon_tosferina_ques']  = $this->input->post('odon_tosferina_ques');
				$data_insert['fodon_tosferina_edad']  = $this->input->post('odon_tosferina_edad');
				$data_insert['fodon_freumatica_ques']  = $this->input->post('odon_freumatica_ques');
				$data_insert['fodon_freumatica_edad']  = $this->input->post('odon_freumatica_edad');
				$data_insert['fodon_escarlatina_ques']  = $this->input->post('odon_escarlatina_ques');
				$data_insert['fodon_escarlatina_edad']  = $this->input->post('odon_escarlatina_edad');
				$data_insert['fodon_diabetes_ques']  = $this->input->post('odon_diabetes_ques');
				$data_insert['fodon_diabetes_edad']  = $this->input->post('odon_diabetes_edad');
				$data_insert['fodon_hepatitis_ques']  = $this->input->post('odon_hepatitis_ques');
				$data_insert['fodon_hepatitis_edad']  = $this->input->post('odon_hepatitis_edad');
				$data_insert['fodon_cardiovascular_ques']  = $this->input->post('odon_cardiovascular_ques');
				$data_insert['fodon_cardiovascular_edad']  = $this->input->post('odon_cardiovascular_edad');
				$data_insert['fodon_vih_ques']  = $this->input->post('odon_vih_ques');
				$data_insert['fodon_vih_edad']  = $this->input->post('odon_vih_edad');
				$data_insert['fodon_artritis_ques']  = $this->input->post('odon_artritis_ques');
				$data_insert['fodon_artritis_edad']  = $this->input->post('odon_artritis_edad');
				$data_insert['fodon_asma_ques']  = $this->input->post('odon_asma_ques');
				$data_insert['fodon_asma_edad']  = $this->input->post('odon_asma_edad');
				$data_insert['fodon_traumatismos_ques']  = $this->input->post('odon_traumatismos_ques');
				$data_insert['fodon_traumatismos_edad']  = $this->input->post('odon_traumatismos_edad');
				$data_insert['fodon_disfuncion_ques']  = $this->input->post('odon_disfuncion_ques');
				$data_insert['fodon_disfuncion_edad']  = $this->input->post('odon_disfuncion_edad');
				$data_insert['fodon_intervensiones_ques']  = $this->input->post('odon_intervensiones_ques');
				$data_insert['fodon_intervensiones_edad']  = $this->input->post('odon_intervensiones_edad');
				$data_insert['fodon_hipertension_ques']  = $this->input->post('odon_hipertension_ques');
				$data_insert['fodon_hipertension_edad']  = $this->input->post('odon_hipertension_edad');
				$data_insert['fodon_transfusion_ques']  = $this->input->post('odon_transfusion_ques');
				$data_insert['fodon_transfusion_edad']  = $this->input->post('odon_transfusion_edad');
				$data_insert['fodon_cancer_ques']  = $this->input->post('odon_cancer_ques');
				$data_insert['fodon_cancer_edad']  = $this->input->post('odon_cancer_edad');
				$data_insert['fodon_autoinmune_ques']  = $this->input->post('odon_autoinmune_ques');
				$data_insert['fodon_autoinmune_edad']  = $this->input->post('odon_autoinmune_edad');
				$data_insert['fodon_otra_ques']  = $this->input->post('odon_otra_ques');
				$data_insert['fodon_especifique_otra']  = $this->input->post('odon_especifique_otra');
				$data_insert['fodon_enfermedad_actual_ques']  = $this->input->post('odon_enfermedad_actual_ques');
				$data_insert['fodon_enfermedad_actual_detalle']  = $this->input->post('odon_enfermedad_actual_detalle');
				$data_insert['fodon_medicamento_ques']  = $this->input->post('odon_medicamento_ques');
				$data_insert['fodon_medicamento_detalle']  = $this->input->post('odon_medicamento_detalle');
				$data_insert['fodon_alergias_ques']  = $this->input->post('odon_alergias_ques');
				$data_insert['fodon_alergias_detalle']  = $this->input->post('odon_alergias_detalle');
				$data_insert['fodon_otra_alergias_ques']  = $this->input->post('odon_otra_alergias_ques');
				$data_insert['fodon_otra_alergias_detalle']  = $this->input->post('odon_otra_alergias_detalle');
				
				$data_insert['fodon_lava_dientes_ques']  = $this->input->post('odon_lava_dientes_ques');
				
				if ($this->input->post('odon_cuando_lava_ques'))
				{	
					$data_insert['fodon_cuando_lava_ques']  = implode(',', $this->input->post('odon_cuando_lava_ques'));
				}
				
				$data_insert['fodon_cambia_cepillo_ques']  = $this->input->post('odon_cambia_cepillo_ques');
				
				if ($this->input->post('odon_auxiliar_lavado_ques'))
				{	
					$data_insert['fodon_auxiliar_lavado_ques']  = implode(',',$this->input->post('odon_auxiliar_lavado_ques'));
				}
				
				$data_insert['fodon_visita_fodon_ques']  = $this->input->post('odon_visita_odon_ques');
				$data_insert['fodon_ultima_visita_fodon_detalle']  = $this->input->post('odon_ultima_visita_odon_detalle');
				
				$data_insert['fodon_fuma_ques']  = $this->input->post('odon_fuma_ques');
				$data_insert['fodon_fuma_detalle']  = $this->input->post('odon_fuma_detalle');
				$data_insert['fodon_alcohol_ques']  = $this->input->post('odon_alcohol_ques');
				$data_insert['fodon_alcohol_detalle']  = $this->input->post('odon_alcohol_detalle');
				$data_insert['fodon_perfil_ques']  = $this->input->post('odon_perfil_ques');
				$data_insert['fodon_cara_ques']  = $this->input->post('odon_cara_ques');
				$data_insert['fodon_senas_otra']  = $this->input->post('odon_senas_otra');
				$data_insert['fodon_ganglios_ques']  = $this->input->post('odon_ganglios_ques');
				$data_insert['fodon_ganglios_obs']  = $this->input->post('odon_ganglios_obs');
				
				if  ($this->input->post('odon_chasquido_ques'))
				{	
				$data_insert['fodon_chasquido_ques']  = implode(',',$this->input->post('odon_chasquido_ques'));
				}
				
				if ($this->input->post('odon_crepitacion_ques'))
				{
					$data_insert['fodon_crepitacion_ques']  = implode(',',$this->input->post('odon_crepitacion_ques'));
				}	
				
				if ($this->input->post('odon_dmandibular_ques'))
				{$data_insert['fodon_dmandibular_ques']  = implode(',',$this->input->post('odon_dmandibular_ques'));
				}	

				if ($this->input->post('odon_condilar_ques'))
				{$data_insert['fodon_condilar_ques']  = implode(',',$this->input->post('odon_condilar_ques'));
				}	
				
				
				$data_insert['fodon_masticacion_ques']  = $this->input->post('odon_masticacion_ques');
				$data_insert['fodon_mov_izquierdo_ques']  = $this->input->post('odon_mov_izquierdo_ques');
				$data_insert['fodon_mov_derecho_ques']  = $this->input->post('odon_mov_derecho_ques');
				$data_insert['fodon_apertura']  = $this->input->post('odon_apertura');
				$data_insert['fodon_trimus_ques']  = $this->input->post('odon_trimus_ques');
				$data_insert['fodon_alt_musculares_ques']  = $this->input->post('odon_alt_musculares_ques');
			
			
				if ($this->input->post('odon_labios_ques'))
				{$data_insert['fodon_labios_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_labios_ques')));
				}
				if ($this->input->post('odon_myugal_ques'))
				{$data_insert['fodon_myugal_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_myugal_ques')));
				}
				if ($this->input->post('odon_mbucal_ques'))
				{$data_insert['fodon_mbucal_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_mbucal_ques')));
				}
				if ($this->input->post('odon_frenillos_ques'))
				{$data_insert['fodon_frenillos_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_frenillos_ques')));
				}
							
				if ($this->input->post('odon_encia_ques'))
				{$data_insert['fodon_encia_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_encia_ques')));
				}
				if ($this->input->post('odon_paladar_db_ques'))
				{$data_insert['fodon_paladar_db_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_paladar_db_ques')));
				}	
				if ($this->input->post('odon_fauces_ques'))
				{$data_insert['fodon_fauces_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_fauces_ques')));
				}	
				if ($this->input->post('odon_uvula_que'))
				{$data_insert['fodon_uvula_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_uvula_ques')));
				}	
				if ($this->input->post('odon_amigdalas2_ques'))
				{$data_insert['fodon_amigdalas2_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_amigdalas2_ques')));
				}	
				if ($this->input->post('odon_lengua_ques'))
				{$data_insert['fodon_lengua_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_lengua_ques')));
				}				
				if ($this->input->post('odon_piso_boca_ques'))
				{$data_insert['fodon_piso_boca_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_piso_boca_ques')));
				}				
				if ($this->input->post('odon_parotidas_ques'))
				{$data_insert['fodon_parotidas_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_parotidas_ques')));
				}

				if ($this->input->post('odon_submandibular_ques'))
				{$data_insert['fodon_submandibular_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_submandibular_ques')));
				}	
				if ($this->input->post('odon_sublingual_ques'))
				{$data_insert['fodon_sublingual_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_sublingual_ques')));
				}		


				
				$data_insert['fodon_tejidos_periodentales_ques']  = $this->input->post('odon_tejidos_periodentales_ques');
				



				
				$data_insert['fodon_orofaringe_ques']  = $this->input->post('odon_orofaringe_ques'); //implode(',',$this->input->post('odon_orofaringe_ques'));
						
				
				$data_insert['fodon_hidratacion_ques']  = $this->input->post('odon_hidratacion_ques');
				$data_insert['fodon_halitosis_ques']  = $this->input->post('odon_halitosis_ques');
				$data_insert['fodon_eperiodontal_ques']  = $this->input->post('odon_eperiodontal_ques');
				$data_insert['fodon_eperiodontal_donde_ques']  = $this->input->post('odon_eperiodontal_donde_ques');
				$data_insert['fodon_intrabucal_obs']  = $this->input->post('odon_intrabucal_obs');
				$data_insert['fodon_color_alteracion']  = $this->input->post('odon_color_alteracion');
				$data_insert['fodon_color_localizacon']  = $this->input->post('odon_color_localizacon');
				$data_insert['fodon_forma_alteracion']  = $this->input->post('odon_forma_alteracion');
				$data_insert['fodon_forma_localizacon']  = $this->input->post('odon_forma_localizacon');
				$data_insert['fodon_numero_alteracion']  = $this->input->post('odon_numero_alteracion');
				$data_insert['fodon_numero_localizacon']  = $this->input->post('odon_numero_localizacon');
				$data_insert['fodon_estructura_alteracion']  = $this->input->post('odon_estructura_alteracion');
				$data_insert['fodon_estructura_localizacon']  = $this->input->post('odon_estructura_localizacon');
				$data_insert['fodon_erupcion_alteracion']  = $this->input->post('odon_erupcion_alteracion');
				$data_insert['fodon_erupcion_localizacon']  = $this->input->post('odon_erupcion_localizacon');
				$data_insert['fodon_posicion_alteracion']  = $this->input->post('odon_posicion_alteracion');
				$data_insert['fodon_posicion_localizacon']  = $this->input->post('odon_posicion_localizacon');
				$data_insert['fodon_otros_alteracion']  = $this->input->post('odon_otros_alteracion');
				$data_insert['fodon_otros_localizacon']  = $this->input->post('odon_otros_localizacon');
				$data_insert['fodon_maloclucion_ques']  = $this->input->post('odon_maloclucion_ques');
				$data_insert['fodon_maxilares_ques']  = $this->input->post('odon_maxilares_ques');
				$data_insert['fodon_i_molar_derecho']  = $this->input->post('odon_i_molar_derecho');
				$data_insert['fodon_i_molar_izquierdo']  = $this->input->post('odon_i_molar_izquierdo');
				$data_insert['fodon_1_canino_derecho']  = $this->input->post('odon_1_canino_derecho');
				$data_insert['fodon_1_canino_izquierdo']  = $this->input->post('odon_1_canino_izquierdo');
				$data_insert['fodon_ii_molar_derecho']  = $this->input->post('odon_ii_molar_derecho');
				$data_insert['fodon_ii_molar_izquierdo']  = $this->input->post('odon_ii_molar_izquierdo');
				$data_insert['fodon_2_canino_derecho']  = $this->input->post('odon_2_canino_derecho');
				$data_insert['fodon_2_canino_izquierdo']  = $this->input->post('odon_2_canino_izquierdo');
				$data_insert['fodon_iii_molar_derecho']  = $this->input->post('odon_iii_molar_derecho');
				$data_insert['fodon_iii_molar_izquierdo']  = $this->input->post('odon_iii_molar_izquierdo');
				$data_insert['fodon_3_canino_derecho']  = $this->input->post('odon_3_canino_derecho');
				$data_insert['fodon_3_canino_izquierdo']  = $this->input->post('odon_3_canino_izquierdo');
				$data_insert['fodon_oclusión_cruzada_posterior']  = $this->input->post('odon_oclusión_cruzada_posterior');
				$data_insert['fodon_oclusión_cruzada_anterior']  = $this->input->post('odon_oclusión_cruzada_anterior');
				$data_insert['fodon_sobremordida_vertical']  = $this->input->post('odon_sobremordida_vertical');
				$data_insert['fodon_sobremordida_horizonta']  = $this->input->post('odon_sobremordida_horizonta');
				$data_insert['fodon_mordida_abierta']  = $this->input->post('odon_mordida_abierta');
				$data_insert['fodon_mordida_borde_a_borde']  = $this->input->post('odon_mordida_borde_a_borde');
				$data_insert['fodon_linea_media_superior']  = $this->input->post('odon_linea_media_superior');
				$data_insert['fodon_linea_media_inferior']  = $this->input->post('odon_linea_media_inferior');
				$data_insert['fodon_diastemas']  = $this->input->post('odon_diastemas');
				$data_insert['fodon_facetas_de_desgaste']  = $this->input->post('odon_facetas_de_desgaste');
				$data_insert['fodon_habitos_orales']  = $this->input->post('odon_habitos_orales');
				$data_insert['fodon_bruxismo_briscomania']  = $this->input->post('odon_bruxismo_briscomania');
				$data_insert['fodon_onicofagia']  = $this->input->post('odon_onicofagia');
				$data_insert['fodon_succion_digital_labial']  = $this->input->post('odon_succion_digital_labial');
				$data_insert['fodon_otro_intrabucal']  = $this->input->post('odon_otro_intrabucal');
				$data_insert['fodon_dentaria_obs']  = $this->input->post('odon_dentaria_obs');
				
				$data_insert['fodon_auxiliar_lavado_ques_detalle']  = $this->input->post('odon_auxiliar_lavado_ques_detalle');
				$data_insert['fodon_atm_obs']  = $this->input->post('odon_atm_obs'); 


				if ($this->input->post('odon_i_molar'))
				{$data_insert['fodon_i_molar']  = implode(',',$this->input->post('odon_i_molar'));
				}
				if ($this->input->post('odon_1_canino'))
				{$data_insert['fodon_1_canino']  = implode(',',$this->input->post('odon_1_canino'));	
				}
				if ($this->input->post('odon_ii_molar'))
				{$data_insert['fodon_ii_molar']  = implode(',',$this->input->post('odon_ii_molar'));
				}
				if ($this->input->post('odon_2_canino'))
				{$data_insert['fodon_2_canino']  = implode(',',$this->input->post('odon_2_canino'));
				}
				if ($this->input->post('odon_iii_molar'))
				{$data_insert['fodon_iii_molar']  = implode(',',$this->input->post('odon_iii_molar'));
				}
				if ($this->input->post('odon_3_canino'))
				{$data_insert['fodon_3_canino']  = implode(',',$this->input->post('odon_3_canino'));
				}				

				$data_insert['fodon_cpod_cariado']  = $this->input->post('odon_cpod_cariado');				
				$data_insert['fodon_cpod_obturado']  = $this->input->post('odon_cpod_obturado');				
				$data_insert['fodon_cpod_perdido']  = $this->input->post('odon_cpod_perdido');				
				$data_insert['fodon_cpod_exp_caries']  = $this->input->post('odon_cpod_exp_caries');				
				$data_insert['fodon_cpod_obs']  = $this->input->post('odon_cpod_obs');

				$data_insert['fodon_dientes_medicion']  = $this->input->post('odon_dientes_medicion'); 
				$data_insert['fodon_dientes_posteriores']  = $this->input->post('odon_dientes_posteriores'); 
				$data_insert['fodon_dientes_anteriores']  = $this->input->post('odon_dientes_anteriores'); 
				$data_insert['fodon_superficies_posteriores']  = $this->input->post('odon_superficies_posteriores'); 
				$data_insert['fodon_superficies_anteriores']  = $this->input->post('odon_superficies_anteriores');
				$data_insert['fodon_superficies_pdb']  = $this->input->post('odon_superficies_pdb'); 
				$data_insert['fodon_porcentaje_pdb']  = $this->input->post('odon_porcentaje_pdb'); 
				$data_insert['fodon_dientes_interpretacion']  = $this->input->post('odon_dientes_interpretacion'); 
				$data_insert['fodon_dientes_observaciones']  = $this->input->post('odon_dientes_observaciones'); 
              
				$data_insert['fodon_higiene_oral_ques']  = $this->input->post('odon_higiene_oral_ques');
				
                
				$data_insert = array_to_upper($data_insert);
                $data_insert['fodon_ipd']=  'ODO_IPD.jpg' ;
				$data_insert['fodon_croquis']='ODO_ODONTOGRAMA.jpg' ;                 
                $this->db->trans_start();
				
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				$fsm_id = $this->historia_clinica->add_odon($data_insert);
				
                if($fsm_id)
                {
                   
                    send_json_ok(array('id' => $cliente_id, 'msg' => 'Se guardó de forma correcta'));
 					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='ODO;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/	               
				}
                else
                {
                    send_json_error('Ocurrió un error al salvar la información.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
        
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/				
            $this->load->helper('template');
			
	            $params_view = array(
                'title' => '',
                'view' => 'examen/FSM_ODON/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function edita($cliente_id, $fsm_id)
    {
        $this->load->model('empleado/Empleado_model','empleado');
        $persona = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->gsi->get($fsm_id);
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            //$this->form_validation->set_rules('servicio','Orden de servicio','required');
            
            if(true)
            {
                /*$data_update['clte_id'] = $persona['clte_id'];
                $data_update['usr_id'] = $medico['usr_id'];
                $data_update['emp_id'] = $empresa['emp_id'];
                $data_update['serv_id']  = $this->input->post('servicio');
                $data_update['esc_f'] = date('Y-m-d H:i:s',time()-21600);
				$data_update['fodon_f'] = formatea_fecha_mysql($this->input->post('odon_fecha_eva'));
				$data_update['fodon_fechaeva'] = formatea_fecha_mysql($this->input->post('odon_fecha_eva')); */
				
				$data_update['fodon_f'] = $this->input->post('odon_fecha_eva');
				$data_update['fodon_fechaeva'] = $this->input->post('odon_fecha_eva'); 
				
				$data_update['fodon_varicela_ques']  = $this->input->post('odon_varicela_ques');
				$data_update['fodon_varicela_edad']  = $this->input->post('odon_varicela_edad');
				$data_update['fodon_etsexual_ques']  = $this->input->post('odon_etsexual_ques');
				$data_update['fodon_etsexual_edad']  = $this->input->post('odon_etsexual_edad');
				$data_update['fodon_rubeola_ques']  = $this->input->post('odon_rubeola_ques');
				$data_update['fodon_rubeola_edad']  = $this->input->post('odon_rubeola_edad');
				$data_update['fodon_epilepsia_ques']  = $this->input->post('odon_epilepsia_ques');
				$data_update['fodon_epilepcia_edad']  = $this->input->post('odon_epilepcia_edad');
				$data_update['fodon_sarampion_ques']  = $this->input->post('odon_sarampion_ques');
				$data_update['fodon_sarampion_edad']  = $this->input->post('odon_sarampion_edad');
				$data_update['fodon_amigdalitis_ques']  = $this->input->post('odon_amigdalitis_ques');
				$data_update['fodon_amigdalitis_edad']  = $this->input->post('odon_amigdalitis_edad');
				$data_update['fodon_paperas_ques']  = $this->input->post('odon_paperas_ques');
				$data_update['fodon_paperas_edad']  = $this->input->post('odon_paperas_edad');
				$data_update['fodon_tuberculosis_ques']  = $this->input->post('odon_tuberculosis_ques');
				$data_update['fodon_tuberculosis_edad']  = $this->input->post('odon_tuberculosis_edad');
				$data_update['fodon_tosferina_ques']  = $this->input->post('odon_tosferina_ques');
				$data_update['fodon_tosferina_edad']  = $this->input->post('odon_tosferina_edad');
				$data_update['fodon_freumatica_ques']  = $this->input->post('odon_freumatica_ques');
				$data_update['fodon_freumatica_edad']  = $this->input->post('odon_freumatica_edad');
				$data_update['fodon_escarlatina_ques']  = $this->input->post('odon_escarlatina_ques');
				$data_update['fodon_escarlatina_edad']  = $this->input->post('odon_escarlatina_edad');
				$data_update['fodon_diabetes_ques']  = $this->input->post('odon_diabetes_ques');
				$data_update['fodon_diabetes_edad']  = $this->input->post('odon_diabetes_edad');
				$data_update['fodon_hepatitis_ques']  = $this->input->post('odon_hepatitis_ques');
				$data_update['fodon_hepatitis_edad']  = $this->input->post('odon_hepatitis_edad');
				$data_update['fodon_cardiovascular_ques']  = $this->input->post('odon_cardiovascular_ques');
				$data_update['fodon_cardiovascular_edad']  = $this->input->post('odon_cardiovascular_edad');
				$data_update['fodon_vih_ques']  = $this->input->post('odon_vih_ques');
				$data_update['fodon_vih_edad']  = $this->input->post('odon_vih_edad');
				$data_update['fodon_artritis_ques']  = $this->input->post('odon_artritis_ques');
				$data_update['fodon_artritis_edad']  = $this->input->post('odon_artritis_edad');
				$data_update['fodon_asma_ques']  = $this->input->post('odon_asma_ques');
				$data_update['fodon_asma_edad']  = $this->input->post('odon_asma_edad');
				$data_update['fodon_traumatismos_ques']  = $this->input->post('odon_traumatismos_ques');
				$data_update['fodon_traumatismos_edad']  = $this->input->post('odon_traumatismos_edad');
				$data_update['fodon_disfuncion_ques']  = $this->input->post('odon_disfuncion_ques');
				$data_update['fodon_disfuncion_edad']  = $this->input->post('odon_disfuncion_edad');
				$data_update['fodon_intervensiones_ques']  = $this->input->post('odon_intervensiones_ques');
				$data_update['fodon_intervensiones_edad']  = $this->input->post('odon_intervensiones_edad');
				$data_update['fodon_hipertension_ques']  = $this->input->post('odon_hipertension_ques');
				$data_update['fodon_hipertension_edad']  = $this->input->post('odon_hipertension_edad');
				$data_update['fodon_transfusion_ques']  = $this->input->post('odon_transfusion_ques');
				$data_update['fodon_transfusion_edad']  = $this->input->post('odon_transfusion_edad');
				$data_update['fodon_cancer_ques']  = $this->input->post('odon_cancer_ques');
				$data_update['fodon_cancer_edad']  = $this->input->post('odon_cancer_edad');
				$data_update['fodon_autoinmune_ques']  = $this->input->post('odon_autoinmune_ques');
				$data_update['fodon_autoinmune_edad']  = $this->input->post('odon_autoinmune_edad');
				$data_update['fodon_otra_ques']  = $this->input->post('odon_otra_ques');
				$data_update['fodon_especifique_otra']  = $this->input->post('odon_especifique_otra');
				$data_update['fodon_enfermedad_actual_ques']  = $this->input->post('odon_enfermedad_actual_ques');
				$data_update['fodon_enfermedad_actual_detalle']  = $this->input->post('odon_enfermedad_actual_detalle');
				$data_update['fodon_medicamento_ques']  = $this->input->post('odon_medicamento_ques');
				$data_update['fodon_medicamento_detalle']  = $this->input->post('odon_medicamento_detalle');
				$data_update['fodon_alergias_ques']  = $this->input->post('odon_alergias_ques');
				$data_update['fodon_alergias_detalle']  = $this->input->post('odon_alergias_detalle');
				$data_update['fodon_otra_alergias_ques']  = $this->input->post('odon_otra_alergias_ques');
				$data_update['fodon_otra_alergias_detalle']  = $this->input->post('odon_otra_alergias_detalle');
				$data_update['fodon_lava_dientes_ques']  = $this->input->post('odon_lava_dientes_ques');
				$data_update['fodon_higiene_oral_ques']  = $this->input->post('odon_higiene_oral_ques');
				if (!empty($this->input->post('odon_cuando_lava_ques')))
				{	
					$data_update['fodon_cuando_lava_ques']  = implode(',', $this->input->post('odon_cuando_lava_ques'));
				}
				

				$data_update['fodon_cambia_cepillo_ques']  = $this->input->post('odon_cambia_cepillo_ques');
				
				if (!empty($this->input->post('odon_auxiliar_lavado_ques')))
				{	
					$data_update['fodon_auxiliar_lavado_ques']  = implode(',', $this->input->post('odon_auxiliar_lavado_ques'));
				}				

	
				$data_update['fodon_visita_fodon_ques']  = $this->input->post('odon_visita_odon_ques');
				$data_update['fodon_ultima_visita_fodon_detalle']  = $this->input->post('odon_ultima_visita_odon_detalle');
				$data_update['fodon_fuma_ques']  = $this->input->post('odon_fuma_ques');
				$data_update['fodon_fuma_detalle']  = $this->input->post('odon_fuma_detalle');
				$data_update['fodon_alcohol_ques']  = $this->input->post('odon_alcohol_ques');
				$data_update['fodon_alcohol_detalle']  = $this->input->post('odon_alcohol_detalle');
				$data_update['fodon_perfil_ques']  = $this->input->post('odon_perfil_ques');
				$data_update['fodon_cara_ques']  = $this->input->post('odon_cara_ques');
				$data_update['fodon_senas_otra']  = $this->input->post('odon_senas_otra');
				$data_update['fodon_ganglios_ques']  = $this->input->post('odon_ganglios_ques');
				$data_update['fodon_ganglios_obs']  = $this->input->post('odon_ganglios_obs');
				
				$data_update['fodon_orofaringe_ques']  = $this->input->post('odon_orofaringe_ques'); //implode(',',$this->input->post('odon_orofaringe_ques'));
				
				
				if  (!empty($this->input->post('odon_chasquido_ques')))
				{	
					$data_update['fodon_chasquido_ques']  = implode(',',$this->input->post('odon_chasquido_ques'));
				}	
				else
				{	
					$data_update['fodon_chasquido_ques']  = '';
				}				
				
				if (!empty($this->input->post('odon_crepitacion_ques')))
				{
					$data_update['fodon_crepitacion_ques']  = implode(',',$this->input->post('odon_crepitacion_ques'));
				}
				else
				{	
					$data_update['fodon_crepitacion_ques']  = '';
				}				
				
				if (!empty($this->input->post('odon_dmandibular_ques')))
				{$data_update['fodon_dmandibular_ques']  = implode(',',$this->input->post('odon_dmandibular_ques'));
				}
				else
				{	
					$data_update['fodon_dmandibular_ques']  = '';
				}

				if (!empty($this->input->post('odon_condilar_ques')))
				{$data_update['fodon_condilar_ques']  = implode(',',$this->input->post('odon_condilar_ques'));
				}
				else
				{	
					$data_update['fodon_condilar_ques']  = '';
				}				
								
				$data_update['fodon_masticacion_ques']  = $this->input->post('odon_masticacion_ques');
				$data_update['fodon_mov_izquierdo_ques']  = $this->input->post('odon_mov_izquierdo_ques');
				$data_update['fodon_mov_derecho_ques']  = $this->input->post('odon_mov_derecho_ques');
				$data_update['fodon_apertura']  = $this->input->post('odon_apertura');
				$data_update['fodon_trimus_ques']  = $this->input->post('odon_trimus_ques');
				$data_update['fodon_alt_musculares_ques']  = $this->input->post('odon_alt_musculares_ques');


				if (strlen($this->input->post('odon_labios_ques')<1))
				{
					$data_update['fodon_labios_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	$data_update['fodon_labios_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_labios_ques')));
					
					
				}
				
				if (strlen($this->input->post('odon_myugal_ques')<1))
				{
					$data_update['fodon_myugal_ques']  = 'SIN DATOS PATOLÓGICOS';					
				}
				else
				{	
					$data_update['fodon_myugal_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_myugal_ques')));
				}
				
				
				
				if (strlen($this->input->post('odon_mbucal_ques')<1))
				{$data_update['fodon_mbucal_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
					$data_update['fodon_mbucal_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_mbucal_ques')));
				}
				
				if (strlen($this->input->post('odon_frenillos_ques')<1))
				{$data_update['fodon_frenillos_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
					$data_update['fodon_frenillos_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_frenillos_ques')));
				}
				
				if (strlen($this->input->post('odon_encia_ques')<1))
				{$data_update['fodon_encia_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
					$data_update['fodon_encia_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_encia_ques')));
				}
				
				if (strlen($this->input->post('odon_paladar_db_ques')<1))
				{$data_update['fodon_paladar_db_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
					$data_update['fodon_paladar_db_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_paladar_db_ques')));
				}
		
				if (strlen($this->input->post('odon_fauces_ques')<1))
				{$data_update['fodon_fauces_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
					$data_update['fodon_fauces_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_fauces_ques')));
				}
				
				if (strlen($this->input->post('odon_uvula_que')<1))
				{$data_update['fodon_uvula_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
					$data_update['fodon_uvula_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_uvula_ques')));
				}
				
				if (strlen($this->input->post('odon_amigdalas2_ques')<1))
				{$data_update['fodon_amigdalas2_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
					$data_update['fodon_amigdalas2_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_amigdalas2_ques')));
				}
				
				if (strlen($this->input->post('odon_lengua_ques')<1))
				{$data_update['fodon_lengua_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
					$data_update['fodon_lengua_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_lengua_ques')));
				}
				
				if (strlen($this->input->post('odon_piso_boca_ques')<1))
				{$data_update['fodon_piso_boca_ques']  = 'SIN DATOS PATOLÓGICOS';
				}	
				else
				{	
					$data_update['fodon_piso_boca_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_piso_boca_ques')));
				}
				
				if (strlen($this->input->post('odon_parotidas_ques')<1))
				{$data_update['fodon_parotidas_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else
				{	
				$data_update['fodon_parotidas_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_parotidas_ques')));	
				}				
				
				if (strlen($this->input->post('odon_submandibular_ques')<1))
				{$data_update['fodon_submandibular_ques']  = 'SIN DATOS PATOLÓGICOS';
				}				
				else
				{	
					$data_update['fodon_submandibular_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_submandibular_ques')));
				}

				
				if (strlen($this->input->post('odon_sublingual_ques')<1))
				{$data_update['fodon_sublingual_ques']  = 'SIN DATOS PATOLÓGICOS';
				}	
				else
				{	
					$data_update['fodon_sublingual_ques']  = $this->gsi->intrabucal(implode(',',$this->input->post('odon_sublingual_ques')));
				}				
				
				
										
				/*if (strlen($this->input->post('odon_tejidos_periodentales_ques')<1))
				{
					$data_update['fodon_tejidos_periodentales_ques']  = 'SIN DATOS PATOLÓGICOS';
				}
				else*/
				{	
					$data_update['fodon_tejidos_periodentales_ques']= $this->input->post('odon_tejidos_periodentales_ques');
				}				
				
							
				/*$data_update['fodon_labios_ques']  = implode(',',$this->input->post('odon_labios_ques'));
				$data_update['fodon_myugal_ques']  = implode(',',$this->input->post('odon_myugal_ques'));
				$data_update['fodon_mbucal_ques']  = implode(',',$this->input->post('odon_mbucal_ques'));
				$data_update['fodon_frenillos_ques']  = implode(',',$this->input->post('odon_frenillos_ques'));
				$data_update['fodon_encia_ques']  = implode(',',$this->input->post('odon_encia_ques'));
				$data_update['fodon_paladar_db_ques']  = implode(',',$this->input->post('odon_paladar_db_ques'));
				$data_update['fodon_orofaringe_ques']  = $this->input->post('odon_orofaringe_ques'); //implode(',',$this->input->post('odon_orofaringe_ques'));
				$data_update['fodon_fauces_ques']  = implode(',',$this->input->post('odon_fauces_ques'));
				$data_update['fodon_uvula_ques']  = implode(',',$this->input->post('odon_uvula_ques'));
				$data_update['fodon_amigdalas2_ques']  = implode(',',$this->input->post('odon_amigdalas2_ques'));
				$data_update['fodon_lengua_ques']  = implode(',',$this->input->post('odon_lengua_ques'));
				$data_update['fodon_piso_boca_ques']  = implode(',',$this->input->post('odon_piso_boca_ques'));
				$data_update['fodon_parotidas_ques']  = implode(',',$this->input->post('odon_parotidas_ques'));
				$data_update['fodon_submandibular_ques']  = implode(',',$this->input->post('odon_submandibular_ques'));
				$data_update['fodon_sublingual_ques']  = implode(',',$this->input->post('odon_sublingual_ques'));
				*/
			
				
				$data_update['fodon_hidratacion_ques']  = $this->input->post('odon_hidratacion_ques');
				$data_update['fodon_halitosis_ques']  = $this->input->post('odon_halitosis_ques');
				$data_update['fodon_eperiodontal_ques']  = $this->input->post('odon_eperiodontal_ques');
				$data_update['fodon_eperiodontal_donde_ques']  = $this->input->post('odon_eperiodontal_donde_ques');
				$data_update['fodon_intrabucal_obs']  = $this->input->post('odon_intrabucal_obs');
				$data_update['fodon_color_alteracion']  = $this->input->post('odon_color_alteracion');
				$data_update['fodon_color_localizacon']  = $this->input->post('odon_color_localizacon');
				$data_update['fodon_forma_alteracion']  = $this->input->post('odon_forma_alteracion');
				$data_update['fodon_forma_localizacon']  = $this->input->post('odon_forma_localizacon');
				$data_update['fodon_numero_alteracion']  = $this->input->post('odon_numero_alteracion');
				$data_update['fodon_numero_localizacon']  = $this->input->post('odon_numero_localizacon');
				$data_update['fodon_estructura_alteracion']  = $this->input->post('odon_estructura_alteracion');
				$data_update['fodon_estructura_localizacon']  = $this->input->post('odon_estructura_localizacon');
				$data_update['fodon_erupcion_alteracion']  = $this->input->post('odon_erupcion_alteracion');
				$data_update['fodon_erupcion_localizacon']  = $this->input->post('odon_erupcion_localizacon');
				$data_update['fodon_posicion_alteracion']  = $this->input->post('odon_posicion_alteracion');
				$data_update['fodon_posicion_localizacon']  = $this->input->post('odon_posicion_localizacon');
				$data_update['fodon_otros_alteracion']  = $this->input->post('odon_otros_alteracion');
				$data_update['fodon_otros_localizacon']  = $this->input->post('odon_otros_localizacon');
				
				$data_update['fodon_maloclucion_ques']  = $this->input->post('odon_maloclucion_ques');
				
				$data_update['fodon_maxilares_ques']  = $this->input->post('odon_maxilares_ques');
				
				$data_update['fodon_i_molar_derecho']  = $this->input->post('odon_i_molar_derecho');
				$data_update['fodon_i_molar_izquierdo']  = $this->input->post('odon_i_molar_izquierdo');
				$data_update['fodon_1_canino_derecho']  = $this->input->post('odon_1_canino_derecho');
				$data_update['fodon_1_canino_izquierdo']  = $this->input->post('odon_1_canino_izquierdo');
				$data_update['fodon_ii_molar_derecho']  = $this->input->post('odon_ii_molar_derecho');
				$data_update['fodon_ii_molar_izquierdo']  = $this->input->post('odon_ii_molar_izquierdo');
				$data_update['fodon_2_canino_derecho']  = $this->input->post('odon_2_canino_derecho');
				$data_update['fodon_2_canino_izquierdo']  = $this->input->post('odon_2_canino_izquierdo');
				$data_update['fodon_iii_molar_derecho']  = $this->input->post('odon_iii_molar_derecho');
				$data_update['fodon_iii_molar_izquierdo']  = $this->input->post('odon_iii_molar_izquierdo');
				$data_update['fodon_3_canino_derecho']  = $this->input->post('odon_3_canino_derecho');
				$data_update['fodon_3_canino_izquierdo']  = $this->input->post('odon_3_canino_izquierdo');
				$data_update['fodon_oclusión_cruzada_posterior']  = $this->input->post('odon_oclusión_cruzada_posterior');
				$data_update['fodon_oclusión_cruzada_anterior']  = $this->input->post('odon_oclusión_cruzada_anterior');
				$data_update['fodon_sobremordida_vertical']  = $this->input->post('odon_sobremordida_vertical');
				$data_update['fodon_sobremordida_horizonta']  = $this->input->post('odon_sobremordida_horizonta');
				$data_update['fodon_mordida_abierta']  = $this->input->post('odon_mordida_abierta');
				$data_update['fodon_mordida_borde_a_borde']  = $this->input->post('odon_mordida_borde_a_borde');
				$data_update['fodon_linea_media_superior']  = $this->input->post('odon_linea_media_superior');
				$data_update['fodon_linea_media_inferior']  = $this->input->post('odon_linea_media_inferior');
				$data_update['fodon_diastemas']  = $this->input->post('odon_diastemas');
				$data_update['fodon_facetas_de_desgaste']  = $this->input->post('odon_facetas_de_desgaste');
				$data_update['fodon_habitos_orales']  = $this->input->post('odon_habitos_orales');
				$data_update['fodon_bruxismo_briscomania']  = $this->input->post('odon_bruxismo_briscomania');
				$data_update['fodon_onicofagia']  = $this->input->post('odon_onicofagia');
				$data_update['fodon_succion_digital_labial']  = $this->input->post('odon_succion_digital_labial');
				$data_update['fodon_otro_intrabucal']  = $this->input->post('odon_otro_intrabucal');
				$data_update['fodon_dentaria_obs']  = $this->input->post('odon_dentaria_obs');	
				
				$data_update['fodon_auxiliar_lavado_ques_detalle']  = $this->input->post('odon_auxiliar_lavado_ques_detalle');
                
				
				
				$data_update['fodon_cpod_cariado']  = $this->input->post('odon_cpod_cariado');				
				$data_update['fodon_cpod_obturado']  = $this->input->post('odon_cpod_obturado');				
				$data_update['fodon_cpod_perdido']  = $this->input->post('odon_cpod_perdido');				
				$data_update['fodon_cpod_exp_caries']  = $this->input->post('odon_cpod_exp_caries');				
				$data_update['fodon_cpod_obs']  = $this->input->post('odon_cpod_obs');				
				
				
				$data_update['fodon_odon_abrasion']  = $this->input->post('odon_abrasion');				
				$data_update['fodon_odon_amalgama']  = $this->input->post('odon_amalgama');				
				$data_update['fodon_brackets']  = $this->input->post('odon_brackets');				
				$data_update['fodon_caries']  = $this->input->post('odon_caries');				
				$data_update['fodon_cavidad']  = $this->input->post('odon_cavidad');
				$data_update['fodon_corona_total_estetica']  = $this->input->post('odon_corona_total_estetica');				
				$data_update['fodon_corona_metal_total']  = $this->input->post('odon_corona_metal_total');				
				$data_update['fodon_corona_tres_cuartos']  = $this->input->post('odon_corona_tres_cuartos');				
				$data_update['fodon_diatema']  = $this->input->post('odon_diatema');				
				$data_update['fodon_fractura']  = $this->input->post('odon_fractura');				
				$data_update['fodon_gengivitis']  = $this->input->post('odon_gengivitis');				
				$data_update['fodon_hiperplasia_de_tejidos_blandoso']  = $this->input->post('odon_hiperplasia_de_tejidos_blandos');				
				$data_update['fodon_incrustacion']  = $this->input->post('odon_incrustacion');				
				$data_update['fodon_intrusion_o_extrusion']  = $this->input->post('odon_intrusion_o_extrusion');				
				$data_update['fodon_mal_posiciones']  = $this->input->post('odon_mal_posiciones');				
				$data_update['fodon_munon']  = $this->input->post('odon_munon');				
				$data_update['fodon_obturacion_temporal']  = $this->input->post('odon_obturacion_temporal');				
				$data_update['fodon_pigmentaciones']  = $this->input->post('odon_pigmentaciones');				
				$data_update['fodon_placa_detobacteriana']  = $this->input->post('odon_placa_detobacteriana');				
				$data_update['fodon_protesis_fija']  = $this->input->post('odon_protesis_fija');				
				$data_update['fodon_protesis_removible']  = $this->input->post('odon_protesis_removible');				
				$data_update['fodon_protesis_total']  = $this->input->post('odon_protesis_total');				
				$data_update['fodon_recesión_gingival']  = $this->input->post('odon_recesión_gingival');				
				$data_update['fodon_resina']  = $this->input->post('odon_resina');				
				$data_update['fodon_resto_radicular']  = $this->input->post('odon_resto_radicular');				
				$data_update['fodon_sarro']  = $this->input->post('odon_sarro');				
				$data_update['fodon_perdido_por_caries']  = $this->input->post('odon_perdido_por_caries');				
				$data_update['fodon_extraccion_indicada']  = $this->input->post('odon_extraccion_indicada');				
			
				$data_update['fodon_dientes_medicion']  = $this->input->post('odon_dientes_medicion'); 
				$data_update['fodon_dientes_posteriores']  = $this->input->post('odon_dientes_posteriores'); 
				$data_update['fodon_dientes_anteriores']  = $this->input->post('odon_dientes_anteriores'); 
				$data_update['fodon_superficies_posteriores']  = $this->input->post('odon_superficies_posteriores'); 
				$data_update['fodon_superficies_anteriores']  = $this->input->post('odon_superficies_anteriores');
				$data_update['fodon_superficies_pdb']  = $this->input->post('odon_superficies_pdb'); 
				$data_update['fodon_porcentaje_pdb']  = $this->input->post('odon_porcentaje_pdb'); 
				$data_update['fodon_dientes_interpretacion']  = $this->input->post('odon_dientes_interpretacion'); 
				$data_update['fodon_dientes_observaciones']  = $this->input->post('odon_dientes_observaciones'); 
				
				$data_update['fodon_atm_obs']  = $this->input->post('odon_atm_obs'); 


				if (strlen($this->input->post('odon_i_molar')>0))
				{$data_update['fodon_i_molar']  = implode(',',$this->input->post('odon_i_molar'));
				}
				else
				{	
					$data_update['fodon_i_molar']  = '';
				}
				
				if (!empty($this->input->post('odon_1_canino')))
				{$data_update['fodon_1_canino']  = implode(',',$this->input->post('odon_1_canino'));	
				}
								else
				{	
					$data_update['fodon_1_canino']  = '';
				}
				if (!empty($this->input->post('odon_ii_molar')))
				{$data_update['fodon_ii_molar']  = implode(',',$this->input->post('odon_ii_molar'));
				}
								else
				{	
					$data_update['fodon_ii_molar']  = '';
				}
				
				if (!empty($this->input->post('odon_2_canino')))
				{$data_update['fodon_2_canino']  = implode(',',$this->input->post('odon_2_canino'));
				}
								else
				{	
					$data_update['fodon_2_canino']  = '';
				}
				
				if (!empty($this->input->post('odon_iii_molar')))
				{
					$data_update['fodon_iii_molar']  = implode(',',$this->input->post('odon_iii_molar'));
				}
				else
				{	
					$data_update['fodon_iii_molar']  = '';
				}
				
				if (!empty($this->input->post('odon_3_canino')))
				{$data_update['fodon_3_canino']  = implode(',',$this->input->post('odon_3_canino'));
				}
								else
				{	
					$data_update['fodon_3_canino']  = '';
				}
				
			
				
			/*	$data_update['fodon_tejidos_periodentales_ques']= implode(',',$this->input->post('odon_tejidos_periodentales_ques'));
				$data_update['fodon_i_molar']  = implode(',',$this->input->post('odon_i_molar'));			
				$data_update['fodon_1_canino']  =implode(',', $this->input->post('odon_1_canino'));		
				$data_update['fodon_ii_molar']  = implode(',',$this->input->post('odon_ii_molar'));
				$data_update['fodon_2_canino']  = implode(',',$this->input->post('odon_2_canino'));
				$data_update['fodon_iii_molar']  = implode(',',$this->input->post('odon_iii_molar'));
				$data_update['fodon_3_canino']  = implode(',',$this->input->post('odon_3_canino'));*/
				
				$data_update = array_to_upper($data_update);
				
				$pre_croquis= carga_imagen('croquis','./hm/');
				
				if ($pre_croquis != NULL)
				{
					$data_update['fodon_croquis']=$pre_croquis;
				}
				else
				{
					$data_update['fodon_croquis']=  $data['fsm']['fodon_croquis'] ;

				}				
				
				$pre_ipd= carga_imagen('ipd','./hm/');
				

 
				if ($pre_ipd != NULL)
				{
					$data_update['fodon_ipd']=$pre_ipd;
				}
				else
				{
					$data_update['fodon_ipd']=  $data['fsm']['fodon_ipd'] ;

				}
				$data_update['log_insrt_f']  =  date('Y-m-d H:i:s');


				/*$pre_odograma= carga_imagen('odograma','./hm/');

				if ($pre_odograma != NULL)
				{
					$data_update['fodon_odograma']=$pre_odograma;
				}
				else
				{
					$data_update['fodon_odograma']=  $data['fsm']['fodon_odograma'] ;

				}*/

				                
                $this->db->trans_start();
                $result_update = $this->gsi->update($fsm_id, $data_update);
                if($result_update)
                {

                    send_json_ok(array('id' => $cliente_id, 'msg' => 'Se actualizó de forma correcta'));
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
       
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;

            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/FSM_ODON/edita_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        //ini_set("memory_limit","1000M");
        $this->load->model('empleado/Empleado_model','empleado');
        $persona = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->gsi->get($fsm_id);
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        $this->load->helper('pdf');
		//genera_pdf_tohuanti_mkw($this->load->view('examen//FSM_ODON/pdf',$data,TRUE),'Historia_Clinica','EX',base_url('../dist/images/persona.png');)
        genera_pdf_tohuanti_odo($this->load->view('examen//FSM_ODON/pdf',$data,TRUE),'Historia Clínica Odontológica',base_url('../dist/images/persona.png'));
    }

    public function pdfhco($cliente_id, $fsm_id)
    {
        //ini_set("memory_limit","1000M");
        $this->load->model('empleado/Empleado_model','empleado');
        $persona = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->gsi->get($fsm_id);
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        $this->load->helper('pdf');
		$observaciones='Esta historia está basada en la NOM-004-SSA3-2012, del expediente clínico, NOM-013-SSA2-2015, para la prevención y control de enfermedades bucales, y retoma conceptos y criterio de la OMS';
	    //genera_pdf_tohuanti_odo($this->load->view('examen//FSM_ODON/pdf_hco',$data,TRUE),'Historia Clínica Odontológica',base_url('../dist/images/persona.png'));
		genera_pdf_lab_new_z($this->load->view('examen//FSM_ODON/pdf_hco',$data,TRUE),'Historia Clínica Odontológica','Historia Clínica Odontológica',$med_name,$observaciones,$fuera_rango);
	}

    public function pdfeo($cliente_id, $fsm_id)
    {
        //ini_set("memory_limit","1000M");
        $this->load->model('empleado/Empleado_model','empleado');
        $persona = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->gsi->get($fsm_id);
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        $this->load->helper('pdf');
	   // genera_pdf_todo($this->load->view('examen//FSM_ODON/pdf_eo',$data,TRUE),'Historia Clínica Odontológica',base_url('../dist/images/persona.png'));
		genera_pdf_lab_new_z($this->load->view('examen//FSM_ODON/pdf_eo',$data,TRUE),'EXAMEN ODONTOLÓGICO','EXAMEN ODONTOLÓGICO',$med_name,$observaciones,$fuera_rango);
	
	}

    public function pdfvo($cliente_id, $fsm_id)
    {
        //ini_set("memory_limit","1000M");
        $this->load->model('empleado/Empleado_model','empleado');
        $persona = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->gsi->get($fsm_id);
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        $this->load->helper('pdf');
	   // genera_pdf_todo($this->load->view('examen//FSM_ODON/pdf_vo',$data,TRUE),'Historia Clínica Odontológica',base_url('../dist/images/persona.png'));
		genera_pdf_lab_new_z($this->load->view('examen//FSM_ODON/pdf_vo',$data,TRUE),'VALORACIÓN ODONTOLÓGICA','VALORACIÓN ODONTOLÓGICA',$med_name,$observaciones,$fuera_rango);
	}

    public function elimina($mapeo,$fsm_id, $id )
    {
        $array_tablas = array(
            'docs' => 'esc_dopre',
            'acad' => 'esc_sitaca',
            'fam' => 'esc_inffam',
            'hijos' => 'esc_hifudema',
            'ingresos' => 'esc_inapmifa',
            'ingresos_otro' => 'esc_inapotpe',
            'egresos' => 'esc_egresos',
            'deudas' => 'esc_deudeco',
            'tcreditos' => 'esc_tarjcred',
            'creditos' => 'esc_crditos',
            'props' => 'esc_propie',
            'orga' => 'esc_aspcul_dep',
            'dom' => 'esc_dom',
            'rper' => 'esc_ref_personal',
            'rvec' => 'esc_ref_vecinal',
            'lab' => 'esc_ant_lab',
            'comlab' => 'esc_com_lab',
            'foto' => 'esc_fotos'
        );

        if($this->gsi->delete_tabla($fsm_id,$id,$array_tablas[$mapeo]))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function sube_fotos()
    {
        if(!empty($_FILES['file']['name']))
        {
            $this->load->library('upload');
            $filename = md5(time().$_FILES['file']['name']);
            $config = array(
                    'upload_path'   => './esc/',
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'png|jpg|jpeg',
                    'max_size'      => '10000'
            );

            $this->upload->initialize($config);
            if ( ! $this->upload->do_upload('file'))
            {
                send_json_error($this->upload->display_errors());
            }
            else 
            {
                $data7 = $this->upload->data();
                send_json_ok($data7['file_name']);
            }
        }
    }
}