<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Poligrafico extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Poligrafico_model','poligrafico');
    }
    

    public function nuevo_cedula($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('servicio','Orden de servicio','required');
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
            $this->form_validation->set_rules('fecha_eval','Fecha de evaluación','required');
            $this->form_validation->set_rules('tecnica','Técnica utilizada','required');
            $this->form_validation->set_rules('cedula_resultado','Resultado de la cédula','required');
            $this->form_validation->set_rules('polig_ap','Poligrafista AP','required');
            $this->form_validation->set_rules('polig_nombre','Nombre del aplicador','required');
            $this->form_validation->set_rules('ap02_nombre','Nombre del supervisor','required');
            $this->form_validation->set_rules('ap01_nombre','Nombre del responsable de área','required');

            if($this->form_validation->run())
            {
                
                $data_insert['polig_tipo_cve']        = 'CEDULA';
                $data_insert['emp_id']                = $persona['emp_id'];
                $data_insert['clte_id']               = $persona['clte_id'];
                $data_insert['usr_id']                = $medico['usr_id'];
                $data_insert['serv_id']  = $this->input->post('servicio');
                $data_insert['polig_motivo']                =	$this->input->post('motivo');
                $data_insert['polig_fecha_eval']            =	formatea_fecha_mysql($this->input->post('fecha_eval'));
                $data_insert['polig_tecnica']               =	$this->input->post('tecnica');
                $data_insert['polig_cedula_resultado']      =	$this->input->post('cedula_resultado');
                //$data_insert['nombre_conclusiones']   = $this->input->post('nombre_conclusiones');
                $data_insert['polig_conclusiones']               = $this->input->post('leyenda');
                $data_insert['polig_ap']              =	$this->input->post('polig_ap');
                $data_insert['polig_nombre']          =	$this->input->post('polig_nombre');
                $data_insert['polig_ap01_nombre']           =	$this->input->post('ap01_nombre');
                $data_insert['polig_ap01_cedula']           =	$this->input->post('ap01_cedula');
                $data_insert['polig_ap02_nombre']           =	$this->input->post('ap02_nombre');
                $data_insert['polig_ap02_cedula']           =	$this->input->post('ap02_cedula');
                
                if($this->poligrafico->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/poligrafico/nuevo_cedula_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


    public function nuevo_reporte($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('servicio','Orden de servicio','required');
            $this->form_validation->set_rules('fecha_eval','Fecha de evaluación','required');
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
            $this->form_validation->set_rules('tecnica','Técnica utilizada','required');
            
            
            if($this->form_validation->run())
            {
                $data_insert['polig_tipo_cve']            = 'POLI';
                $data_insert['emp_id']                    = $persona['emp_id'];
                $data_insert['clte_id']                   = $persona['clte_id'];
                $data_insert['usr_id']                    = $medico['usr_id'];
                $data_insert['polig_motivo']                    = $this->input->post('motivo');
                $data_insert['polig_fecha_eval']                = formatea_fecha_mysql($this->input->post('fecha_eval'));
                $data_insert['polig_tecnica']                   = $this->input->post('tecnica');
                $data_insert['polig_resultado_criterio']  = $this->input->post('polig_resultado_criterio');
                $data_insert['polig_resultado_tecnico']   = $this->input->post('polig_resultado_tecnico');
                $data_insert['polig_trayectoria']         = $this->input->post('polig_trayectoria');
                $data_insert['polig_ilicito']             = $this->input->post('polig_ilicito');
                $data_insert['polig_droga']               = $this->input->post('polig_droga');
                $data_insert['polig_alcohol']             = $this->input->post('polig_alcohol');
                $data_insert['polig_delito']              = $this->input->post('polig_delito');
                $data_insert['polig_delictivo']           = $this->input->post('polig_delictivo');
                
                $data_insert['polig_bienes']              = $this->input->post('polig_bienes');
                $data_insert['polig_ant_personales']      = $this->input->post('polig_ant_personales');
                $data_insert['polig_ant_laborales']       = $this->input->post('polig_ant_laborales');
                $data_insert['polig_conducta']            = $this->input->post('polig_conducta');
                
                $data_insert['polig_veracidad']            = $this->input->post('veracidad');
                $data_insert['polig_conclusiones']               = $this->input->post('conclusiones');
                
                $data_insert['polig_ap']              =	$this->input->post('polig_ap');
                $data_insert['polig_nombre']          =	$this->input->post('polig_nombre');
                $data_insert['polig_ap01_nombre']           =	$this->input->post('ap01_nombre');
                $data_insert['polig_ap01_cedula']           =	$this->input->post('ap01_cedula');
                $data_insert['polig_ap02_nombre']           =	$this->input->post('ap02_nombre');
                $data_insert['polig_ap02_cedula']           =	$this->input->post('ap02_cedula');
                $data_insert['polig_envia']           =	$this->input->post('poli_envia');
                
                if($this->poligrafico->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/poligrafico/nuevo_reporte_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

   public function edit($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $data['fsm'] = $this->poligrafico->get($fsm_id);
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
            $this->form_validation->set_rules('tecnica','Técnica utilizada','required');
            

            if($this->form_validation->run())
            {
                
                $data_insert['polig_tipo_cve']            = 'POLI';
                $data_insert['emp_id']                    = $persona['emp_id'];
                $data_insert['clte_id']                   = $persona['clte_id'];
                $data_insert['usr_id']                    = $medico['usr_id'];
                $data_insert['polig_motivo']                    = $this->input->post('motivo');
                $data_insert['polig_fecha_eval']                = formatea_fecha_mysql($this->input->post('fecha_eval'));
                $data_insert['polig_tecnica']                   = $this->input->post('tecnica');
                $data_insert['polig_resultado_criterio']  = $this->input->post('polig_resultado_criterio');
                $data_insert['polig_resultado_tecnico']   = $this->input->post('polig_resultado_tecnico');
                $data_insert['polig_trayectoria']         = $this->input->post('polig_trayectoria');
                $data_insert['polig_ilicito']             = $this->input->post('polig_ilicito');
                $data_insert['polig_droga']               = $this->input->post('polig_droga');
                $data_insert['polig_alcohol']             = $this->input->post('polig_alcohol');
                $data_insert['polig_delito']              = $this->input->post('polig_delito');
                $data_insert['polig_delictivo']           = $this->input->post('polig_delictivo');
                
                $data_insert['polig_bienes']              = $this->input->post('polig_bienes');
                $data_insert['polig_ant_personales']      = $this->input->post('polig_ant_personales');
                $data_insert['polig_ant_laborales']       = $this->input->post('polig_ant_laborales');
                $data_insert['polig_conducta']            = $this->input->post('polig_conducta');
                
                $data_insert['polig_veracidad']            = $this->input->post('veracidad');
                $data_insert['polig_conclusiones']               = $this->input->post('conclusiones');
                
                $data_insert['polig_ap']              =	$this->input->post('polig_ap');
                $data_insert['polig_nombre']          =	$this->input->post('polig_nombre');
                $data_insert['polig_ap01_nombre']           =	$this->input->post('ap01_nombre');
                $data_insert['polig_ap01_cedula']           =	$this->input->post('ap01_cedula');
                $data_insert['polig_ap02_nombre']           =	$this->input->post('ap02_nombre');
                $data_insert['polig_ap02_cedula']           =	$this->input->post('ap02_cedula');
                $data_insert['polig_envia']           =	$this->input->post('poli_envia');
                

                $dat_insert = array_to_upper($data_insert);
                $this->db->trans_start();
                if($this->poligrafico->update($fsm_id ,$data_insert))
                {
                    send_json_ok('Se actualizó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/poligrafico/ed',
                'view_data' => $data 
               );
            render_template($params_view);
        }
        
    }
     
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id);
        $data['medico'] = $this->session->user;
        $data['fsm'] = $this->poligrafico->get($fsm_id);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        if($data['fsm']['polig_tipo_cve'] == 'CEDULA')
        {
            $html = $this->load->view('examen/poligrafico/cedula_pdf',$data,TRUE);
        }
        else
        {
            $html = $this->load->view('examen/poligrafico/reporte_pdf',$data,TRUE);
        }
        $this->load->helper('pdf');
        genera_pdf($html,'poligrafico','poligrafico','poligrafico');
    }
}