<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Covid extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Covid_model','covid');
		$this->load->helper('util');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		
		if  ($persona['cei_id'] == 4)
		{
			$medico = $this->medico->get_id(113);
		}
		else
		{
			$medico = $this->medico->get_id(113);
		}

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
				if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
				{					
						$this->form_validation->set_rules('servicio','Orden de servicio','required');
				}
				else
				{
						$this->form_validation->set_rules('servicio','Orden de servicio','integer');
				}
            /*************************************************/
            
            //$this->form_validation->set_rules('fsm_med_vis_info','required');
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $medico['usr_id'];
                $data_insert['med_id']  = $medico['usr_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                $data_insert['covid_medico_sol'] = $this->input->post('medico_sol');

                //$data_insert['qui_f_recibido']   = date('Y-m-d H:i:s'); //formatea_fecha_mysql($this->input->post('fecha_rec'));
                $data_insert['covid_f_recibido']   =  formatea_fechahora_mysql($this->input->post('f_recibido'));
                $data_insert['covid_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));

                $data_insert['covid_met'] = $this->input->post('metodocovid');

                $data_insert['antigeno_sars_resultado']= $this->input->post('antigueno-sars');

                $data_insert['anticuerpos_IgG_resultado']= $this->input->post('anticuerpos-IgG');
                $data_insert['anticuerpos_IgM_resultado']= $this->input->post('anticuerpos-IgM');
                //$data_insert['alcohol_fis_resultado']= $this->form_validation->set_rules('alcoholimetro', 'ALCOHOLIMETRO', 'required');
				
                $data_insert['covid_lab'] = $this->input->post('laboratorista');
				
				
				$data_insert['covid_uso'] = $this->input->post('personalcovid');
				$data_insert['covid_personal'] = $this->input->post('para_uso_personal');
				$data_insert['covid_destino'] = $this->input->post('viaje_destino');
				$data_insert['covid_aerolinea'] = $this->input->post('viaje_aerolinea');
				$data_insert['covid_vuelo'] = $this->input->post('viaje_vuelo');
				$data_insert['covid_fecha_viaje'] = formatea_fecha_mysql($this->input->post('viaje_fecha'));
				$data_insert['covid_pasaporte'] = $this->input->post('viaje_pasaporte');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');

                $data_insert=array_to_upper($data_insert);				
                $data_insert['covid_obs']= $this->input->post('covid_obs');              
                if($this->covid->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='COV19R;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/					
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/				
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/covid/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function e_mail($cliente_id, $fsm_id)
    {
		$data['id']=$cliente_id;
		$persona = $this->cliente->get($cliente_id);
        $data['persona'] = $persona; // $this->cliente->get($cliente_id,get_desp_id_usr());
        $fsm = $this->covid->get($fsm_id,get_desp_id_usr());
		$data['fsm'] = $fsm;
		
        //echo $data['id'].'-'.$persona['clte_id'].'-'.$fsm['fsm_id'];
        $user = $this->session->user;
		
      
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['clte_email'] == ''))
			{					
					//$this->form_validation->set_rules('email','EMAIL DE ENVIO','required');
			}
			
			$data_insert['email'] = $this->input->post('email');
			$data_insert['clte_id'] = $this->input->post('persona_clte_id');
			$data_insert['fsm_id'] = $this->input->post('fsm_id');
			
			
			$persona = $this->cliente->get($data_insert['clte_id']);
			$fsm = $this->covid->get($data_insert['fsm_id'],get_desp_id_usr());
			
			$this->load->helper('mail');
			
			$logo= $fsm_id;
			$data_email = array(
				'persona' => $persona, 
				'fsm' => $fsm,
				'numero' => $data['id'],
				'logo1' => $data_insert['fsm_id'],
				'logo' => $data_insert['clte_id']
				
				);
				
			//$html = $this->load->view('examen/covid/mail_rep_dia',$data_email,TRUE);	
			$html = $this->load->view('examen/covid/mail',$data_email,TRUE);		
			/*send_mail_agenda_next_day*/  send_mail_reporte_lab($data['id'],$html,$empresa,$f_ini);

            if(true/*$this->form_validation->run()*/)
            {
                

             
               // if($this->covid->insert($data_insert))
				if(TRUE)
                {
                    send_json_ok('Se envío de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error en el envío.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
           // $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/	

			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/covid/email_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
	
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->covid->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=$data['fsm']['covid_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['covid_obs'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		/*if ($data_empresa['emp_id'] == 165)*/
		{
			$laboratorista=explode(" ",$med_name);
			$med_cedula = str_replace(" ", "", $med_cedula);
			
			$med_name1='';
			$med_cedula=$med_name;
			for ($i=0; ($laboratorista[$i] != NULL); $i++)
			{
				$med_name1.=$laboratorista[$i].' ';
				$med_cedula = str_replace($laboratorista[$i], "", $med_cedula);
			}
			$med_cedula = str_replace(" ", "", $med_cedula);
			$med_name = $med_name1.'               Cédula Profesional / Professional License: '.$med_cedula;
			$ruta= "http://13.57.91.218/humancenter/dist/images/qr//hclogo_g.jpg'" ; //base_url('../dist/images/hclogo_g.jpg');
			
			
			genera_pdf_lab_c($this->load->view('examen/covid/pdf',$data,TRUE),'covid','covid',$med_name,$observaciones,$ruta);	
		}
		/*else
		{	
			genera_pdf_lab_new($this->load->view('examen/covid/pdf',$data,TRUE),'covid','covid',$med_name,$observaciones);		
		}*/
    }	

    public function borra_covid($fsm_id)
    {
        if($this->covid->delete_covid($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}