﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Nom035f extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('nom035f/Nom035f_model','cliente');
		$this->load->model('examen/Nom035_model', 'nom035i');
        $this->load->model('examen/Nom035ii_model', 'nom035ii');
        $this->load->model('examen/Nom035iii_model', 'nom035iii');	
		$this->load->model('empleado/Empleado_model','empleado');
		$this->load->model('empresa/Empresa_model','empresa');		
		
		
		
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->model('examen/Salud_ocupacional_model','salud_ocupacional');
		$this->load->helper('util');
		$this->load->helper('nom035');
		
		
		$this->load->helper('laboratorx');
		$this->load->helper('laboratory');
		$this->load->helper('laboratorz');
		$this->load->helper('laboratoru');
		$this->load->helper('laboratorg');
    }


    function reporte_empleado_nom035()
    {
           $usuario = trim(strtoupper($this->input->post('usuario'))); 
           $puesto = trim(strtoupper($this->input->post('puesto'))); 
           $estatus ='Activo' ;//trim($this->input->post('estatus')); 
		   $cei = $this->input->post('cei'); 
           $empresa = $this->input->post('emp_id'); 
 
           $data['empleados'] = $this->empleado->get_all_report_nom035($empresa,$estatus, $cei, $puesto, $usuario); 

            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php

                date_default_timezone_set('America/Mexico_City');
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_Usuarios_".$empresa."_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
					.auto-style18a {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: left;
					}					
					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
                    <tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px"> <span class="auto-style8" style="text-align: right">Reporte de Usuarios NOM-035 en Plataforma</th>
                            

                            
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>

							<th class="auto-style5" style="width: 325px; height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 80px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px; height: 27px;"> <?php echo $date2today; ?></th>
						</tr>


						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>



						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        


						<tr>
							<th class="auto-style14" style="width: 82px">ID</th>
							<th class="auto-style14" style="width: 325px">NOMBRE</th>
							<th class="auto-style14" style="width: 82px">USUARIO</th>
                            <th class="auto-style14" style="width: 164px">CONTRASEÑA</th>
							<th class="auto-style14" style="width: 150px">PUESTO</th>
							<th class="auto-style14" style="width: 424px">EMPRESA</th>
							<th class="auto-style14" style="width: 164px">SUCURSAL</th>
							<th class="auto-style14" style="width: 164px">CEI</th>
							<th class="auto-style14" style="width: 164px">EMAIL</th>
							<th class="auto-style14" style="width: 164px">ESTATUS</th>
							<th class="auto-style14" style="width: 164px">SERVICIOS</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($data['empleados']): 
						$array_rol = get_cat_nombre_var('ROL'); 
							foreach ($data['empleados'] as $empleado): 

                    
                                                
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}

                                if ( $empleado['usr_estatus_cve'] === 'ACTIVO')
								{ $color='black';} else { $color='red';}
				
                                
                                
							?>

								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_id']; ?></td>
									<td class=<?php echo $class18; ?>  align="left" style="width: 325px">
										<?php echo get_code_html($empleado['usr_paterno']); ?> 
										<?php echo get_code_html($empleado['usr_materno']); ?>
										<?php echo get_code_html($empleado['usr_nombre']); ?> 
									</td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_username']; ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_tous']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_puesto']; ?></td>
									<td class=<?php echo $class18; ?> style="width: 424px"><?php echo get_code_html(get_empresa($empleado['emp_id'])); ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_una_sucursal($empleado['suc_id']); ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_cei($empleado['cei_id']); ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $empleado['usr_correo']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['usr_estatus_cve']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empleado['servicios']; ?></td>
								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }

    public function nuevo_reporte_nom035()	
    {       
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		
		$this->load->helper('template');
		//$data['empresas'] = $this->cliente->trae_empresas();
		$data['empresa'] = $usuario['emp_id']; //$this->empresa->get_all_empresas_clean(); 
		$params_view = array(
			'title' => 'Servicios',
			'view' => 'nom035f/ficha_nom035',
			'view_data' => $data
		   );
		
		render_template($params_view);  
    }

    public function busca_nom035()
    {        
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno = trim(strtoupper($this->input->post('materno')));
		$empresa = $this->input->post('empresa');  
		$usuario = trim(strtoupper($this->input->post('usuario'))); 
		$puesto = trim(strtoupper($this->input->post('puesto'))); 
		$estatus = 'Activo'; //trim($this->input->post('estatus')); 
		$cei = $this->input->post('cei'); 
        $data['empleados'] = $this->empleado->busca_nom035($nombre,$paterno,$materno, $empresa, $cei, $usuario, $puesto,$estatus);
        send_json_ok($this->load->view('nom035f/busca_nom035',$data,TRUE));
    }

    public function envia_cnom035($empleado_id)
    {
        $empleado_registrado = $this->empleado->get($empleado_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(1)
            {
				$empleado= $this->input->post('empleado');
				$correo_electronico= $this->input->post('correo_electronico');
				$usuario = $this->input->post('usuario');
				$password= $this->input->post('password');
				$archivo_nom= $this->input->post('archivo_nom');
				$asunto= $this->input->post('asunto');
				$titulo= $this->input->post('titulo');
				$this->load->helper('mail');
				$data_email['empleado'] =  $empleado;
				$data_email['email'] =  $correo_electronico;
				$data_email['usuario'] =  $usuario;
				$data_email['password'] =  $password;
				$data_email['asunto'] =  $asunto;
				$data_email['titulo'] =  $titulo;

				$html = $this->load->view('nom035f/email_cnom035',$data_email,TRUE);
				send_mail_cnom035($correo_electronico,$empleado, $html,$archivo_nom,$asunto);

				if(1)
				{
					//send_json_ok('Se envió de forma correcta el email de NOM-035');
					send_json_ok(array('msg' =>'Se envió de forma correcta el email de NOM-035', 'id' => $empleado_id));
				}
				else
				{
					send_json_error('Ocurrió un error al enviar el email de NOM-035.');
				}
            }
            else
            {
                //send_json_error(validation_errors('<div />'));
				send_json_error('Ocurrió un error en el proceso de envio del email.');
            }
        }
        else 
        {

        }
    }

public function edita_nom035($empleado_id)
    {
        $empleado = $this->empleado->get($empleado_id);

		
		$user = $this->session->user;
        
        if($empleado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
				$this->form_validation->set_rules('rol','Rol','required');
                $this->form_validation->set_rules('empresa','Empresa','required');
				if($this->input->post('pass') != '')
                {
                $this->form_validation->set_rules('pass','Contraseña','required|min_length[12]');
          		$this->form_validation->set_rules('pass_re','Confirma contraseña','required|matches[pass]');
				}

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_usr['usr_nombre'] =  $this->input->post('nombre');
                    $data_usr['usr_paterno'] =  $this->input->post('paterno');
                    $data_usr['usr_materno'] =  $this->input->post('materno');
                    $data_usr['usr_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_usr['usr_genero_cve'] =  $this->input->post('genero');
                    $data_usr['usr_rfc'] =  $this->input->post('rfc');
                    $data_usr['usr_cedula'] =  $this->input->post('cedula');
                    $data_usr['usr_puesto'] =  $this->input->post('puesto');
					$data_usr['perfil_id'] =  $this->input->post('rol');
					$data_usr['usr_username'] =  $this->input->post('user');
                    $data_usr['emp_id'] =  $this->input->post('empresa');
                    $data_usr['usr_tel'] = limpia_telefono($this->input->post('tel'));                
                    $data_usr['usr_movil'] =  limpia_telefono($this->input->post('cel'));
                    $data_usr['usr_correo'] =  $this->input->post('correo');
					$data_usr['usr_rfc'] =  $this->input->post('rfc');
					$data_usr['suc_id'] =  $this->input->post('sucursal');
					$data_usr['cei_id'] =  $this->input->post('cei');
					$data_usr['servicios'] =  'TODOS';

					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_usr['usr_path_foto'] = $data['file_name'];
                        }
                    }
					
                    $data_usr = array_to_upper($data_usr);
					$data_usr['usr_estatus_cve'] =  $this->input->post('estatus');
					
                    if($this->input->post('pass') != '')
                    {
                        $data_usr['usr_password'] = password_hash($this->input->post('pass'),PASSWORD_DEFAULT);
						$data_usr['usr_tous']=$this->input->post('pass');
					}

                    if($this->empleado->actualiza($empleado_id, $data_usr))
                    {
                        //send_json_ok('Se actualizó de forma correcta');
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $empleado_id));
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el empleado.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas_clean();
				
				
				$data['sucursals'] = $this->empresa->get_select_sucursales($empleado['emp_id']);
				
				
				
				
				$data['consultorios'] = $this->empresa->get_all_consultorios_clean();
                $data['empleado'] = $empleado;
				$data['empleado_password'] = $empleado_password;
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'nom035f/edit_nom035',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function sender_nom035()
    {
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		
		if (strstr($usuario['modulos'],'M41LN0M'))  
		{ 
			$emp_id=$usuario['emp_id'];
			$rows = 30; //30;
			$this->load->library('pagination');
			$config['base_url'] = base_url('nom035f/sender_nom035/');
			$config['total_rows'] = $this->empleado->count_all_nom035();
			$config['per_page'] = $rows;
			$config['attributes'] = array('class' => 'pagination');
			$config['full_tag_open'] = '<div class="pagination-full">';
			$config['full_tag_close'] = '</div>';
			$config['uri_segment'] = 3;
			$config['query_string_segment'] = 4;
			$config['use_page_numbers'] = TRUE;
			$this->pagination->initialize($config);
						
			$data['empleados'] = $this->empleado->get_all_nom035_by_emp($rows,$emp_id);
			//$data['empresas'] = $this->empresa->get_all_empresas_clean();   
			$data['empresa'] = $usuario['emp_id']; //$this->empresa->get_all_empresas_clean(); 
			$data['usuario']= $usuario;
		   $this->load->helper('template');
			$params_view = array(
				'title' => 'Usuario',
				'view' => 'nom035f/sender_nom035',
				'view_data' => $data 
			   );
			render_template($params_view);  
		}
    }

    function busca()	
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$empresa = $this->input->post('empresa');			
		$id_cliente = $this->input->post('id_cliente');
		$concepto_cliente = $this->input->post('concepto_cliente');
		$f_ini_cliente = $this->input->post('f_ini_cliente');
		$f_fin_cliente = $this->input->post('f_fin_cliente');
		$data['clientes'] = $this->cliente->busca($empresa,$id_cliente,$concepto_cliente,$f_ini_cliente,$f_fin_cliente);		
		$data['usuario'] =$usuario;
		
		$data['f_ini_cliente'] = $f_ini_cliente;
		$data['f_fin_cliente'] = $f_fin_cliente;
		
		send_json_ok($this->load->view('nom035f/busca',$data,TRUE));
    }	




    public function edita($cliente_id)
    {   
        $user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$usuario = $this->medico->get($user['usr_id']);

        if ($cliente_id)
        {
            if (isset($_POST) && count($_POST) > 0)     
            {
				$this->load->library('form_validation');
				$this->form_validation->set_rules('concepto','Concepto','required');
				$this->form_validation->set_rules('f_inicial','Fecha Inicial','required');
				$this->form_validation->set_rules('f_final','Fecha Final','required');

                if (1) //if($this->form_validation->run())
                {
					$data_clte['emp_id'] =  $this->input->post('empresa');
					$data_clte['nom_concepto'] =  trim($this->input->post('concepto'));
					$data_clte['nom_f_ini'] = formatea_fecha_mysql($this->input->post('f_inicial'));
					$data_clte['nom_f_fin'] = formatea_fecha_mysql($this->input->post('f_final'));
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					$data_clte['nom035_i'] =  trim($this->input->post('nom_1'));
					$data_clte['nom035_ii'] =  trim($this->input->post('nom_2'));
					$data_clte['nom035_iii'] =  trim($this->input->post('nom_3'));
					$data_clte['nom_status'] =  $this->input->post('estatus');
					
					
					
					
					if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))				
					{
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar la persona.');
					}
					
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				$this->load->model('empresa/Empresa_model','empresa');
                $this->load->helper('template');
				$data['cliente']=$cliente;
				$data['empresas'] = $this->empresa->trae_emp_asig($usuario['emp_id']);			
				$data['sucursales'] = $this->empresa->get_select_sucursales($usuario['emp_id']);
				$data['usuario']=$usuario;
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'nom035f/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }



   public function borra($fsm_id)
    {
        if($this->cliente->borra_periodo($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function nuevo()
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('concepto','Concepto','required');
            $this->form_validation->set_rules('f_inicial','Fecha Inicial','required');
            $this->form_validation->set_rules('f_final','Fecha Final','required');

            if($this->form_validation->run())
            {
				
				$data_clte['emp_id'] =  $this->input->post('empresa');
				$data_clte['nom_concepto'] =  trim($this->input->post('concepto'));
				$data_clte['nom_f_ini'] = formatea_fecha_mysql($this->input->post('f_inicial'));
				$data_clte['nom_f_fin'] = formatea_fecha_mysql($this->input->post('f_final'));
				$data_clte['suc_id'] =  $this->input->post('sucursal');
                $data_clte['nom035_i'] =  trim($this->input->post('nom_1'));
                $data_clte['nom035_ii'] =  trim($this->input->post('nom_2'));
                $data_clte['nom035_iii'] =  trim($this->input->post('nom_3'));
				$data_clte['serv_id'] =  trim($this->input->post('serv_id'));
   
   
			
				if($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del evaluado.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->model('empresa/Empresa_model','empresa');	
			$data['empresas'] = $this->empresa->trae_emp_asig($usuario['emp_id']);			
			$data['sucursales'] = $this->empresa->get_select_sucursales($usuario['emp_id']);
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($usuario['emp_id']);
			$data['usuario']=$usuario;
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nom035f/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevom($empresa)
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$usuario['emp_id']=$empresa;
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('concepto','Concepto','required');
            $this->form_validation->set_rules('f_inicial','Fecha Inicial','required');
            $this->form_validation->set_rules('f_final','Fecha Final','required');

            if($this->form_validation->run())
            {
				
				$data_clte['emp_id'] =  $this->input->post('empresa');
				$data_clte['nom_concepto'] =  trim($this->input->post('concepto'));
				$data_clte['nom_f_ini'] = formatea_fecha_mysql($this->input->post('f_inicial'));
				$data_clte['nom_f_fin'] = formatea_fecha_mysql($this->input->post('f_final'));
				$data_clte['suc_id'] =  $this->input->post('sucursal');
                $data_clte['nom035_i'] =  trim($this->input->post('nom_1'));
                $data_clte['nom035_ii'] =  trim($this->input->post('nom_2'));
                $data_clte['nom035_iii'] =  trim($this->input->post('nom_3'));
   
			
				if($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del evaluado.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->model('empresa/Empresa_model','empresa');	
			$data['empresas'] = $this->empresa->trae_emp_asig($usuario['emp_id']);			
			$data['sucursales'] = $this->empresa->get_select_sucursales($usuario['emp_id']);
			$data['usuario']=$usuario;
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nom035f/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function lista()
    {   

		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('nom035f/lista/');
		$config['total_rows'] = $this->cliente->count_allo($usuario['emp_id']);
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		$data['clientes'] = $this->cliente->get_allo($rows,$usuario['emp_id']);

        $this->load->model('empresa/Empresa_model','empresa');
        $data['empresas'] = $this->empresa->trae_emp_asig($usuario['emp_id']);	
		$data['sucursales'] = $this->empresa->get_all_sucursales();
		$data['usuario']=$usuario;
       $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'nom035f/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }



    public function listam($emp)
    {   

		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$usuario['emp_id']=$emp;
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('nom035f/listam/'.$usuario['emp_id']);
		$config['total_rows'] = $this->cliente->count_allo($usuario['emp_id']);
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		$data['clientes'] = $this->cliente->get_allo($rows,$usuario['emp_id']);

        $this->load->model('empresa/Empresa_model','empresa');
        $data['empresas'] = $this->empresa->trae_emp_asig($usuario['emp_id']);	
		$data['sucursales'] = $this->empresa->get_all_sucursales();
		$data['usuario']=$usuario;
       $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'nom035f/indexf',
            'view_data' => $data 
           );
        render_template($params_view);  
    }





    public function id($id)
    {   

		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$grupo = $this->cliente->get($id);

		if($grupo)
        {

			$data['questions_i']= $this->nom035i->get_questions_by_dates($grupo['emp_id'],$grupo['nom_f_ini'],$grupo['nom_f_fin']);
			$data['questions_ii']= $this->nom035ii->get_questions_by_dates($grupo['emp_id'],$grupo['nom_f_ini'],$grupo['nom_f_fin']);
			$data['questions_iii']= $this->nom035iii->get_questions_by_dates($grupo['emp_id'],$grupo['nom_f_ini'],$grupo['nom_f_fin']);	
			$data['grupo']=$grupo;
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Evaluados',
                'view' => 'nom035f/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }




/**************************************************************************************************************/

 function busca_empleado()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        
		$empresa=$user['emp_id']; 
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
	
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_empleado($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta);	

		send_json_ok($this->load->view('persona/busca_empleado',$data,TRUE));
    }




    function busca_sw()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
		$empresa=253; 
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
	
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_sw($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta);	

		send_json_ok($this->load->view('persona/busca_sw',$data,TRUE));
    }    

/*************************************************************************************/	
    function busca_empleados_ext()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_empleados_ext($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	

		send_json_ok($this->load->view('persona/busca_empleados_ext',$data,TRUE));
    } 



/*************************************************************************************/	
    function busca_swe()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_swe($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	

		send_json_ok($this->load->view('persona/busca_swe',$data,TRUE));
    } 



   function busca_enom()
    {   
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; 
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		$data['clientes'] = $this->cliente->busca_enom($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	
		send_json_ok($this->load->view('persona/busca_enom',$data,TRUE));

		
    } 

   function busca_e() /*BUSCARDOR DE HC*/
    {   
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		if ( strstr($usuario['modulos'],'HCRHGSI') )
		{
			$data['clientes'] = $this->cliente->busca_empleados_hc_gsi_medicos($empresa, $nombre, $nombre2,$paterno, $materno);
		}
		elseif ($user['usr_id'] == 482)
		{
			$data['clientes'] = $this->cliente->busca_m($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);
        }
		else
		{
			$data['clientes'] = $this->cliente->busca_e($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	
		}
		
		if ( strstr($usuario['modulos'],'HCRHGSI') )
		{
			send_json_ok($this->load->view('persona/busca_empleados_hc_gsi',$data,TRUE));
		}
		else
		{	
			send_json_ok($this->load->view('persona/busca_e',$data,TRUE));
		}
		
    } 

 /*************************************************************************************/	
    function busca_a()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
		
        $data['clientes'] = $this->cliente->busca_a($empresa, $nombre, $nombre2,$paterno, $materno);
        
		send_json_ok($this->load->view('persona/busca_a',$data,TRUE));
    } 
	
	
    public function borra_comentario($fsm_id)
    {
        if($this->cliente->borrar_comentario($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	


    public function borra_documento_ALCOSA($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='ALCOSA';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_ALCOSA($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_ANTICUA($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='ANTICUA';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_ANTICUA($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function borra_documento_TORAX($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='TORAX';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_TORAX($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_RADIOL($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_RADIOL($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function borra_documento_RADIOT($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_RADIOT($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_PCR($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_PCR($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function borra_documento_AUDIO($fsm_id)
    {
		$documento=$this->cliente->get_doc_AUDIO($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_AUDIO($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_SPIRO($fsm_id)
    {
		$documento=$this->cliente->get_doc_SPIRO($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_SPIRO($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_hc($fsm_id)
    {
		$documento=$this->cliente->get_doc_hc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_hc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

	
    public function borra_documento($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_gen($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_gen($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function edita_g_gen($fsm_id,$cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);		
		$documento=$this->cliente->get_doc_gen($fsm_id);         
		
        if($documento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nuevo_nombre','Nuevo Nombre del Archivo','required');


                if($this->form_validation->run())
                {

                    $data_clte['doc_nombre'] =  trim($this->input->post('nuevo_nombre'));
					
					if($this->cliente->actualiza_nombre_doc_gen($fsm_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['persona'] = 	$cliente;
				$data['documento'] = 	$documento;
				

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_g_gen',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }


    public function edita_g($fsm_id,$cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);		
		$documento=$this->cliente->get_doc($fsm_id);         
		
        if($documento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nuevo_nombre','Nuevo Nombre del Archivo','required');


                if($this->form_validation->run())
                {

                    $data_clte['doc_nombre'] =  trim($this->input->post('nuevo_nombre'));
					
					if($this->cliente->actualiza_nombre_doc($fsm_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['persona'] = 	$cliente;
				$data['documento'] = 	$documento;
				

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_g',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }
	
 
}